/****************************************************************************
** $Id: xtermcontrol.h,v 1.13 2002/08/01 21:54:17 jet Exp $
**
** Copyright (C) 2002-2013 Jess Thrysoee <jess@thrysoee.dk>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
***************************************************************************  */

#ifndef XTERMCONTROL_H
#define XTERMCONTROL_H

enum CTLSEQS_TYPE
{
    CSI,
    GET_CSI,
    OSC,
    GET_OSC,
    ANY
};

/* xterm control sequences are described in ctlseq.ms, which is
   distributed with the xterm source package, obtainable from
   http://dickey.his.com/xterm.
   To read the troff file as plain text, issue
   "nroff -ms -t -c ctlseqs.ms | col -b > ctlseqs.txt"              */

struct controlseq
{
    int ctl1;          /* Ps                                        */
    int ctl2;          /* Ps                                        */
    char *text;        /* Pt                                        */
    int type;          /* CTLSEQS_TYPE                              */
    char *conf_title;  /* used in reports and configuration file    */
    char *synopsis;    /* used in usage                             */
    char *description; /* used in usage and configuration file      */
};

extern struct controlseq ctlseqstab[];
#define NSEQ (sizeof ctlseqstab / sizeof ctlseqstab[0])

void check_term_variable(void);
void csi_print1(int ctl1);
void csi_print2(int ctl1, int ctl2);
void csi_print3(int ctl1, int ctl2, int ctl3);

void osc_print(int ps1, int ps2, char *pt);

void tty_control(void);
char *ctty_path(void);
void raw_print(char *ctlseq);
ssize_t tty_read(char *output, size_t size);

char *tmux_dcs_passthrough(char *ctlseq);
void set_tty_raw(void);
void set_tty_restore(void);

int get_title(char *title, size_t size, int verbose, int ctl1);
int get_osc(char *osc, size_t size, int verbose, unsigned int option, int ctl1, int ctl2);

void set_geometry(int ctl1, int ctl2, char *geometry);
int get_geometry(char *geometry, size_t size, int verbose, int ctl1, int ctl2);

int configuration_write(const char *filepath);

void usage(int status);
void version(void);

void report_error(const char *synopsis);
void do_exit(int status);

enum OPTION
{
    FG,
    BG,
    COLOR_0,
    COLOR_1,
    COLOR_2,
    COLOR_3,
    COLOR_4,
    COLOR_5,
    COLOR_6,
    COLOR_7,
    COLOR_8,
    COLOR_9,
    COLOR_10,
    COLOR_11,
    COLOR_12,
    COLOR_13,
    COLOR_14,
    COLOR_15,
    COLOR_16,
    COLOR_17,
    COLOR_18,
    COLOR_19,
    COLOR_20,
    COLOR_21,
    COLOR_22,
    COLOR_23,
    COLOR_24,
    COLOR_25,
    COLOR_26,
    COLOR_27,
    COLOR_28,
    COLOR_29,
    COLOR_30,
    COLOR_31,
    COLOR_32,
    COLOR_33,
    COLOR_34,
    COLOR_35,
    COLOR_36,
    COLOR_37,
    COLOR_38,
    COLOR_39,
    COLOR_40,
    COLOR_41,
    COLOR_42,
    COLOR_43,
    COLOR_44,
    COLOR_45,
    COLOR_46,
    COLOR_47,
    COLOR_48,
    COLOR_49,
    COLOR_50,
    COLOR_51,
    COLOR_52,
    COLOR_53,
    COLOR_54,
    COLOR_55,
    COLOR_56,
    COLOR_57,
    COLOR_58,
    COLOR_59,
    COLOR_60,
    COLOR_61,
    COLOR_62,
    COLOR_63,
    COLOR_64,
    COLOR_65,
    COLOR_66,
    COLOR_67,
    COLOR_68,
    COLOR_69,
    COLOR_70,
    COLOR_71,
    COLOR_72,
    COLOR_73,
    COLOR_74,
    COLOR_75,
    COLOR_76,
    COLOR_77,
    COLOR_78,
    COLOR_79,
    COLOR_80,
    COLOR_81,
    COLOR_82,
    COLOR_83,
    COLOR_84,
    COLOR_85,
    COLOR_86,
    COLOR_87,
    COLOR_88,
    COLOR_89,
    COLOR_90,
    COLOR_91,
    COLOR_92,
    COLOR_93,
    COLOR_94,
    COLOR_95,
    COLOR_96,
    COLOR_97,
    COLOR_98,
    COLOR_99,
    COLOR_100,
    COLOR_101,
    COLOR_102,
    COLOR_103,
    COLOR_104,
    COLOR_105,
    COLOR_106,
    COLOR_107,
    COLOR_108,
    COLOR_109,
    COLOR_110,
    COLOR_111,
    COLOR_112,
    COLOR_113,
    COLOR_114,
    COLOR_115,
    COLOR_116,
    COLOR_117,
    COLOR_118,
    COLOR_119,
    COLOR_120,
    COLOR_121,
    COLOR_122,
    COLOR_123,
    COLOR_124,
    COLOR_125,
    COLOR_126,
    COLOR_127,
    COLOR_128,
    COLOR_129,
    COLOR_130,
    COLOR_131,
    COLOR_132,
    COLOR_133,
    COLOR_134,
    COLOR_135,
    COLOR_136,
    COLOR_137,
    COLOR_138,
    COLOR_139,
    COLOR_140,
    COLOR_141,
    COLOR_142,
    COLOR_143,
    COLOR_144,
    COLOR_145,
    COLOR_146,
    COLOR_147,
    COLOR_148,
    COLOR_149,
    COLOR_150,
    COLOR_151,
    COLOR_152,
    COLOR_153,
    COLOR_154,
    COLOR_155,
    COLOR_156,
    COLOR_157,
    COLOR_158,
    COLOR_159,
    COLOR_160,
    COLOR_161,
    COLOR_162,
    COLOR_163,
    COLOR_164,
    COLOR_165,
    COLOR_166,
    COLOR_167,
    COLOR_168,
    COLOR_169,
    COLOR_170,
    COLOR_171,
    COLOR_172,
    COLOR_173,
    COLOR_174,
    COLOR_175,
    COLOR_176,
    COLOR_177,
    COLOR_178,
    COLOR_179,
    COLOR_180,
    COLOR_181,
    COLOR_182,
    COLOR_183,
    COLOR_184,
    COLOR_185,
    COLOR_186,
    COLOR_187,
    COLOR_188,
    COLOR_189,
    COLOR_190,
    COLOR_191,
    COLOR_192,
    COLOR_193,
    COLOR_194,
    COLOR_195,
    COLOR_196,
    COLOR_197,
    COLOR_198,
    COLOR_199,
    COLOR_200,
    COLOR_201,
    COLOR_202,
    COLOR_203,
    COLOR_204,
    COLOR_205,
    COLOR_206,
    COLOR_207,
    COLOR_208,
    COLOR_209,
    COLOR_210,
    COLOR_211,
    COLOR_212,
    COLOR_213,
    COLOR_214,
    COLOR_215,
    COLOR_216,
    COLOR_217,
    COLOR_218,
    COLOR_219,
    COLOR_220,
    COLOR_221,
    COLOR_222,
    COLOR_223,
    COLOR_224,
    COLOR_225,
    COLOR_226,
    COLOR_227,
    COLOR_228,
    COLOR_229,
    COLOR_230,
    COLOR_231,
    COLOR_232,
    COLOR_233,
    COLOR_234,
    COLOR_235,
    COLOR_236,
    COLOR_237,
    COLOR_238,
    COLOR_239,
    COLOR_240,
    COLOR_241,
    COLOR_242,
    COLOR_243,
    COLOR_244,
    COLOR_245,
    COLOR_246,
    COLOR_247,
    COLOR_248,
    COLOR_249,
    COLOR_250,
    COLOR_251,
    COLOR_252,
    COLOR_253,
    COLOR_254,
    COLOR_255,
    COLOR_HL,
    CURSOR,
    MOUSE_FG,
    MOUSE_BG,
    FONT,
    TITLE,
    GEOMETRY,
    GET_FG,
    GET_BG,
    GET_COLOR_0,
    GET_COLOR_1,
    GET_COLOR_2,
    GET_COLOR_3,
    GET_COLOR_4,
    GET_COLOR_5,
    GET_COLOR_6,
    GET_COLOR_7,
    GET_COLOR_8,
    GET_COLOR_9,
    GET_COLOR_10,
    GET_COLOR_11,
    GET_COLOR_12,
    GET_COLOR_13,
    GET_COLOR_14,
    GET_COLOR_15,
    GET_COLOR_16,
    GET_COLOR_17,
    GET_COLOR_18,
    GET_COLOR_19,
    GET_COLOR_20,
    GET_COLOR_21,
    GET_COLOR_22,
    GET_COLOR_23,
    GET_COLOR_24,
    GET_COLOR_25,
    GET_COLOR_26,
    GET_COLOR_27,
    GET_COLOR_28,
    GET_COLOR_29,
    GET_COLOR_30,
    GET_COLOR_31,
    GET_COLOR_32,
    GET_COLOR_33,
    GET_COLOR_34,
    GET_COLOR_35,
    GET_COLOR_36,
    GET_COLOR_37,
    GET_COLOR_38,
    GET_COLOR_39,
    GET_COLOR_40,
    GET_COLOR_41,
    GET_COLOR_42,
    GET_COLOR_43,
    GET_COLOR_44,
    GET_COLOR_45,
    GET_COLOR_46,
    GET_COLOR_47,
    GET_COLOR_48,
    GET_COLOR_49,
    GET_COLOR_50,
    GET_COLOR_51,
    GET_COLOR_52,
    GET_COLOR_53,
    GET_COLOR_54,
    GET_COLOR_55,
    GET_COLOR_56,
    GET_COLOR_57,
    GET_COLOR_58,
    GET_COLOR_59,
    GET_COLOR_60,
    GET_COLOR_61,
    GET_COLOR_62,
    GET_COLOR_63,
    GET_COLOR_64,
    GET_COLOR_65,
    GET_COLOR_66,
    GET_COLOR_67,
    GET_COLOR_68,
    GET_COLOR_69,
    GET_COLOR_70,
    GET_COLOR_71,
    GET_COLOR_72,
    GET_COLOR_73,
    GET_COLOR_74,
    GET_COLOR_75,
    GET_COLOR_76,
    GET_COLOR_77,
    GET_COLOR_78,
    GET_COLOR_79,
    GET_COLOR_80,
    GET_COLOR_81,
    GET_COLOR_82,
    GET_COLOR_83,
    GET_COLOR_84,
    GET_COLOR_85,
    GET_COLOR_86,
    GET_COLOR_87,
    GET_COLOR_88,
    GET_COLOR_89,
    GET_COLOR_90,
    GET_COLOR_91,
    GET_COLOR_92,
    GET_COLOR_93,
    GET_COLOR_94,
    GET_COLOR_95,
    GET_COLOR_96,
    GET_COLOR_97,
    GET_COLOR_98,
    GET_COLOR_99,
    GET_COLOR_100,
    GET_COLOR_101,
    GET_COLOR_102,
    GET_COLOR_103,
    GET_COLOR_104,
    GET_COLOR_105,
    GET_COLOR_106,
    GET_COLOR_107,
    GET_COLOR_108,
    GET_COLOR_109,
    GET_COLOR_110,
    GET_COLOR_111,
    GET_COLOR_112,
    GET_COLOR_113,
    GET_COLOR_114,
    GET_COLOR_115,
    GET_COLOR_116,
    GET_COLOR_117,
    GET_COLOR_118,
    GET_COLOR_119,
    GET_COLOR_120,
    GET_COLOR_121,
    GET_COLOR_122,
    GET_COLOR_123,
    GET_COLOR_124,
    GET_COLOR_125,
    GET_COLOR_126,
    GET_COLOR_127,
    GET_COLOR_128,
    GET_COLOR_129,
    GET_COLOR_130,
    GET_COLOR_131,
    GET_COLOR_132,
    GET_COLOR_133,
    GET_COLOR_134,
    GET_COLOR_135,
    GET_COLOR_136,
    GET_COLOR_137,
    GET_COLOR_138,
    GET_COLOR_139,
    GET_COLOR_140,
    GET_COLOR_141,
    GET_COLOR_142,
    GET_COLOR_143,
    GET_COLOR_144,
    GET_COLOR_145,
    GET_COLOR_146,
    GET_COLOR_147,
    GET_COLOR_148,
    GET_COLOR_149,
    GET_COLOR_150,
    GET_COLOR_151,
    GET_COLOR_152,
    GET_COLOR_153,
    GET_COLOR_154,
    GET_COLOR_155,
    GET_COLOR_156,
    GET_COLOR_157,
    GET_COLOR_158,
    GET_COLOR_159,
    GET_COLOR_160,
    GET_COLOR_161,
    GET_COLOR_162,
    GET_COLOR_163,
    GET_COLOR_164,
    GET_COLOR_165,
    GET_COLOR_166,
    GET_COLOR_167,
    GET_COLOR_168,
    GET_COLOR_169,
    GET_COLOR_170,
    GET_COLOR_171,
    GET_COLOR_172,
    GET_COLOR_173,
    GET_COLOR_174,
    GET_COLOR_175,
    GET_COLOR_176,
    GET_COLOR_177,
    GET_COLOR_178,
    GET_COLOR_179,
    GET_COLOR_180,
    GET_COLOR_181,
    GET_COLOR_182,
    GET_COLOR_183,
    GET_COLOR_184,
    GET_COLOR_185,
    GET_COLOR_186,
    GET_COLOR_187,
    GET_COLOR_188,
    GET_COLOR_189,
    GET_COLOR_190,
    GET_COLOR_191,
    GET_COLOR_192,
    GET_COLOR_193,
    GET_COLOR_194,
    GET_COLOR_195,
    GET_COLOR_196,
    GET_COLOR_197,
    GET_COLOR_198,
    GET_COLOR_199,
    GET_COLOR_200,
    GET_COLOR_201,
    GET_COLOR_202,
    GET_COLOR_203,
    GET_COLOR_204,
    GET_COLOR_205,
    GET_COLOR_206,
    GET_COLOR_207,
    GET_COLOR_208,
    GET_COLOR_209,
    GET_COLOR_210,
    GET_COLOR_211,
    GET_COLOR_212,
    GET_COLOR_213,
    GET_COLOR_214,
    GET_COLOR_215,
    GET_COLOR_216,
    GET_COLOR_217,
    GET_COLOR_218,
    GET_COLOR_219,
    GET_COLOR_220,
    GET_COLOR_221,
    GET_COLOR_222,
    GET_COLOR_223,
    GET_COLOR_224,
    GET_COLOR_225,
    GET_COLOR_226,
    GET_COLOR_227,
    GET_COLOR_228,
    GET_COLOR_229,
    GET_COLOR_230,
    GET_COLOR_231,
    GET_COLOR_232,
    GET_COLOR_233,
    GET_COLOR_234,
    GET_COLOR_235,
    GET_COLOR_236,
    GET_COLOR_237,
    GET_COLOR_238,
    GET_COLOR_239,
    GET_COLOR_240,
    GET_COLOR_241,
    GET_COLOR_242,
    GET_COLOR_243,
    GET_COLOR_244,
    GET_COLOR_245,
    GET_COLOR_246,
    GET_COLOR_247,
    GET_COLOR_248,
    GET_COLOR_249,
    GET_COLOR_250,
    GET_COLOR_251,
    GET_COLOR_252,
    GET_COLOR_253,
    GET_COLOR_254,
    GET_COLOR_255,
    GET_COLOR_HL,
    GET_CURSOR,
    GET_MOUSE_FG,
    GET_MOUSE_BG,
    GET_FONT,
    GET_TITLE,
    GET_GEOMETRY,
    MAXIMIZE,
    RESTORE,
    ICONIFY,
    DE_ICONIFY,
    RAISE,
    LOWER,
    RESET,
    RAW,
    FILE_CONF
};

#endif
