;; Basic Roma-to-HankakuKana (jisx0201) Translation Table for Egg

;; This file is part of Egg on Mule (Japanese Environment)

;; Egg is distributed in the forms of patches to GNU
;; Emacs under the terms of the GNU EMACS GENERAL PUBLIC
;; LICENSE which is distributed along with GNU Emacs by the
;; Free Software Foundation.

;; Egg is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied
;; warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
;; PURPOSE.  See the GNU EMACS GENERAL PUBLIC LICENSE for
;; more details.

;; You should have received a copy of the GNU EMACS GENERAL
;; PUBLIC LICENSE along with Nemacs; see the file COPYING.
;; If not, write to the Free Software Foundation, 675 Mass
;; Ave, Cambridge, MA 02139, USA.

;;; 92.9.24  created for Mule Ver.0.9.6 by K.Shibata <shibata@sgi.co.jp>

(require 'egg-jisx0201)

(its-define-mode "roma-han-kata"  "(I1'(B" t)

(dolist (aa '("k" "s" "t" "h" "y" "r" "w" "g" "z" "d" "b"
		 "p" "c" "f" "j" "v"))
  (its-defrule (concat aa aa) "(I/(B" aa))

(its-defrule "tch"  "(I/(B" "ch")

(dolist (q1 '("b" "m" "p"))
  (its-defrule (concat "m" q1) "(I](B" q1))

(its-defrule "N" "(I](B")

(defvar enable-double-n-syntax nil "*Enable \"nn\" input for \"(I](B\"")

(its-defrule-conditional "n"
  ((not enable-double-n-syntax) "(I](B")
  (t nil))
(its-defrule-conditional "nn"
  ( enable-double-n-syntax "(I](B")
  (t nil))

(its-defrule "n'" "(I](B")

(let ((small '"x" ))
  (its-defrule (concat small "a") "(I'(B")
  (its-defrule (concat small "i") "(I((B")
  (its-defrule (concat small "u") "(I)(B")
  (its-defrule (concat small "e") "(I*(B")
  (its-defrule (concat small "o") "(I+(B")
  (its-defrule (concat small "ya") "(I,(B")
  (its-defrule (concat small "yu") "(I-(B")
  (its-defrule (concat small "yo") "(I.(B")
  (its-defrule (concat small "tu") "(I/(B")
  (its-defrule (concat small "tsu") "(I/(B")
  )


(its-defrule   "a"    "(I1(B")
(its-defrule   "i"    "(I2(B")
(its-defrule   "u"    "(I3(B")
(its-defrule   "e"    "(I4(B")
(its-defrule   "o"    "(I5(B")
(its-defrule   "ka"   "(I6(B")
(its-defrule   "ki"   "(I7(B")
(its-defrule   "ku"   "(I8(B")
(its-defrule   "ke"   "(I9(B")
(its-defrule   "ko"   "(I:(B")
(its-defrule   "kya"  "(I7,(B")
(its-defrule   "kyu"  "(I7-(B")
(its-defrule   "kye"  "(I7*(B")
(its-defrule   "kyo"  "(I7.(B")
(its-defrule   "sa"   "(I;(B")
(its-defrule   "si"   "(I<(B")
(its-defrule   "su"   "(I=(B")
(its-defrule   "se"   "(I>(B")
(its-defrule   "so"   "(I?(B")
(its-defrule   "sya"  "(I<,(B")
(its-defrule   "syu"  "(I<-(B")
(its-defrule   "sye"  "(I<*(B")
(its-defrule   "syo"  "(I<.(B")
(its-defrule   "sha"  "(I<,(B")
(its-defrule   "shi"  "(I<(B")
(its-defrule   "shu"  "(I<-(B")
(its-defrule   "she"  "(I<*(B")
(its-defrule   "sho"  "(I<.(B")
(its-defrule   "ta"   "(I@(B")
(its-defrule   "ti"   "(IA(B")
(its-defrule   "tu"   "(IB(B")
(its-defrule   "te"   "(IC(B")
(its-defrule   "to"   "(ID(B")
(its-defrule   "tya"  "(IA,(B")
(its-defrule   "tyi"  "(IC((B")
(its-defrule   "tyu"  "(IA-(B")
(its-defrule   "tye"  "(IA*(B")
(its-defrule   "tyo"  "(IA.(B")
(its-defrule   "tsu"  "(IB(B")
(its-defrule   "cha"  "(IA,(B")
(its-defrule   "chi"  "(IA(B")
(its-defrule   "chu"  "(IA-(B")
(its-defrule   "che"  "(IA*(B")
(its-defrule   "cho"  "(IA.(B")
(its-defrule   "na"   "(IE(B")
(its-defrule   "ni"   "(IF(B")
(its-defrule   "nu"   "(IG(B")
(its-defrule   "ne"   "(IH(B")
(its-defrule   "no"   "(II(B")
(its-defrule   "nya"  "(IF,(B")
(its-defrule   "nyu"  "(IF-(B")
(its-defrule   "nye"  "(IF*(B")
(its-defrule   "nyo"  "(IF.(B")
(its-defrule   "ha"   "(IJ(B")
(its-defrule   "hi"   "(IK(B")
(its-defrule   "hu"   "(IL(B")
(its-defrule   "he"   "(IM(B")
(its-defrule   "ho"   "(IN(B")
(its-defrule   "hya"  "(IK,(B")
(its-defrule   "hyu"  "(IK-(B")
(its-defrule   "hye"  "(IK*(B")
(its-defrule   "hyo"  "(IK.(B")
(its-defrule   "fa"   "(IL'(B")
(its-defrule   "fi"   "(IL((B")
(its-defrule   "fu"   "(IL(B")
(its-defrule   "fe"   "(IL*(B")
(its-defrule   "fo"   "(IL+(B")
(its-defrule   "ma"   "(IO(B")
(its-defrule   "mi"   "(IP(B")
(its-defrule   "mu"   "(IQ(B")
(its-defrule   "me"   "(IR(B")
(its-defrule   "mo"   "(IS(B")
(its-defrule   "mya"  "(IP,(B")
(its-defrule   "myu"  "(IP-(B")
(its-defrule   "mye"  "(IP*(B")
(its-defrule   "myo"  "(IP.(B")
(its-defrule   "ya"   "(IT(B")
(its-defrule   "yi"   "(I2(B")
(its-defrule   "yu"   "(IU(B")
(its-defrule   "ye"   "(I2*(B")
(its-defrule   "yo"   "(IV(B")
(its-defrule   "ra"   "(IW(B")
(its-defrule   "ri"   "(IX(B")
(its-defrule   "ru"   "(IY(B")
(its-defrule   "re"   "(IZ(B")
(its-defrule   "ro"   "(I[(B")
(its-defrule   "la"   "(IW(B")
(its-defrule   "li"   "(IX(B")
(its-defrule   "lu"   "(IY(B")
(its-defrule   "le"   "(IZ(B")
(its-defrule   "lo"   "(I[(B")
(its-defrule   "rya"  "(IX,(B")
(its-defrule   "ryu"  "(IX-(B")
(its-defrule   "rye"  "(IX*(B")
(its-defrule   "ryo"  "(IX.(B")
(its-defrule   "lya"  "(IX,(B")
(its-defrule   "lyu"  "(IX-(B")
(its-defrule   "lye"  "(IX*(B")
(its-defrule   "lyo"  "(IX.(B")
(its-defrule   "wa"   "(I\(B")
(its-defrule   "wu"   "(I3(B")
(its-defrule   "wo"   "(I&(B")
(its-defrule   "ga"   "(I6^(B")
(its-defrule   "gi"   "(I7^(B")
(its-defrule   "gu"   "(I8^(B")
(its-defrule   "ge"   "(I9^(B")
(its-defrule   "go"   "(I:^(B")
(its-defrule   "gya"  "(I7^,(B")
(its-defrule   "gyu"  "(I7^-(B")
(its-defrule   "gye"  "(I7^*(B")
(its-defrule   "gyo"  "(I7^.(B")
(its-defrule   "za"   "(I;^(B")
(its-defrule   "zi"   "(I<^(B")
(its-defrule   "zu"   "(I=^(B")
(its-defrule   "ze"   "(I>^(B")
(its-defrule   "zo"   "(I?^(B")
(its-defrule   "zya"  "(I<^,(B")
(its-defrule   "zyu"  "(I<^-(B")
(its-defrule   "zye"  "(I<^*(B")
(its-defrule   "zyo"  "(I<^.(B")
(its-defrule   "ja"   "(I<^,(B")
(its-defrule   "ji"   "(I<^(B")
(its-defrule   "ju"   "(I<^-(B")
(its-defrule   "je"   "(I<^*(B")
(its-defrule   "jo"   "(I<^.(B")
(its-defrule   "da"   "(I@^(B")
(its-defrule   "di"   "(IA^(B")
(its-defrule   "du"   "(IB^(B")
(its-defrule   "de"   "(IC^(B")
(its-defrule   "do"   "(ID^(B")
(its-defrule   "dya"  "(IA^,(B")
(its-defrule   "dyi"  "(IA^((B")
(its-defrule   "dyu"  "(IA^-(B")
(its-defrule   "dye"  "(IA^*(B")
(its-defrule   "dyo"  "(IA^.(B")
(its-defrule   "ba"   "(IJ^(B")
(its-defrule   "bi"   "(IK^(B")
(its-defrule   "bu"   "(IL^(B")
(its-defrule   "be"   "(IM^(B")
(its-defrule   "bo"   "(IN^(B")
(its-defrule   "va"   "(I3^'(B")
(its-defrule   "vi"   "(I3^((B")
(its-defrule   "vu"   "(I3^(B")
(its-defrule   "ve"   "(I3^*(B")
(its-defrule   "vo"   "(I3^+(B")
(its-defrule   "bya"  "(IK^,(B")
(its-defrule   "byu"  "(IK^-(B")
(its-defrule   "bye"  "(IK^*(B")
(its-defrule   "byo"  "(IK^.(B")
(its-defrule   "pa"   "(IJ_(B")
(its-defrule   "pi"   "(IK_(B")
(its-defrule   "pu"   "(IL_(B")
(its-defrule   "pe"   "(IM_(B")
(its-defrule   "po"   "(IN_(B")
(its-defrule   "pya"  "(IK_,(B")
(its-defrule   "pyu"  "(IK_-(B")
(its-defrule   "pye"  "(IK_*(B")
(its-defrule   "pyo"  "(IK_.(B")
(its-defrule   "kwi"  "(I8((B")
(its-defrule   "kwu"  "(I8(B")
(its-defrule   "kwe"  "(I8*(B")
(its-defrule   "kwo"  "(I8+(B")
(its-defrule   "gwi"  "(I8^((B")
(its-defrule   "gwu"  "(I8^(B")
(its-defrule   "gwe"  "(I8^*(B")
(its-defrule   "gwo"  "(I8^+(B")
(its-defrule   "tsa"  "(IB'(B")
(its-defrule   "tsi"  "(IB((B")
(its-defrule   "tse"  "(IB*(B")
(its-defrule   "tso"  "(IB+(B")
(its-defrule   "xka"  "(I6(B")
(its-defrule   "xke"  "(I9(B")
(its-defrule   "xti"  "(IC((B")
(its-defrule   "xdi"  "(IA^((B")
(its-defrule   "xdu"  "(ID^)(B")
(its-defrule   "xde"  "(IA^*(B")
(its-defrule   "xdo"  "(ID^+(B")
(its-defrule   "xwi"  "(I3((B")
(its-defrule   "xwe"  "(I3*(B")
(its-defrule   "xwo"  "(I3+(B")

(its-defrule   "-"   "(I0(B")
(its-defrule   "["    "(I"(B")
(its-defrule   "]"    "(I#(B")
(its-defrule   "z/"   "(I%(B")

(defvar use-kuten-for-period t "*(IK_X5D^$B$r6gE@$KJQ49$9$k(B")
(defvar use-touten-for-comma t "*(I:]O$B$rFIE@$KJQ49$9$k(B")

(its-defrule-conditional "."
  (use-kuten-for-period "(I!(B")
  (t "."))

(its-defrule-conditional ","
  (use-touten-for-comma "(I$(B")
  (t ","))

(its-defrule (concat zenkaku-escape ",")  "$B!$(B")
(its-defrule (concat zenkaku-escape ".")  "$B!%(B")

(defun its:select-hankaku-katakana ()
  (interactive)
  (its:select-mode "roma-han-kata"))

(define-key mule-keymap "x" 'its:select-hankaku-katakana)
(define-key fence-mode-map "\e\C-x" 'its:select-hankaku-katakana)
