/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "main.h"
#include "shared.h"

/* Signal handler */
static void sig_handler( int signal );

/*------------------------------------------------------------------------*/

  int
main (int argc, char *argv[])
{
  /* Main window */
  GtkWidget *main_window;

  /* Command line option returned by getopt() */
  int option;

  /* New and old actions for sigaction() */
  struct sigaction sa_new, sa_old;

  /* Initialize new actions */
  sa_new.sa_handler = sig_handler;
  sigemptyset( &sa_new.sa_mask );
  sa_new.sa_flags = 0;

  /* Register function to handle signals */
  sigaction( SIGINT,  &sa_new, &sa_old );
  sigaction( SIGSEGV, &sa_new, 0 );
  sigaction( SIGFPE,  &sa_new, 0 );
  sigaction( SIGTERM, &sa_new, 0 );
  sigaction( SIGABRT, &sa_new, 0 );

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  /* Process command line options */
  while( (option = getopt(argc, argv, "hv") ) != -1 )
	switch( option )
	{
	  case 'h': /* Print usage and exit */
		Usage();
		exit( 0 );

	  case 'v': /* Print version */
		puts( PACKAGE_STRING );
		exit( 0 );

	  default: /* Print usage and exit */
		Usage();
		exit( -1 );

	} /* End of switch( option ) */

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  main_window = create_main_window ();
  gtk_window_set_title( GTK_WINDOW(main_window), PACKAGE_STRING );

  /* Get Rx text buffer and scroller */
  gbl_rx_text_buffer = gtk_text_view_get_buffer
	( GTK_TEXT_VIEW(lookup_widget(main_window, "rx_textview")) );
  gbl_rx_scrolledwindow = lookup_widget( main_window, "rx_scrolledwindow" );

  /* Get widgets and spin buttons */
  gbl_scope       = lookup_widget( main_window, "scope" );
  gbl_waterfall   = lookup_widget( main_window, "waterfall" );
  gbl_scope_label = lookup_widget( main_window, "label1" );
  gbl_speed       = GTK_SPIN_BUTTON( lookup_widget(main_window, "speed") );
  gbl_squelch     = GTK_SPIN_BUTTON( lookup_widget(main_window, "squelch") );
  gbl_ratio       = GTK_SPIN_BUTTON( lookup_widget(main_window, "ratio") );
  rc_data.det_squelch = (int)gtk_spin_button_get_value_as_int( gbl_squelch );
  rc_data.det_ratio   = gtk_spin_button_get_value( gbl_ratio );
  rc_data.speed_wpm   = (int)gtk_spin_button_get_value_as_int( gbl_speed );
  Set_Flag( SELECT_LEVEL );
  Set_Flag( DISPLAY_SIGNAL );
  rc_data.unit_elem = 15;

  gtk_widget_show (main_window);

  /* Initialize FFT */
  Ifft_Init( FFT_INPUT_SIZE, gbl_wfall_width );

  /* Load runtime config file, abort on error */
  gtk_idle_add( Load_Config, NULL );

  gtk_main ();

  return 0;
}

/*------------------------------------------------------------------------*/

/*  Load_Config()
 *
 *  Loads the xdemorserc configuration file
 */

  gboolean
Load_Config( gpointer data )
{
  char
	rc_fpath[64], /* File path to xdemorserc */
	line[81];     /* Buffer for Load_Line  */

  /* Config file pointer */
  FILE *xdemorserc;

  /* ALSA channel names and values */
  char *chan_name[] =
  {
	"FRONT_LEFT",
	"FRONT_RIGHT",
	"REAR_LEFT",
	"REAR_RIGHT",
	"SIDE_LEFT",
	"SIDE_RIGHT",
	"MONO"
  };

  int chan_number[] =
  {
	SND_MIXER_SCHN_FRONT_LEFT,
	SND_MIXER_SCHN_FRONT_RIGHT,
	SND_MIXER_SCHN_REAR_LEFT,
	SND_MIXER_SCHN_REAR_RIGHT,
	SND_MIXER_SCHN_SIDE_LEFT,
	SND_MIXER_SCHN_SIDE_RIGHT,
	SND_MIXER_SCHN_MONO
  };

  int idx, num_chan = 7;

  /* Setup file path to xdemorserc */
  snprintf( rc_fpath, sizeof(rc_fpath), "%s/.xdemorserc", getenv("HOME") );

  /* Open xdemorserc file */
  xdemorserc = fopen( rc_fpath, "r" );
  if( xdemorserc == NULL )
  {
	perror( rc_fpath );
	Error_Dialog(
		_("Failed to open .xdemorserc file.\n"\
		  "Quit xdemorse and correct.\n"\
		  "(You may need to copy the file:\n"\
		  "/usr/share/doc/xdemorse/examples/xdemorserc.example\n"\
		  "to your <home-directory>/.xdemorserc and edit.)") );
	return( FALSE );
  }

  /*** Read runtime configuration data ***/
  /* Read card name, abort if EOF */
  if( Load_Line(line, xdemorserc, _("Card Name")) != SUCCESS )
 	return( FALSE );
  Strlcpy( rc_data.snd_card, line, sizeof(rc_data.snd_card) );

  /* Read DSP rate Samples/sec, abort if EOF */
  if( Load_Line(line, xdemorserc, _("DSP Rate") ) != SUCCESS )
	return( FALSE );
  rc_data.dsp_rate = atoi( line );

  /* Read ALSA "channel", abort if EOF */
  if( Load_Line(line, xdemorserc, _("ALSA Channel") ) != SUCCESS )
	return( FALSE );
  for( idx = 0; idx < num_chan; idx++ )
	if( strcmp(chan_name[idx], line) == 0 )
	  break;
  if( idx == num_chan )
  {
	fclose( xdemorserc );
	Error_Dialog(
		_("Invalid ALSA channel name\n"\
		  "Quit and correct xdemorserc") );
	return( FALSE );
  }
  rc_data.channel = chan_number[idx];

  /* Set right or left channel buffer index */
  if( strstr(line, "LEFT") || strstr(line, "MONO") )
	rc_data.use_chnl = 0;
  else
	rc_data.use_chnl = 1;

  /* Set number of channels */
  if( strstr(line, "MONO") ) rc_data.num_chnl = 1;
  else rc_data.num_chnl = 2;

  /* Read capture source, abort if EOF */
  if( Load_Line(line, xdemorserc, _("Capture Source")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cap_src, line, sizeof(rc_data.cap_src) );

  /* Read Capture volume control, abort if EOF */
  if( Load_Line(line, xdemorserc, _("Capture Volume Control")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cap_vol, line, sizeof(rc_data.cap_vol) );

  /* Read Capture volume, abort if EOF */
  if( Load_Line(line, xdemorserc, _("Capture Volume")) != SUCCESS )
	return( FALSE );
  rc_data.cap_level = atoi( line );

  /* Read max WPM, abort if EOF */
  if( Load_Line(line, xdemorserc, _("Maximum WPM")) != SUCCESS )
	return( FALSE );
  rc_data.min_unit = atoi( line );

  /* Read min WPM, abort if EOF */
  if( Load_Line(line, xdemorserc, _("Minimum WPM")) != SUCCESS )
	return( FALSE );
  rc_data.max_unit = atoi( line );

  /* Check range of Morse speeds. At this point max_unit
   * holds minimum wpm and min_unit holds maximum wpm */
  if( (rc_data.max_unit < MIN_SPEED) ||
	  (rc_data.min_unit > MAX_SPEED) )
  {
	fclose( xdemorserc );
	Error_Dialog(
		_("Morse code speed (WPM)\n"\
		  "range is out of limits\n"\
		  "Quit and correct xdemorserc") );
	return( FALSE );
  }

  /* Set spinbutton range */
  gtk_spin_button_set_range( gbl_speed,
	  (gdouble)rc_data.max_unit, (gdouble)rc_data.min_unit );

  /* Read and check initial WPM, abort if EOF */
  if( Load_Line(line, xdemorserc, _("Initial WPM")) != SUCCESS )
	return( FALSE );
  int wpm = atoi( line );

  /* Check initial Morse speed. At this point max_unit
   * holds minimum wpm and min_unit holds maximum wpm */
  if( (wpm > rc_data.min_unit) ||
	  (wpm < rc_data.max_unit) )
  {
	fclose( xdemorserc );
	Error_Dialog(
		_("Initial Morse code speed (WPM)\n"\
		  "is out of specified range\n"\
		  "Quit and correct xdemorserc") );
	return( FALSE );
  }

  /* Read CAT serial port device, abort if EOF */
  if( Load_Line(line, xdemorserc, _("CAT Serial Port")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cat_serial, line, sizeof(rc_data.cat_serial) );

  /* Read CAT enable flag, abort if EOF */
  if( Load_Line(line, xdemorserc, _("Transceiver type for CAT")) != SUCCESS )
	return( FALSE );
  if( strcmp(line, "FT847") == 0 )
	rc_data.tcvr_type = FT847;
  else if( strcmp(line, "FT857") == 0 )
	rc_data.tcvr_type = FT857;
  else if( strcmp(line, "K2") == 0 )
	rc_data.tcvr_type = K2;
  else if( strcmp(line, "K3") == 0 )
	rc_data.tcvr_type = K3;
  else if( strcmp(line, "NONE") == 0 )
	rc_data.tcvr_type = NONE;
  else
  {
	rc_data.tcvr_type = NONE;
	fclose( xdemorserc );
	Error_Dialog(
		_("Error reading Transceiver type\n"\
		  "Quit and correct xdemorserc") );
	return( FALSE );
  }

  /* Read input tone (Rx BFO) frequency */
  if( Load_Line(line, xdemorserc, _("Input Tone")) != SUCCESS )
	return( FALSE );
  rc_data.tone_freq = atoi( line );
  if( rc_data.tone_freq < 200 )
  {
	fclose( xdemorserc );
	Error_Dialog(
		_("Error reading BFO Tone Freq\n"\
		  "Quit and correct xdemorserc") );
	return( FALSE );
  }

  /* Puts the tone freq in middle of waterfall */
  idx = FFT_INPUT_SIZE / (gbl_wfall_width / 2);
 
  /* The tone freq must be rounded so that the fft_stride
   * is an integer otherwise the waterfall is not accurate */
  rc_data.fft_stride = rc_data.dsp_rate / rc_data.tone_freq  / idx;
  rc_data.tone_freq  = rc_data.dsp_rate / rc_data.fft_stride / idx;

  /* Calculate parameters that depend on above */
  rc_data.max_unit = (60 * rc_data.tone_freq) /
	(50 * CYCLES_PER_FRAG * rc_data.max_unit);
  rc_data.max_unit_x2 = rc_data.max_unit * 2;
  rc_data.min_unit = (60 * rc_data.tone_freq) /
	(50 * CYCLES_PER_FRAG * rc_data.min_unit);

  /* Set spinbutton value */
  gtk_spin_button_set_value( gbl_speed, (gdouble)wpm );
  rc_data.unit_elem =
	(60 * rc_data.tone_freq) / (50 * CYCLES_PER_FRAG * wpm);
  rc_data.center_line = gbl_wfall_width / 2 + 1;

  /* Enable Transceiver CAT */
  if( rc_data.tcvr_type == NONE )
	Clear_Flag( ENABLE_CAT );
  else
	Set_Flag( ENABLE_CAT );

  /* Allocate memory to recv samples buffer */
  samples_buffer.buffer_size = READI_FRAMES * rc_data.num_chnl;
  samples_buffer.buffer_idx  = samples_buffer.buffer_size;
  samples_buffer.buffer = NULL;
  if( !mem_alloc( (void *)&(samples_buffer.buffer),
		(size_t)samples_buffer.buffer_size * sizeof(short)) )
  {
	fclose( xdemorserc );
	return( FALSE );
  }
  memset( samples_buffer.buffer, 0,
	  (size_t)samples_buffer.buffer_size * sizeof(short) );

  Set_Flag( RCCONFIG_OK | CENTERLINE );
  if( Initialize_Detector() )
	Set_Flag( ENABLE_RECEIVE );

  fclose( xdemorserc );
  return( FALSE );
} /* End of Load_Config() */

/*------------------------------------------------------------------*/

/*  Load_Line()
 *
 *  Loads a line from a file, aborts on failure. Lines beginning
 *  with a '#' are ignored as comments. At the end of file EOF is
 *  returned. Lines assumed maximum 80 characters long.
 */

  int
Load_Line( char *buff, FILE *pfile, char *mesg )
{
  int
	num_chr, /* Number of characters read, excluding lf/cr */
	chr;     /* Character read by getc() */
  char error_mesg[MESG_SIZE];

  /* Prepare error message */
  snprintf( error_mesg, MESG_SIZE,
	  _("Error reading %s\n"\
		"Premature EOF (End Of File)"), mesg );

  /* Clear buffer at start */
  buff[0] = '\0';
  num_chr = 0;

  /* Get next character, return error if chr = EOF */
  if( (chr = fgetc(pfile)) == EOF )
  {
	fprintf( stderr, "xdemorse: %s\n", error_mesg );
	fclose( pfile );
	Error_Dialog( error_mesg );
	return( EOF );
  }

  /* Ignore commented lines, white spaces and eol/cr */
  while(
	  (chr == '#') ||
	  (chr == ' ') ||
	  (chr == HT ) ||
	  (chr == CR ) ||
	  (chr == LF ) )
  {
	/* Go to the end of line (look for LF or CR) */
	while( (chr != CR) && (chr != LF) )
	  /* Get next character, return error if chr = EOF */
	  if( (chr = fgetc(pfile)) == EOF )
	  {
		fprintf( stderr, "xdemorse: %s\n", error_mesg );
		fclose( pfile );
		Error_Dialog( error_mesg );
		return( EOF );
	  }

	/* Dump any CR/LF remaining */
	while( (chr == CR) || (chr == LF) )
	  /* Get next character, return error if chr = EOF */
	  if( (chr = fgetc(pfile)) == EOF )
	  {
		fprintf( stderr, "xdemorse: %s\n", error_mesg );
		fclose( pfile );
		Error_Dialog( error_mesg );
		return( EOF );
	  }

  } /* End of while( (chr == '#') || ... */

  /* Continue reading characters from file till
   * number of characters = 80 or EOF or CR/LF */
  while( num_chr < 80 )
  {
	/* If LF/CR reached before filling buffer, return line */
	if( (chr == LF) || (chr == CR) ) break;

	/* Enter new character to line buffer */
	buff[num_chr++] = (char)chr;

	/* Get next character */
	if( (chr = fgetc(pfile)) == EOF )
	{
	  /* Terminate buffer as a string if chr = EOF */
	  buff[num_chr] = '\0';
	  return( SUCCESS );
	}

	/* Abort if end of line not reached at 80 char. */
	if( (num_chr == 80) && (chr != LF) && (chr != CR) )
	{
	  /* Terminate buffer as a string */
	  buff[num_chr] = '\0';
	  snprintf( error_mesg, MESG_SIZE,
		  _("Error reading %s\n"\
			"Line longer than 80 characters"), mesg );
	  fprintf( stderr, "xdemorse: %s\n%s\n", error_mesg, buff );
	  fclose( pfile );
	  Error_Dialog( error_mesg );
	  return( ERROR );
	}

  } /* End of while( num_chr < max_chr ) */

  /* Terminate buffer as a string */
  buff[num_chr] = '\0';

  return( SUCCESS );
} /* End of Load_Line() */

/*------------------------------------------------------------------*/

/*  Print_Character()
 *
 *  Prints a character to a text view port
 */

  gboolean
Print_Character( gpointer data )
{
  /* Text buffer marker */
  static GtkTextIter iter;

  GtkAdjustment *adjustment;
  static double last_upper = 0.0;

  char
	dec_char = 0, /* Decoded Morse character */
	char2text[2]; /* Convert char to string  */

  /* Print decoded characters */
  if( Get_Character(&dec_char) )
  {
	/* Return on 0 char */
	if( !dec_char ) return( TRUE );

	/* Convert char to 'text' */
	char2text[0] = dec_char;
	char2text[1] = '\0';

	/* Print character */
	gtk_text_buffer_get_iter_at_offset(
		gbl_rx_text_buffer, &iter,
		gtk_text_buffer_get_char_count(
		  gbl_rx_text_buffer) );

	gtk_text_buffer_insert(
		gbl_rx_text_buffer, &iter, char2text, -1 );

	/* Scroll Text View to bottom on change of page size */
	adjustment = gtk_scrolled_window_get_vadjustment
	  ( GTK_SCROLLED_WINDOW(gbl_rx_scrolledwindow) );
	gdouble upper = gtk_adjustment_get_upper( adjustment );
	gdouble page_size = gtk_adjustment_get_page_size( adjustment );

	if( upper != last_upper )
	{
	  gtk_adjustment_set_value( adjustment, upper - page_size );
	  last_upper = page_size;
	}


	return( TRUE );
  } /* if( Get_Character(&dec_char) ) */

  return( FALSE );
} /* Print_Character() */

/*------------------------------------------------------------------------*/

/*  Usage()
 *
 *  Prints usage information
 */

  void
Usage( void )
{
  fprintf( stderr, "%s\n",
	  _("Usage: xdemorse [-hv]") );

  fprintf( stderr, "%s\n",
	  _("       -h: Print this usage information and exit"));

  fprintf( stderr, "%s\n",
	  _("       -v: Print version number and exit"));

} /* End of Usage() */

/*------------------------------------------------------------------------*/

/*  sig_handler()
 *
 *  Signal Action Handler function
 */

static void sig_handler( int signal )
{
  /* Wrap up and quit */
  Cleanup();
  fprintf( stderr, "\n" );
  switch( signal )
  {
	case SIGINT :
	  fprintf( stderr, "%s\n",  _("xdemorse: Exiting via User Interrupt") );
	  exit( signal );

	case SIGSEGV :
	  fprintf( stderr, "%s\n",  _("xdemorse: Segmentation Fault") );
	  exit( signal );

	case SIGFPE :
	  fprintf( stderr, "%s\n",  _("xdemorse: Floating Point Exception") );
	  exit( signal );

	case SIGABRT :
	  fprintf( stderr, "%s\n",  _("xdemorse: Abort Signal received") );
	  exit( signal );

	case SIGTERM :
	  fprintf( stderr, "%s\n",  _("xdemorse: Termination Request received") );
	  exit( signal );
  }

} /* End of sig_handler() */

/*------------------------------------------------------------------------*/

