/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* writerperfect
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2004 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2004-2006 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>

#include <libe-book/libe-book.h>

#include <libepubgen/libepubgen.h>

#include "EpubPackage.hxx"

class EpubOutputFileHelper
{
public:
	EpubOutputFileHelper(const char *const outFileName) :
		m_fileName(outFileName)
	{
	}

	bool convertDocument(librevenge::RVNGInputStream &input)
	{
		EpubPackage package(m_fileName);
		libepubgen::EPUBTextGenerator collector(&package);

		return libebook::EBOOKDocument::RESULT_OK == libebook::EBOOKDocument::parse(&input, &collector);
	}

	bool isSupportedFormat(librevenge::RVNGInputStream &input)
	{
		return libebook::EBOOKDocument::CONFIDENCE_EXCELLENT == libebook::EBOOKDocument::isSupported(&input);
	}

private:
	std::string m_fileName;
};

int printUsage(char *name)
{
	fprintf(stderr, "Usage : %s <infile> <outfile>\n", name);
	fprintf(stderr, "\twhere <infile> is the e-book source document\n");
	fprintf(stderr, "\tand <outfile> is the ePub target document.\n");
	return 1;
}

int main(int argc, char *argv[])
{
	if (argc != 3)
		return printUsage(argv[0]);

	char *szInputFile = argv[1];
	char *szOutFile = argv[2];

	if (!szInputFile || !szOutFile)
		return printUsage(argv[0]);

	librevenge::RVNGFileStream input(szInputFile);
	EpubOutputFileHelper helper(szOutFile);

	if (!helper.isSupportedFormat(input))
	{
		fprintf(stderr, "ERROR: the document is not in any supported format.\n");
		return 1;
	}

	if (!helper.convertDocument(input))
	{
		fprintf(stderr, "ERROR : Couldn't convert the document\n");
		return 1;
	}

	return 0;
}

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
