/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.FontMetrics;
import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionEditDialog;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.SimulationObject;

public class ExpressionObject
extends ConstructionObject
implements MoveableObject,
SimulationObject {
    protected double X;
    protected double Y;
    private static Count N = new Count();
    Expression E;
    protected Expression EX;
    protected Expression EY;
    protected boolean Fixed;
    String Prompt = Zirkel.name("expression.value");
    protected double CurrentValue = 0.0;
    protected boolean CurrentValueValid = true;
    protected boolean Slider = false;
    protected Expression SMin;
    protected Expression SMax;
    public double C;
    public double R;
    public double W;
    public double H;
    public double SC;
    public double SR;
    public double SW;
    public double SH;
    public double SX;
    public double SY;
    public double SD;
    private double OldE;
    double oldx;
    double oldy;
    double startx;
    double starty;
    boolean DragSlider;

    public ExpressionObject(Construction construction, double d2, double d3) {
        super(construction);
        this.X = d2;
        this.Y = d3;
        this.setColor(this.ColorIndex);
        this.updateText();
    }

    public String getTag() {
        return "Expression";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        if (this.E != null) {
            this.setText(ExpressionObject.text3(Zirkel.name("text.expression"), this.E.toString(), "" + this.roundDisplay(this.X), "" + this.roundDisplay(this.Y)));
        } else {
            this.setText(ExpressionObject.text3(Zirkel.name("text.expression"), "", "" + this.roundDisplay(this.X), "" + this.roundDisplay(this.Y)));
        }
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        this.DisplaysText = false;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        this.C = zirkelCanvas.col(this.X);
        this.R = zirkelCanvas.row(this.Y);
        this.setFont(myGraphics);
        FontMetrics fontMetrics = myGraphics.getFontMetrics();
        if (this.isStrongSelected() && myGraphics instanceof MyGraphics) {
            ((MyGraphics13)myGraphics).drawMarkerRect(this.C - 5.0, this.R - 5.0, 10.0, 10.0);
        }
        myGraphics.setColor(this);
        String string = "";
        if (this.showName()) {
            string = this.Prompt;
            string = this.showValue() ? (string.endsWith("_") && string.length() > 1 ? string.substring(0, string.length() - 1) : string + " = ") : this.Prompt;
        }
        if (this.showValue()) {
            try {
                this.E.getValue();
                double d2 = this.round(this.CurrentValue);
                if (this.Slider) {
                    d2 = this.round(this.CurrentValue, 100.0);
                }
                string = Math.abs(d2 - (double)Math.round(d2)) < 1.0E-10 ? string + (int)d2 : string + d2;
            }
            catch (Exception exception) {
                string = string + "???";
            }
        }
        string = string + this.Unit;
        string = AngleObject.translateToUnicode(string);
        this.W = fontMetrics.stringWidth("---");
        if (string.equals("") && !this.Slider) {
            string = "-";
        }
        if (!string.equals("")) {
            this.setFont(myGraphics);
            this.R -= (double)fontMetrics.getAscent();
            this.H = myGraphics.drawStringExtended(string, this.C, this.R);
        }
        if (this.Slider) {
            int n = (int)(4.0 * zirkelCanvas.pointSize());
            this.R += this.H;
            myGraphics.drawLine(this.C, this.R + (double)(n / 2), this.C + (double)(10 * n), this.R + (double)(n / 2));
            double d3 = this.getSliderPosition();
            int n2 = n / 4;
            double d4 = this.C + d3 * 10.0 * (double)n;
            if (this.getColorType() == 1) {
                myGraphics.fillOval(d4 - (double)n2, this.R + (double)(n / 2) - (double)n2, 2 * n2, 2 * n2, true, false, this);
            } else {
                myGraphics.drawOval(d4 - (double)n2, this.R + (double)(n / 2) - (double)n2, 2 * n2, 2 * n2);
            }
            this.SC = d4 - (double)n2;
            this.SR = this.R + (double)(n / 2) - (double)n2;
            this.SW = this.SH = (double)(2 * n2);
            this.SX = zirkelCanvas.x((int)this.C);
            this.SY = zirkelCanvas.y((int)this.R + n / 2 - n2);
            this.SD = zirkelCanvas.x((int)this.C + 10 * n) - this.SX;
            this.R -= this.H;
        }
    }

    public double getSliderPosition() {
        try {
            double d2 = this.SMin.getValue();
            double d3 = this.SMax.getValue();
            double d4 = this.CurrentValue;
            if (d2 >= d3) {
                this.Valid = false;
                return 0.0;
            }
            if (d4 < d2) {
                d4 = d2;
            }
            if (d4 > d3) {
                d4 = d3;
            }
            return (d4 - d2) / (d3 - d2);
        }
        catch (Exception exception) {
            this.Valid = false;
            return 0.0;
        }
    }

    public void setSliderPosition(double d2) {
        try {
            double d3 = this.SMin.getValue();
            double d4 = this.SMax.getValue();
            if (d3 >= d4) {
                this.Valid = false;
                return;
            }
            double d5 = d3 + d2 * (d4 - d3);
            if (d5 < d3) {
                d5 = d3;
            }
            if (d5 > d4) {
                d5 = d4;
            }
            this.E.setValue(d5);
        }
        catch (Exception exception) {
            this.Valid = false;
        }
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        this.DragSlider = false;
        if (this.Valid && !this.displays(zirkelCanvas)) {
            return false;
        }
        if (this.C <= (double)n && (double)n <= this.C + this.W && this.R <= (double)n2 && (double)n2 <= this.R + this.H) {
            return true;
        }
        if (this.SC <= (double)n && this.SR <= (double)n2 && this.SC + this.SW >= (double)n && this.SR + this.SH >= (double)n2) {
            this.DragSlider = true;
            return true;
        }
        return false;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public void move(double d2, double d3) {
        this.X = d2;
        this.Y = d3;
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
    }

    public void round() {
        this.move(this.round(this.X, ZirkelCanvas.LengthsFactor), this.round(this.Y, ZirkelCanvas.LengthsFactor));
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        Warning warning;
        Frame frame;
        ExpressionEditDialog expressionEditDialog = new ExpressionEditDialog(zirkelCanvas.getFrame(), zirkelCanvas, this);
        expressionEditDialog.setVisible(true);
        zirkelCanvas.repaint();
        if (this.E != null && !this.E.isValid()) {
            frame = zirkelCanvas.getFrame();
            warning = new Warning(frame, this.E.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
        if (this.EX != null && !this.EX.isValid()) {
            frame = zirkelCanvas.getFrame();
            warning = new Warning(frame, this.EX.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        } else if (this.EY != null && !this.EY.isValid()) {
            frame = zirkelCanvas.getFrame();
            warning = new Warning(frame, this.EY.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
        this.validate();
        if (expressionEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            xmlWriter.printArg("x", this.EX.toString());
        } else {
            xmlWriter.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            xmlWriter.printArg("y", this.EY.toString());
        } else {
            xmlWriter.printArg("y", "" + this.Y);
        }
        if (this.E != null) {
            xmlWriter.printArg("value", this.E.toString());
        } else {
            xmlWriter.printArg("value", "");
        }
        xmlWriter.printArg("prompt", this.Prompt);
        if (this.Fixed) {
            xmlWriter.printArg("fixed", "true");
        }
        if (this.Slider) {
            xmlWriter.printArg("slider", "true");
            xmlWriter.printArg("min", this.SMin.toString());
            xmlWriter.printArg("max", this.SMax.toString());
        }
    }

    public boolean equals(ConstructionObject constructionObject) {
        return false;
    }

    public void setExpression(String string, Construction construction) throws ConstructionException {
        this.E = new Expression(string, construction, this);
        this.updateText();
    }

    public void setFixed(String string) {
        this.E = new Expression(string, this.getConstruction(), this);
        this.updateText();
    }

    public String getExpression() {
        if (this.E != null) {
            return this.E.toString();
        }
        return "";
    }

    public Enumeration depending() {
        Enumeration enumeration;
        DL.reset();
        if (this.E != null) {
            enumeration = this.E.getDepList().elements();
            while (enumeration.hasMoreElements()) {
                DL.add((ConstructionObject)enumeration.nextElement());
            }
        }
        if (this.Fixed) {
            if (this.EX != null) {
                enumeration = this.EX.getDepList().elements();
                while (enumeration.hasMoreElements()) {
                    DL.add((ConstructionObject)enumeration.nextElement());
                }
            }
            if (this.EY != null) {
                enumeration = this.EY.getDepList().elements();
                while (enumeration.hasMoreElements()) {
                    DL.add((ConstructionObject)enumeration.nextElement());
                }
            }
        }
        return DL.elements();
    }

    public double getValue() throws ConstructionException {
        if (!this.CurrentValueValid) {
            throw new InvalidException("");
        }
        return this.CurrentValue;
    }

    public String getPrompt() {
        return this.Prompt;
    }

    public void setPrompt(String string) {
        this.Prompt = string;
    }

    public void translate() {
        this.E.translate();
        if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateText();
    }

    public void validate() {
        try {
            this.CurrentValue = this.E.getValue();
            this.CurrentValueValid = true;
        }
        catch (Exception exception) {
            this.CurrentValueValid = false;
        }
        this.Valid = true;
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception exception) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception exception) {
                this.Valid = false;
                return;
            }
        }
    }

    public void setFixed(boolean bl) {
        this.Fixed = bl;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    public void setFixed(String string, String string2) {
        this.Fixed = true;
        this.EX = new Expression(string, this.getConstruction(), this);
        this.EY = new Expression(string2, this.getConstruction(), this);
        this.updateText();
    }

    public ConstructionObject copy() {
        try {
            ExpressionObject expressionObject = (ExpressionObject)this.clone();
            this.setTranslation(expressionObject);
            expressionObject.setExpression(this.E.toString(), this.getConstruction());
            expressionObject.translateConditionals();
            expressionObject.translate();
            expressionObject.setName();
            expressionObject.updateText();
            expressionObject.setBreak(false);
            expressionObject.setTarget(false);
            return expressionObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDefaults() {
        super.setDefaults();
        this.setShowValue(true);
    }

    public boolean moveable() {
        if (this.Slider) {
            return true;
        }
        return this.EX == null && this.EY == null;
    }

    public void reset() {
        if (this.E != null) {
            this.E.reset();
        }
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public void setCurrentValue(double d2) {
        this.CurrentValue = d2;
        this.CurrentValueValid = true;
    }

    public void setSimulationValue(double d2) {
        this.OldE = this.CurrentValue;
        this.CurrentValue = d2;
    }

    public void resetSimulationValue() {
        this.CurrentValue = this.OldE;
    }

    public void setSlider(String string, String string2) {
        this.Slider = true;
        this.SMin = new Expression(string, this.getConstruction(), this);
        this.SMax = new Expression(string2, this.getConstruction(), this);
    }

    public void setSlider(boolean bl) {
        this.Slider = bl;
    }

    public void startDrag(double d2, double d3) {
        this.oldx = this.X;
        this.oldy = this.Y;
        this.startx = d2;
        this.starty = d3;
    }

    public void dragTo(double d2, double d3) {
        if (this.DragSlider) {
            this.setSliderPosition((d2 - this.SX) / this.SD);
        } else {
            this.move(this.oldx + (d2 - this.startx), this.oldy + (d3 - this.starty));
        }
    }

    public boolean isSlider() {
        return this.Slider;
    }

    public String getMin() {
        if (this.Slider) {
            return this.SMin.toString();
        }
        return "-5";
    }

    public String getMax() {
        if (this.Slider) {
            return this.SMax.toString();
        }
        return "5";
    }

    public String getDisplayValue() {
        String string = "";
        try {
            this.E.getValue();
            double d2 = this.round(this.CurrentValue);
            if (this.Slider) {
                d2 = this.round(this.CurrentValue, 100.0);
            }
            string = Math.abs(d2 - (double)Math.round(d2)) < 1.0E-10 ? string + (int)d2 : string + d2;
        }
        catch (Exception exception) {
            string = string + "???";
        }
        string = string + this.Unit;
        return string;
    }

    public String getEquation() {
        if (this.E == null) {
            return "???";
        }
        return this.E.toString();
    }
}

