/* WhySynth DSSI software synthesizer GUI
 *
 * Copyright (C) 2004-2008 Sean Bolton and others.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#ifndef _GUI_INTERFACE_H
#define _GUI_INTERFACE_H

#include <gtk/gtk.h>
#include "gui_popmenu.h"

extern GtkWidget *main_window;
extern GtkObject *main_test_note_key_adj;
extern GtkObject *main_test_note_velocity_adj;

extern GtkWidget *patches_clist;

extern GtkWidget *about_window;
extern GtkWidget *about_label;

extern GtkWidget *open_file_chooser;
extern GtkObject *open_file_position_spin_adj;
extern GtkWidget *open_file_position_name_label;

extern GtkWidget *save_file_chooser;
extern GtkObject *save_file_start_spin_adj;
extern GtkWidget *save_file_start_name;
extern GtkObject *save_file_end_spin_adj;
extern GtkWidget *save_file_end_name;
#ifdef DEVELOPER
extern GtkWidget *save_file_c_mode_button;
#endif /* DEVELOPER */

extern GtkWidget *import_file_chooser;
extern GtkObject *import_file_position_spin_adj;
extern GtkWidget *import_file_position_name_label;
extern GtkWidget *import_file_position_dual_button;

extern GtkWidget *notice_window;
extern GtkWidget *notice_label_1;
extern GtkWidget *notice_label_2;

extern GtkWidget *edit_window;
extern GtkObject *edit_test_note_key_adj;
extern GtkObject *edit_test_note_velocity_adj;
extern GtkWidget *edit_test_note_button;
extern GtkWidget *edit_test_note_toggle;

extern GtkWidget *edit_save_position_window;
extern GtkObject *edit_save_position_spin_adj;
extern GtkWidget *edit_save_position_name_label;

extern GtkWidget *name_entry;
extern GtkWidget *comment_entry;

extern GtkObject *tuning_adj;
extern GtkObject *polyphony_adj;
extern GtkWidget *monophonic_option_menu;
extern GtkWidget *glide_option_menu;
extern GtkWidget *program_cancel_button;

struct voice_widgets {
    GtkWidget *widget;    /* knob, spin button, popmenubutton, etc. */
    GtkObject *adjustment;
    GtkWidget *top_label;
    GtkWidget *label1;    /* knob lower left label, detent value label */
    GtkWidget *label2;    /* knob lower right label */
    int        last_mode;
};

extern struct voice_widgets voice_widgets[];

extern popmenu *popmenus[];

void create_windows(const char *instance_tag);

#endif /* _GUI_INTERFACE_H */

