/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkX3D.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkX3D.h"

#define X3DATTRIBUTENUM 348
#define X3DELEMENTNUM 171


const char* x3dElementString[X3DELEMENTNUM] = {
    "Shape",
    "Appearance",
    "Material",
    "IndexedFaceSet",
    "ProtoInstance",
    "Transform",
    "ImageTexture",
    "TextureTransform",
    "Coordinate",
    "Normal",
    "Color",
    "ColorRGBA",
    "TextureCoordinate",
    "ROUTE",
    "fieldValue",
    "Group",
    "LOD",
    "Switch",
    "Script",
    "IndexedTriangleFanSet",
    "IndexedTriangleSet",
    "IndexedTriangleStripSet",
    "MultiTexture",
    "MultiTextureCoordinate",
    "MultiTextureTransform",
    "IndexedLineSet",
    "PointSet",
    "StaticGroup",
    "Sphere",
    "Box",
    "Cone",
    "Anchor",
    "Arc2D",
    "ArcClose2D",
    "AudioClip",
    "Background",
    "Billboard",
    "BooleanFilter",
    "BooleanSequencer",
    "BooleanToggle",
    "BooleanTrigger",
    "Circle2D",
    "Collision",
    "ColorInterpolator",
    "Contour2D",
    "ContourPolyline2D",
    "CoordinateDouble",
    "CoordinateInterpolator",
    "CoordinateInterpolator2D",
    "Cylinder",
    "CylinderSensor",
    "DirectionalLight",
    "Disk2D",
    "EXPORT",
    "ElevationGrid",
    "EspduTransform",
    "ExternProtoDeclare",
    "Extrusion",
    "FillProperties",
    "Fog",
    "FontStyle",
    "GeoCoordinate",
    "GeoElevationGrid",
    "GeoLOD",
    "GeoLocation",
    "GeoMetadata",
    "GeoOrigin",
    "GeoPositionInterpolator",
    "GeoTouchSensor",
    "GeoViewpoint",
    "HAnimDisplacer",
    "HAnimHumanoid",
    "HAnimJoint",
    "HAnimSegment",
    "HAnimSite",
    "IMPORT",
    "IS",
    "Inline",
    "IntegerSequencer",
    "IntegerTrigger",
    "KeySensor",
    "LineProperties",
    "LineSet",
    "LoadSensor",
    "MetadataDouble",
    "MetadataFloat",
    "MetadataInteger",
    "MetadataSet",
    "MetadataString",
    "MovieTexture",
    "NavigationInfo",
    "NormalInterpolator",
    "NurbsCurve",
    "NurbsCurve2D",
    "NurbsOrientationInterpolator",
    "NurbsPatchSurface",
    "NurbsPositionInterpolator",
    "NurbsSet",
    "NurbsSurfaceInterpolator",
    "NurbsSweptSurface",
    "NurbsSwungSurface",
    "NurbsTextureCoordinate",
    "NurbsTrimmedSurface",
    "OrientationInterpolator",
    "PixelTexture",
    "PlaneSensor",
    "PointLight",
    "Polyline2D",
    "Polypoint2D",
    "PositionInterpolator",
    "PositionInterpolator2D",
    "ProtoBody",
    "ProtoDeclare",
    "ProtoInterface",
    "ProximitySensor",
    "ReceiverPdu",
    "Rectangle2D",
    "ScalarInterpolator",
    "Scene",
    "SignalPdu",
    "Sound",
    "SphereSensor",
    "SpotLight",
    "StringSensor",
    "Text",
    "TextureBackground",
    "TextureCoordinateGenerator",
    "TimeSensor",
    "TimeTrigger",
    "TouchSensor",
    "TransmitterPdu",
    "TriangleFanSet",
    "TriangleSet",
    "TriangleSet2D",
    "TriangleStripSet",
    "Viewpoint",
    "VisibilitySensor",
    "WorldInfo",
    "X3D",
    "component",
    "connect",
    "field",
    "head",
    "humanoidBodyType",
    "meta",
    "CADAssembly",
    "CADFace",
    "CADLayer",
    "CADPart",
    "ComposedCubeMapTexture",
    "ComposedShader",
    "ComposedTexture3D",
    "FloatVertexAttribute",
    "FogCoordinate",
    "GeneratedCubeMapTexture",
    "ImageCubeMapTexture",
    "ImageTexture3D",
    "IndexedQuadSet",
    "LocalFog",
    "Matrix3VertexAttribute",
    "Matrix4VertexAttribute",
    "PackagedShader",
    "PixelTexture3D",
    "ProgramShader",
    "QuadSet",
    "ShaderPart",
    "ShaderProgram",
    "TextureCoordinate3D",
    "TextureCoordinate4D",
    "TextureTransform3D",
    "TextureTransformMatrix3D"
  };

const char* x3dAttributeString[X3DATTRIBUTENUM] = {
  "DEF",
  "USE",
  "containerField",
  "fromNode",
  "fromField",
  "toNode",
  "toField",
  "name",
  "value",
  "color",
  "colorIndex",
  "coordIndex",
  "texCoordIndex",
  "normalIndex",
  "colorPerVertex",
  "normalPerVertex",
  "rotation",
  "scale",
  "center",
  "scaleOrientation",
  "translation",
  "url",
  "repeatS",
  "repeatT",
  "point",
  "vector",
  "range",
  "ambientIntensity",
  "diffuseColor",
  "emissiveColor",
  "shininess",
  "specularColor",
  "transparency",
  "whichChoice",
  "index",
  "mode",
  "source",
  "function",
  "alpha",
  "vertexCount",
  "radius",
  "size",
  "height",
  "solid",
  "ccw",
  "key",
  "keyValue",
  "enabled",
  "direction",
  "position",
  "orientation",
  "bboxCenter",
  "bboxSize",
  "AS",
  "InlineDEF",
  "accessType",
  "actionKeyPress",
  "actionKeyRelease",
  "address",
  "altKey",
  "antennaLocation",
  "antennaPatternLength",
  "antennaPatternType",
  "applicationID",
  "articulationParameterArray",
  "articulationParameterChangeIndicatorArray",
  "articulationParameterCount",
  "articulationParameterDesignatorArray",
  "articulationParameterIdPartAttachedArray",
  "articulationParameterTypeArray",
  "attenuation",
  "autoOffset",
  "avatarSize",
  "axisOfRotation",
  "backUrl",
  "beamWidth",
  "beginCap",
  "bindTime",
  "bottom",
  "bottomRadius",
  "bottomUrl",
  "centerOfMass",
  "centerOfRotation",
  "child1Url",
  "child2Url",
  "child3Url",
  "child4Url",
  "class",
  "closureType",
  "collideTime",
  "content",
  "controlKey",
  "controlPoint",
  "convex",
  "coordinateSystem",
  "copyright",
  "creaseAngle",
  "crossSection",
  "cryptoKeyID",
  "cryptoSystem",
  "cutOffAngle",
  "cycleInterval",
  "cycleTime",
  "data",
  "dataFormat",
  "dataLength",
  "dataUrl",
  "date",
  "deadReckoning",
  "deletionAllowed",
  "description",
  "detonateTime",
  "dir",
  "directOutput",
  "diskAngle",
  "displacements",
  "documentation",
  "elapsedTime",
  "ellipsoid",
  "encodingScheme",
  "endAngle",
  "endCap",
  "enterTime",
  "enteredText",
  "entityCategory",
  "entityCountry",
  "entityDomain",
  "entityExtra",
  "entityID",
  "entityKind",
  "entitySpecific",
  "entitySubCategory",
  "exitTime",
  "extent",
  "family",
  "fanCount",
  "fieldOfView",
  "filled",
  "finalText",
  "fireMissionIndex",
  "fired1",
  "fired2",
  "firedTime",
  "firingRange",
  "firingRate",
  "fogType",
  "forceID",
  "frequency",
  "frontUrl",
  "fuse",
  "geoCoords",
  "geoGridOrigin",
  "geoSystem",
  "groundAngle",
  "groundColor",
  "hatchColor",
  "hatchStyle",
  "hatched",
  "headlight",
  "horizontal",
  "horizontalDatum",
  "http-equiv",
  "image",
  "importedDEF",
  "info",
  "innerRadius",
  "inputFalse",
  "inputNegate",
  "inputSource",
  "inputTrue",
  "integerKey",
  "intensity",
  "jump",
  "justify",
  "keyPress",
  "keyRelease",
  "knot",
  "lang",
  "language",
  "leftToRight",
  "leftUrl",
  "length",
  "lengthOfModulationParameters",
  "level",
  "limitOrientation",
  "lineSegments",
  "linearAcceleration",
  "linearVelocity",
  "linetype",
  "linewidthScaleFactor",
  "llimit",
  "load",
  "loadTime",
  "localDEF",
  "location",
  "loop",
  "marking",
  "mass",
  "maxAngle",
  "maxBack",
  "maxExtent",
  "maxFront",
  "maxPosition",
  "metadataFormat",
  "minAngle",
  "minBack",
  "minFront",
  "minPosition",
  "modulationTypeDetail",
  "modulationTypeMajor",
  "modulationTypeSpreadSpectrum",
  "modulationTypeSystem",
  "momentsOfInertia",
  "multicastRelayHost",
  "multicastRelayPort",
  "munitionApplicationID",
  "munitionEndPoint",
  "munitionEntityID",
  "munitionQuantity",
  "munitionSiteID",
  "munitionStartPoint",
  "mustEvaluate",
  "navType",
  "networkMode",
  "next",
  "nodeField",
  "offset",
  "on",
  "order",
  "originator",
  "outerRadius",
  "parameter",
  "pauseTime",
  "pitch",
  "points",
  "port",
  "power",
  "previous",
  "priority",
  "profile",
  "progress",
  "protoField",
  "radioEntityTypeCategory",
  "radioEntityTypeCountry",
  "radioEntityTypeDomain",
  "radioEntityTypeKind",
  "radioEntityTypeNomenclature",
  "radioEntityTypeNomenclatureVersion",
  "radioID",
  "readInterval",
  "receivedPower",
  "receiverState",
  "reference",
  "relativeAntennaLocation",
  "resolution",
  "resumeTime",
  "rightUrl",
  "rootUrl",
  "rotateYUp",
  "rtpHeaderExpected",
  "sampleRate",
  "samples",
  "shiftKey",
  "side",
  "siteID",
  "skinCoordIndex",
  "skinCoordWeight",
  "skyAngle",
  "skyColor",
  "spacing",
  "spatialize",
  "speed",
  "speedFactor",
  "spine",
  "startAngle",
  "startTime",
  "stiffness",
  "stopTime",
  "string",
  "stripCount",
  "style",
  "summary",
  "tdlType",
  "tessellation",
  "tessellationScale",
  "time",
  "timeOut",
  "timestamp",
  "title",
  "toggle",
  "top",
  "topToBottom",
  "topUrl",
  "touchTime",
  "transmitFrequencyBandwidth",
  "transmitState",
  "transmitterApplicationID",
  "transmitterEntityID",
  "transmitterRadioID",
  "transmitterSiteID",
  "transparent",
  "triggerTime",
  "triggerTrue",
  "triggerValue",
  "type",
  "uDimension",
  "uKnot",
  "uOrder",
  "uTessellation",
  "ulimit",
  "vDimension",
  "vKnot",
  "vOrder",
  "vTessellation",
  "version",
  "verticalDatum",
  "vertices",
  "visibilityLimit",
  "visibilityRange",
  "warhead",
  "weight",
  "whichGeometry",
  "writeInterval",
  "xDimension",
  "xSpacing",
  "yScale",
  "zDimension",
  "zSpacing",
  "visible",
  "repeatR",
  "texture",
  "back",
  "front",
  "left",
  "right",
  "parts",
  "isSelected",
  "isValid",
  "numComponents",
  "depth",
  "update",
  "fogCoord",
  "texCoord",
  "activate",
  "programs",
  "matrix"
  };

