// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQADD_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SQADD_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sqadd_2D[] = {
  0x00000000000000fa, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000001,
  0x000000000000007e, 0x0000000000000002,
  0x000000000000007f, 0x0000000000000040,
  0x00000000000000bd, 0x000000000000007d,
  0x00000000000000fa, 0x000000000000007e,
  0x00000000000000fb, 0x000000000000007f,
  0x00000000000000fc, 0x0000000000007ffd,
  0x000000000000807a, 0x0000000000007ffe,
  0x000000000000807b, 0x0000000000007fff,
  0x000000000000807c, 0x000000007ffffffd,
  0x000000008000007a, 0x000000007ffffffe,
  0x000000008000007b, 0x000000007fffffff,
  0x000000008000007c, 0x3333333333333333,
  0x33333333333333b0, 0x5555555555555555,
  0x55555555555555d2, 0x7ffffffffffffffd,
  0x7fffffffffffffff, 0x7ffffffffffffffe,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000000000,
  0x800000000000007d, 0x8000000000000001,
  0x800000000000007e, 0x8000000000000002,
  0x800000000000007f, 0x8000000000000003,
  0x8000000000000080, 0xaaaaaaaaaaaaaaaa,
  0xaaaaaaaaaaaaab27, 0xcccccccccccccccc,
  0xcccccccccccccd49, 0xffffffff80000000,
  0xffffffff8000007d, 0xffffffff80000001,
  0xffffffff8000007e, 0xffffffff80000002,
  0xffffffff8000007f, 0xffffffff80000003,
  0xffffffff80000080, 0xffffffffffff8000,
  0xffffffffffff807d, 0xffffffffffff8001,
  0xffffffffffff807e, 0xffffffffffff8002,
  0xffffffffffff807f, 0xffffffffffff8003,
  0xffffffffffff8080, 0xffffffffffffff80,
  0xfffffffffffffffd, 0xffffffffffffff81,
  0xfffffffffffffffe, 0xffffffffffffff82,
  0xffffffffffffffff, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffffc0,
  0x000000000000003d, 0xfffffffffffffffd,
  0x000000000000007a, 0xfffffffffffffffe,
  0x000000000000007b, 0xffffffffffffffff,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000041,
  0x0000000000000040, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x3333333333333334,
  0x3333333333333333, 0x5555555555555556,
  0x5555555555555555, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000004,
  0x8000000000000003, 0xaaaaaaaaaaaaaaab,
  0xaaaaaaaaaaaaaaaa, 0xcccccccccccccccd,
  0xcccccccccccccccc, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffffc1,
  0xffffffffffffffc0, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000042,
  0x0000000000000041, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x3333333333333335,
  0x3333333333333334, 0x5555555555555557,
  0x5555555555555556, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000005,
  0x8000000000000004, 0xaaaaaaaaaaaaaaac,
  0xaaaaaaaaaaaaaaab, 0xccccccccccccccce,
  0xcccccccccccccccd, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000005,
  0xffffffff80000004, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffffc2,
  0xffffffffffffffc1, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000040,
  0x0000000000000002, 0x0000000000000041,
  0x0000000000000003, 0x0000000000000042,
  0x0000000000000004, 0x0000000000000080,
  0x0000000000000042, 0x00000000000000bd,
  0x000000000000007f, 0x00000000000000be,
  0x0000000000000080, 0x00000000000000bf,
  0x0000000000000081, 0x000000000000803d,
  0x0000000000007fff, 0x000000000000803e,
  0x0000000000008000, 0x000000000000803f,
  0x0000000000008001, 0x000000008000003d,
  0x000000007fffffff, 0x000000008000003e,
  0x0000000080000000, 0x000000008000003f,
  0x0000000080000001, 0x3333333333333373,
  0x3333333333333335, 0x5555555555555595,
  0x5555555555555557, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000000040,
  0x8000000000000002, 0x8000000000000041,
  0x8000000000000003, 0x8000000000000042,
  0x8000000000000004, 0x8000000000000043,
  0x8000000000000005, 0xaaaaaaaaaaaaaaea,
  0xaaaaaaaaaaaaaaac, 0xcccccccccccccd0c,
  0xccccccccccccccce, 0xffffffff80000040,
  0xffffffff80000002, 0xffffffff80000041,
  0xffffffff80000003, 0xffffffff80000042,
  0xffffffff80000004, 0xffffffff80000043,
  0xffffffff80000005, 0xffffffffffff8040,
  0xffffffffffff8002, 0xffffffffffff8041,
  0xffffffffffff8003, 0xffffffffffff8042,
  0xffffffffffff8004, 0xffffffffffff8043,
  0xffffffffffff8005, 0xffffffffffffffc0,
  0xffffffffffffff82, 0xffffffffffffffc1,
  0xffffffffffffff83, 0xffffffffffffffc2,
  0xffffffffffffff84, 0xffffffffffffffc3,
  0xffffffffffffff85, 0x0000000000000000,
  0xffffffffffffffc2, 0x000000000000003d,
  0xffffffffffffffff, 0x000000000000003e,
  0x0000000000000000, 0x000000000000003f,
  0x000000000000003f, 0x000000000000007d,
  0x0000000000000040, 0x000000000000007e,
  0x0000000000000041, 0x000000000000007f,
  0x0000000000000042, 0x00000000000000bd,
  0x0000000000000080, 0x00000000000000fa,
  0x00000000000000bd, 0x00000000000000fb,
  0x00000000000000be, 0x00000000000000fc,
  0x00000000000000bf, 0x000000000000807a,
  0x000000000000803d, 0x000000000000807b,
  0x000000000000803e, 0x000000000000807c,
  0x000000000000803f, 0x000000008000007a,
  0x000000008000003d, 0x000000008000007b,
  0x000000008000003e, 0x000000008000007c,
  0x000000008000003f, 0x33333333333333b0,
  0x3333333333333373, 0x55555555555555d2,
  0x5555555555555595, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x800000000000007d,
  0x8000000000000040, 0x800000000000007e,
  0x8000000000000041, 0x800000000000007f,
  0x8000000000000042, 0x8000000000000080,
  0x8000000000000043, 0xaaaaaaaaaaaaab27,
  0xaaaaaaaaaaaaaaea, 0xcccccccccccccd49,
  0xcccccccccccccd0c, 0xffffffff8000007d,
  0xffffffff80000040, 0xffffffff8000007e,
  0xffffffff80000041, 0xffffffff8000007f,
  0xffffffff80000042, 0xffffffff80000080,
  0xffffffff80000043, 0xffffffffffff807d,
  0xffffffffffff8040, 0xffffffffffff807e,
  0xffffffffffff8041, 0xffffffffffff807f,
  0xffffffffffff8042, 0xffffffffffff8080,
  0xffffffffffff8043, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffe,
  0xffffffffffffffc1, 0xffffffffffffffff,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffc3, 0x000000000000003d,
  0x0000000000000000, 0x000000000000007a,
  0x000000000000003d, 0x000000000000007b,
  0x000000000000003e, 0x000000000000007c,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x00000000000000be,
  0x00000000000000bd, 0x00000000000000fb,
  0x00000000000000fa, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x33333333333333b1,
  0x33333333333333b0, 0x55555555555555d3,
  0x55555555555555d2, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000081,
  0x8000000000000080, 0xaaaaaaaaaaaaab28,
  0xaaaaaaaaaaaaab27, 0xcccccccccccccd4a,
  0xcccccccccccccd49, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffffffff807e,
  0xffffffffffff807d, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000000000003e,
  0x000000000000003d, 0x000000000000007b,
  0x000000000000007a, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x00000000000000bf,
  0x00000000000000be, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fe,
  0x00000000000000fd, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x33333333333333b2,
  0x33333333333333b1, 0x55555555555555d4,
  0x55555555555555d3, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000081,
  0x8000000000000080, 0x8000000000000082,
  0x8000000000000081, 0xaaaaaaaaaaaaab29,
  0xaaaaaaaaaaaaab28, 0xcccccccccccccd4b,
  0xcccccccccccccd4a, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000082,
  0xffffffff80000081, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8082,
  0xffffffffffff8081, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000000000003f,
  0x000000000000003e, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007e, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000000081, 0x000000000000803d,
  0x00000000000000bf, 0x000000000000807a,
  0x00000000000000fc, 0x000000000000807b,
  0x00000000000000fd, 0x000000000000807c,
  0x00000000000000fe, 0x000000000000fffa,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000807e, 0x0000000080007ffa,
  0x000000008000007c, 0x0000000080007ffb,
  0x000000008000007d, 0x0000000080007ffc,
  0x000000008000007e, 0x333333333333b330,
  0x33333333333333b2, 0x555555555555d552,
  0x55555555555555d4, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000007ffd,
  0x800000000000007f, 0x8000000000007ffe,
  0x8000000000000080, 0x8000000000007fff,
  0x8000000000000081, 0x8000000000008000,
  0x8000000000000082, 0xaaaaaaaaaaab2aa7,
  0xaaaaaaaaaaaaab29, 0xcccccccccccd4cc9,
  0xcccccccccccccd4b, 0xffffffff80007ffd,
  0xffffffff8000007f, 0xffffffff80007ffe,
  0xffffffff80000080, 0xffffffff80007fff,
  0xffffffff80000081, 0xffffffff80008000,
  0xffffffff80000082, 0xfffffffffffffffd,
  0xffffffffffff807f, 0xfffffffffffffffe,
  0xffffffffffff8080, 0xffffffffffffffff,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffff8082, 0x0000000000007f7d,
  0xffffffffffffffff, 0x0000000000007f7e,
  0x0000000000000000, 0x0000000000007f7f,
  0x0000000000000001, 0x0000000000007f80,
  0x0000000000000002, 0x0000000000007fbd,
  0x000000000000003f, 0x0000000000007ffa,
  0x000000000000007c, 0x0000000000007ffb,
  0x000000000000007d, 0x0000000000007ffc,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x000000000000803e,
  0x000000000000803d, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000fffa, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x333333333333b331,
  0x333333333333b330, 0x555555555555d553,
  0x555555555555d552, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000008001,
  0x8000000000008000, 0xaaaaaaaaaaab2aa8,
  0xaaaaaaaaaaab2aa7, 0xcccccccccccd4cca,
  0xcccccccccccd4cc9, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80008001,
  0xffffffff80008000, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007fbe,
  0x0000000000007fbd, 0x0000000000007ffb,
  0x0000000000007ffa, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x000000000000803f,
  0x000000000000803e, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffe,
  0x000000000000fffd, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x333333333333b332,
  0x333333333333b331, 0x555555555555d554,
  0x555555555555d553, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000008001,
  0x8000000000008000, 0x8000000000008002,
  0x8000000000008001, 0xaaaaaaaaaaab2aa9,
  0xaaaaaaaaaaab2aa8, 0xcccccccccccd4ccb,
  0xcccccccccccd4cca, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008002,
  0xffffffff80008001, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007fbf,
  0x0000000000007fbe, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffe, 0x000000007ffffffd,
  0x0000000000007fff, 0x000000007ffffffe,
  0x0000000000008000, 0x000000007fffffff,
  0x0000000000008001, 0x000000008000003d,
  0x000000000000803f, 0x000000008000007a,
  0x000000000000807c, 0x000000008000007b,
  0x000000000000807d, 0x000000008000007c,
  0x000000000000807e, 0x0000000080007ffa,
  0x000000000000fffc, 0x0000000080007ffb,
  0x000000000000fffd, 0x0000000080007ffc,
  0x000000000000fffe, 0x00000000fffffffa,
  0x0000000080007ffc, 0x00000000fffffffb,
  0x0000000080007ffd, 0x00000000fffffffc,
  0x0000000080007ffe, 0x33333333b3333330,
  0x333333333333b332, 0x55555555d5555552,
  0x555555555555d554, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x800000007ffffffd,
  0x8000000000007fff, 0x800000007ffffffe,
  0x8000000000008000, 0x800000007fffffff,
  0x8000000000008001, 0x8000000080000000,
  0x8000000000008002, 0xaaaaaaab2aaaaaa7,
  0xaaaaaaaaaaab2aa9, 0xcccccccd4cccccc9,
  0xcccccccccccd4ccb, 0xfffffffffffffffd,
  0xffffffff80007fff, 0xfffffffffffffffe,
  0xffffffff80008000, 0xffffffffffffffff,
  0xffffffff80008001, 0x0000000000000000,
  0xffffffff80008002, 0x000000007fff7ffd,
  0xffffffffffffffff, 0x000000007fff7ffe,
  0x0000000000000000, 0x000000007fff7fff,
  0x0000000000000001, 0x000000007fff8000,
  0x0000000000000002, 0x000000007fffff7d,
  0x0000000000007f7f, 0x000000007fffff7e,
  0x0000000000007f80, 0x000000007fffff7f,
  0x0000000000007f81, 0x000000007fffff80,
  0x0000000000007f82, 0x000000007fffffbd,
  0x0000000000007fbf, 0x000000007ffffffa,
  0x0000000000007ffc, 0x000000007ffffffb,
  0x0000000000007ffd, 0x000000007ffffffc,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x000000008000003e,
  0x000000008000003d, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x00000000fffffffb,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x33333333b3333331,
  0x33333333b3333330, 0x55555555d5555553,
  0x55555555d5555552, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0xaaaaaaab2aaaaaa8,
  0xaaaaaaab2aaaaaa7, 0xcccccccd4cccccca,
  0xcccccccd4cccccc9, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000007fff7ffe,
  0x000000007fff7ffd, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fffff7e,
  0x000000007fffff7d, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffffbe,
  0x000000007fffffbd, 0x000000007ffffffb,
  0x000000007ffffffa, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x000000008000003f,
  0x000000008000003e, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0x33333333b3333332,
  0x33333333b3333331, 0x55555555d5555554,
  0x55555555d5555553, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0x8000000080000002,
  0x8000000080000001, 0xaaaaaaab2aaaaaa9,
  0xaaaaaaab2aaaaaa8, 0xcccccccd4ccccccb,
  0xcccccccd4cccccca, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffffbf,
  0x000000007fffffbe, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffe, 0x3333333333333333,
  0x000000007fffffff, 0x3333333333333334,
  0x0000000080000000, 0x3333333333333335,
  0x0000000080000001, 0x3333333333333373,
  0x000000008000003f, 0x33333333333333b0,
  0x000000008000007c, 0x33333333333333b1,
  0x000000008000007d, 0x33333333333333b2,
  0x000000008000007e, 0x333333333333b330,
  0x0000000080007ffc, 0x333333333333b331,
  0x0000000080007ffd, 0x333333333333b332,
  0x0000000080007ffe, 0x33333333b3333330,
  0x00000000fffffffc, 0x33333333b3333331,
  0x00000000fffffffd, 0x33333333b3333332,
  0x00000000fffffffe, 0x6666666666666666,
  0x33333333b3333332, 0x7fffffffffffffff,
  0x55555555d5555554, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0xb333333333333333,
  0x800000007fffffff, 0xb333333333333334,
  0x8000000080000000, 0xb333333333333335,
  0x8000000080000001, 0xb333333333333336,
  0x8000000080000002, 0xdddddddddddddddd,
  0xaaaaaaab2aaaaaa9, 0xffffffffffffffff,
  0xcccccccd4ccccccb, 0x33333332b3333333,
  0xffffffffffffffff, 0x33333332b3333334,
  0x0000000000000000, 0x33333332b3333335,
  0x0000000000000001, 0x33333332b3333336,
  0x0000000000000002, 0x333333333332b333,
  0x000000007fff7fff, 0x333333333332b334,
  0x000000007fff8000, 0x333333333332b335,
  0x000000007fff8001, 0x333333333332b336,
  0x000000007fff8002, 0x33333333333332b3,
  0x000000007fffff7f, 0x33333333333332b4,
  0x000000007fffff80, 0x33333333333332b5,
  0x000000007fffff81, 0x33333333333332b6,
  0x000000007fffff82, 0x33333333333332f3,
  0x000000007fffffbf, 0x3333333333333330,
  0x000000007ffffffc, 0x3333333333333331,
  0x000000007ffffffd, 0x3333333333333332,
  0x3333333333333332, 0x5555555555555555,
  0x3333333333333333, 0x5555555555555556,
  0x3333333333333334, 0x5555555555555557,
  0x3333333333333335, 0x5555555555555595,
  0x3333333333333373, 0x55555555555555d2,
  0x33333333333333b0, 0x55555555555555d3,
  0x33333333333333b1, 0x55555555555555d4,
  0x33333333333333b2, 0x555555555555d552,
  0x333333333333b330, 0x555555555555d553,
  0x333333333333b331, 0x555555555555d554,
  0x333333333333b332, 0x55555555d5555552,
  0x33333333b3333330, 0x55555555d5555553,
  0x33333333b3333331, 0x55555555d5555554,
  0x33333333b3333332, 0x7fffffffffffffff,
  0x6666666666666666, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0xd555555555555555,
  0xb333333333333333, 0xd555555555555556,
  0xb333333333333334, 0xd555555555555557,
  0xb333333333333335, 0xd555555555555558,
  0xb333333333333336, 0xffffffffffffffff,
  0xdddddddddddddddd, 0x2222222222222221,
  0xffffffffffffffff, 0x55555554d5555555,
  0x33333332b3333333, 0x55555554d5555556,
  0x33333332b3333334, 0x55555554d5555557,
  0x33333332b3333335, 0x55555554d5555558,
  0x33333332b3333336, 0x555555555554d555,
  0x333333333332b333, 0x555555555554d556,
  0x333333333332b334, 0x555555555554d557,
  0x333333333332b335, 0x555555555554d558,
  0x333333333332b336, 0x55555555555554d5,
  0x33333333333332b3, 0x55555555555554d6,
  0x33333333333332b4, 0x55555555555554d7,
  0x33333333333332b5, 0x55555555555554d8,
  0x33333333333332b6, 0x5555555555555515,
  0x33333333333332f3, 0x5555555555555552,
  0x3333333333333330, 0x5555555555555553,
  0x3333333333333331, 0x5555555555555554,
  0x5555555555555554, 0x7ffffffffffffffd,
  0x5555555555555555, 0x7ffffffffffffffe,
  0x5555555555555556, 0x7fffffffffffffff,
  0x5555555555555557, 0x7fffffffffffffff,
  0x5555555555555595, 0x7fffffffffffffff,
  0x55555555555555d2, 0x7fffffffffffffff,
  0x55555555555555d3, 0x7fffffffffffffff,
  0x55555555555555d4, 0x7fffffffffffffff,
  0x555555555555d552, 0x7fffffffffffffff,
  0x555555555555d553, 0x7fffffffffffffff,
  0x555555555555d554, 0x7fffffffffffffff,
  0x55555555d5555552, 0x7fffffffffffffff,
  0x55555555d5555553, 0x7fffffffffffffff,
  0x55555555d5555554, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0xfffffffffffffffd,
  0xd555555555555555, 0xfffffffffffffffe,
  0xd555555555555556, 0xffffffffffffffff,
  0xd555555555555557, 0x0000000000000000,
  0xd555555555555558, 0x2aaaaaaaaaaaaaa7,
  0xffffffffffffffff, 0x4cccccccccccccc9,
  0x2222222222222221, 0x7fffffff7ffffffd,
  0x55555554d5555555, 0x7fffffff7ffffffe,
  0x55555554d5555556, 0x7fffffff7fffffff,
  0x55555554d5555557, 0x7fffffff80000000,
  0x55555554d5555558, 0x7fffffffffff7ffd,
  0x555555555554d555, 0x7fffffffffff7ffe,
  0x555555555554d556, 0x7fffffffffff7fff,
  0x555555555554d557, 0x7fffffffffff8000,
  0x555555555554d558, 0x7fffffffffffff7d,
  0x55555555555554d5, 0x7fffffffffffff7e,
  0x55555555555554d6, 0x7fffffffffffff7f,
  0x55555555555554d7, 0x7fffffffffffff80,
  0x55555555555554d8, 0x7fffffffffffffbd,
  0x5555555555555515, 0x7ffffffffffffffa,
  0x5555555555555552, 0x7ffffffffffffffb,
  0x5555555555555553, 0x7ffffffffffffffc,
  0x7ffffffffffffffc, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x2aaaaaaaaaaaaaa8,
  0x2aaaaaaaaaaaaaa7, 0x4cccccccccccccca,
  0x4cccccccccccccc9, 0x7fffffff7ffffffe,
  0x7fffffff7ffffffd, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffffffff7ffe,
  0x7fffffffffff7ffd, 0x7fffffffffff7fff,
  0x7fffffffffff7ffe, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffffff7e,
  0x7fffffffffffff7d, 0x7fffffffffffff7f,
  0x7fffffffffffff7e, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffffbe,
  0x7fffffffffffffbd, 0x7ffffffffffffffb,
  0x7ffffffffffffffa, 0x7ffffffffffffffc,
  0x7ffffffffffffffb, 0x7ffffffffffffffd,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x2aaaaaaaaaaaaaa9,
  0x2aaaaaaaaaaaaaa8, 0x4ccccccccccccccb,
  0x4cccccccccccccca, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffffffff7fff,
  0x7fffffffffff7ffe, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffffff7f,
  0x7fffffffffffff7e, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffffbf,
  0x7fffffffffffffbe, 0x7ffffffffffffffc,
  0x7ffffffffffffffb, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x7ffffffffffffffe,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000001,
  0x7fffffffffffffff, 0x8000000000000002,
  0x7fffffffffffffff, 0x8000000000000040,
  0x7fffffffffffffff, 0x800000000000007d,
  0x7fffffffffffffff, 0x800000000000007e,
  0x7fffffffffffffff, 0x800000000000007f,
  0x7fffffffffffffff, 0x8000000000007ffd,
  0x7fffffffffffffff, 0x8000000000007ffe,
  0x7fffffffffffffff, 0x8000000000007fff,
  0x7fffffffffffffff, 0x800000007ffffffd,
  0x7fffffffffffffff, 0x800000007ffffffe,
  0x7fffffffffffffff, 0x800000007fffffff,
  0x7fffffffffffffff, 0xb333333333333333,
  0x7fffffffffffffff, 0xd555555555555555,
  0x7fffffffffffffff, 0xfffffffffffffffd,
  0x7fffffffffffffff, 0xfffffffffffffffe,
  0x7fffffffffffffff, 0xffffffffffffffff,
  0x7fffffffffffffff, 0x8000000000000000,
  0xffffffffffffffff, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000002, 0x8000000000000000,
  0x2aaaaaaaaaaaaaa9, 0x8000000000000000,
  0x4ccccccccccccccb, 0x8000000000000000,
  0x7fffffff7fffffff, 0x8000000000000000,
  0x7fffffff80000000, 0x8000000000000000,
  0x7fffffff80000001, 0x8000000000000000,
  0x7fffffff80000002, 0x8000000000000000,
  0x7fffffffffff7fff, 0x8000000000000000,
  0x7fffffffffff8000, 0x8000000000000000,
  0x7fffffffffff8001, 0x8000000000000000,
  0x7fffffffffff8002, 0x8000000000000000,
  0x7fffffffffffff7f, 0x8000000000000000,
  0x7fffffffffffff80, 0x8000000000000000,
  0x7fffffffffffff81, 0x8000000000000000,
  0x7fffffffffffff82, 0x8000000000000000,
  0x7fffffffffffffbf, 0x8000000000000000,
  0x7ffffffffffffffc, 0x8000000000000000,
  0x7ffffffffffffffd, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000041,
  0x8000000000000040, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000080,
  0x800000000000007f, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000008000,
  0x8000000000007fff, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0xb333333333333334,
  0xb333333333333333, 0xd555555555555556,
  0xd555555555555555, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000042,
  0x8000000000000041, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000081,
  0x8000000000000080, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000008001,
  0x8000000000008000, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0xb333333333333335,
  0xb333333333333334, 0xd555555555555557,
  0xd555555555555556, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000001,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000005,
  0x8000000000000004, 0x8000000000000043,
  0x8000000000000042, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000081,
  0x8000000000000080, 0x8000000000000082,
  0x8000000000000081, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000008001,
  0x8000000000008000, 0x8000000000008002,
  0x8000000000008001, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0x8000000080000002,
  0x8000000080000001, 0xb333333333333336,
  0xb333333333333335, 0xd555555555555558,
  0xd555555555555557, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000002, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0xaaaaaaaaaaaaaaab,
  0x8000000000000004, 0xaaaaaaaaaaaaaaac,
  0x8000000000000005, 0xaaaaaaaaaaaaaaea,
  0x8000000000000043, 0xaaaaaaaaaaaaab27,
  0x8000000000000080, 0xaaaaaaaaaaaaab28,
  0x8000000000000081, 0xaaaaaaaaaaaaab29,
  0x8000000000000082, 0xaaaaaaaaaaab2aa7,
  0x8000000000008000, 0xaaaaaaaaaaab2aa8,
  0x8000000000008001, 0xaaaaaaaaaaab2aa9,
  0x8000000000008002, 0xaaaaaaab2aaaaaa7,
  0x8000000080000000, 0xaaaaaaab2aaaaaa8,
  0x8000000080000001, 0xaaaaaaab2aaaaaa9,
  0x8000000080000002, 0xdddddddddddddddd,
  0xb333333333333336, 0xffffffffffffffff,
  0xd555555555555558, 0x2aaaaaaaaaaaaaa7,
  0x0000000000000000, 0x2aaaaaaaaaaaaaa8,
  0x0000000000000001, 0x2aaaaaaaaaaaaaa9,
  0x0000000000000002, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaa2aaaaaaa,
  0x8000000000000000, 0xaaaaaaaa2aaaaaab,
  0x8000000000000000, 0xaaaaaaaa2aaaaaac,
  0x8000000000000000, 0xaaaaaaaa2aaaaaad,
  0x8000000000000000, 0xaaaaaaaaaaaa2aaa,
  0x8000000000000000, 0xaaaaaaaaaaaa2aab,
  0x8000000000000000, 0xaaaaaaaaaaaa2aac,
  0x8000000000000000, 0xaaaaaaaaaaaa2aad,
  0x8000000000000000, 0xaaaaaaaaaaaaaa2a,
  0x8000000000000000, 0xaaaaaaaaaaaaaa2b,
  0x8000000000000000, 0xaaaaaaaaaaaaaa2c,
  0x8000000000000000, 0xaaaaaaaaaaaaaa2d,
  0x8000000000000000, 0xaaaaaaaaaaaaaa6a,
  0x8000000000000000, 0xaaaaaaaaaaaaaaa7,
  0x8000000000000000, 0xaaaaaaaaaaaaaaa8,
  0x8000000000000001, 0xaaaaaaaaaaaaaaa9,
  0xaaaaaaaaaaaaaaa9, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0xcccccccccccccccd,
  0xaaaaaaaaaaaaaaab, 0xccccccccccccccce,
  0xaaaaaaaaaaaaaaac, 0xcccccccccccccd0c,
  0xaaaaaaaaaaaaaaea, 0xcccccccccccccd49,
  0xaaaaaaaaaaaaab27, 0xcccccccccccccd4a,
  0xaaaaaaaaaaaaab28, 0xcccccccccccccd4b,
  0xaaaaaaaaaaaaab29, 0xcccccccccccd4cc9,
  0xaaaaaaaaaaab2aa7, 0xcccccccccccd4cca,
  0xaaaaaaaaaaab2aa8, 0xcccccccccccd4ccb,
  0xaaaaaaaaaaab2aa9, 0xcccccccd4cccccc9,
  0xaaaaaaab2aaaaaa7, 0xcccccccd4cccccca,
  0xaaaaaaab2aaaaaa8, 0xcccccccd4ccccccb,
  0xaaaaaaab2aaaaaa9, 0xffffffffffffffff,
  0xdddddddddddddddd, 0x2222222222222221,
  0xffffffffffffffff, 0x4cccccccccccccc9,
  0x2aaaaaaaaaaaaaa7, 0x4cccccccccccccca,
  0x2aaaaaaaaaaaaaa8, 0x4ccccccccccccccb,
  0x2aaaaaaaaaaaaaa9, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x9999999999999998,
  0x8000000000000000, 0xcccccccc4ccccccc,
  0xaaaaaaaa2aaaaaaa, 0xcccccccc4ccccccd,
  0xaaaaaaaa2aaaaaab, 0xcccccccc4cccccce,
  0xaaaaaaaa2aaaaaac, 0xcccccccc4ccccccf,
  0xaaaaaaaa2aaaaaad, 0xcccccccccccc4ccc,
  0xaaaaaaaaaaaa2aaa, 0xcccccccccccc4ccd,
  0xaaaaaaaaaaaa2aab, 0xcccccccccccc4cce,
  0xaaaaaaaaaaaa2aac, 0xcccccccccccc4ccf,
  0xaaaaaaaaaaaa2aad, 0xcccccccccccccc4c,
  0xaaaaaaaaaaaaaa2a, 0xcccccccccccccc4d,
  0xaaaaaaaaaaaaaa2b, 0xcccccccccccccc4e,
  0xaaaaaaaaaaaaaa2c, 0xcccccccccccccc4f,
  0xaaaaaaaaaaaaaa2d, 0xcccccccccccccc8c,
  0xaaaaaaaaaaaaaa6a, 0xccccccccccccccc9,
  0xaaaaaaaaaaaaaaa7, 0xccccccccccccccca,
  0xaaaaaaaaaaaaaaa8, 0xcccccccccccccccb,
  0xcccccccccccccccb, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff80000001,
  0xcccccccccccccccd, 0xffffffff80000002,
  0xccccccccccccccce, 0xffffffff80000040,
  0xcccccccccccccd0c, 0xffffffff8000007d,
  0xcccccccccccccd49, 0xffffffff8000007e,
  0xcccccccccccccd4a, 0xffffffff8000007f,
  0xcccccccccccccd4b, 0xffffffff80007ffd,
  0xcccccccccccd4cc9, 0xffffffff80007ffe,
  0xcccccccccccd4cca, 0xffffffff80007fff,
  0xcccccccccccd4ccb, 0xfffffffffffffffd,
  0xcccccccd4cccccc9, 0xfffffffffffffffe,
  0xcccccccd4cccccca, 0xffffffffffffffff,
  0xcccccccd4ccccccb, 0x33333332b3333333,
  0xffffffffffffffff, 0x55555554d5555555,
  0x2222222222222221, 0x7fffffff7ffffffd,
  0x4cccccccccccccc9, 0x7fffffff7ffffffe,
  0x4cccccccccccccca, 0x7fffffff7fffffff,
  0x4ccccccccccccccb, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaa2aaaaaaa,
  0x8000000000000000, 0xcccccccc4ccccccc,
  0x9999999999999998, 0xffffffff00000000,
  0xcccccccc4ccccccc, 0xffffffff00000001,
  0xcccccccc4ccccccd, 0xffffffff00000002,
  0xcccccccc4cccccce, 0xffffffff00000003,
  0xcccccccc4ccccccf, 0xffffffff7fff8000,
  0xcccccccccccc4ccc, 0xffffffff7fff8001,
  0xcccccccccccc4ccd, 0xffffffff7fff8002,
  0xcccccccccccc4cce, 0xffffffff7fff8003,
  0xcccccccccccc4ccf, 0xffffffff7fffff80,
  0xcccccccccccccc4c, 0xffffffff7fffff81,
  0xcccccccccccccc4d, 0xffffffff7fffff82,
  0xcccccccccccccc4e, 0xffffffff7fffff83,
  0xcccccccccccccc4f, 0xffffffff7fffffc0,
  0xcccccccccccccc8c, 0xffffffff7ffffffd,
  0xccccccccccccccc9, 0xffffffff7ffffffe,
  0xccccccccccccccca, 0xffffffff7fffffff,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000041,
  0xffffffff80000040, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x33333332b3333334,
  0x33333332b3333333, 0x55555554d5555556,
  0x55555554d5555555, 0x7fffffff7ffffffe,
  0x7fffffff7ffffffd, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaa2aaaaaab,
  0xaaaaaaaa2aaaaaaa, 0xcccccccc4ccccccd,
  0xcccccccc4ccccccc, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff7fff8001,
  0xffffffff7fff8000, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fffff81,
  0xffffffff7fffff80, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffffc1,
  0xffffffff7fffffc0, 0xffffffff7ffffffe,
  0xffffffff7ffffffd, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff80000000,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000042,
  0xffffffff80000041, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x33333332b3333335,
  0x33333332b3333334, 0x55555554d5555557,
  0x55555554d5555556, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff80000001,
  0x7fffffff80000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaa2aaaaaac,
  0xaaaaaaaa2aaaaaab, 0xcccccccc4cccccce,
  0xcccccccc4ccccccd, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff00000005,
  0xffffffff00000004, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffffc2,
  0xffffffff7fffffc1, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000005,
  0xffffffff80000004, 0xffffffff80000043,
  0xffffffff80000042, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000082,
  0xffffffff80000081, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008002,
  0xffffffff80008001, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x33333332b3333336,
  0x33333332b3333335, 0x55555554d5555558,
  0x55555554d5555557, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000002,
  0x7fffffff80000001, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaa2aaaaaad,
  0xaaaaaaaa2aaaaaac, 0xcccccccc4ccccccf,
  0xcccccccc4cccccce, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff00000005,
  0xffffffff00000004, 0xffffffff00000006,
  0xffffffff00000005, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8006,
  0xffffffff7fff8005, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff86,
  0xffffffff7fffff85, 0xffffffff7fffffc3,
  0xffffffff7fffffc2, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000002, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff8001,
  0xffffffff80000004, 0xffffffffffff8002,
  0xffffffff80000005, 0xffffffffffff8040,
  0xffffffff80000043, 0xffffffffffff807d,
  0xffffffff80000080, 0xffffffffffff807e,
  0xffffffff80000081, 0xffffffffffff807f,
  0xffffffff80000082, 0xfffffffffffffffd,
  0xffffffff80008000, 0xfffffffffffffffe,
  0xffffffff80008001, 0xffffffffffffffff,
  0xffffffff80008002, 0x000000007fff7ffd,
  0x0000000000000000, 0x000000007fff7ffe,
  0x0000000000000001, 0x000000007fff7fff,
  0x0000000000000002, 0x333333333332b333,
  0x33333332b3333336, 0x555555555554d555,
  0x55555554d5555558, 0x7fffffffffff7ffd,
  0x7fffffff80000000, 0x7fffffffffff7ffe,
  0x7fffffff80000001, 0x7fffffffffff7fff,
  0x7fffffff80000002, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaa2aaa,
  0xaaaaaaaa2aaaaaad, 0xcccccccccccc4ccc,
  0xcccccccc4ccccccf, 0xffffffff7fff8000,
  0xffffffff00000003, 0xffffffff7fff8001,
  0xffffffff00000004, 0xffffffff7fff8002,
  0xffffffff00000005, 0xffffffff7fff8003,
  0xffffffff00000006, 0xffffffffffff0000,
  0xffffffff7fff8003, 0xffffffffffff0001,
  0xffffffff7fff8004, 0xffffffffffff0002,
  0xffffffff7fff8005, 0xffffffffffff0003,
  0xffffffff7fff8006, 0xffffffffffff7f80,
  0xffffffff7fffff83, 0xffffffffffff7f81,
  0xffffffff7fffff84, 0xffffffffffff7f82,
  0xffffffff7fffff85, 0xffffffffffff7f83,
  0xffffffff7fffff86, 0xffffffffffff7fc0,
  0xffffffff7fffffc3, 0xffffffffffff7ffd,
  0xffffffff80000000, 0xffffffffffff7ffe,
  0xffffffff80000001, 0xffffffffffff7fff,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8041,
  0xffffffffffff8040, 0xffffffffffff807e,
  0xffffffffffff807d, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000007fff7ffe,
  0x000000007fff7ffd, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x333333333332b334,
  0x333333333332b333, 0x555555555554d556,
  0x555555555554d555, 0x7fffffffffff7ffe,
  0x7fffffffffff7ffd, 0x7fffffffffff7fff,
  0x7fffffffffff7ffe, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaa2aab,
  0xaaaaaaaaaaaa2aaa, 0xcccccccccccc4ccd,
  0xcccccccccccc4ccc, 0xffffffff7fff8001,
  0xffffffff7fff8000, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffffffff0001,
  0xffffffffffff0000, 0xffffffffffff0002,
  0xffffffffffff0001, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff7f81,
  0xffffffffffff7f80, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7fc1,
  0xffffffffffff7fc0, 0xffffffffffff7ffe,
  0xffffffffffff7ffd, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8042,
  0xffffffffffff8041, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x333333333332b335,
  0x333333333332b334, 0x555555555554d557,
  0x555555555554d556, 0x7fffffffffff7fff,
  0x7fffffffffff7ffe, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaa2aac,
  0xaaaaaaaaaaaa2aab, 0xcccccccccccc4cce,
  0xcccccccccccc4ccd, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffffffff0002,
  0xffffffffffff0001, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7fc2,
  0xffffffffffff7fc1, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffff8043,
  0xffffffffffff8042, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8082,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0x333333333332b336,
  0x333333333332b335, 0x555555555554d558,
  0x555555555554d557, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaa2aad,
  0xaaaaaaaaaaaa2aac, 0xcccccccccccc4ccf,
  0xcccccccccccc4cce, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8006,
  0xffffffff7fff8005, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff0006,
  0xffffffffffff0005, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffff7fc3,
  0xffffffffffff7fc2, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8002, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffff8004, 0xffffffffffffff82,
  0xffffffffffff8005, 0xffffffffffffffc0,
  0xffffffffffff8043, 0xfffffffffffffffd,
  0xffffffffffff8080, 0xfffffffffffffffe,
  0xffffffffffff8081, 0xffffffffffffffff,
  0xffffffffffff8082, 0x0000000000007f7d,
  0x0000000000000000, 0x0000000000007f7e,
  0x0000000000000001, 0x0000000000007f7f,
  0x0000000000000002, 0x000000007fffff7d,
  0x000000007fff8000, 0x000000007fffff7e,
  0x000000007fff8001, 0x000000007fffff7f,
  0x000000007fff8002, 0x33333333333332b3,
  0x333333333332b336, 0x55555555555554d5,
  0x555555555554d558, 0x7fffffffffffff7d,
  0x7fffffffffff8000, 0x7fffffffffffff7e,
  0x7fffffffffff8001, 0x7fffffffffffff7f,
  0x7fffffffffff8002, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaaaa2a,
  0xaaaaaaaaaaaa2aad, 0xcccccccccccccc4c,
  0xcccccccccccc4ccf, 0xffffffff7fffff80,
  0xffffffff7fff8003, 0xffffffff7fffff81,
  0xffffffff7fff8004, 0xffffffff7fffff82,
  0xffffffff7fff8005, 0xffffffff7fffff83,
  0xffffffff7fff8006, 0xffffffffffff7f80,
  0xffffffffffff0003, 0xffffffffffff7f81,
  0xffffffffffff0004, 0xffffffffffff7f82,
  0xffffffffffff0005, 0xffffffffffff7f83,
  0xffffffffffff0006, 0xffffffffffffff00,
  0xffffffffffff7f83, 0xffffffffffffff01,
  0xffffffffffff7f84, 0xffffffffffffff02,
  0xffffffffffff7f85, 0xffffffffffffff03,
  0xffffffffffff7f86, 0xffffffffffffff40,
  0xffffffffffff7fc3, 0xffffffffffffff7d,
  0xffffffffffff8000, 0xffffffffffffff7e,
  0xffffffffffff8001, 0xffffffffffffff7f,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffffc1,
  0xffffffffffffffc0, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x000000007fffff7e,
  0x000000007fffff7d, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x33333333333332b4,
  0x33333333333332b3, 0x55555555555554d6,
  0x55555555555554d5, 0x7fffffffffffff7e,
  0x7fffffffffffff7d, 0x7fffffffffffff7f,
  0x7fffffffffffff7e, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaaaa2b,
  0xaaaaaaaaaaaaaa2a, 0xcccccccccccccc4d,
  0xcccccccccccccc4c, 0xffffffff7fffff81,
  0xffffffff7fffff80, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffffffff7f81,
  0xffffffffffff7f80, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffffff01,
  0xffffffffffffff00, 0xffffffffffffff02,
  0xffffffffffffff01, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff41,
  0xffffffffffffff40, 0xffffffffffffff7e,
  0xffffffffffffff7d, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffffc2,
  0xffffffffffffffc1, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x33333333333332b5,
  0x33333333333332b4, 0x55555555555554d7,
  0x55555555555554d6, 0x7fffffffffffff7f,
  0x7fffffffffffff7e, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaaaa2c,
  0xaaaaaaaaaaaaaa2b, 0xcccccccccccccc4e,
  0xcccccccccccccc4d, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffffff02,
  0xffffffffffffff01, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff42,
  0xffffffffffffff41, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffffc3,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f82,
  0x0000000000007f81, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0x33333333333332b6,
  0x33333333333332b5, 0x55555555555554d8,
  0x55555555555554d7, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaaaa2d,
  0xaaaaaaaaaaaaaa2c, 0xcccccccccccccc4f,
  0xcccccccccccccc4e, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff86,
  0xffffffff7fffff85, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff06,
  0xffffffffffffff05, 0xffffffffffffff43,
  0xffffffffffffff42, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff82, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffffc1,
  0xffffffffffffff84, 0xffffffffffffffc2,
  0xffffffffffffff85, 0x0000000000000000,
  0xffffffffffffffc3, 0x000000000000003d,
  0x0000000000000000, 0x000000000000003e,
  0x0000000000000001, 0x000000000000003f,
  0x0000000000000002, 0x0000000000007fbd,
  0x0000000000007f80, 0x0000000000007fbe,
  0x0000000000007f81, 0x0000000000007fbf,
  0x0000000000007f82, 0x000000007fffffbd,
  0x000000007fffff80, 0x000000007fffffbe,
  0x000000007fffff81, 0x000000007fffffbf,
  0x000000007fffff82, 0x33333333333332f3,
  0x33333333333332b6, 0x5555555555555515,
  0x55555555555554d8, 0x7fffffffffffffbd,
  0x7fffffffffffff80, 0x7fffffffffffffbe,
  0x7fffffffffffff81, 0x7fffffffffffffbf,
  0x7fffffffffffff82, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaaaa6a,
  0xaaaaaaaaaaaaaa2d, 0xcccccccccccccc8c,
  0xcccccccccccccc4f, 0xffffffff7fffffc0,
  0xffffffff7fffff83, 0xffffffff7fffffc1,
  0xffffffff7fffff84, 0xffffffff7fffffc2,
  0xffffffff7fffff85, 0xffffffff7fffffc3,
  0xffffffff7fffff86, 0xffffffffffff7fc0,
  0xffffffffffff7f83, 0xffffffffffff7fc1,
  0xffffffffffff7f84, 0xffffffffffff7fc2,
  0xffffffffffff7f85, 0xffffffffffff7fc3,
  0xffffffffffff7f86, 0xffffffffffffff40,
  0xffffffffffffff03, 0xffffffffffffff41,
  0xffffffffffffff04, 0xffffffffffffff42,
  0xffffffffffffff05, 0xffffffffffffff43,
  0xffffffffffffff06, 0xffffffffffffff80,
  0xffffffffffffff43, 0xffffffffffffffbd,
  0xffffffffffffff80, 0xffffffffffffffbe,
  0xffffffffffffff81, 0xffffffffffffffbf,
  0xffffffffffffffbf, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffe,
  0xffffffffffffffc1, 0xffffffffffffffff,
  0xffffffffffffffc2, 0x000000000000003d,
  0x0000000000000000, 0x000000000000007a,
  0x000000000000003d, 0x000000000000007b,
  0x000000000000003e, 0x000000000000007c,
  0x000000000000003f, 0x0000000000007ffa,
  0x0000000000007fbd, 0x0000000000007ffb,
  0x0000000000007fbe, 0x0000000000007ffc,
  0x0000000000007fbf, 0x000000007ffffffa,
  0x000000007fffffbd, 0x000000007ffffffb,
  0x000000007fffffbe, 0x000000007ffffffc,
  0x000000007fffffbf, 0x3333333333333330,
  0x33333333333332f3, 0x5555555555555552,
  0x5555555555555515, 0x7ffffffffffffffa,
  0x7fffffffffffffbd, 0x7ffffffffffffffb,
  0x7fffffffffffffbe, 0x7ffffffffffffffc,
  0x7fffffffffffffbf, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaaaaa7,
  0xaaaaaaaaaaaaaa6a, 0xccccccccccccccc9,
  0xcccccccccccccc8c, 0xffffffff7ffffffd,
  0xffffffff7fffffc0, 0xffffffff7ffffffe,
  0xffffffff7fffffc1, 0xffffffff7fffffff,
  0xffffffff7fffffc2, 0xffffffff80000000,
  0xffffffff7fffffc3, 0xffffffffffff7ffd,
  0xffffffffffff7fc0, 0xffffffffffff7ffe,
  0xffffffffffff7fc1, 0xffffffffffff7fff,
  0xffffffffffff7fc2, 0xffffffffffff8000,
  0xffffffffffff7fc3, 0xffffffffffffff7d,
  0xffffffffffffff40, 0xffffffffffffff7e,
  0xffffffffffffff41, 0xffffffffffffff7f,
  0xffffffffffffff42, 0xffffffffffffff80,
  0xffffffffffffff43, 0xffffffffffffffbd,
  0xffffffffffffff80, 0xfffffffffffffffa,
  0xffffffffffffffbd, 0xfffffffffffffffb,
  0xffffffffffffffbe, 0xfffffffffffffffc,
  0xfffffffffffffffc, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000000000003e,
  0x000000000000003d, 0x000000000000007b,
  0x000000000000007a, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x0000000000007ffb,
  0x0000000000007ffa, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x000000007ffffffb,
  0x000000007ffffffa, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x3333333333333331,
  0x3333333333333330, 0x5555555555555553,
  0x5555555555555552, 0x7ffffffffffffffb,
  0x7ffffffffffffffa, 0x7ffffffffffffffc,
  0x7ffffffffffffffb, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000001,
  0x8000000000000000, 0xaaaaaaaaaaaaaaa8,
  0xaaaaaaaaaaaaaaa7, 0xccccccccccccccca,
  0xccccccccccccccc9, 0xffffffff7ffffffe,
  0xffffffff7ffffffd, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffffffff7ffe,
  0xffffffffffff7ffd, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffffff7e,
  0xffffffffffffff7d, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffffbe,
  0xffffffffffffffbd, 0xfffffffffffffffb,
  0xfffffffffffffffa, 0xfffffffffffffffc,
  0xfffffffffffffffb, 0xfffffffffffffffd,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000000000003f,
  0x000000000000003e, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007d, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x3333333333333332,
  0x3333333333333331, 0x5555555555555554,
  0x5555555555555553, 0x7ffffffffffffffc,
  0x7ffffffffffffffb, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0xaaaaaaaaaaaaaaa9,
  0xaaaaaaaaaaaaaaa8, 0xcccccccccccccccb,
  0xccccccccccccccca, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffffbf,
  0xffffffffffffffbe, 0xfffffffffffffffc,
  0xfffffffffffffffb, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xfffffffffffffffe,
};
const unsigned kExpectedCount_NEON_sqadd_2D = 1600;

#endif  // VIXL_SIM_SQADD_2D_TRACE_AARCH64_H_
