# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#Standards Modules
from xml.dom import minidom
from xml.dom.minidom import Document
from PyQt4.QtCore import *
from PyQt4.QtGui import *

#Specific Windows version : Load Windows Registry module
try :
  import _winreg
except:
  None

#Modules from Videoporama project
from interface import *
from main_win import *
from statusconf import *
from about import *
from ConfigurationDlg import *
from GlobalDefines import *
from DocHelpDlg import *
from RenderDlg import *
from DefMoviePointDlg import *
from SoundDlg import *
from SoundProcess import *
from OFD import *

class Gui_Main(QMainWindow,Ui_MainWindow) : #OK QT4
    def __init__(self, parent=None):
        super(Gui_Main, self).__init__(parent)
        self.setupUi(self)
    
    #domledom : Add resizeEvent signal
    def resizeEvent (self, event):
      self.emit(SIGNAL("resizeEvent(QResizeEvent)"),event)

class videoporama :
    def __init__(self,args,IsPortable):
      # Define if application start in portable application mode
      self.IsPortable=IsPortable
      
      # First thing to do : ask if it's a windows operating system !
      if isWindows()==False: 
        if self.IsPortable==True :
          print "This PortableVersion can only be use on Windows System"
          return
          
        self.AEROCOMPATIBILITY = False     #True pour prendre en charge AERO (Vista/Windows 7)
        self.Windows           = ""        #It's not a Windows OS
        print "Linux version"
      else :
        WinVersion=QtCore.QSysInfo().WindowsVersion
        if WinVersion==0x0010   : self.Windows="Windows NT (operating system version 4.0)"
        elif WinVersion==0x0020 : self.Windows="Windows 2000 (operating system version 5.0)"
        elif WinVersion==0x0030 : self.Windows="Windows XP (operating system version 5.1)"
        elif WinVersion==0x0040 : self.Windows="Windows Server 2003, Windows Server 2003 R2, Windows Home Server, Windows XP Professional x64 Edition (operating system version 5.2)"
        elif WinVersion==0x0080 : self.Windows="Windows Vista, Windows Server 2008 (operating system version 6.0)"
        elif WinVersion==0x0090 : self.Windows="Windows 7, Windows Server 2008 R2 (operating system version 6.1)"
        else : self.Windows="Unknown version"

        #AERO Flag for MPlayer
        if WinVersion>=0x0080:
          self.AEROCOMPATIBILITY = True     #True pour prendre en charge AERO (Vista/Windows 7)
        else :
          self.AEROCOMPATIBILITY = False    #False pour ne pas prendre en charge AERO (Vista/Windows 7)

        #Load registry value for specific Windows Folder
        key = _winreg.OpenKey(_winreg.HKEY_CURRENT_USER,'Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders',0,_winreg.KEY_READ)
        (WINDOWS_APPDATA,typevaleur)  = _winreg.QueryValueEx(key,'AppData')
        (WINDOWS_MUSIC,typevaleur)    = _winreg.QueryValueEx(key,'My Music')
        (WINDOWS_PICTURES,typevaleur) = _winreg.QueryValueEx(key,'My Pictures')
        (WINDOWS_VIDEO,typevaleur)    = _winreg.QueryValueEx(key,'My Video')
        (WINDOWS_DOCUMENTS,typevaleur)= _winreg.QueryValueEx(key,'Personal')
        _winreg.CloseKey(key)

        print "Windows = "+self.Windows

      #local variables definition
      self.index                        = -1
      self.AACMode                      = ""        #adts if ffmpeg 0.6 and libfaac for ffmpeg 0.5
      self.StopMAJOFD                   = False     #Flag to stop modification of OFD configuration for project
      self.StopMAJSpinbox               = False     #Flag to stop multiple update during spinbox update
      self.BLOCKDefZoomPointDlg         = False     #Flag for allow only one DefZoomPointDlg at a time
      self.BLOCKCloseApp                = False     #Flag to block multiple ask for save project when close app
      self.StopUpdatePixDuringNewSelect = False     #Variable to stop multiple updatepix when an image is selected
      self.StopUpdatePixDuringEmpty     = False     #Variable to stop updatepix when empty timeline
      self.StopSetupInterface           = False     #Variable to stop multiple SetupInterface
      self.OutputOFDXMLObject           = None      #Output format definition XML Object
      self.homeDir                      = ""        #Home directory
      self.lastDirImage                 = ""        #Last directory use for Image
      self.lastDirMovies                = ""        #Last directory use for Movie
      self.lastDirProject               = ""        #Last directory use for Project
      self.lastDirSound                 = ""        #Last directory use for Sound
      self.lastDirRender                = ""        #Last directory use for Render
      self.lastDirBackground            = ""        #Last directory use for Background Image
      self.NewSEQPosition               = 0         #if Add sequence after current sequence else Add sequence at the project end
      
      #Project file
      self.ProjectFilePathName          = ""        #PathName of the project file
      self.ProjectXMLObject             = None      #Document object of the project file
      self.IsProjectModified            = False     #Flag for known if project file need to be save
      self.imgformat                    = 0         #Project image format
      #self.soundfile                    = ""        #Project sound file
      self.outputFile                   = ""        #Project output file
      self.XMLText                      = None      #Overlaid text

      #Configuration file
      self.ConfigFilePathName           = ""        #PathName of the configuration file
      self.ConfigXMLObject              = None      #Document object of the configuration file

      #Directory Configuration (default value are calculate during the init process)
      self.T                            = ""        #Temporary directory
      self.I                            = ""        #FFMPEG directory
      self.MP                           = ""        #MPlayer directory
      self.S                            = ""        #SOX directory
      self.MJ                           = ""        #MPJEPTools directory
      self.ImageEditor                  = ""        #ImageEditor filename
      IsGIMPOk                          = False     #True if image editor is found

      #Standard Project Options (default value are set here !)
      self.ConfVideoF                   = 0         #Default output format
      self.ConfImgFormat                = 0         #Default output format
      self.ConfTime                     = 7         #project options : image duration of the 1st static shot
      self.ConfStaticTimeNext           = 2         #project options : image duration of next static shot
      self.ConfAnimTimeNext             = 3         #project options : image duration of animated shot
      self.ConfTime                     = 7         #project options : image duration
      self.ConfSpeedT                   = 3         #project options : transition duration
      self.ConfTypeT                    = 8         #project options : default transition : Random
      self.ConfTransiOpt                = 0         #project options : default transition option (0 for Random)
      self.ConfBgFile                   = ""        #project options : default background file
      self.ConfBgColor                  = 0         #project options : default background color
      self.ConfDisplayUnit              = 0         #Display configuration - "0"=as %, "1"= as Pixel
      self.ConfAutoRotate               = 1         #Display configuration - Automatic Rotation of rotaded image
      #Overlaid Text
      if isWindows() : 
        self.TOverlaidFontName          = "Arial Black"    # font name
      else:
        self.TOverlaidFontName          = "Impact"         # font name
      self.TOverlaidFontSize            = 12               # font size
      self.TOverlaidFontColor           = "ffffff"         # font color
      self.TOverlaidFontShadowColor     = "000000"         # font shadow color
      self.TOverlaidIsBold              = False            # if bold mode
      self.TOverlaidIsItalic            = False            # if Italic mode
      self.TOverlaidIsUnderline         = False            # if Underline mode
      self.TOverlaidHAlign              = 1                # Horizontal alignement : 0=left, 1=center, 2=right, 3=justif
      self.TOverlaidVAlign              = 1                # Vertical alignement : 0=up, 1=center, 2=bottom
      self.TOverlaidStyleText           = 1                # Style : 0=normal, 1=outerline, 2=shadow up-left, 3=shadow up-right, 4=shadow bt-left, 5=shadow bt-right
      self.TOverlaidBackgroundForm      = 0                # Type of the form : 0=None, 1=Rectangle, 2=Ellipse
      self.TOverlaidBackgroundStyle     = 0                # Type of the background color : 0=Solid, 1=Transparent 90% 2=Transparent 80%..., 10=Transparent
      self.TOverlaidBackgroundColor     = "afafaf"         # Color of the background of the form
      self.TOverlaidPenSize             = 1                # Width of the pen of the form
      self.TOverlaidPenColor            = "ffffff"         # Color of the pen of the form
      #Background Text
      if isWindows() : 
        self.TBackGFontName             = "Comic Sans MS"  # font name
      else:
        self.TBackGFontName             = "DejaVu Sans"    # font name
      self.TBackGFontSize               = 28               # font size
      self.TBackGFontColor              = "ffffff"         # font color
      self.TBackGFontShadowColor        = "5f5f5f"         # font shadow color
      self.TBackGIsBold                 = True             # if bold mode
      self.TBackGIsItalic               = False            # if Italic mode
      self.TBackGIsUnderline            = False            # if Underline mode
      self.TBackGHAlign                 = 1                # Horizontal alignement : 0=left, 1=center, 2=right, 3=justif
      self.TBackGVAlign                 = 1                # Vertical alignement : 0=up, 1=center, 2=bottom
      self.TBackGStyleText              = 1                # Style : 0=normal, 1=outerline, 2=shadow up-left, 3=shadow up-right, 4=shadow bt-left, 5=shadow bt-right
      self.TBackGBackgroundForm         = 0                # Type of the form : 0=None, 1=Rectangle, 2=Ellipse
      self.TBackGBackgroundStyle        = 0                # Type of the background color : 0=Solid, 1=Transparent 90% 2=Transparent 80%..., 10=Transparent
      self.TBackGBackgroundColor        = "afafaf"         # Color of the background of the form
      self.TBackGPenSize                = 1                # Width of the pen of the form
      self.TBackGPenColor               = "ffffff"         # Color of the pen of the form
      #Shot Text
      if isWindows() : 
        self.TShotFontName              = "Comic Sans MS"    # font name
      else:
        self.TShotFontName              = "DejaVu Sans"    # font name
      self.TShotFontSize                = 20               # font size
      self.TShotFontColor               = "ffffff"         # font color
      self.TShotFontShadowColor         = "5f5f5f"         # font shadow color
      self.TShotIsBold                  = False            # if bold mode
      self.TShotIsItalic                = False            # if Italic mode
      self.TShotIsUnderline             = False            # if Underline mode
      self.TShotHAlign                  = 1                # Horizontal alignement : 0=left, 1=center, 2=right, 3=justif
      self.TShotVAlign                  = 1                # Vertical alignement : 0=up, 1=center, 2=bottom
      self.TShotStyleText               = 5                # Style : 0=normal, 1=outerline, 2=shadow up-left, 3=shadow up-right, 4=shadow bt-left, 5=shadow bt-right
      self.TShotBackgroundForm          = 2                # Type of the form : 0=None, 1=Rectangle, 2=Ellipse
      self.TShotBackgroundStyle         = 2                # Type of the Background color : 0=Solid, 1=Transparent 90% 2=Transparent 80%..., 10=Transparent
      self.TShotBackgroundColor         = "550000"         # Color of the Background of the form
      self.TShotPenSize                 = 2                # Width of the pen of the form
      self.TShotPenColor                = "ffffff"         # Color of the pen of the form

      #Other options
      self.CheckCodecAtStartup          = 0                #if 0 then Check Codec at Startup
      self.ThumbnailsSize               = 1                #size of the thumbnails in the timeline

      self.RestoreWindowState           = 1                #if 1 restore window size/position at startup
      self.MainWinRx                    = 0                #Saved position for Main Windows
      self.MainWinRy                    = 0                #Saved position for Main Windows
      self.MainWinRw                    = 600              #Saved position for Main Windows
      self.MainWinRh                    = 400              #Saved position for Main Windows
      self.ZoomBoxIsMaximized           = 0                #Saved position for Zoombox DLG
      self.ZoomBoxWinRx                 = -1               #Saved position for Zoombox DLG
      self.ZoomBoxWinRy                 = -1               #Saved position for Zoombox DLG
      self.ZoomBoxWinRw                 = -1               #Saved position for Zoombox DLG
      self.ZoomBoxWinRh                 = -1               #Saved position for Zoombox DLG
      self.TextBoxIsMaximized           = 0                #Saved position for Textbox DLG
      self.TextBoxWinRx                 = -1               #Saved position for Textbox DLG
      self.TextBoxWinRy                 = -1               #Saved position for Textbox DLG
      self.TextBoxWinRw                 = -1               #Saved position for Textbox DLG
      self.TextBoxWinRh                 = -1               #Saved position for Textbox DLG

      #Internal Clipboard
      self.SEQClipboard                 = None             #Internal clipboard for Sequence

      # To optimise DisplayLength
      self.TimeChanged          = True                 # True if a time as change
      # To not redraw ruller if no change
      self.PrevStart   =QTime(0,0,0)
      self.PrevEnd     =QTime(0,0,0)
      self.PrevDuration=QTime(0,0,0)

      #-------------------------------------------------------------------------------------------------------------

      # Init Qt application and locale
      self.qtapp=QApplication(args)
      self.qtapp.setAttribute(Qt.AA_NativeWindows,True)
      locale = QLocale.system().name()
      print "locale : ", locale

      #Init QT translation
      qtTrans = QTranslator()
      if qtTrans.load(u"/usr/share/qt4/translations/qt_"+unicode(locale[0:2])+u".qm") :
        self.qtapp.installTranslator(qtTrans)

      #Init videoporama translation
      qtTranslator = QTranslator()
      if qtTranslator.load(u"./locale/videoporama_"+unicode(locale[0:2])+u".qm") :
        self.qtapp.installTranslator(qtTranslator)

      # Loading Output Format Definition from xml file
      self.OutputOFDXMLObject=VideoporamaOFD("VideoporamaOFD.xml",self)

      #check if the .videoporama directory exist in the home-user. If not : create it
      #and Init default directory
      
      if isWindows() :
        #-----------------------
        # Windows version
        #-----------------------

        #Configuration directory & file
        Sep=u"/"
        self.homeDir=WINDOWS_APPDATA
        if self.homeDir[len(self.homeDir)-1]!='/' : self.homeDir=self.homeDir+'/'
        self.ConfigFilePathName=self.homeDir+u'videoporama/'
        #self.ConfigFilePathName=QDir().toNativeSeparators(self.ConfigFilePathName)
        if self.IsPortable==False:
          if QDir(self.ConfigFilePathName).exists()==False :
            #print self.qtapp.translate("main","Configuration directory doesn't exist")
            #print self.qtapp.translate("main","Create configuration directory")
            try:
              QDir().mkpath(self.ConfigFilePathName)
            except:
              #print self.qtapp.translate("main","Error creating driectory directory")
              return
          self.ConfigFilePathName=self.ConfigFilePathName+u'idv_config.xml'
        else:
          cwd=QDir().current().absolutePath()
          if cwd.endsWith(Sep)!=True: cwd=unicode(cwd)+Sep
          self.ConfigFilePathName=cwd+u'idv_config.xml' # In portable version, file is save in the current directory

        #Default directory for ressources
        self.lastDirImage      = WINDOWS_PICTURES
        self.lastDirMovies     = WINDOWS_VIDEO
        self.lastDirProject    = WINDOWS_DOCUMENTS
        self.lastDirSound      = WINDOWS_MUSIC
        self.lastDirRender     = WINDOWS_VIDEO
        self.lastDirBackground = WINDOWS_PICTURES
        
        #External softwares directory
        cwd=QDir().current().absolutePath()
        if cwd.endsWith(Sep)!=True: cwd=unicode(cwd)+Sep
        self.I           = cwd+u"extern_bin/ffmpeg/bin/"                    #FFMPEG directory
        self.MP          = cwd+u"extern_bin/mplayer/"                        #MPlayer directory
        self.S           = cwd+u"extern_bin/sox/"                            #SOX directory
        self.MJ          = cwd+u"extern_bin/mjpegtools/bin/"                #MPJEPTools directory
		
		
        #Image Editor
        if self.IsPortable==False:
          if IsBinaryFileExist("C:\\Program Files\\GIMP-2.0\\bin\\gimp-2.6.exe"):
            self.ImageEditor = "C:\\Program Files\\GIMP-2.0\\bin\\gimp-2.6.exe"
          else :
            self.ImageEditor = ""
        else:
          if IsBinaryFileExist("C:\\Program Files\\GIMP-2.0\\bin\\gimp-2.6.exe"):
            self.ImageEditor = "C:\\Program Files\\GIMP-2.0\\bin\\gimp-2.6.exe"
          elif IsBinaryFileExist("..\\..\\GIMPPortable\\GIMPPortable.exe"):
            self.ImageEditor = "..\\..\\GIMPPortable\\GIMPPortable.exe"
          else :
            self.ImageEditor = ""

      else :
        #-----------------------
        # Unix/Linux version
        #-----------------------
        self.homeDir=QDir().homePath()
        if self.homeDir[len(self.homeDir)-1]!='/' : self.homeDir=self.homeDir+'/'
        self.homeDir=QDir().toNativeSeparators(self.homeDir)

        #Default directory for ressources
        self.lastDirImage      = self.homeDir        #Last directory use for Image
        self.lastDirMovies     = self.homeDir        #Last directory use for Movie
        self.lastDirProject    = self.homeDir        #Last directory use for Project
        self.lastDirSound      = self.homeDir        #Last directory use for Sound
        self.lastDirRender     = self.homeDir        #Last directory use for Render
        self.lastDirBackground = self.homeDir        #Last directory use for Background Image

        #External softwares directory
        self.I           = "/usr/bin/"                 #FFMPEG directory
        self.MP          = "/usr/bin/"                 #MPlayer directory
        self.S           = "/usr/bin/"                 #SOX directory
        self.MJ          = "/usr/bin/"                 #MPJEPTools directory
        #GIMP filename
        if IsBinaryFileExist("/usr/bin/gimp"):
          self.ImageEditor = "/usr/bin/gimp"
        else :
          self.ImageEditor = ""

        #Configuration directory
        self.ConfigFilePathName=self.homeDir+".videoporama/"
        self.ConfigFilePathName=QDir().toNativeSeparators(self.ConfigFilePathName)
        if QDir(self.ConfigFilePathName).exists()==False :
          print self.qtapp.translate("main","Configuration directory doesn't exist")
          print self.qtapp.translate("main","Create configuration directory")
          try:
            QDir().mkpath(self.ConfigFilePathName)
          except:
            print self.qtapp.translate("main","Error creating driectory directory")
            return
        self.ConfigFilePathName=self.ConfigFilePathName+u'idv_config.xml'

      #Temporary directory
      self.T=QDir().toNativeSeparators(QDir.temp().absolutePath())
      if self.T[len(self.T)-1]!=QDir().separator().toAscii() : self.T=self.T+QDir().separator().toAscii()

      # Loading configuration data from xml file
      ConfigFile=QFile(self.ConfigFilePathName)
      if ConfigFile.open(QIODevice.ReadOnly | QIODevice.Text) :
        print self.qtapp.translate("main",u"Loading configuration data")
        self.ConfigXMLObject=minidom.parse(ConfigFile)
        ConfigFile.close()
        ForceConfig=False
      else :
        print self.qtapp.translate("main","Create configuration data file")
        self.ConfigXMLObject= Document()
        xmltag = self.ConfigXMLObject.createElement(u"configuration")
        self.ConfigXMLObject.appendChild(xmltag)
        ForceConfig=True

      #Loading configuration from configuration file
      #  ... force loading all data to create them with default value if not exist

      #Configuration TAB Directory configuration
      if self.IsPortable==False :
        self.T                 = LoadValueFromXMLFile(self.ConfigXMLObject,'tmpdir',self.T)                            #Temporary directory
        self.I                 = LoadValueFromXMLFile(self.ConfigXMLObject,'imgmgkdir',self.I)                         #FFMPEG directory
        self.MP                = LoadValueFromXMLFile(self.ConfigXMLObject,'mplayerdir',self.MP)                       #MPlayer directory
        self.S                 = LoadValueFromXMLFile(self.ConfigXMLObject,'soxdir',self.S)                            #SOX directory
        self.MJ                = LoadValueFromXMLFile(self.ConfigXMLObject,'mjpegtoolsdir',self.MJ)                    #MPJEPTools directory
        self.ImageEditor       = LoadValueFromXMLFile(self.ConfigXMLObject,'ImageEditor',self.ImageEditor)             #ImageEditor filename

      self.lastDirImage      = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirImage',self.lastDirImage)           #Last directory use for Image
      self.lastDirMovies     = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirMovies',self.lastDirMovies)         #Last directory use for Movie
      self.lastDirProject    = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirProject',self.lastDirProject)       #Last directory use for Project
      self.lastDirSound      = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirSound',self.lastDirSound)           #Last directory use for Sound
      self.lastDirRender     = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirRender',self.lastDirRender)         #Last directory use for Render
      self.lastDirBackground = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirBackground',self.lastDirBackground) #Last directory use for Background Image

      #Configuration TAB Display configuration
      self.ConfDisplayUnit    = LoadValueFromXMLFile(self.ConfigXMLObject,'zoomVal',self.ConfDisplayUnit)
      self.RestoreWindowState = LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-RestoreWindowState',self.RestoreWindowState)
      self.ThumbnailsSize     = int(LoadValueFromXMLFile(self.ConfigXMLObject,'ThumbnailsSize',self.ThumbnailsSize))
      self.ConfAutoRotate     = LoadValueFromXMLFile(self.ConfigXMLObject,'ConfAutoRotate',self.ConfAutoRotate)
      self.NewSEQPosition     = int(LoadValueFromXMLFile(self.ConfigXMLObject,'NewSEQPosition',self.NewSEQPosition))

      #Configuration TAB Default output format
      self.ConfVideoF         = LoadValueFromXMLFile(self.ConfigXMLObject,'videof',self.ConfVideoF)
      self.ConfImgFormat      = LoadValueFromXMLFile(self.ConfigXMLObject,'imgformat',self.ConfImgFormat)
      self.XMLText            = None
      self.ConfOFDDeviceType  = LoadValueFromXMLFile(self.ConfigXMLObject,'OFDDeviceType',"Computer")
      self.ConfOFDDeviceModel = LoadValueFromXMLFile(self.ConfigXMLObject,'OFDDeviceModel',"Generic PC")
      self.ConfOFDOutputCodec = LoadValueFromXMLFile(self.ConfigXMLObject,'OFDOutputCodec',"AVI (XVid/MP3)")
      self.ConfOFDOutputFormat= LoadValueFromXMLFile(self.ConfigXMLObject,'OFDOutputFormat',"VGA 640x480-25 fps")

      #Configuration TAB Standards project options
      self.ConfTime           = LoadValueFromXMLFile(self.ConfigXMLObject,'time',self.ConfTime)
      self.ConfStaticTimeNext = LoadValueFromXMLFile(self.ConfigXMLObject,'StaticTimeNext',self.ConfStaticTimeNext)
      self.ConfAnimTimeNext   = LoadValueFromXMLFile(self.ConfigXMLObject,'AnimTimeNext',self.ConfAnimTimeNext)
      self.ConfSpeedT         = LoadValueFromXMLFile(self.ConfigXMLObject,'speedt',self.ConfSpeedT)
      self.ConfTypeT          = LoadValueFromXMLFile(self.ConfigXMLObject,'typet',self.ConfTypeT)
      self.ConfTransiOpt      = LoadValueFromXMLFile(self.ConfigXMLObject,'transiopt',self.ConfTransiOpt)
      self.ConfBgFile         = LoadValueFromXMLFile(self.ConfigXMLObject,'bgfile',self.ConfBgFile)
      self.ConfBgColor        = LoadValueFromXMLFile(self.ConfigXMLObject,'bgcolor',self.ConfBgColor)

      #Configuration Default texts options for dialog box
      #Overlaid Text
      self.TOverlaidFontName       = LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidFontName',self.TOverlaidFontName)
      self.TOverlaidFontSize       = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidFontSize',str(self.TOverlaidFontSize)))
      self.TOverlaidFontColor      = LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidFontColor',self.TOverlaidFontColor)
      self.TOverlaidFontShadowColor= LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidFontShadowColor',self.TOverlaidFontShadowColor)
      self.TOverlaidIsBold         = (LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidIsBold',"1" if self.TOverlaidIsBold==True else "0")=="1")
      self.TOverlaidIsItalic       = (LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidIsItalic',"1" if self.TOverlaidIsItalic==True  else "0")=="1")
      self.TOverlaidIsUnderline    = (LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidIsUnderline',"1" if self.TOverlaidIsUnderline==True else "0")=="1")
      self.TOverlaidHAlign         = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidHAlign',str(self.TOverlaidHAlign)))
      self.TOverlaidVAlign         = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidVAlign',str(self.TOverlaidVAlign)))
      self.TOverlaidStyleText      = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidStyleText',str(self.TOverlaidStyleText)))
      self.TOverlaidBackgroundForm = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidBackgroundForm',str(self.TOverlaidBackgroundForm)))
      self.TOverlaidBackgroundStyle= int(LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidBackgroundStyle',str(self.TOverlaidBackgroundStyle)))
      self.TOverlaidBackgroundColor= LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidBackgroundColor',self.TOverlaidBackgroundColor)
      self.TOverlaidPenSize        = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidPenSize',str(self.TOverlaidPenSize)))
      self.TOverlaidPenColor       = LoadValueFromXMLFile(self.ConfigXMLObject,'TOverlaidPenColor',self.TOverlaidPenColor)
      #Background Text
      self.TBackGFontName       = LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGFontName',self.TBackGFontName)
      self.TBackGFontSize       = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGFontSize',str(self.TBackGFontSize)))
      self.TBackGFontColor      = LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGFontColor',self.TBackGFontColor)
      self.TBackGFontShadowColor= LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGFontShadowColor',self.TBackGFontShadowColor)
      self.TBackGIsBold         = (LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGIsBold',"1" if self.TBackGIsBold==True else "0")=="1")
      self.TBackGIsItalic       = (LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGIsItalic',"1" if self.TBackGIsItalic==True  else "0")=="1")
      self.TBackGIsUnderline    = (LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGIsUnderline',"1" if self.TBackGIsUnderline==True else "0")=="1")
      self.TBackGHAlign         = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGHAlign',str(self.TBackGHAlign)))
      self.TBackGVAlign         = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGVAlign',str(self.TBackGVAlign)))
      self.TBackGStyleText      = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGStyleText',str(self.TBackGStyleText)))
      self.TBackGBackgroundForm = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGBackgroundForm',str(self.TBackGBackgroundForm)))
      self.TBackGBackgroundStyle= int(LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGBackgroundStyle',str(self.TBackGBackgroundStyle)))
      self.TBackGBackgroundColor= LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGBackgroundColor',self.TBackGBackgroundColor)
      self.TBackGPenSize        = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGPenSize',str(self.TBackGPenSize)))
      self.TBackGPenColor       = LoadValueFromXMLFile(self.ConfigXMLObject,'TBackGPenColor',self.TBackGPenColor)
      #Shot Text
      self.TShotFontName       = LoadValueFromXMLFile(self.ConfigXMLObject,'TShotFontName',self.TShotFontName)
      self.TShotFontSize       = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TShotFontSize',str(self.TShotFontSize)))
      self.TShotFontColor      = LoadValueFromXMLFile(self.ConfigXMLObject,'TShotFontColor',self.TShotFontColor)
      self.TShotFontShadowColor= LoadValueFromXMLFile(self.ConfigXMLObject,'TShotFontShadowColor',self.TShotFontShadowColor)
      self.TShotIsBold         = (LoadValueFromXMLFile(self.ConfigXMLObject,'TShotIsBold',"1" if self.TShotIsBold==True else "0")=="1")
      self.TShotIsItalic       = (LoadValueFromXMLFile(self.ConfigXMLObject,'TShotIsItalic',"1" if self.TShotIsItalic==True  else "0")=="1")
      self.TShotIsUnderline    = (LoadValueFromXMLFile(self.ConfigXMLObject,'TShotIsUnderline',"1" if self.TShotIsUnderline==True else "0")=="1")
      self.TShotHAlign         = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TShotHAlign',str(self.TShotHAlign)))
      self.TShotVAlign         = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TShotVAlign',str(self.TShotVAlign)))
      self.TShotStyleText      = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TShotStyleText',str(self.TShotStyleText)))
      self.TShotBackgroundForm = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TShotBackgroundForm',str(self.TShotBackgroundForm)))
      self.TShotBackgroundStyle= int(LoadValueFromXMLFile(self.ConfigXMLObject,'TShotBackgroundStyle',str(self.TShotBackgroundStyle)))
      self.TShotBackgroundColor= LoadValueFromXMLFile(self.ConfigXMLObject,'TShotBackgroundColor',self.TShotBackgroundColor)
      self.TShotPenSize        = int(LoadValueFromXMLFile(self.ConfigXMLObject,'TShotPenSize',str(self.TShotPenSize)))
      self.TShotPenColor       = LoadValueFromXMLFile(self.ConfigXMLObject,'TShotPenColor',self.TShotPenColor)

      #Others Configuration options
      self.CheckCodecAtStartup= LoadValueFromXMLFile(self.ConfigXMLObject,'CheckCodecAtStartup',self.CheckCodecAtStartup)

      # Main windows
      self.win=Gui_Main()
      self.win.TABOptions.setCurrentIndex(0)  # Force 1st TAB
      
      #Init Timeline
      self.win.timeline.horizontalHeader().hide()
      self.win.timeline.verticalHeader().hide()
      self.win.timeline.setRowCount(1)
      self.win.timeline.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOn)
      self.win.timeline.setShowGrid(False)
      self.SelectionEnCours=None

      #Init TableZoomPoint
      self.win.TableZoomPoint.horizontalHeader().hide()
      self.win.TableZoomPoint.verticalHeader().hide()
      self.win.TableZoomPoint.setColumnCount(1)
      self.win.TableZoomPoint.setShowGrid(False)

      self.index=-1

      #Init TAB Montage
      self.win.imgformat.setCurrentIndex(self.imgformat)

      #Init TAB Image
      # Create transition list
      self.lstT=LstTransi(self)
      self.win.typet.addItems(self.lstT)
      self.RANDOMTRANSITIONTYPE=self.win.typet.count()
      self.win.transiopt.addItem(QIcon("iconstr/tr-00-00.png"),self.qtapp.translate("main","No Option"))

      # Restore Windows Settings (size/position/state) if needed
      try:
        if self.RestoreWindowState=="1":
          ForceMaximized=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-ismaximized',0))
          self.MainWinRx=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-x',0))
          self.MainWinRy=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-y',0))
          self.MainWinRw=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-width',0))
          self.MainWinRh=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-height',0))

          self.win.move(self.MainWinRx,self.MainWinRy)
          self.win.resize(self.MainWinRw,self.MainWinRh)
          if ForceMaximized!=0: self.win.showMaximized()

          self.ZoomBoxIsMaximized=int(LoadValueFromXMLFile(self.ConfigXMLObject,'ZoomBoxSettings-ismaximized',0))
          self.ZoomBoxWinRx      =int(LoadValueFromXMLFile(self.ConfigXMLObject,'ZoomBoxSettings-x',0))
          self.ZoomBoxWinRy      =int(LoadValueFromXMLFile(self.ConfigXMLObject,'ZoomBoxSettings-y',0))
          self.ZoomBoxWinRw      =int(LoadValueFromXMLFile(self.ConfigXMLObject,'ZoomBoxSettings-width',0))
          self.ZoomBoxWinRh      =int(LoadValueFromXMLFile(self.ConfigXMLObject,'ZoomBoxSettings-height',0))
          self.TextBoxIsMaximized=int(LoadValueFromXMLFile(self.ConfigXMLObject,'TextBoxSettings-ismaximized',0))
          self.TextBoxWinRx      =int(LoadValueFromXMLFile(self.ConfigXMLObject,'TextBoxSettings-x',0))
          self.TextBoxWinRy      =int(LoadValueFromXMLFile(self.ConfigXMLObject,'TextBoxSettings-y',0))
          self.TextBoxWinRw      =int(LoadValueFromXMLFile(self.ConfigXMLObject,'TextBoxSettings-width',0))
          self.TextBoxWinRh      =int(LoadValueFromXMLFile(self.ConfigXMLObject,'TextBoxSettings-height',0))

      except:
        None

      self.montageLenght = 0.0
      self.SoundDef = None # Sound definition data of sound montage part
      
      #setup Timeline heigh depend on self.ThumbnailsSize
      self.Timeline_ChTThumbnailSize()

      # Difference between Posix and Nt plateforme
      if isWindows() : 
        actionButton="triggered()"
      else : 
        actionButton="activated()"

      #---------------------------------------------
      # Qt SLOT/SIGNAL connection
      #---------------------------------------------

      #application handler
      self.qtapp.connect(self.win.action_Exit,SIGNAL(actionButton),self.App_CloseApp)
      self.qtapp.connect(self.qtapp, SIGNAL("lastWindowClosed()"),self.App_CloseApp)
      self.qtapp.connect(self.win,SIGNAL("resizeEvent(QResizeEvent)"),self.App_ResizeEvent)
      self.qtapp.connect(self.win.TABOptions,SIGNAL("currentChanged(int)"),self.App_DisplayPixMainWin)

      #file manipulation function
      self.qtapp.connect(self.win.action_New,SIGNAL(actionButton),self.File_NewProject)
      self.qtapp.connect(self.win.action_Open,SIGNAL(actionButton),self.File_OpenProject)
      self.qtapp.connect(self.win.action_Save,SIGNAL(actionButton),self.File_SaveProject)
      self.qtapp.connect(self.win.actionSave_as,SIGNAL(actionButton),self.File_SaveAsProject)
      self.qtapp.connect(self.win.actionAddProject,SIGNAL(actionButton),self.File_AddProject)

      #TAB Montage Option
      #self.qtapp.connect(self.win.soundfile,SIGNAL("lostFocus()"),self.TAB_Montage_ChgSndFile)
      #self.qtapp.connect(self.win.soundfilea,SIGNAL("clicked()"),self.TAB_Montage_BrowseSndFile)
      self.qtapp.connect(self.win.imgformat,SIGNAL("activated(int)"),self.TAB_Montage_SetImgFormat)
      self.qtapp.connect(self.win.DefTextBtMontage,SIGNAL("pressed()"),self.TAB_Montage_DefText)

      #TAB Sequence
      self.qtapp.connect(self.win.actionCut,SIGNAL(actionButton),self.SEQ_Cut)
      self.qtapp.connect(self.win.actionCopy,SIGNAL(actionButton),self.SEQ_Copy)
      self.qtapp.connect(self.win.actionPaste,SIGNAL(actionButton),self.SEQ_Paste)

      self.qtapp.connect(self.win.typet,SIGNAL("currentIndexChanged(int)"),self.SEQ_ChgTrOption)
      self.qtapp.connect(self.win.transiopt,SIGNAL("currentIndexChanged(int)"),self.SEQ_ChgOptTr)
      self.qtapp.connect(self.win.speedt,SIGNAL("activated(int)"),self.SEQ_ChoixSpeedT)
      self.qtapp.connect(self.win.bgfile,SIGNAL("lostFocus()"),self.SEQ_ChgBgFile)
      self.qtapp.connect(self.win.bgfilea,SIGNAL("clicked()"),self.SEQ_BrowseBgFile)
      self.qtapp.connect(self.win.bgcolor,SIGNAL("lostFocus()"),self.SEQ_ChgBgColor)
      self.qtapp.connect(self.win.bgcolora,SIGNAL("clicked()"),self.SEQ_BrowseBgColor)
      self.qtapp.connect(self.win.DefTextBtImage,SIGNAL("pressed()"),self.SEQ_DefText)

      #TAB Image
      self.qtapp.connect(self.win.ImageFileBt,SIGNAL("pressed()"),self.TAB_Image_ChgImageFile)
      self.qtapp.connect(self.win.RotateLeftBT,SIGNAL("pressed()"),self.TAB_Image_RotateLeft)
      self.qtapp.connect(self.win.RotateRightBT,SIGNAL("pressed()"),self.TAB_Image_RotateRight)
      self.qtapp.connect(self.win.CallGimpBT,SIGNAL("pressed()"),self.TAB_Image_CallGimp)
      self.qtapp.connect(self.win.RefreshImgBT,SIGNAL("pressed()"),self.TAB_Image_RefreshImg)

      #TAB Movie
      self.qtapp.connect(self.win.MovieFileBt,SIGNAL("pressed()"),self.TAB_Movie_ChgMovieFile)
      self.qtapp.connect(self.win.RotateLeftMovieBT,SIGNAL("pressed()"),self.TAB_Movie_RotateLeft)
      self.qtapp.connect(self.win.RotateRightMovieBT,SIGNAL("pressed()"),self.TAB_Movie_RotateRight)
      self.qtapp.connect(self.win.RefreshMovieBT,SIGNAL("pressed()"),self.TAB_Movie_RefreshMovie)
      self.qtapp.connect(self.win.DefMoviePointBt,SIGNAL("pressed()"),self.TAB_Movie_DefMoviePoint)
      self.qtapp.connect(self.win.MovieStartEd,SIGNAL("timeChanged(QTime)"),self.TAB_Movie_OnDefStartPosEd)
      self.qtapp.connect(self.win.MovieEndEd,SIGNAL("timeChanged(QTime)"),self.TAB_Movie_OnDefEndPosEd)

      #Timeline action
      self.qtapp.connect(self.win.actionAddtitle,SIGNAL(actionButton),self.Timeline_AddTitle)
      self.qtapp.connect(self.win.actionAdd,SIGNAL(actionButton),self.Timeline_BrowseAddImage)
      self.qtapp.connect(self.win.actionAddMovie,SIGNAL(actionButton),self.Timeline_BrowseAddMovie)
      self.qtapp.connect(self.win.actionMove_right,SIGNAL(actionButton),self.Timeline_MoveItemToRight)
      self.qtapp.connect(self.win.actionMove_left,SIGNAL(actionButton),self.Timeline_MoveItemToLeft)
      self.qtapp.connect(self.win.actionRemove,SIGNAL(actionButton),self.Timeline_DeleteItem)
      self.qtapp.connect(self.win.timeline,SIGNAL("itemSelectionChanged()"),self.Timeline_ChgSelectedItem)
      self.qtapp.connect(self.win.ZoomDownBt,SIGNAL("pressed()"),self.Timeline_ZoomDown)
      self.qtapp.connect(self.win.ZoomUpBt,SIGNAL("pressed()"),self.Timeline_ZoomUp)

      #TableZoomPoint and TAB Zoom action
      self.qtapp.connect(self.win.addZoomPoint,SIGNAL("pressed()"),self.TableZoomPoint_AddPoint)
      self.qtapp.connect(self.win.moveZoomPointToLeft,SIGNAL("pressed()"),self.TableZoomPoint_MoveItemToUp)
      self.qtapp.connect(self.win.moveZoomPointToRight,SIGNAL("pressed()"),self.TableZoomPoint_MoveItemToDown)
      self.qtapp.connect(self.win.removeZoomPoint,SIGNAL("pressed()"),self.TableZoomPoint_DeleteItem)
      self.qtapp.connect(self.win.ZoomPointTimeFixe,SIGNAL("valueChanged(int)"),self.TableZoomPoint_ChgTimeFixe)
      self.qtapp.connect(self.win.ZoomPointTimeTravel,SIGNAL("valueChanged(int)"),self.TableZoomPoint_ChgTimeToTravel)
      self.qtapp.connect(self.win.TableZoomPoint,SIGNAL("itemSelectionChanged()"),self.TableZoomPoint_ChgSelectedItem)
      self.qtapp.connect(self.win.ZoomPointXValue,SIGNAL("valueChanged(double)"),self.TableZoomPoint_ChgZoomPointXValue)
      self.qtapp.connect(self.win.ZoomPointYValue,SIGNAL("valueChanged(double)"),self.TableZoomPoint_ChgZoomPointYValue)
      self.qtapp.connect(self.win.ZoomPointZoomValue,SIGNAL("valueChanged(double)"),self.TableZoomPoint_ChgZoomPointZoomValue)
      self.qtapp.connect(self.win.DefZoomPointBt,SIGNAL("pressed()"),self.TableZoomPoint_DefZoomPoint)
      self.qtapp.connect(self.win.DefTextBtZoomPoint,SIGNAL("pressed()"),self.TableZoomPoint_DefZoomPointText)
      #Other toolbar action
      self.qtapp.connect(self.win.actionConfiguration,SIGNAL(actionButton),self.App_Configuration)
      self.qtapp.connect(self.win.action_About,SIGNAL(actionButton),self.App_About)
      self.qtapp.connect(self.win.actionDocumentation,SIGNAL(actionButton),self.App_Documentation)
      self.qtapp.connect(self.win.actionNewFunctions,SIGNAL(actionButton),self.App_NewFunctions)
      self.qtapp.connect(self.win.serie,SIGNAL(actionButton),self.App_ProcessSerieDialog)
      self.qtapp.connect(self.win.actionPreview,SIGNAL(actionButton),self.App_Preview)
      self.qtapp.connect(self.win.actionPreviewBt,SIGNAL("pressed()"),self.App_Preview)
      self.qtapp.connect(self.win.actionPreviewFrom,SIGNAL(actionButton),self.App_PreviewFrom)
      self.qtapp.connect(self.win.actionPreviewFromBt,SIGNAL("pressed()"),self.App_PreviewFrom)
      self.qtapp.connect(self.win.actionRender,SIGNAL(actionButton),self.App_DoRender)
      self.qtapp.connect(self.win.actionRenderBt,SIGNAL("pressed()"),self.App_DoRender)
      self.qtapp.connect(self.win.actionVideo_player,SIGNAL(actionButton),self.App_MplayerView)
      self.qtapp.connect(self.win.actionVideo_player,SIGNAL(actionButton),self.App_MplayerView)

      # Sound montage button
      self.qtapp.connect(self.win.SoundButton,SIGNAL("pressed()"),self.SND_test)

      # Display main window
      self.win.show()
      #check config
      self.check_CheckConfig(False,ForceConfig)
      #if firsttime : open the configuration dialogbox
      if ForceConfig==True: self.App_Configuration(True)

      self.StopMAJOFD = False

      #Init new project
      self.IsProjectModified=False
      self.File_NewProject()
      
      # If option -idv + idv file -> Open file
      if len(args) > 2 :
        if args[2] == "-idv" :
          self.ProjectFilePathName=args[3]
          #Import configurations data from xml file
          try:
            fo2=open(self.ProjectFilePathName,'r')
            self.ProjectXMLObject=minidom.parse(fo2)
            fo2.close()
            #Make object from XML data
            self.File_MakeFromXML()
          except:
            print self.qtapp.translate("main","Opening ")+self.ProjectFilePathName
            
      # Display lenght time.
      self.App_DisplayLenght()
      self.App_DisplayPixMainWin(0)
      # Start app
      self.qtapp.exec_()
      
    ### Sound montage      
    def SND_test(self) :
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      self.soundDlg = SoundDlg(self.montageLenght, self, self.win)
      self.soundDlg.show()
      #self.WaitEvents() #Pour laisser le temps à la fenêtre de se fermer !      
      self.soundDlg.setTimeline(self.win.timeline, 25)
      try :
        xmlSound = self.ProjectXMLObject.getElementsByTagName('sound')[0]
      except :
        xmlSound = None
      self.soundDlg.setSoundFromXml(xmlSound)
      self.qtapp.restoreOverrideCursor()
      
      self.qtapp.connect(self.soundDlg.buttonBox,SIGNAL("rejected()"),self.soundDlg,SLOT("close()"))
      self.qtapp.connect(self.soundDlg.buttonBox,SIGNAL("accepted()"), self.getSoundDef)
      
    def getXMLSound(self) :
      """Function to get XML for sound montage part"""
      XMLSound = self.soundDlg.getXMLSound(self.ProjectXMLObject)
      try :
        oldSound = self.ProjectXMLObject.getElementsByTagName('Videoporama')[0].removeChild(self.ProjectXMLObject.getElementsByTagName('sound')[0])
        oldsound.unlink()
      except : None
      self.ProjectXMLObject.getElementsByTagName('Videoporama')[0].appendChild(XMLSound)
      self.soundDlg.close()

    def getSoundDef(self) :
      """Function to get definition of sound montage part"""
      self.getXMLSound()
      self.SoundDef = self.soundDlg.getPropSound()
      self.soundDlg.close()

    #----------------------------------------------------------------------------------------
    # Petite fonction pour forcer les réaffichages en vidant l'EventLoop !
    #----------------------------------------------------------------------------------------
    def WaitEvents(self):
        i=0
        while i<250:
          QCoreApplication.processEvents()
          i+=1

    #----------------------------------------------------------------------------------------
    # closeApp : when videoporama stop
    #----------------------------------------------------------------------------------------
    def App_CloseApp(self):
      if self.BLOCKCloseApp: return
      #Ask to save project before continuing if current project not save
      if self.IsProjectModified:
        self.BLOCKCloseApp=True
        reply = QtGui.QMessageBox.question(self.win, self.qtapp.translate("main","New project"),
          self.qtapp.translate("main","Current project was modified.\nSave it now before continuing ?"),
          QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply==QtGui.QMessageBox.Yes: self.File_SaveProject()

      self.App_SaveConfig()
      self.qtapp.quit()

    def App_SaveConfig(self): 
      # Update xml document
      if self.IsPortable==False :
        UpdateConfigurationXMLFile(self.ConfigXMLObject,u"imgmgkdir",unicode(self.I))
        UpdateConfigurationXMLFile(self.ConfigXMLObject,u"mjpegtoolsdir",unicode(self.MJ))
        UpdateConfigurationXMLFile(self.ConfigXMLObject,u"soxdir",unicode(self.S))
        UpdateConfigurationXMLFile(self.ConfigXMLObject,u"tmpdir",unicode(self.T))
        UpdateConfigurationXMLFile(self.ConfigXMLObject,u"mplayerdir",unicode(self.MP))
        UpdateConfigurationXMLFile(self.ConfigXMLObject,u"ImageEditor",unicode(self.ImageEditor))

      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"time",str(self.ConfTime))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"StaticTimeNext",str(self.ConfStaticTimeNext))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"AnimTimeNext",str(self.ConfAnimTimeNext))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"speedt",str(self.ConfSpeedT))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"typet",str(self.ConfTypeT))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"transiopt",str(self.ConfTransiOpt))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"bgcolor",str(self.ConfBgColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"bgfile",unicode(self.ConfBgFile))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"imgformat",str(self.ConfImgFormat))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"zoomVal",str(self.ConfDisplayUnit))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"ThumbnailsSize",str(self.ThumbnailsSize))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"NewSEQPosition",str(self.NewSEQPosition))

      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-RestoreWindowState",str(self.RestoreWindowState))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'OFDDeviceType',unicode(self.ConfOFDDeviceType))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'OFDDeviceModel',unicode(self.ConfOFDDeviceModel))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'OFDOutputCodec',unicode(self.ConfOFDOutputCodec))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'OFDOutputFormat',unicode(self.ConfOFDOutputFormat))
      #Overlaid Text
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidFontName',        str(self.TOverlaidFontName))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidFontSize',        str(self.TOverlaidFontSize))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidFontColor',       str(self.TOverlaidFontColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidFontShadowColor', str(self.TOverlaidFontShadowColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidIsBold',          str("1" if self.TOverlaidIsBold==True else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidIsItalic',        str("1" if self.TOverlaidIsItalic==True  else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidIsUnderline',     str("1" if self.TOverlaidIsUnderline==True else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidHAlign',          str(self.TOverlaidHAlign))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidVAlign',          str(self.TOverlaidVAlign))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidStyleText',       str(self.TOverlaidStyleText))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidBackgroundForm',  str(self.TOverlaidBackgroundForm))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidBackgroundStyle', str(self.TOverlaidBackgroundStyle))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidBackgroundColor', str(self.TOverlaidBackgroundColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidPenSize',         str(self.TOverlaidPenSize))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TOverlaidPenColor',        str(self.TOverlaidPenColor))
      #BackGround Text
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGFontName',           str(self.TBackGFontName))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGFontSize',           str(self.TBackGFontSize))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGFontColor',          str(self.TBackGFontColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGFontShadowColor',    str(self.TBackGFontShadowColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGIsBold',             str("1" if self.TBackGIsBold==True else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGIsItalic',           str("1" if self.TBackGIsItalic==True  else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGIsUnderline',        str("1" if self.TBackGIsUnderline==True else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGHAlign',             str(self.TBackGHAlign))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGVAlign',             str(self.TBackGVAlign))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGStyleText',          str(self.TBackGStyleText))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGBackgroundForm',     str(self.TBackGBackgroundForm))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGBackgroundStyle',    str(self.TBackGBackgroundStyle))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGBackgroundColor',    str(self.TBackGBackgroundColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGPenSize',            str(self.TBackGPenSize))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TBackGPenColor',           str(self.TBackGPenColor))
      #Shot Text
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotFontName',            str(self.TShotFontName))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotFontSize',            str(self.TShotFontSize))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotFontColor',           str(self.TShotFontColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotFontShadowColor',     str(self.TShotFontShadowColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotIsBold',              str("1" if self.TShotIsBold==True else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotIsItalic',            str("1" if self.TShotIsItalic==True  else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotIsUnderline',         str("1" if self.TShotIsUnderline==True else "0"))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotHAlign',              str(self.TShotHAlign))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotVAlign',              str(self.TShotVAlign))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotStyleText',           str(self.TShotStyleText))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotBackgroundForm',      str(self.TShotBackgroundForm))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotBackgroundStyle',     str(self.TShotBackgroundStyle))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotBackgroundColor',     str(self.TShotBackgroundColor))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotPenSize',             str(self.TShotPenSize))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'TShotPenColor',            str(self.TShotPenColor))

      # Save Windows size/position on exit
      if self.win.isMaximized():  
        state=1
      else : 
        state=0
        if isWindows():
          size=self.win.frameGeometry()
          self.MainWinRx = size.x()
          self.MainWinRy = size.y()
          size=self.win.geometry()
        else:
          size=self.win.geometry()
          self.MainWinRx = size.x()-1 #It's not good but X11 don't give the real information !
          self.MainWinRy = size.y()-self.win.menuBar().height()-5 #It's not good but X11 don't give the real information !
        self.MainWinRw = size.width()
        self.MainWinRh = size.height()
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-ismaximized",str(state))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-x",str(self.MainWinRx))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-y",str(self.MainWinRy))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-width",str(self.MainWinRw))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-height",str(self.MainWinRh))

      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"ZoomBoxSettings-ismaximized",str(self.ZoomBoxIsMaximized))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"ZoomBoxSettings-x",str(self.ZoomBoxWinRx))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"ZoomBoxSettings-y",str(self.ZoomBoxWinRy))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"ZoomBoxSettings-width",str(self.ZoomBoxWinRw))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"ZoomBoxSettings-height",str(self.ZoomBoxWinRh))

      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"TextBoxSettings-ismaximized",str(self.TextBoxIsMaximized))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"TextBoxSettings-x",str(self.TextBoxWinRx))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"TextBoxSettings-y",str(self.TextBoxWinRy))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"TextBoxSettings-width",str(self.TextBoxWinRw))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"TextBoxSettings-height",str(self.TextBoxWinRh))

      #Other
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirImage",unicode(self.lastDirImage))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirMovies",unicode(self.lastDirMovies))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirProject",unicode(self.lastDirProject))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirSound",unicode(self.lastDirSound))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirRender",unicode(self.lastDirRender))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirBackground",unicode(self.lastDirBackground))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"CheckCodecAtStartup",str(self.CheckCodecAtStartup))

      #save the file
      ConfigFile=QFile(self.ConfigFilePathName)
      if ConfigFile.open(QIODevice.WriteOnly | QIODevice.Text) :
        ConfigFile.write(self.ConfigXMLObject.toxml('utf-8'))
        ConfigFile.close()

    #-------------------------------------------------------------------------------------------------
    # App_DisplayPixMainWin : function call each time the preview zone (main window) need to be update
    #-------------------------------------------------------------------------------------------------
    def App_DisplayPixMainWin(self,TabToDisplay) :
      if self.StopUpdatePixDuringNewSelect==True : return
      #Aspect ratio rendering
      OuputWidth=float(self.win.preview.width())
      if self.imgformat==1 : OutputHeight=float((OuputWidth/16)*9)
      else :                 OutputHeight=float((OuputWidth/4)*3)
      if OutputHeight>self.win.preview.height():
      #Retry for OuputWidth if image is not landscape
        OutputHeight=float(self.win.preview.height())
        if self.imgformat==1 : OuputWidth=float((OutputHeight/9)*16)
        else :                 OuputWidth=float((OutputHeight/3)*4)
      #Calc position
      DecalX=float(self.win.preview.width()-OuputWidth)/2
      DecalY=float(self.win.preview.height()-OutputHeight)/2
      #Create Background QImage
      bkgpix = QImage(QSize(self.win.preview.width(),self.win.preview.height()),QImage.Format_ARGB32_Premultiplied)
      p=QPainter(bkgpix)
      p.fillRect(QRect(0,0,self.win.preview.width(),self.win.preview.height()),toqcolor(QString("afafaf").toInt(16)[0]))
      p.end()
      if (self.index != -1) :
        image=self.win.timeline.cellWidget(0,self.index)
        if image!=None:
          # Zoom and travel TAB
          i = self.win.TableZoomPoint.currentRow()
          if i > -1 : Dessin,Unused=image.ToRenderImageForDisplay(i,OuputWidth,OutputHeight)
          else :      Dessin,Unused=image.ToRenderImageForDisplay(0,OuputWidth,OutputHeight)
          if self.XMLText!=None: Dessin=ApplyTextToQImage(Dessin,self.XMLText.getElementsByTagName(u"SaveXML")[0])
          p=QPainter(bkgpix)
          p.drawImage(DecalX,DecalY,Dessin)
          p.end()
      self.win.preview.setPixmap(QPixmap.fromImage(bkgpix))

    #----------------------------------------------------------------------------------------
    # App_ResizeEvent : when main videoporama window is resize
    #----------------------------------------------------------------------------------------
    def App_ResizeEvent(self, event) :
      try:
        self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
        # Reset variables to force a refresh of the ruller
        self.TimeChanged=True
        self.PrevStart   =QTime(0,0,0)
        self.PrevEnd     =QTime(0,0,0)
        self.PrevDuration=QTime(0,0,0)
        self.App_DisplayLenght()
      except:
        None

    #----------------------------------------------------------------------------------------
    # Function for set all elements in the main windows
    #----------------------------------------------------------------------------------------
    def App_SetupInterface(self):
      self.StopSetupInterface = True
      NbrImageItem = self.win.timeline.columnCount()
      if NbrImageItem>0:
        self.index = self.win.timeline.currentColumn()
        if self.index==-1:
          #if none is selected, force select the first
          self.win.timeline.setCurrentCell(0,0)
          self.index = self.win.timeline.currentColumn()
        image=self.win.timeline.cellWidget(0,self.index)
        if image.ObjectType!=2 :
          row=self.win.TableZoomPoint.currentRow()
          if row!=-1 : ZoomPointItem=self.win.TableZoomPoint.cellWidget(row,0)
          else : ZoomPointItem=None
        else : ZoomPointItem=None
      else:
        self.index    = -1
        image         = None
        ZoomPointItem = None

      self.App_WindowTitleAndFlag()
      CurTab=self.win.TABOptions.currentIndex()
      if image==None :
        if CurTab!=0: self.win.TABOptions.setCurrentIndex(0)
        self.win.TABOptions.setTabEnabled(1,False)
        self.win.TABOptions.setTabEnabled(2,False)
        self.win.TABOptions.setTabEnabled(3,False)
      else :
        self.win.TABOptions.setTabEnabled(1,True)
      
      #----------------------------------------
      #TAB Montage Option
      #----------------------------------------
      self.win.imgformat.setCurrentIndex(self.imgformat)
      #self.win.soundfile.setText(self.soundfile)
      
      #----------------------------------------
      #TAB Sequence
      #----------------------------------------
      self.win.bgcolor.setDisabled(image==None)
      self.win.bgcolora.setDisabled(image==None)
      self.win.bgfile.setDisabled(image==None)
      self.win.bgfilea.setDisabled(image==None)
      self.win.ZoomPointTimeFixe.setDisabled(image==None)
      self.win.ZoomPointTimeTravel.setDisabled(image==None)
      self.win.speedt.setDisabled(image==None)
      self.win.typet.setDisabled(image==None)
      self.win.transiopt.setDisabled(image==None)
      self.win.DefTextBtImage.setDisabled(image==None)

      if image!=None:
        self.win.bgcolor.setText(str(image.bgcolor))
        color=toqcolor(QString(image.bgcolor).toInt(16)[0])
        qp=QPalette()
        qp.setColor(QPalette.Base,color)
        self.win.bgcolor.setPalette(qp)
        self.win.bgfile.setText(image.bgfile)
        self.win.speedt.setCurrentIndex(int(image.speedt))
        self.win.typet.setCurrentIndex(int(image.typet))
        self.win.transiopt.setCurrentIndex(int(image.opttransi))
      else:
        self.win.bgcolor.setText(str(self.ConfBgColor))
        color=toqcolor(QString(self.ConfBgColor).toInt(16)[0])
        qp=QPalette()
        qp.setColor(QPalette.Base,color)
        self.win.bgcolor.setPalette(qp)
        self.win.bgfile.setText(self.ConfBgFile)
        self.win.speedt.setCurrentIndex(int(self.ConfSpeedT))
        self.win.typet.setCurrentIndex(int(self.ConfTypeT))
        self.win.transiopt.setCurrentIndex(int(self.ConfTransiOpt))

      #----------------------------------------
      #Actions button
      #----------------------------------------
      self.win.actionMove_left.setDisabled(image==None or NbrImageItem<2 or self.index==0)
      self.win.actionMove_right.setDisabled(image==None or NbrImageItem<2 or self.index==NbrImageItem-1)
      self.win.actionRemove.setDisabled(self.index==-1)
      self.win.actionPreview.setDisabled(NbrImageItem==0)
      self.win.actionPreviewFrom.setDisabled(NbrImageItem==0)
      self.win.actionPreviewBt.setDisabled(NbrImageItem==0)
      self.win.actionPreviewFromBt.setDisabled(NbrImageItem==0)
      self.win.actionRender.setDisabled(NbrImageItem==0)
      self.win.actionRenderBt.setDisabled(NbrImageItem==0)
      self.win.actionCut.setDisabled(image==None)
      self.win.actionCopy.setDisabled(image==None)
      self.win.actionPaste.setDisabled(self.SEQClipboard==None)
      self.win.actionSave_as.setDisabled(NbrImageItem==0)
      self.win.ZoomDownBt.setDisabled(self.ThumbnailsSize==0)
      self.win.ZoomUpBt.setDisabled(self.ThumbnailsSize==2)
      
      #----------------------------------------
      #TAB Image
      #----------------------------------------
      if image!=None : DisableFlag=image.ObjectType==2
      else:            DisableFlag=True
      
      self.win.addZoomPoint.setDisabled(DisableFlag)
      self.win.ZoomPointXValue.setDisabled(ZoomPointItem==None)
      self.win.ZoomPointYValue.setDisabled(ZoomPointItem==None)
      self.win.ZoomPointZoomValue.setDisabled(ZoomPointItem==None)
      self.win.DefZoomPointBt.setDisabled(ZoomPointItem==None)
      self.win.DefTextBtZoomPoint.setDisabled(ZoomPointItem==None)
      self.win.ZoomPointTimeFixe.setDisabled(ZoomPointItem==None)

      if DisableFlag==False:
        self.win.moveZoomPointToLeft.setDisabled(self.win.TableZoomPoint.rowCount()<2 or self.win.TableZoomPoint.currentRow()==0)
        self.win.moveZoomPointToRight.setDisabled(self.win.TableZoomPoint.rowCount()<2 or self.win.TableZoomPoint.currentRow()==self.win.TableZoomPoint.rowCount()-1)
        self.win.removeZoomPoint.setDisabled(self.win.TableZoomPoint.rowCount()<2)
        self.win.EXIFTable.setDisabled(image.urlim=="")
        self.win.ImageFile.setDisabled(image.urlim=="")
        self.win.ImageFileBt.setDisabled(image.urlim=="")
        self.win.RotateLeftBT.setDisabled(image.urlim=="")
        self.win.RotateRightBT.setDisabled(image.urlim=="")
        self.win.CallGimpBT.setDisabled(image.urlim=="" or self.IsGIMPOk==False)
        self.win.RefreshImgBT.setDisabled(image.urlim=="")
      else :
        self.win.moveZoomPointToLeft.setDisabled(True)
        self.win.moveZoomPointToRight.setDisabled(True)
        self.win.removeZoomPoint.setDisabled(True)
        self.win.ImageFile.setText("")
        self.win.EXIFTable.setDisabled(True)
        self.win.ImageFile.setDisabled(True)
        self.win.ImageFileBt.setDisabled(True)
        self.win.RotateLeftBT.setDisabled(True)
        self.win.RotateRightBT.setDisabled(True)
        self.win.CallGimpBT.setDisabled(True)
        self.win.RefreshImgBT.setDisabled(True)

      if ZoomPointItem!=None : 
        #if an item is selected in TableZoomPoint
        ZoomPointItem.SetupInterface()
        self.win.ZoomPointTimeTravel.setDisabled(self.win.TableZoomPoint.currentRow()<=0)
        if self.win.TableZoomPoint.currentRow()<=0: self.win.ZoomPointTimeTravel.setValue(0)
      else :
        #if no item in TableZoomPoint
        self.win.ZoomPointTimeTravel.setDisabled(True)
        self.win.ZoomPointZoomValue.setValue(100)
        self.win.ZoomPointYValue.setValue(0)
        self.win.ZoomPointXValue.setValue(0)
        self.win.ZoomPointXLabel.setText("")
        self.win.ZoomPointYLabel.setText("")
        self.win.ZoomPointZoomLabel.setText("")
        self.win.ZoomPointTimeFixe.setValue(0)
        self.win.ZoomPointTimeTravel.setValue(0)

      if self.ConfDisplayUnit=="0":
        #Display unit in %
        self.win.ZoomPointXValue.setDecimals(2)
        self.win.ZoomPointYValue.setDecimals(2)
        self.win.ZoomPointZoomValue.setDecimals(2)
      else:
        #Display unit in pixel
        self.win.ZoomPointXValue.setDecimals(0)
        self.win.ZoomPointYValue.setDecimals(0)
        self.win.ZoomPointZoomValue.setDecimals(0)

      #----------------------------------------
      #TAB Movie
      #----------------------------------------
      if image!=None : 
        DisableFlag=image.ObjectType!=2
      else:
        DisableFlag=True
      
      self.win.MovieFile.setDisabled(DisableFlag)
      self.win.MovieFileBt.setDisabled(DisableFlag)
      self.win.RotateLeftMovieBT.setDisabled(DisableFlag)
      self.win.RotateRightMovieBT.setDisabled(DisableFlag)
      self.win.RefreshMovieBT.setDisabled(DisableFlag)
      
      #----------------------------------------
      #Other toolbar action
      #----------------------------------------
      #self.win.actionVideo_player.setDisabled(NbrImageItem==0)
      self.win.serie.setDisabled(NbrImageItem==0)
      self.App_DisplayLenght()
      self.StopSetupInterface = False

    #----------------------------------------------------------------------------------------
    # Function to calcul project duration and set it
    #----------------------------------------------------------------------------------------
    def App_DisplayLenght(self) :
      if self.TimeChanged==True:
        try:
          imgpsec=self.OutputOFDXMLObject.GetAllProperties(self.OFDDeviceType,self.OFDDeviceModel,self.OFDOutputCodec,self.imgformat,self.OFDOutputFormat)[1]
        except:
          imgpsec="25"

        imgpsec=int(imgpsec)
        if imgpsec==30 : ips=float(30000/1001)
        else :           ips=imgpsec

        self.totimage      = 0
        self.montageLenght = 0.0
        self.curimage      = 0
        StartSequence      = 0
        DurationSequence   = 0
        k=0
        while k<self.win.timeline.columnCount() :
          Image=self.win.timeline.cellWidget(0,k)
          if Image!=None:
            if Image.ObjectType!=2 :  StopShot=self.win.TableZoomPoint.currentRow()
            else :                    StopShot=0
            # Calc curimage position for current shot
            if k<self.win.timeline.currentColumn() : 
              self.curimage    = self.totimage+Image.CalcImageTime(imgpsec,StopShot)[1]
            if k<=self.win.timeline.currentColumn() :
              StartSequence    = self.totimage+Image.CalcImageTime(imgpsec,0)[1]   # For ruller
              DurationSequence = Image.CalcImageTime(imgpsec)[1]                   # For ruller
            if k==(self.win.timeline.columnCount()-1): self.totimage += Image.CalcImageTime(imgpsec)[1]
            else : self.totimage += Image.CalcImageTime(imgpsec)[1]-Image.CalcImageTime(imgpsec)[5]
          k+=1
        self.montageLenght = float(self.totimage)/ips
        self.win.duration.setText(frameToTime(self.curimage, ips)+"/"+frameToTime(self.totimage, ips))

        # Draw the ruller
        Duration=QTime(0,0,0,0).fromString(frameToTime(self.totimage,ips),"HH:mm:ss.zzz")
        Start   =QTime(0,0,0,0).fromString(frameToTime(StartSequence,ips),"HH:mm:ss.zzz")
        End     =QTime(0,0,0,0).fromString(frameToTime(StartSequence+DurationSequence,ips),"HH:mm:ss.zzz")
        if Start<>self.PrevStart or End<>self.PrevEnd or Duration<>self.PrevDuration:
          DrawMovieRuller(self.win.CustomWidget,Start,End,Duration) # Draw zone
          self.PrevStart   =Start
          self.PrevEnd     =End
          self.PrevDuration=Duration
        self.TimeChanged      = False

    #----------------------------------------------------------------------------------------
    # Function for set Window Title and Flag
    #----------------------------------------------------------------------------------------
    def App_WindowTitleAndFlag(self):
      if self.IsPortable :
        Title="Portable Videoporama (0.8.1) - "
      else :
        Title="Videoporama (0.8.1) - "

      if self.ProjectFilePathName=="":
        Title=Title+"<"+self.qtapp.translate("main","new file")+">"
      else:
        Title=Title+validatePath(self.ProjectFilePathName,False)
      Title=Title+"[*]"
      #if self.IsProjectModified: Title=Title+"*"
      self.win.setWindowTitle(Title)
      self.win.action_Save.setDisabled(self.IsProjectModified==False)
      self.win.setWindowModified(self.IsProjectModified)

    #----------------------------------------------------------------------------------------
    # Function for set Window Title and Flag
    #----------------------------------------------------------------------------------------
    def App_SetModifiedFlag(self):
      if self.IsProjectModified==False and self.StopUpdatePixDuringNewSelect==False:
        self.IsProjectModified=True
        self.App_WindowTitleAndFlag()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# Other toolbar action
#-----------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------
    # Preview process
    #----------------------------------------------------------------------------------------
    def App_Preview(self) :
      self.File_CreateXMLObject()               # ensure ProjectXMLObject is created and up to date
      showprog=RenderDlg(self,True,self.win)    # open dialog box
      showprog.show()                           # display dialog box
      self.WaitEvents()                         # be sure dialog box is display
      showprog.ProgressProcess()                # start process

    def App_PreviewFrom(self) :
      self.File_CreateXMLObject()               # ensure ProjectXMLObject is created and up to date
      showprog=RenderDlg(self,True,self.win)    # open dialog box
      showprog.show()                           # display dialog box
      self.WaitEvents()                         # be sure dialog box is display
      # Define a start sequence for preview
      showprog.StartRenderSequence = self.win.timeline.currentColumn()
      showprog.ProgressProcess()                # start process

    #----------------------------------------------------------------------------------------
    # Render process
    #----------------------------------------------------------------------------------------
    def App_DoRender(self) :
      self.File_CreateXMLObject()               # ensure ProjectXMLObject is created and up to date
      showprog=RenderDlg(self,False,self.win)   # open dialog box
      showprog.show()                           # display dialog box

    #----------------------------------------------------------------------------------------
    # start mplayer to view a file
    #----------------------------------------------------------------------------------------
    def App_MplayerView(self) :
      #--------------------------------------------- à faire : vérifier en anglais !
      self.mpview = Mplayer(self,taille=(400,300), choixWidget=(Mplayer.PAS_PRECEDENT_SUIVANT,Mplayer.CURSEUR_A_PART,Mplayer.PARCOURIR), cheminMPlayer=self.MP)
      self.mpview.setWindowTitle(self.qtapp.translate("main","Video Player"))
      self.mpview.show()

    #----------------------------------------------------------------------------------------
    # About Dialog box
    #----------------------------------------------------------------------------------------
    def App_About(self) :
      aboutw=About(self.win)
      aboutw.show()
      self.qtapp.connect(aboutw.closeabout,SIGNAL("clicked()"),aboutw,SLOT("close()"))

    #----------------------------------------------------------------------------------------
    # Documentation Dialog box
    #----------------------------------------------------------------------------------------
    def App_Documentation(self) :
      docw=DocHelp(self,self.qtapp.translate("Documentation","en-main.html"),self.win)
      docw.show() 

    def App_NewFunctions(self) :
      docw=DocHelp(self,self.qtapp.translate("Documentation","en-new.html"),self.win)
      docw.show() 

    #----------------------------------------------------------------------------------------
    # Serie dialog box and process
    #----------------------------------------------------------------------------------------
    def App_ProcessSerieDialog(self) :
      self.winserie=Lot(self.lstT,self,self.win)
      self.winserie.fromc.setMaximum(self.win.timeline.columnCount())
      self.winserie.toc.setMaximum(self.win.timeline.columnCount())
      self.winserie.show()
      self.qtapp.connect(self.winserie.buttonBox,SIGNAL("accepted()"),self.App_ProcessSerieDo)

    def App_ProcessSerieDo(self) :
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      #if user forget to add line : add current selection
      if self.winserie.tableImage.rowCount() == 0 : self.winserie.validLineA()
      #Process all line
      Cur=0
      while Cur < self.winserie.tableImage.rowCount() :
        option=self.winserie.tableImage.item(Cur,2).text().split(":")
        imF   =self.winserie.tableImage.item(Cur,0).text()
        imL   =self.winserie.tableImage.item(Cur,1).text()
        i=int(imF)-1
        while i <= (int(imL)-1) :
          if str(option[0].split("=")[0])=="1" :
            UpdateAttributXMLFile(self.win.timeline.cellWidget(0,i).ZoomPointList,u"Point-0",u"timeFixe",str(option[0].split("=")[1]),u"ZoomPointTable")
            if i==self.win.timeline.currentColumn(): self.win.TableZoomPoint.cellWidget(0,0).timeFixe=int(str(option[0].split("=")[1]))
          if str(option[1].split("=")[0])=="1" : self.win.timeline.cellWidget(0,i).bgfile   =str(option[1].split("=")[1])
          if str(option[2].split("=")[0])=="1" : self.win.timeline.cellWidget(0,i).bgcolor  =str(option[2].split("=")[1])
          if str(option[3].split("=")[0])=="1" : self.win.timeline.cellWidget(0,i).speedt   =unicode(option[3].split("=")[1])
          if str(option[4].split("=")[0])=="1" : 
            if int(option[4].split("=")[1])==self.winserie.RANDOMTRANSITIONTYPE:
              transi, optTransi = randomTransi()
              self.win.timeline.cellWidget(0,i).typet    =int(transi)
              self.win.timeline.cellWidget(0,i).opttransi=int(optTransi)
            else:
              self.win.timeline.cellWidget(0,i).typet    =int(option[4].split("=")[1])
              self.win.timeline.cellWidget(0,i).opttransi=int(option[5])
          #refresh image and timeline thumbnail
          self.win.timeline.cellWidget(0,i).ResetThumb()
          i+=1
        Cur+=1
      self.App_SetupInterface()
      self.App_DisplayLenght()
      self.App_SetModifiedFlag()
      self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
      self.qtapp.restoreOverrideCursor()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# Status_conf dialog box : Check configuration and display report
#-----------------------------------------------------------------------------------------------------------------------------------------------

    def check_CheckConfig(self,ConfigWindow=True,ForceHide=False):
      # init dialog box if need or if self.CheckCodecAtStartup not check
      if (ConfigWindow==True) or (ForceHide==False and self.CheckCodecAtStartup!="2"):
        ok=QIcon(QPixmap("icons/ok.png"))
        nok=QIcon(QPixmap("icons/nok.png"))
        self.statconf=StatusConf(self.win)
      else : self.statconf=None

      #Check Image Editor configuration
      if QFileInfo(QDir().toNativeSeparators(self.ImageEditor)).exists():
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,self.qtapp.translate("main","An Image Editor is correctly configured")))
        self.IsGIMPOk=True
      else :
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The Image Editor is not found, check the configuration")))
        self.IsGIMPOk=False

      #Check FFMpeg directory configuration
      if QDir(self.I).exists():
        if isWindows(): ToCheck=QDir().toNativeSeparators(self.I)+"ffmpeg.exe"
        else :          ToCheck=QDir().toNativeSeparators(self.I)+"ffmpeg"
        if QFileInfo(ToCheck).exists():
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,"FFmpeg"+self.qtapp.translate("main"," is correctly configured")))
        else:
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"FFmpeg : "+self.qtapp.translate("main","not found, check the configuration")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"FFmpeg "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))

      #Check ffmpeg abilities
      self.fmsg = 0
      self.msgffmpeg = QStringList()
      self.listformats = QStringList()
      self.convertformat = []

      if isWindows() :
        commande = u"\""+unicode(self.I)+u"ffmpeg.exe\" -formats"
        f = subprocess.Popen(commande.encode('iso-8859-1'), shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
      else:
        f = subprocess.Popen(validateCommande(self.I+"ffmpeg")+' -formats', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
      FormatToTest=[
        #Video codec test
        ["RAW DV (dv)","dv"],
        ["MPEG1","mpeg1video"],
        ["MPEG2","mpeg2video"],
        ["Flash","flv"],
        ["Theora","libtheora"],
        ["MJPEG","mjpeg"],
        ["Xvid","libxvid"],
        ["H264","libx264"],
        ["WebM (VP8)","libvpx"],
        #Audiocodec test
        ["libfaac AAC (Advanced Audio Codec)","libfaac"],
        ["ADTS AAC (Advanced Audio Codec)","adts"],
        ["libmp3lame MP3 (MPEG audio layer 3)","libmp3lame"],
        ["libvorbis Vorbis","libvorbis"],
        ["Dolby Digital (AC-3)","ac3"],
        ["PCM signed 16-bit little-endian","s16le"],
        
        #File format test
        ["MPEG file format","mpeg"],
        ["MOV file format","mov"],
        ["DV file format","dv"],
        ["AVI file format","avi"],
        ["FLV file format","flv"],
        ["MKV file format","matroska"],
        ["3GP file format","3gp"],
        ["WEBM file format","webm"],
        ["MP4 file format","mp4"]
      ]

      #search all format
      self.AACMode=""
      verffmpeg = f.communicate()[0]
      for ff in FormatToTest :
        if verffmpeg.find(ff[1]) == -1 :  #if format is not found
          self.fmsg = 1
          #add-it to the projet combobox
          if ff[1]!="libfaac" and ff[1]!="adts" and self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The ffmpeg package installed don't include %1 and isn't able to encode in %2. This format will be disable in the user interface.").arg(QString(ff[1])).arg(QString(ff[0]))))

        else :  #if format is found
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,self.qtapp.translate("main","The ffmpeg package is able to encode in %1.").arg(QString(ff[0]))))
          if ff[1]=="libfaac" : self.AACMode="libfaac"
          self.listformats.append(ff[1])

      #Check SoX
      if QDir(self.S).exists():
        if isWindows(): ToCheck=QDir().toNativeSeparators(self.S)+"sox.exe"
        else :          ToCheck=QDir().toNativeSeparators(self.S)+"sox"
        if QFileInfo(ToCheck).exists():
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,"SoX"+self.qtapp.translate("main"," is correctly configured")))
          #Check sox abilities
          try:
            if isWindows() :
              commande = u"\""+unicode(self.S)+u"sox.exe\" -h"
              s = subprocess.Popen(commande.encode('iso-8859-1'), shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0]
            else :
              s = subprocess.Popen(validateCommande(unicode(self.S+"sox"))+u" -h", shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0]
            self.msgsox = [u"",u"",u""]
            if s.find("wav") == -1 :
              if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","Wav Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to make video.")))
            if s.find("ogg") == -1 :
              if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","Ogg Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to use ogg sound file.")))
            if s.find("mp3") == -1 :
              if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","Mp3 Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to use mp3 sound file.")))
          except:
            None
        else:
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"SoX : "+self.qtapp.translate("main","not found, check the configuration")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"SoX "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))

      #Check MJpegTools
      if QDir(self.MJ).exists():
        if isWindows(): ToCheck=QDir().toNativeSeparators(self.MJ)+"ppmtoy4m.exe"
        else :          ToCheck=QDir().toNativeSeparators(self.MJ)+"ppmtoy4m"
        if QFileInfo(ToCheck).exists():
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,"MJpegTools"+self.qtapp.translate("main"," is correctly configured")))
        else:
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"MJpegTools : "+self.qtapp.translate("main","not found, check the configuration")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"MJpegTools "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))

      #Check MPlayer
      if QDir(self.MP).exists():
        if isWindows(): ToCheck=QDir().toNativeSeparators(self.MP)+"mplayer.exe"
        else :          ToCheck=QDir().toNativeSeparators(self.MP)+"mplayer"
        if QFileInfo(ToCheck).exists():
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,"MPlayer"+self.qtapp.translate("main"," is correctly configured")))
        else:
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"MPlayer : "+self.qtapp.translate("main","not found, check the configuration")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"MPlayer "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))

      #Check tempdir
      if QDir(self.T).exists():
        if IsPathWritable(self.T) :
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,self.qtapp.translate("main","The temporary directory is writable")))
        else :
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The temporary directory is not writable")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The temporary directory is not define, check the configuration")))

      if self.statconf!=None: 
        c=int(self.CheckCodecAtStartup)
        self.statconf.chk.setChecked(bool(c))
        self.qtapp.connect(self.statconf.closew,SIGNAL("clicked()"),self.statconf,SLOT("close()"))
        self.statconf.connect(self.statconf.chk,SIGNAL("stateChanged(int)"),self.check_ChgDisplayAtStartup)
        self.statconf.show()

    #Handler for the checkbox "Don't display at startup"
    def check_ChgDisplayAtStartup(self,state):
      self.CheckCodecAtStartup=str(state)
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"CheckCodecAtStartup",str(state))

#-----------------------------------------------------------------------------------------------------------------------------------------------
# File manipulation functions
#-----------------------------------------------------------------------------------------------------------------------------------------------

    #----------------------------------------------------------------------------------------
    # Create a new Project (to xml file) function
    #----------------------------------------------------------------------------------------
    def File_NewProject(self):
      #Ask to save project before continuing if current project not save
      if self.IsProjectModified:
        reply = QtGui.QMessageBox.question(self.win, self.qtapp.translate("main","New project"),
          self.qtapp.translate("main","Current project was modified.\nSave it now before continuing ?"),
          QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply==QtGui.QMessageBox.Yes: self.File_SaveProject()
    
      #Clean
      self.Timeline_Empty()
      
      #Setup default value
      self.imgformat            = int(self.ConfImgFormat)           #Project image format
      self.OFDDeviceType        = self.ConfOFDDeviceType            #
      self.OFDDeviceModel       = self.ConfOFDDeviceModel           #
      self.OFDOutputCodec       = self.ConfOFDOutputCodec           #
      self.OFDOutputFormat      = self.ConfOFDOutputFormat          #
      self.ProjectFilePathName  = ""                                #PathName of the project file
      self.ProjectXMLObject     = None                              #Document object of the project file
      self.IsProjectModified    = False                             #Flag for known if project file need to be save
      #self.soundfile            = ""                                #Project sound file
      self.outputFile           = ""                                #Project output file
      self.XMLText              = None                              #Overlaid text
      self.File_CreateXMLObject()
      self.App_DisplayLenght()
      self.App_SetupInterface()

    #----------------------------------------------------------------------------------------
    # open an existing project (from xml file) function
    #----------------------------------------------------------------------------------------
    def File_OpenProject(self):
      #Ask to save project before continuing if current project not save
      if self.IsProjectModified:
        reply = QtGui.QMessageBox.question(self.win, self.qtapp.translate("main","Open project"),
          self.qtapp.translate("main","Current project was modified.\nSave it now before continuing ?"),
          QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply==QtGui.QMessageBox.Yes: self.File_SaveProject()

      #Select a file
      try :
        FileName=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","Open project"),self.lastDirProject, QString("*.idv (*.idv)"))
        self.WaitEvents() #Pour laisser le temps à la fenêtre de se fermer !
        if FileName!="":
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          self.lastDirProject=QFileInfo(unicode(FileName)).dir().absolutePath()

          #Clean
          self.Timeline_Empty()

          self.ProjectFilePathName=validatePath(FileName,False)
          #Import configurations data from xml file
          Err=0
          File=QFile(self.ProjectFilePathName)
          if File.open(QIODevice.ReadOnly | QIODevice.Text) :
            try:
              self.ProjectXMLObject=minidom.parse(File)
              File.close()
              #Make object from XML data
              self.File_MakeFromXML()
            except : Err=1
          else : Err=1
          if Err==1 : QtGui.QMessageBox.critical(self.win,self.qtapp.translate("main","Open project"),self.qtapp.translate("main","Error loading file"),QtGui.QMessageBox.Ok)
        self.App_SetupInterface()
        self.qtapp.restoreOverrideCursor()
      except :
        None

    #----------------------------------------------------------------------------------------
    # Add an existing project (from xml file) add the end of this project function
    #----------------------------------------------------------------------------------------
    def File_AddProject(self):
      #Select a file
      try :
        FileName=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","Add an existing project"),self.lastDirProject, QString("*.idv (*.idv)"))
        self.WaitEvents() #Pour laisser le temps à la fenêtre de se fermer !
        if FileName!="":
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          self.lastDirProject=QFileInfo(unicode(FileName)).dir().absolutePath()

          self.ProjectFilePathName=validatePath(FileName,False)
          #Import configurations data from xml file
          Err=0
          File=QFile(self.ProjectFilePathName)
          if File.open(QIODevice.ReadOnly | QIODevice.Text) :
            try:
              AddXMLObject=minidom.parse(File)
              File.close()
              #Make object from XML data
              self.File_MakeFromXMLObject(AddXMLObject)
            except : Err=1
          else : Err=1
          if Err==1 : QtGui.QMessageBox.critical(self.win,self.qtapp.translate("main","Add an existing project"),self.qtapp.translate("main","Error loading file"),QtGui.QMessageBox.Ok)
        self.TimeChanged =True
        self.App_SetupInterface()
        self.IsProjectModified=True
        self.App_WindowTitleAndFlag()
        self.qtapp.restoreOverrideCursor()
      except :
        None

    #----------------------------------------------------------------------------------------
    # Save project to file asking for filename (to xml file) function
    #----------------------------------------------------------------------------------------
    def File_SaveAsProject(self):
      #Get a new filename
      FileName=QFileDialog.getSaveFileName(self.win,self.qtapp.translate("main","Save project"),self.lastDirProject, QString("*.idv (*.idv)"))
      if FileName!="":
        self.lastDirProject=QFileInfo(FileName).dir().absolutePath()
        self.ProjectFilePathName=self.lastDirProject
        if self.ProjectFilePathName.endsWith(QDir().separator().toAscii())!=True : self.ProjectFilePathName=self.ProjectFilePathName+QDir().separator().toAscii()
        self.ProjectFilePathName=self.ProjectFilePathName+QFileInfo(FileName).baseName()+u".idv"
        #ensure ProjectXMLObject is created
        self.File_CreateXMLObject()
        #write xml to file
        Err=0
        File=QFile(self.ProjectFilePathName)
        if File.open(QIODevice.WriteOnly | QIODevice.Text) :
          try:
            File.write(self.ProjectXMLObject.toxml('utf-8'))
            File.close()
            self.IsProjectModified=False
            self.App_WindowTitleAndFlag()
          except : Err=1
        else : Err=1
        if Err==1 : QtGui.QMessageBox.critical(self.win,self.qtapp.translate("main","Save project"),self.qtapp.translate("main","Error writing file"),QtGui.QMessageBox.Ok)

    #----------------------------------------------------------------------------------------
    # saveProject (to xml file) function
    #----------------------------------------------------------------------------------------
    def File_SaveProject(self):
      #if no filename transfert to Save As function
      if self.ProjectFilePathName=="":
        self.File_SaveAsProject()
      else:
        #ensure ProjectXMLObject is created
        self.File_CreateXMLObject()
        #write xml to file
        Err=0
        File=QFile(self.ProjectFilePathName)
        if File.open(QIODevice.WriteOnly | QIODevice.Text) :
          try:
            File.write(self.ProjectXMLObject.toprettyxml(encoding='utf-8'))
#            File.write(self.ProjectXMLObject.toxml('utf-8'))
            File.close()
            self.IsProjectModified=False
            self.App_WindowTitleAndFlag()
          except : Err=1
        else : Err=1
        if Err==1 : QtGui.QMessageBox.critical(self.win,self.qtapp.translate("main","Save project"),self.qtapp.translate("main","Error writing file"),QtGui.QMessageBox.Ok)

    #----------------------------------------------------------------------------------------
    # Create XMLObject from objects
    #----------------------------------------------------------------------------------------
    def File_CreateXMLObject(self):
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      soundTag=None
      if self.SoundDef == None :
        try:
          xmlPoint=self.ProjectXMLObject.getElementsByTagName(u"Videoporama")[0]
          TheSound = xmlPoint.getElementsByTagName(u"sound")
          if TheSound.length>0:
            soundTag=self.ProjectXMLObject.importNode(TheSound[0],True)
        except:
          soundTag=None
      self.ProjectXMLObject = Document()
      xmltag = self.ProjectXMLObject.createElement(u"Videoporama")
      self.ProjectXMLObject.appendChild(xmltag)

      UpdateConfigurationXMLFile(self.ProjectXMLObject,u"outputfile",MakeRelatif(self.ProjectFilePathName,self.outputFile),u"Videoporama")
      #UpdateConfigurationXMLFile(self.ProjectXMLObject,u"sndfile",MakeRelatif(self.ProjectFilePathName,self.soundfile),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,u"imgformat",str(self.imgformat),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,'OFDDeviceType',str(self.OFDDeviceType),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,'OFDDeviceModel',str(self.OFDDeviceModel),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,'OFDOutputCodec',str(self.OFDOutputCodec),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,'OFDOutputFormat',str(self.OFDOutputFormat),u"Videoporama")

      if self.SoundDef == None :
        if soundTag!=None : xmltag.appendChild(soundTag)
      else:
        soundTag = self.ProjectXMLObject.createElement(u"sound")
        mainTag = self.ProjectXMLObject.createElement(u"mainTrack")
        commentTag = self.ProjectXMLObject.createElement(u"commentTrack")
        for sound in self.SoundDef[0] :
          sndTag = self.ProjectXMLObject.createElement(u"soundObject")
          sndTag.setAttribute(u'track',unicode(sound[0]))
          sndTag.setAttribute(u'urlFile',MakeRelatif(self.ProjectFilePathName, unicode(sound[1])))
          sndTag.setAttribute(u'TstartV',unicode(sound[2]))
          sndTag.setAttribute(u'TendV',unicode(sound[3]))
          sndTag.setAttribute(u'silence',unicode(sound[4]))
          sndTag.setAttribute(u'silenceD',unicode(sound[5]))
          sndTag.setAttribute(u'gain',unicode(sound[6]))
          sndTag.setAttribute(u'fadein',unicode(sound[7]))
          sndTag.setAttribute(u'fadeout',unicode(sound[8]))
          mainTag.appendChild(sndTag)

        for sound in self.SoundDef[1] :
          sndTag = self.ProjectXMLObject.createElement(u"soundObject")
          sndTag.setAttribute(u'track',unicode(sound[0]))
          sndTag.setAttribute(u'urlFile',MakeRelatif(self.ProjectFilePathName, unicode(sound[1])))
          sndTag.setAttribute(u'TstartV',unicode(sound[2]))
          sndTag.setAttribute(u'TendV',unicode(sound[3]))
          sndTag.setAttribute(u'silence',unicode(sound[4]))
          sndTag.setAttribute(u'silenceD',unicode(sound[5]))
          sndTag.setAttribute(u'gain',unicode(sound[6]))
          sndTag.setAttribute(u'fadein',unicode(sound[7]))
          sndTag.setAttribute(u'fadeout',unicode(sound[8]))
          commentTag.appendChild(sndTag)

        soundTag.appendChild(mainTag)
        soundTag.appendChild(commentTag)
        xmltag.appendChild(soundTag)
        
      #Transfert overlaid text to XMLFile
      if self.XMLText!=None:
        xmlText=self.XMLText.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText=xmlText[0]
          TextToAdd=self.XMLText.importNode(xmlText,True)
          xmltag.appendChild(TextToAdd)

      nitem=self.win.timeline.columnCount()
      i=0
      while i<nitem :
        QCoreApplication.processEvents()
        #Project options
        Image=self.win.timeline.cellWidget(0,i)
        doc=Document()
        xmlchild=doc.createElement("IMG-"+str(i))
        xmlchild.setAttribute('ObjectType',str(Image.ObjectType))
        xmlchild.setAttribute('transition',str(Image.typet))
        xmlchild.setAttribute('tr_option',str(Image.opttransi))
        xmlchild.setAttribute('speedt',str(Image.speedt))
        xmlchild.setAttribute('bgcolor',str(Image.bgcolor))
        xmlchild.setAttribute('bgfile',MakeRelatif(self.ProjectFilePathName,Image.bgfile))
        xmlchild.setAttribute('urlimage',MakeRelatif(self.ProjectFilePathName,Image.urlim))
        xmlchild.setAttribute('EXIF_Orientation',str(Image.EXIF_Orientation))
        xmlchild.setAttribute('EndVideo',unicode(Image.EndVideo.toString("HH:mm:ss.zzz")))
        xmlchild.setAttribute('StartVideo',unicode(Image.StartVideo.toString("HH:mm:ss.zzz")))

        item=self.win.timeline.cellWidget(0,i)
        
        #Transfert image text to XMLFile
        if item.XMLText!=None:
          xmlText=item.XMLText.getElementsByTagName(u"Text")
          if xmlText.length>0 :
            xmlText=xmlText[0]
            TextToAdd=item.XMLText.importNode(xmlText,True)
            xmlchild.appendChild(TextToAdd)

        #Transfert XML ZoomPointList of each item to XMLFile
        j=0
        x=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+str(j),u"x",u"ZoomPointTable")
        while x!="":
          QCoreApplication.processEvents()
          y=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+str(j),u"y",u"ZoomPointTable")
          zoom=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+str(j),u"zoom",u"ZoomPointTable")
          timeFixe=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+str(j),u"timeFixe",u"ZoomPointTable")
          timeToTravel=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+str(j),u"timeToTravel",u"ZoomPointTable")
          
          #add zoompoint to xml
          doc=Document()
          xmlSubChild=doc.createElement('Point-'+str(j))
          xmlSubChild.setAttribute('x',str(x))
          xmlSubChild.setAttribute('y',str(y))
          xmlSubChild.setAttribute('zoom',str(zoom))
          xmlSubChild.setAttribute('timeFixe',str(timeFixe))
          xmlSubChild.setAttribute('timeToTravel',str(timeToTravel))
          
          # Transfert ZoompointText item(s)
          xmlDocItem=item.ZoomPointList.getElementsByTagName(u"Point-"+str(j))[0]
          xmlDoc=xmlDocItem.getElementsByTagName(u"Text")
          if xmlDoc.length>0 :  # If text exist
            xmlDoc=xmlDoc[0]
            xmlText=xmlDocItem.getElementsByTagName(u"Text")
            if xmlText.length>0 :
              xmlText=xmlText[0]
              TextToAdd=item.ZoomPointList.importNode(xmlDoc,True)
              xmlSubChild.appendChild(TextToAdd)

          xmlchild.appendChild(xmlSubChild)

          j+=1
          x=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+str(j),u"x",u"ZoomPointTable")
        #==> End of ZoomPointList table
        xmltag.appendChild(xmlchild)
        i+=1
      #==> End of img table
      self.qtapp.restoreOverrideCursor()

    #----------------------------------------------------------------------------------------
    # Read data from ProjectXMLObject and create all object
    #----------------------------------------------------------------------------------------
    def File_MakeFromXML(self,ForceNewImageFormat=False,ForceNewVideoFormat=False): #OK QT4
      #init new project with XML file
      if ForceNewImageFormat==False: self.imgformat = int(LoadValueFromXMLFile(self.ProjectXMLObject,'imgformat',self.ConfImgFormat,u"Videoporama"))
      self.outputFile     = MakeAbsolut(self.ProjectFilePathName,LoadValueFromXMLFile(self.ProjectXMLObject,'outputfile',"",u"Videoporama"))
      #self.soundfile      = MakeAbsolut(self.ProjectFilePathName,LoadValueFromXMLFile(self.ProjectXMLObject,'sndfile',"",u"Videoporama"))
      self.OFDDeviceType  = LoadValueFromXMLFile(self.ProjectXMLObject,'OFDDeviceType',"",u"Videoporama")
      self.OFDDeviceModel = LoadValueFromXMLFile(self.ProjectXMLObject,'OFDDeviceModel',"",u"Videoporama")
      self.OFDOutputCodec = LoadValueFromXMLFile(self.ProjectXMLObject,'OFDOutputCodec',"",u"Videoporama")
      self.OFDOutputFormat= LoadValueFromXMLFile(self.ProjectXMLObject,'OFDOutputFormat',"",u"Videoporama")

      #Search if the project have overlaid text
      xmlPoint=self.ProjectXMLObject.getElementsByTagName(u"Videoporama")[0]
      xmlText =xmlPoint.getElementsByTagName(u"Text")
      if xmlText.length>0 :
        xmlText=xmlText[0]
        # Be sure this child is type Overlaid (and not type image or Zoompoint)
        if xmlText.getAttribute(u"Type")=="Overlaid":
          self.XMLText=Document()
          xmlRoot=self.XMLText.createElement(u"SaveXML")
          self.XMLText.appendChild(xmlRoot)
          xmlRoot.appendChild(self.ProjectXMLObject.importNode(xmlText,True))
      else :
        self.XMLText=None

      self.File_MakeFromXMLObject(self.ProjectXMLObject)
      self.App_DisplayLenght()
      self.App_SetupInterface()

    def File_MakeFromXMLObject(self,BufXMLObject):
      # load images
      k=0
      NameItem="IMG-"+str(k)
      transition=LoadAttributFromXMLFile(BufXMLObject,NameItem,'transition',u"Videoporama")
      while transition!="":
        QCoreApplication.processEvents()
        #stop update during this process
        self.StopUpdatePixDuringNewSelect=True

        #create the thumb/image
        try:
          ObjectType=int(LoadAttributFromXMLFile(BufXMLObject,NameItem,'ObjectType',u"Videoporama"))
        except:
          ObjectType=0

        col=self.win.timeline.columnCount()
        Image=myLabel(
          MakeAbsolut(self.ProjectFilePathName,LoadAttributFromXMLFile(BufXMLObject,NameItem,'urlimage',u"Videoporama")),#urlim = Filename
          MakeAbsolut(self.ProjectFilePathName,LoadAttributFromXMLFile(BufXMLObject,NameItem,'bgfile',u"Videoporama")),  #background file
          LoadAttributFromXMLFile(BufXMLObject,NameItem,'bgcolor',u"Videoporama"),          #background color
          LoadAttributFromXMLFile(BufXMLObject,NameItem,'transition',u"Videoporama"),       #transition type
          LoadAttributFromXMLFile(BufXMLObject,NameItem,'tr_option',u"Videoporama"),        #transition option
          LoadAttributFromXMLFile(BufXMLObject,NameItem,'speedt',u"Videoporama"),           #transition duration
          LoadAttributFromXMLFile(BufXMLObject,NameItem,'EXIF_Orientation',u"Videoporama"), #image orientation
          self,                                                                                      #Videoporama class instance
          ObjectType                                                                                 #ObjectType
        )
        QCoreApplication.processEvents()
        Image.EndVideo  =QTime(0,0,0).fromString(LoadAttributFromXMLFile(BufXMLObject,NameItem,'EndVideo',u"Videoporama"),"HH:mm:ss.zzz")
        Image.StartVideo=QTime(0,0,0).fromString(LoadAttributFromXMLFile(BufXMLObject,NameItem,'StartVideo',u"Videoporama"),"HH:mm:ss.zzz")
        Image.DurationVideo=QTime(0,0,0).addMSecs(Image.StartVideo.msecsTo(Image.EndVideo))
        #if ObjectType==2: Image.LoadMovieInfo()

        #Search if the image have text
        xmlPoint=BufXMLObject.getElementsByTagName(NameItem)[0]
        xmlText =xmlPoint.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText=xmlText[0]
          # Be sure this child is type image (and not type Zoompoint)
          if xmlText.getAttribute(u"Type")=="Image":
            Image.XMLText=Document()
            xmlRoot=Image.XMLText.createElement(u"SaveXML")
            Image.XMLText.appendChild(xmlRoot)
            xmlRoot.appendChild(BufXMLObject.importNode(xmlText,True))

        self.win.timeline.insertColumn(col)
        hpix=self.win.timeline.height()-18
        if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
        else :            wpix=(hpix-4)*4/3+34
        self.win.timeline.setColumnWidth(col,wpix)
        self.win.timeline.setCellWidget(0,col,Image)

        #Load ZoomPoint
        i=0
        x=LoadAttributSubFromXMLFile(BufXMLObject,NameItem,'Point-'+str(i),'x')
        while x!="":
          QCoreApplication.processEvents()
          y=LoadAttributSubFromXMLFile(BufXMLObject,NameItem,'Point-'+str(i),'y')
          zoom=LoadAttributSubFromXMLFile(BufXMLObject,NameItem,'Point-'+str(i),'zoom')
          timeFixe=LoadAttributSubFromXMLFile(BufXMLObject,NameItem,'Point-'+str(i),'timeFixe')
          timeToTravel=LoadAttributSubFromXMLFile(BufXMLObject,NameItem,'Point-'+str(i),'timeToTravel')
          xmlSourceImage=BufXMLObject.getElementsByTagName(NameItem)[0]
          xmlSourcePoint=xmlSourceImage.getElementsByTagName('Point-'+str(i))[0]
          xmlText=xmlSourcePoint.getElementsByTagName(u"Text")
          if xmlText.length>0 :
            xmlText =xmlText[0]
            TextToAdd=BufXMLObject.importNode(xmlText,True)
          else:
            TextToAdd=None

          #Temp : Compatibility with old file
          if timeFixe=="": 
            timeFixe=LoadAttributFromXMLFile(BufXMLObject,NameItem,'time',u"Videoporama")
            timeToTravel=0

          Image.AddZoomPointItem(float(x),float(y),float(timeFixe),float(zoom),float(timeToTravel),False,False,TextToAdd)
          i+=1
          x=LoadAttributSubFromXMLFile(BufXMLObject,NameItem,'Point-'+str(i),'x')

        #Generate thumbail for this image
        Image.updatePix()
        QCoreApplication.processEvents()
        #Force Display new thumbnail
        self.win.timeline.repaint()
        #update now available
        self.StopUpdatePixDuringNewSelect=False
        k+=1
        NameItem=u"IMG-"+str(k)
        transition=LoadAttributFromXMLFile(BufXMLObject,NameItem,'transition',u"Videoporama")

#-----------------------------------------------------------------------------------------------------------------------------------------------
# Configuration dialog box
#-----------------------------------------------------------------------------------------------------------------------------------------------

    def App_Configuration(self,ForceOnglet=False) : #OK QT4
      self.winconfig=ConfigurationDlg(self,self.win)
      if ForceOnglet==True:
        self.winconfig.tabWidget.setCurrentIndex(2)
      self.winconfig.show()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# TAB Image
#-----------------------------------------------------------------------------------------------------------------------------------------------

    #Function call each time a user enter a new value for background color
    def SEQ_ChgBgColor(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        BgColor=self.win.bgcolor.text()
        color=toqcolor(QString(BgColor).toInt(16)[0])
        qp=QPalette()
        qp.setColor(QPalette.Base,color)
        self.win.bgcolor.setPalette(qp)
        red=color.red()
        green=color.green()
        blue=color.blue()
        xcolor=colortohex(red*65536+green*256+blue)
        self.win.timeline.cellWidget(0,self.index).bgcolor=xcolor
        self.win.BgColor=xcolor
        self.win.timeline.cellWidget(0,self.index).ResetThumb()
        self.App_SetupInterface()
        self.App_SetModifiedFlag()
        self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
        self.qtapp.restoreOverrideCursor()

    #Functions for Cut/Copy and Paste
    def SEQ_Cut(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        CurrentSEQ=self.win.timeline.cellWidget(0,self.index)
        self.SEQClipboard=CurrentSEQ.ExportSequenceToXML()
        self.Timeline_DeleteItem()
        self.qtapp.restoreOverrideCursor()

    def SEQ_Copy(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        CurrentSEQ=self.win.timeline.cellWidget(0,self.index)
        self.SEQClipboard=CurrentSEQ.ExportSequenceToXML()
        self.App_SetupInterface()
        self.qtapp.restoreOverrideCursor()

    def SEQ_Paste(self):
      if self.SEQClipboard ==None : return
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))

      NameItem="Sequence"
      
      #stop update during this process
      self.StopUpdatePixDuringNewSelect=True

      #create the thumb/image
      #col=self.win.timeline.columnCount()   ## For the paste function, col is always after the current item
      col=self.win.timeline.currentColumn()+1
      try:
        ObjectType=int(LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'ObjectType',u"SaveXML"))
      except:
        ObjectType=0

      Image=myLabel(
        LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'urlimage',u"SaveXML"),         #urlim = Filename
        LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'bgfile',u"SaveXML"),           #background file
        LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'bgcolor',u"SaveXML"),          #background color
        LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'transition',u"SaveXML"),       #transition type
        LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'tr_option',u"SaveXML"),        #transition option
        LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'speedt',u"SaveXML"),           #transition duration
        LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'EXIF_Orientation',u"SaveXML"), #image orientation
        self,                                                                              #Videoporama class instance
        ObjectType
      )
      Image.EndVideo  =QTime(0,0,0).fromString(LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'EndVideo',u"SaveXML"),"HH:mm:ss.zzz")
      Image.StartVideo=QTime(0,0,0).fromString(LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'StartVideo',u"SaveXML"),"HH:mm:ss.zzz")
      Image.DurationVideo=QTime(0,0,0).addMSecs(Image.StartVideo.msecsTo(Image.EndVideo))

      #Search if the image have text
      xmlPoint=self.SEQClipboard.getElementsByTagName(NameItem)[0]
      xmlText =xmlPoint.getElementsByTagName(u"Text")
      if xmlText.length>0 :
        xmlText=xmlText[0]
        # Be sure this child is type image (and not type Zoompoint)
        if xmlText.getAttribute(u"Type")=="Image":
          Image.XMLText=Document()
          xmlRoot=Image.XMLText.createElement(u"SaveXML")
          Image.XMLText.appendChild(xmlRoot)
          xmlRoot.appendChild(self.SEQClipboard.importNode(xmlText,True))

      self.win.timeline.insertColumn(col)
      hpix=self.win.timeline.height()-18
      if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
      else :            wpix=(hpix-4)*4/3+34
      self.win.timeline.setColumnWidth(col,wpix)
      self.win.timeline.setCellWidget(0,col,Image)

      #Load ZoomPoint
      i=0
      x=LoadAttributSubFromXMLFile(self.SEQClipboard,NameItem,'Point-'+str(i),'x',u"SaveXML")
      while x!="":
        y=LoadAttributSubFromXMLFile(self.SEQClipboard,NameItem,'Point-'+str(i),'y',u"SaveXML")
        zoom=LoadAttributSubFromXMLFile(self.SEQClipboard,NameItem,'Point-'+str(i),'zoom',u"SaveXML")
        timeFixe=LoadAttributSubFromXMLFile(self.SEQClipboard,NameItem,'Point-'+str(i),'timeFixe',u"SaveXML")
        timeToTravel=LoadAttributSubFromXMLFile(self.SEQClipboard,NameItem,'Point-'+str(i),'timeToTravel',u"SaveXML")
        xmlSourceImage=self.SEQClipboard.getElementsByTagName(NameItem)[0]
        xmlSourcePoint=xmlSourceImage.getElementsByTagName('Point-'+str(i))[0]
        xmlText=xmlSourcePoint.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText =xmlText[0]
          TextToAdd=self.SEQClipboard.importNode(xmlText,True)
        else:
          TextToAdd=None

        #Temp : Compatibility with old file
        if timeFixe=="": 
          timeFixe=LoadAttributFromXMLFile(self.SEQClipboard,NameItem,'time',u"SaveXML")
          timeToTravel=0

        Image.AddZoomPointItem(float(x),float(y),float(timeFixe),float(zoom),float(timeToTravel),False,False,TextToAdd)
        i+=1
        x=LoadAttributSubFromXMLFile(self.SEQClipboard,NameItem,'Point-'+str(i),'x',u"SaveXML")

      #Generate thumbail for this image
      Image.updatePix()
      #Force Display new thumbnail
      self.win.timeline.repaint()
      #update now available
      self.StopUpdatePixDuringNewSelect=False
      #display the thumb/image
      Image.updatePix()

      self.App_DisplayLenght()
      self.App_SetModifiedFlag()
      self.win.timeline.setCurrentCell(0,col)
      self.qtapp.restoreOverrideCursor()

    #Function call each time browse palette to select a background color
    def SEQ_BrowseBgColor(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        color=QColorDialog.getColor(toqcolor(QString(self.win.timeline.cellWidget(0,self.index).bgcolor).toInt(16)[0]),self.win)
        red=color.red()
        green=color.green()
        blue=color.blue()
        xcolor=colortohex(red*65536+green*256+blue)
        self.win.timeline.cellWidget(0,self.index).bgcolor=xcolor
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          self.win.timeline.cellWidget(0,self.index).ResetThumb()
          self.App_SetupInterface()
          self.App_SetModifiedFlag()
          self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
          self.qtapp.restoreOverrideCursor()

    #Function call each time a user enter a new value for background file
    def SEQ_ChgBgFile(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.win.timeline.cellWidget(0,self.index).bgfile=unicode(self.win.bgfile.text())
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          self.win.timeline.cellWidget(0,self.index).ResetThumb()
          self.App_SetupInterface()
          self.App_SetModifiedFlag()
          self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
          self.qtapp.restoreOverrideCursor()

    #Function call each time browse file to select a background file
    def SEQ_BrowseBgFile(self):
      file=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","File Dialog"),self.lastDirBackground, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
      if file!="":
        self.win.bgfile.setText(file)
        self.lastDirBackground=QFileInfo(file).dir().absolutePath()
        self.SEQ_ChgBgFile()
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          self.win.timeline.cellWidget(0,self.index).ResetThumb()
          self.App_SetupInterface()
          self.App_SetModifiedFlag()
          self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
          self.qtapp.restoreOverrideCursor()

    #Function call each time option-transition choice is change
    def SEQ_ChgOptTr(self,newopttransi):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() and newopttransi!=-1 :
        if (self.StopUpdatePixDuringNewSelect!=True):
          image=self.win.timeline.cellWidget(0,self.index)
          if image!=None:
            image.opttransi=newopttransi
            image.updatePix()
          #self.App_SetupInterface()
          self.App_SetModifiedFlag()

    #Function call each time image duration change
    def SEQ_ChgTime(self,val):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.win.timeline.cellWidget(0,self.index).time=val
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.win.timeline.cellWidget(0,self.index).updatePix()
          self.App_SetupInterface()
          self.App_SetModifiedFlag()
          self.App_DisplayLenght()

    #Function call each time transition choice is change
    def SEQ_ChgTrOption(self,NewTransi) :
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        z=getTrOptionLst(self,NewTransi)
        self.win.transiopt.clear()
        i=0;
        max=len(z)
        while i<max:
          if NewTransi==7:
            FNameTr=u"iconstr/"+z[i]+u".png"
          else:
            FNameTr=u"iconstr/tr-0"+unicode(NewTransi)+u"-0"+unicode(i)+u".png"
          try:
            self.win.transiopt.addItem(QIcon(FNameTr),z[i])
          except:
            self.win.transiopt.addItem(z[i])
          i=i+1
        try:
          if (self.StopUpdatePixDuringNewSelect!=True):
            self.win.timeline.cellWidget(0,self.index).typet=NewTransi
            self.win.timeline.cellWidget(0,self.index).optTransi=0
            self.win.timeline.cellWidget(0,self.index).updatePix()
            self.App_SetModifiedFlag()
            self.App_SetupInterface()
            self.App_DisplayLenght()
        except:
          None

    #Function call each time transition duration change
    def SEQ_ChoixSpeedT(self,txt):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.win.timeline.cellWidget(0,self.index).speedt=txt
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.win.timeline.cellWidget(0,self.index).updatePix()
          self.App_SetModifiedFlag()
          self.App_SetupInterface()
          self.App_DisplayLenght()

    def SEQ_DefText(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        self.DefTextDlg=DefTextDlg(image,0,self,"Image",self.win)
        self.DefTextDlg.show()
        self.DefTextDlg.FirstInit()
        if image.XMLText!=None :
          xmlPoint=image.XMLText.getElementsByTagName(u"SaveXML")[0]
          self.DefTextDlg.ImportXML(xmlPoint)
        self.DefTextDlg.ForcePaint()

    def SEQ_DefTextOk(self):
      # Save Windows size/position on exit
      self.DefTextDlg.SaveWindowPosition()

      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        image.XMLText=self.DefTextDlg.ExportToXML()
        image.ResetThumb()
        self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
        self.App_SetModifiedFlag()
      self.DefTextDlg.close()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# TAB Montage Option
#-----------------------------------------------------------------------------------------------------------------------------------------------
    #Function call each time user enter a soundfile
    #def TAB_Montage_ChgSndFile(self):
      #file=self.win.soundfile.text()
      #if file!="":
        #file=QDir().toNativeSeparators(file)
        #self.lastDirSound=QFileInfo(file).dir().absolutePath()
        #self.soundfile=unicode(QFileInfo(self.win.soundfile.text()).absoluteFilePath())
      #else:
        #self.soundfile=u""
      #UpdateConfigurationXMLFile(self.ProjectXMLObject,u"sndfile",self.soundfile,u"Videoporama")
      #self.App_SetModifiedFlag()

    #Function for browse to select soundfile
    #def TAB_Montage_BrowseSndFile(self):
      #file=QFileInfo(QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","File Dialog"),self.lastDirSound, "Sound(*.wav *.WAV *.mp3 *.MP3 *.ogg *.OGG)")).absoluteFilePath()
      #if file!="":
        #self.lastDirSound=QFileInfo(file).dir().absolutePath()
        #file=QDir().toNativeSeparators(file)
      #else:
        #self.soundfile=u""
      #self.win.soundfile.setText(file)
      #self.soundfile=unicode(file)
      #UpdateConfigurationXMLFile(self.ProjectXMLObject,u"sndfile",self.soundfile,u"Videoporama")
      #self.App_SetModifiedFlag()

    #Function call to change image format 16/9 - 4/3
    def TAB_Montage_SetImgFormat(self,imgF) :
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      SaveSelect = self.win.timeline.currentColumn()

      #apply new image format
      self.imgformat=imgF

      # Setup new size
      hpix=self.win.timeline.height()-18
      if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
      else : wpix=(hpix-4)*4/3+34
      i=0
      while i<self.win.timeline.columnCount():
        self.win.timeline.setColumnWidth(i,wpix)
        Sequence=self.win.timeline.cellWidget(0,i)
        Sequence.ResetThumb()
        i+=1

      self.win.timeline.setCurrentCell(0,SaveSelect)
      self.App_SetModifiedFlag()
      self.App_DisplayPixMainWin(0)
      self.qtapp.restoreOverrideCursor()

    def TAB_Montage_DefText(self):
      self.DefTextDlg=DefTextDlg(None,0,self,"Overlaid",self.win)
      self.DefTextDlg.show()
      self.DefTextDlg.FirstInit()
      if self.XMLText!=None :
        xmlPoint=self.XMLText.getElementsByTagName(u"SaveXML")[0]
        self.DefTextDlg.ImportXML(xmlPoint)
        self.DefTextDlg.ForcePaint()

    def TAB_Montage_DefTextOk(self):
      # Save Windows size/position on exit
      self.DefTextDlg.SaveWindowPosition()

      self.XMLText=self.DefTextDlg.ExportToXML()
      self.DefTextDlg.close()
      self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
      self.App_SetModifiedFlag()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# TAB Movie action
#-----------------------------------------------------------------------------------------------------------------------------------------------
    def TAB_Movie_DefMoviePoint(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        Image = self.win.timeline.cellWidget(0,self.index)
        if Image.ObjectType==2:
          self.DefMoviePointDlg=DefMoviePointDlg(Image,self,self.win)
          self.DefMoviePointDlg.show()

    def TAB_Movie_DefMoviePointOk(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        Image = self.win.timeline.cellWidget(0,self.index)
        if Image.ObjectType==2:
          self.TimeChanged =True
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          Image.StartVideo    = self.DefMoviePointDlg.StartVideo
          Image.EndVideo      = self.DefMoviePointDlg.EndVideo
          Image.DurationVideo = self.DefMoviePointDlg.DurationVideo
          self.win.ActualDurationEd.setTime(Image.DurationVideo)
          self.win.MovieStartEd.setMinimumTime(QTime(0,0,0))
          self.win.MovieStartEd.setMaximumTime(Image.EndVideo)
          self.win.MovieStartEd.setTime(Image.StartVideo)
          self.win.MovieEndEd.setMinimumTime(Image.StartVideo)
          self.win.MovieEndEd.setMaximumTime(Image.InitialDurationVideo)
          self.win.MovieEndEd.setTime(Image.EndVideo)
          self.DefMoviePointDlg.close()
          Image.CacheThumb=None
          Image.MakeXMLZoomPointList()
          self.TAB_Movie_RefreshMovie()
          self.qtapp.restoreOverrideCursor()

    def TAB_Movie_RotateLeft(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        Image = self.win.timeline.cellWidget(0,self.index)
        if Image.EXIF_Orientation==1 :   Image.EXIF_Orientation=8
        elif Image.EXIF_Orientation==8 : Image.EXIF_Orientation=3
        elif Image.EXIF_Orientation==3 : Image.EXIF_Orientation=6
        elif Image.EXIF_Orientation==6 : Image.EXIF_Orientation=1
        self.TAB_Movie_RefreshMovie()
        self.qtapp.restoreOverrideCursor()

    def TAB_Movie_RotateRight(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        Image = self.win.timeline.cellWidget(0,self.index)
        if Image.EXIF_Orientation==1 :   Image.EXIF_Orientation=6
        elif Image.EXIF_Orientation==6 : Image.EXIF_Orientation=3
        elif Image.EXIF_Orientation==3 : Image.EXIF_Orientation=8
        elif Image.EXIF_Orientation==8 : Image.EXIF_Orientation=1
        self.TAB_Movie_RefreshMovie()
        self.qtapp.restoreOverrideCursor()

    def TAB_Movie_RefreshMovie(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        Image = self.win.timeline.cellWidget(0,self.index)
        Image.ResetThumb()
        Image.updatePix()
        self.App_SetModifiedFlag()
        self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
        self.App_DisplayLenght()
        self.qtapp.restoreOverrideCursor()

    def TAB_Movie_ChgMovieFile(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        Image = self.win.timeline.cellWidget(0,self.index)
        NewFile=""
        NewFile=QFileDialog.getOpenFileNames(self.win,self.qtapp.translate("main","Change movie files"),self.lastDirMovies, "Movies(*.avi *.AVI *.mpg *.MPG *.mov *.MOV *dv *DV *mp4 *MP4 *.mkv *.MKV)")
        if NewFile!="":
          self.TimeChanged =True
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          self.lastDirMovies=QFileInfo(NewFile[0]).dir().absolutePath()
          Image.urlim=unicode(NewFile[0])
          self.TAB_Movie_RefreshMovie()
          self.Timeline_ChgSelectedItem()
          self.qtapp.restoreOverrideCursor()

    def TAB_Movie_OnDefStartPosEd(self,NewTime):
      if self.StopMAJSpinbox==True: return
      self.StopMAJSpinbox=True
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        Image = self.win.timeline.cellWidget(0,self.index)
        if Image.ObjectType==2:
          self.TimeChanged =True
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          Image.StartVideo=NewTime
          Image.DurationVideo=QTime(0,0,0).addMSecs(Image.StartVideo.msecsTo(Image.EndVideo))
          self.win.MovieStartEd.setTime(Image.StartVideo)
          self.win.MovieEndEd.setMinimumTime(Image.StartVideo)
          self.win.ActualDurationEd.setTime(Image.DurationVideo)
          Image.CacheThumb=None
          Image.MakeXMLZoomPointList()
          Image.updatePix()
          self.App_SetModifiedFlag()
          self.App_DisplayLenght()
          self.qtapp.restoreOverrideCursor()
      self.StopMAJSpinbox=False

    def TAB_Movie_OnDefEndPosEd(self,NewTime):
      if self.StopMAJSpinbox==True: return
      self.StopMAJSpinbox=True
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        Image = self.win.timeline.cellWidget(0,self.index)
        if Image.ObjectType==2:
          self.TimeChanged =True
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          Image.EndVideo=NewTime
          Image.DurationVideo=QTime(0,0,0).addMSecs(Image.StartVideo.msecsTo(Image.EndVideo))
          self.win.MovieEndEd.setTime(Image.EndVideo)
          self.win.MovieStartEd.setMaximumTime(Image.EndVideo)
          self.win.ActualDurationEd.setTime(Image.DurationVideo)
          Image.CacheThumb=None
          Image.MakeXMLZoomPointList()
          Image.updatePix()
          self.App_SetModifiedFlag()
          self.App_DisplayLenght()
          self.qtapp.restoreOverrideCursor()
      self.StopMAJSpinbox=False

#-----------------------------------------------------------------------------------------------------------------------------------------------
# TAB Image action
#-----------------------------------------------------------------------------------------------------------------------------------------------
    def TAB_Image_ChgImageFile(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        Image = self.win.timeline.cellWidget(0,self.index)
        NewFile=""
        if isWindows():
          NewFile=unicode(QFileDialog.getOpenFileName(self.win,self.qtapp.translate("main","Change image file"),self.lastDirImage, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *ppm *PPM *tiff *TIFF *.xpm *.XPM)"))
        else :
          fdialog = CFileDialogIMG(self.win,self.qtapp.translate("main","Change image file"),self.lastDirImage, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
          fdialog.addPreview()
          fdialog.setOption(QFileDialog.DontConfirmOverwrite, False)
          fdialog.setFileMode(QFileDialog.ExistingFile) # Only one file
          if fdialog.exec_():
            NewFile=unicode(fdialog.selectedFiles()[0])
        if NewFile!="":
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          self.lastDirImage=QFileInfo(unicode(NewFile)).dir().absolutePath()
          Image.urlim=NewFile
          self.TAB_Image_RefreshImg()
          self.Timeline_ChgSelectedItem()
          self.qtapp.restoreOverrideCursor()

    def TAB_Image_RotateRight(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        Image = self.win.timeline.cellWidget(0,self.index)
        if Image.EXIF_Orientation==1 :   Image.EXIF_Orientation=6
        elif Image.EXIF_Orientation==6 : Image.EXIF_Orientation=3
        elif Image.EXIF_Orientation==3 : Image.EXIF_Orientation=8
        elif Image.EXIF_Orientation==8 : Image.EXIF_Orientation=1
        self.TAB_Image_RefreshImg()
        self.qtapp.restoreOverrideCursor()

    def TAB_Image_RotateLeft(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        Image = self.win.timeline.cellWidget(0,self.index)
        if Image.EXIF_Orientation==1 :   Image.EXIF_Orientation=8
        elif Image.EXIF_Orientation==8 : Image.EXIF_Orientation=3
        elif Image.EXIF_Orientation==3 : Image.EXIF_Orientation=6
        elif Image.EXIF_Orientation==6 : Image.EXIF_Orientation=1
        self.TAB_Image_RefreshImg()
        self.qtapp.restoreOverrideCursor()

    def TAB_Image_CallGimp(self):
      if self.IsGIMPOk==True and self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        Image = self.win.timeline.cellWidget(0,self.index)
        Gimp=QProcess()
        cmd=u' \"'+unicode(QDir().toNativeSeparators(self.ImageEditor))+u'\" \"'+unicode(QDir().toNativeSeparators(Image.urlim))+u'\"'
        if isWindows() : 
          cmd=u"\""+cmd+"\""
          subprocess.Popen(cmd.encode('iso-8859-1'),shell=True,stdin=subprocess.PIPE,stderr=file('nul','a'),stdout=file('nul','a'))
        else :               
          subprocess.Popen(cmd.encode('utf-8'),shell=True,stdin=subprocess.PIPE)

    def TAB_Image_RefreshImg(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
        Image = self.win.timeline.cellWidget(0,self.index)
        Image.ResetThumb()
        self.App_SetModifiedFlag()
        self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
        self.qtapp.restoreOverrideCursor()

    def TAB_Image_SetDisplayData(self,EXIFDesc,EXIFValue):
      Row=self.win.EXIFTable.rowCount()
      self.win.EXIFTable.insertRow(Row)
      self.win.EXIFTable.setItem(Row,0,QTableWidgetItem(QString(EXIFDesc)))
      try:
        self.win.EXIFTable.setItem(Row,1,QTableWidgetItem(QString(EXIFValue)))
      except:
        None
      self.win.EXIFTable.setRowHeight(Row,18)

#-----------------------------------------------------------------------------------------------------------------------------------------------
# Timeline action
#-----------------------------------------------------------------------------------------------------------------------------------------------
    def Timeline_BrowseAddImage(self):
      if isWindows() :
        files=QFileDialog.getOpenFileNames(self.win,self.qtapp.translate("main","Select input files"),self.lastDirImage, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *ppm *PPM *tiff *TIFF *.xpm *.XPM)")
        self.Timeline_BrowseAddImage2(files)
      else :
        fdialog = CFileDialogIMG(self.win,self.qtapp.translate("main","Select input files"),self.lastDirImage, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
        fdialog.addPreview()
        fdialog.setOption(QFileDialog.DontConfirmOverwrite, False)
        fdialog.setFileMode(QFileDialog.ExistingFiles)
        fdialog.show()
        self.qtapp.connect(fdialog, SIGNAL("filesSelected(QStringList)"), self.Timeline_BrowseAddImage2)

    def Timeline_BrowseAddImage2(self, files) :
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      try :
        self.lastDirImage=QFileInfo(files[0]).dir().absolutePath()
        #Create new item in the timeline at current position if self.NewSEQPosition==0 or at the end
        if self.NewSEQPosition==0: col=self.win.timeline.currentColumn()+1
        else :                     col=self.win.timeline.columnCount()
        NextSelectedItem=col
        for file in files :
          # Check if the transition choice is "Random"-> Then define random transition
          if int(self.ConfTypeT) == self.RANDOMTRANSITIONTYPE : 
            transi, optTransi = randomTransi()
          else :
            # If not random -> Transi define by config
            transi    = self.ConfTypeT
            optTransi = self.ConfTransiOpt

          Image=myLabel(
            unicode(file),                    #urlim = Filename
            unicode(self.ConfBgFile),         #background file
            self.ConfBgColor,                 #background color
            str(transi),                      #transition type
            str(optTransi),                   #transition option
            self.ConfSpeedT,                  #transition duration
            -1,                               #default orientation (read from exif data)
            self,                             #Videoporama class instance
            1                                 #Object Type=Image
          )
          Image.AddZoomPointItem(0,0,self.ConfTime,100,0.0,False,False)
          self.win.timeline.insertColumn(col)
          hpix=self.win.timeline.height()-18
          if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
          else :            wpix=(hpix-4)*4/3+34
          self.win.timeline.setColumnWidth(col,wpix)
          self.win.timeline.setCellWidget(0,col,Image)
          Image.updatePix()           #Generate thumbail for this image
          self.win.timeline.repaint() #Force Display new thumbnail
          col+=1
        #Setup interface
        self.TimeChanged =True
        self.App_SetModifiedFlag()
        self.index=NextSelectedItem
        self.win.timeline.setCurrentCell(0,NextSelectedItem)
      except :
        None
      self.qtapp.restoreOverrideCursor()

    def Timeline_BrowseAddMovie(self):
      files=QFileDialog.getOpenFileNames(self.win,self.qtapp.translate("main","Select movie files"),self.lastDirMovies, "Movies(*.avi *.AVI *.mpg *.MPG *.mov *.MOV *dv *DV *mp4 *MP4 *.mkv *.MKV)")
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      try :
        self.lastDirMovies=QFileInfo(files[0]).dir().absolutePath()
        #Create new item in the timeline at current position if self.NewSEQPosition==0 or at the end
        if self.NewSEQPosition==0: col=self.win.timeline.currentColumn()+1
        else :                     col=self.win.timeline.columnCount()
        NextSelectedItem=col
        for file in files :
          # Check if the transition choice is "Random"-> Then define random transition
          if int(self.ConfTypeT) == self.RANDOMTRANSITIONTYPE : 
            transi, optTransi = randomTransi()
          else :
            # If not random -> Transi define by config
            transi    = self.ConfTypeT
            optTransi = self.ConfTransiOpt
          Image=myLabel(
            unicode(file),                    #urlim = Filename
            unicode(self.ConfBgFile),         #background file
            self.ConfBgColor,                 #background color
            str(transi),                      #transition type
            str(optTransi),                   #transition option
            self.ConfSpeedT,                  #transition duration
            -1,                               #default orientation (read from exif data)
            self,                             #Videoporama class instance
            2                                 #Object Type=Movie
          )
          self.win.timeline.insertColumn(col)
          hpix=self.win.timeline.height()-18
          if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
          else :            wpix=(hpix-4)*4/3+34
          self.win.timeline.setColumnWidth(col,wpix)
          self.win.timeline.setCellWidget(0,col,Image)
          Image.updatePix()           #Generate thumbail for this image
          self.win.timeline.repaint() #Force Display new thumbnail
          col+=1
        #Setup interface
        self.App_SetModifiedFlag()
        self.index=NextSelectedItem
        self.win.timeline.setCurrentCell(0,NextSelectedItem)
        self.TimeChanged =True
        self.App_SetupInterface()
      except :
        None
      self.qtapp.restoreOverrideCursor()

    def Timeline_AddTitle(self):
      # Check if the transition choice is "Random"-> Then define random transition
      if int(self.ConfTypeT) == self.RANDOMTRANSITIONTYPE : 
        transi, optTransi = randomTransi()
      else :
        # If not random -> Transi define by config
        transi    = self.ConfTypeT
        optTransi = self.ConfTransiOpt
      
      #Create new item in the timeline at current position if self.NewSEQPosition==0 or at the end
      if self.NewSEQPosition==0: col=self.win.timeline.currentColumn()+1
      else :                     col=self.win.timeline.columnCount()
      
      Image=myLabel(
        "",                               #urlim = Filename
        unicode(self.ConfBgFile),         #background file
        self.ConfBgColor,                 #background color
        str(transi),                      #transition type
        str(optTransi),                   #transition option
        self.ConfSpeedT,                  #transition duration
        -1,                               #default orientation (not use in this case)
        self,                             #Videoporama class instance
        0                                 #Object Type=Title
      )
      Image.AddZoomPointItem(0,0,self.ConfTime,100,0.0,False,False)
      self.win.timeline.insertColumn(col)
      hpix=self.win.timeline.height()-18
      if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
      else :            wpix=(hpix-4)*4/3+34
      self.win.timeline.setColumnWidth(col,wpix)
      self.win.timeline.setCellWidget(0,col,Image)
      
      Image.updatePix()             #Generate thumbail for this image
      self.win.timeline.repaint()   #Force Display new thumbnail
      #Setup interface
      self.TimeChanged =True
      self.App_SetModifiedFlag()
      self.index=col
      self.win.timeline.setCurrentCell(0,col)
  
    def Timeline_Empty(self):
      self.StopUpdatePixDuringEmpty=True
      self.TimeChanged =True

      #Clear current selection
      self.SelectionEnCours=None
      #Clean Timeline
      i=0
      while i<self.win.timeline.columnCount() : self.win.timeline.removeColumn(i)
      #Clean TableZoomPoint
      i=0
      while i<self.win.TableZoomPoint.rowCount() : self.win.TableZoomPoint.removeRow(i)
      #Init new project data with default option from configuration XML object
      self.XMLText=None
      ProjectFilePathName=""
      self.ProjectXMLObject= Document()
      xmltag = self.ProjectXMLObject.createElement(u"Videoporama")
      self.ProjectXMLObject.appendChild(xmltag)
      self.imgformat          = int(LoadValueFromXMLFile(self.ProjectXMLObject,'imgformat',self.ConfImgFormat,u"Videoporama"))
      #self.soundfile          = LoadValueFromXMLFile(self.ProjectXMLObject,'sndfile',"",u"Videoporama")
      self.outputFile         = ""
      self.StopMAJSpinbox = True
      self.win.imgformat.setCurrentIndex(self.imgformat)
      self.StopMAJSpinbox = False
      self.IsProjectModified=False
      self.StopUpdatePixDuringEmpty=False

    def Timeline_MoveItemToRight(self):
      if self.index!=(self.win.timeline.columnCount()-1) :
        i=self.index
        wcol = self.win.timeline.columnWidth(i)
        pict=self.win.timeline.cellWidget(0,i).copy()
        nc=i+2
        self.win.timeline.insertColumn(nc)
        self.win.timeline.setColumnWidth(nc, wcol)
        self.win.timeline.setCellWidget(0,nc,pict)
        self.win.timeline.removeColumn(i)
        self.win.timeline.setCurrentCell(0,i+1)
        self.TimeChanged =True
        self.App_SetModifiedFlag()
        self.App_SetupInterface()

    def Timeline_MoveItemToLeft(self):
      if self.index!=0 :
        i=self.index
        wcol = self.win.timeline.columnWidth(i)
        pict=self.win.timeline.cellWidget(0,i).copy()
        self.TimeChanged=True
        b=i+1
        nc=i-1
        self.win.timeline.insertColumn(nc)
        self.win.timeline.setColumnWidth(nc, wcol)
        self.win.timeline.setCellWidget(0,nc,pict)
        self.win.timeline.removeColumn(b)
        self.win.timeline.setCurrentCell(0,nc)
        self.TimeChanged =True
        self.App_SetModifiedFlag()
        self.App_SetupInterface()

    def Timeline_DeleteItem(self):
      self.SelectionEnCours=None
      i = self.index
      if i > -1 :
        self.win.timeline.removeColumn(i)
        j = self.win.timeline.columnCount()
        if j != 0 :
          if i == 0 :
            self.win.timeline.setCurrentCell(0,0)
          elif i >= j :
            self.win.timeline.setCurrentCell(0,i-1)
          else :
            self.win.timeline.setCurrentCell(0,i)
        self.TimeChanged =True
        self.App_SetModifiedFlag()
        #Setup interface
        self.App_SetupInterface()

    # Function call each time an image is selected
    def Timeline_ChgSelectedItem(self): 
      if self.StopUpdatePixDuringEmpty==True: return
      #Stop all updatepix during this process
      self.StopUpdatePixDuringNewSelect=True
      
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if (image!=None):
        
        #TAB Sequence
        self.win.typet.setCurrentIndex(int(image.typet))
        self.win.bgcolor.setText(image.bgcolor)
        color=toqcolor(QString(image.bgcolor).toInt(16)[0])
        qp=QPalette()
        qp.setColor(QPalette.Base,color)
        self.win.bgcolor.setPalette(qp)
        self.win.bgfile.setText(image.bgfile)
        self.win.speedt.setCurrentIndex(int(image.speedt))
        optt=int(image.opttransi)
        self.win.transiopt.setCurrentIndex(optt)
        
        i=0
        while i<self.win.EXIFTable.rowCount() : self.win.EXIFTable.removeRow(i)
        CurTab=self.win.TABOptions.currentIndex()
        if image.ObjectType!=2:
          #TAB Image
          if CurTab==3: self.win.TABOptions.setCurrentIndex(2)
          self.win.TABOptions.setTabEnabled(2,True)
          self.win.TABOptions.setTabEnabled(3,False)
          self.win.ImageFile.setText(image.urlim)
          if image.ObjectType==1:
            image.EXIF_Size=str(int(image.RealImageSizeWidth))+" x "+str(int(image.RealImageSizeHeight))
            self.TAB_Image_SetDisplayData("Original date/time",image.EXIF_OrigDatetime) # Date/time of the image taken (EXIF)
            self.TAB_Image_SetDisplayData("Description",image.EXIF_Description)         # Image description (EXIF)
            self.TAB_Image_SetDisplayData("Camera",image.EXIF_Camera)                   # Camera (EXIF)
            self.TAB_Image_SetDisplayData("Artist - Copyright",image.EXIF_Artist)       # Artist/Copyright (EXIF)
            self.TAB_Image_SetDisplayData("Image size",image.EXIF_Size)                 # Size (x*y) (EXIF)
            self.TAB_Image_SetDisplayData("ISO Speed",image.EXIF_ISO)                   # ISO (EXIF)
            self.TAB_Image_SetDisplayData("Focal aperture",image.EXIF_Focal)            # Focal (EXIF)
            self.TAB_Image_SetDisplayData("Exposure Time",image.EXIF_ExposureTime)     # ExposureTime (EXIF)
          #Clean movie TAB
          self.win.VideoTrackInfo.setText("")
          self.win.AudioTrackInfo.setText("")
          self.win.MovieFile.setText("")
        else :
          #TAB Movie
          if CurTab==2: self.win.TABOptions.setCurrentIndex(3)
          self.StopMAJSpinbox=True
          self.win.TABOptions.setTabEnabled(2,False)
          self.win.TABOptions.setTabEnabled(3,True)
          self.win.MovieFile.setText(image.urlim)
          self.win.VideoTrackInfo.setText(image.InfoVideo)
          self.win.AudioTrackInfo.setText(image.InfoAudio)
          self.win.ActualDurationEd.setTime(image.DurationVideo)
          self.win.MovieStartEd.setMinimumTime(QTime(0,0,0))
          self.win.MovieStartEd.setMaximumTime(image.EndVideo)
          self.win.MovieStartEd.setTime(image.StartVideo)
          self.win.MovieEndEd.setMinimumTime(image.StartVideo)
          self.win.MovieEndEd.setMaximumTime(image.InitialDurationVideo)
          self.win.MovieEndEd.setTime(image.EndVideo)
          self.StopMAJSpinbox=False
          self.App_DisplayLenght()
        
        image.StateSelected=True
        image.updatePix()
        if (image!=self.SelectionEnCours):
          if (self.SelectionEnCours!=None):
            try:
              self.SelectionEnCours.StateSelected=False
              self.SelectionEnCours.updatePix()
              #self.SelectionEnCours.SetupInterface()
            except:
                None
        self.SelectionEnCours=image
        self.SelectionEnCours.MakeTableZoomPointFromXML()
        self.win.TableZoomPoint.setCurrentCell(0,0)
        self.StopUpdatePixDuringNewSelect=False   #Allow updatepix now
        image.updatePix() #Then force an updatepix
        
      #Setup interface
      self.StopUpdatePixDuringNewSelect=False
      self.TimeChanged = True
      self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
      if self.StopSetupInterface!=True: self.App_SetupInterface()

    #----------------------------------------------------------------------------------------
    # App_ResizeEvent : when main videoporama window is resize
    #----------------------------------------------------------------------------------------
    def Timeline_ChTThumbnailSize(self) :
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      if self.ThumbnailsSize==0:
        self.win.timeline.setMinimumSize(QtCore.QSize(0, 80))
        self.win.timeline.setMaximumSize(QtCore.QSize(16777215, 80))
      elif self.ThumbnailsSize==1:
        self.win.timeline.setMinimumSize(QtCore.QSize(0, 120))
        self.win.timeline.setMaximumSize(QtCore.QSize(16777215, 120))
      else:
        self.win.timeline.setMinimumSize(QtCore.QSize(0, 150))
        self.win.timeline.setMaximumSize(QtCore.QSize(16777215, 150))

      # Setup new size
      hpix=self.win.timeline.height()-18
      if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
      else :            wpix=(hpix-4)*4/3+34

      self.win.timeline.setRowHeight(0,hpix)
      i=0
      while i<self.win.timeline.columnCount():
        self.win.timeline.setColumnWidth(i,wpix)
        Sequence=self.win.timeline.cellWidget(0,i)
        Sequence.CacheThumb=None
        Sequence.updatePix()
        i+=1
      self.qtapp.restoreOverrideCursor()

    def Timeline_ZoomUp(self):
      if self.ThumbnailsSize<2:
        self.ThumbnailsSize+=1
        self.Timeline_ChTThumbnailSize()
        self.App_SetupInterface()

    def Timeline_ZoomDown(self):
      if self.ThumbnailsSize>0:
        self.ThumbnailsSize-=1
        self.Timeline_ChTThumbnailSize()
        self.App_SetupInterface()

#-----------------------------------------------------------------------------------------------------------------------------------------------
#TableZoomPoint action
#-----------------------------------------------------------------------------------------------------------------------------------------------
    def TableZoomPoint_AddPoint(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        self.TimeChanged =True
        image.AddZoomPointItem(0.1,0.1,self.ConfStaticTimeNext,50,self.ConfAnimTimeNext)

        # Update Thumbnail image
        image.updatePix()

        self.App_SetModifiedFlag()
        self.App_SetupInterface()
    
    def TableZoomPoint_MoveItemToUp(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i!=0 :
          self.TimeChanged =True
          pict=self.win.TableZoomPoint.cellWidget(i,0).copy()
          b=i+1
          nc=i-1
          self.win.TableZoomPoint.insertRow(nc)
          self.win.TableZoomPoint.setRowHeight(nc,pict.h)
          self.win.TableZoomPoint.setCellWidget(nc,0,pict)
          self.win.TableZoomPoint.removeRow(b)
          self.win.TableZoomPoint.setCurrentCell(nc,0)
          image.MakeXMLZoomPointList()
          # Set number of all zoom point
          i=0
          while (i<self.win.TableZoomPoint.rowCount()):
            self.win.TableZoomPoint.cellWidget(i,0).NumZoomPoint=i
            i+=1
          image.CacheThumb=None
          image.updatePix()
          self.App_SetModifiedFlag()
          self.App_SetupInterface()
    
    def TableZoomPoint_MoveItemToDown(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i!=(self.win.TableZoomPoint.rowCount()-1) :
          self.TimeChanged =True
          pict=self.win.TableZoomPoint.cellWidget(i,0).copy()
          nc=i+2
          self.win.TableZoomPoint.insertRow(nc)
          self.win.TableZoomPoint.setRowHeight(nc,pict.h)
          self.win.TableZoomPoint.setCellWidget(nc,0,pict)
          self.win.TableZoomPoint.removeRow(i)
          self.win.TableZoomPoint.setCurrentCell(i+1,0)
          image.MakeXMLZoomPointList()
          # Set number of all zoom point
          i=0
          while (i<self.win.TableZoomPoint.rowCount()):
            self.win.TableZoomPoint.cellWidget(i,0).NumZoomPoint=i
            i+=1
          image.CacheThumb=None
          image.updatePix()
          self.App_SetModifiedFlag()
          self.App_SetupInterface()
    
    def TableZoomPoint_DeleteItem(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        self.TimeChanged =True
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          self.win.TableZoomPoint.removeRow(i)
          image.NbrZoomPoint-=1
          j = self.win.TableZoomPoint.rowCount()
          if j != 0 :
            if i == 0 :
              self.win.TableZoomPoint.setCurrentCell(0,0)
            elif i >= j :
              self.win.TableZoomPoint.setCurrentCell(i-1,0)
            else :
              self.win.TableZoomPoint.setCurrentCell(i,0)
          # Set number of all zoom point
          i=0
          while (i<self.win.TableZoomPoint.rowCount()):
            self.win.TableZoomPoint.cellWidget(i,0).NumZoomPoint=i
            i+=1
          image.MakeXMLZoomPointList()
          # Update Thumbnail image
          image.updatePix()
          self.App_SetModifiedFlag()
          self.App_SetupInterface()

    #Function call each time image duration change
    def TableZoomPoint_ChgTimeFixe(self,val):
      if self.StopSetupInterface : return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        self.TimeChanged =True
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            item.timeFixe = val
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            self.App_SetModifiedFlag()
            self.App_DisplayLenght()

    #Function call each time image duration change
    def TableZoomPoint_ChgTimeToTravel(self,val):
      if self.StopSetupInterface : return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        self.TimeChanged =True
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            item.timeToTravel = val
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            self.App_SetModifiedFlag()
            self.App_DisplayLenght()

    def TableZoomPoint_ChgSelectedItem(self):
      # Draw each item to remove selection or add selection to the new selected item
      i=0
      while (i<self.win.TableZoomPoint.rowCount()) :
        item=self.win.TableZoomPoint.cellWidget(i,0)
        if item!=None : item.updatePix()
        i+=1
      # Repaint preview zone
      self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
      self.App_SetupInterface()

    def TableZoomPoint_ChgZoomPointXValue(self,Value):
      if self.StopMAJSpinbox: return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            if self.ConfDisplayUnit=="0" :
              # Define value in %
              Value=Value/100
            else:
              # Define value in %
              Value=Value/image.xmax
            item.x=Value
            item.CacheThumb=None
            image.CacheThumb=None
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_ChgZoomPointYValue(self,Value):
      if self.StopMAJSpinbox: return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            if self.ConfDisplayUnit=="0" :
              # Define value in %
              Value=Value/100
            else:
              # Define value in %
              Value=Value/image.ymax
            item.y=Value
            image.CacheThumb=None
            item.CacheThumb=None
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_ChgZoomPointZoomValue(self,Value):
      if self.StopMAJSpinbox: return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            if self.ConfDisplayUnit=="0" :
              # Define value in %
              None
            else:
              # Define value in %
              Value=(Value/image.xmax)*100
            item.zoom=Value
            item.CacheThumb=None
            image.CacheThumb=None
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_DefZoomPointText(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        ZoomPointNum = self.win.TableZoomPoint.currentRow()
        if ZoomPointNum > -1 :
          item=self.win.TableZoomPoint.cellWidget(ZoomPointNum,0)
          if item!=None : 
            self.DefTextDlg=DefTextDlg(image,ZoomPointNum,self,"ZoomPoint",self.win)
            xmlPoint=image.ZoomPointList.getElementsByTagName(u"Point-"+str(ZoomPointNum))[0]
            self.DefTextDlg.show()
            self.DefTextDlg.FirstInit()
            self.DefTextDlg.ImportXML(xmlPoint)
            self.DefTextDlg.ForcePaint()

    def TableZoomPoint_DefZoomPointTextOk(self):
      # Save Windows size/position on exit
      self.DefTextDlg.SaveWindowPosition()

      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        ZoomPointNum = self.win.TableZoomPoint.currentRow()
        if ZoomPointNum > -1 :
          ZoomPointItem=self.win.TableZoomPoint.cellWidget(ZoomPointNum,0)
          if ZoomPointItem!=None : 
            ZoomPointItem.CacheThumb=None
            image.CacheThumb=None
            ZoomPointItem.XMLText=self.DefTextDlg.ExportToXML()
            self.DefTextDlg.close()
            image.MakeXMLZoomPointList()
            image.updatePix()
            ZoomPointItem.updatePix()
            ZoomPointItem.SetupInterface()
            self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_DefZoomPoint(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            self.DefZoomPointDlg=DefZoomPointDlg(image,item,self,self.win)
            self.DefZoomPointDlg.show()
            self.DefZoomPointDlg.FirstInit()

    def TableZoomPoint_DefZoomPointOk(self):
      # Save Windows size/position on exit
      self.DefZoomPointDlg.SaveWindowPosition()

      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            item.CacheThumb=None
            item.x         = self.DefZoomPointDlg.cadre.x
            item.y         = self.DefZoomPointDlg.cadre.y
            item.zoom      = self.DefZoomPointDlg.cadre.zoom
            ZoomPointItem.CacheThumb=None
            image.CacheThumb=None
            self.DefZoomPointDlg.close()
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.TABOptions.currentIndex())
            image.MakeXMLZoomPointList()
            self.App_SetModifiedFlag()
