/*
 * Copyright (C) 2014 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Jussi Pakkanen <jussi.pakkanen@canonical.com>
 *
 */

#ifndef RESULTCOLLECTOR_H_
#define RESULTCOLLECTOR_H_

#include <unity/scopes/SearchListenerBase.h>
#include <unity/scopes/ReplyProxyFwd.h>
#include <unity/scopes/ListenerBase.h>
#include <unity/scopes/CategorisedResult.h>

#include <list>
#include <mutex>
#include <condition_variable>

class ResultCollector : public unity::scopes::SearchListenerBase
{
public:

    ResultCollector() : query_finished_(false) {}
    virtual ~ResultCollector() {}

    virtual void push(unity::scopes::CategorisedResult result) override;
    virtual void finished(unity::scopes::CompletionDetails const& details) override;

    bool wait_until_finished(int timeout_ms = -1);
    std::list<unity::scopes::CategorisedResult> take_results();

private:
    std::list<unity::scopes::CategorisedResult> result_list_;
    std::mutex mutex_;
    std::condition_variable condvar_;
    bool query_finished_;
};

#endif
