#ifndef INCLUDED_ESCAPE_H
#define INCLUDED_ESCAPE_H
/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

/**
 * Conversion routines to and from \xNN escaping for non-printable characters
 * (0x00 through 0x1F).
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * Escape all characters below 0x20 and the backslash in a C-string.
 * The destination dest must be at least 4*strlen(src)+1 characters long.
 */
void strtoctrlesc(char* dest, const char* src);

/**
 * Unescape a string escaped by strtoctrlesc.
 * The destination dest must be at least strlen(src)+1 characters long.
 * Returns 0 on success and -1 when an invalid escape sequence is encountered
 * (and the state of dest will be undefined).
 */
int ctrlesctostr(char* dest, const char* src);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* INCLUDED_ESCAPE_H */
