/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jasper;

/**
 * Base class for all exceptions generated by the JSP engine. Makes it
 * convenient to catch just this at the top-level.
 *
 * @author Anil K. Vijendran
 */
public class JasperException extends javax.servlet.ServletException {

    private static final long serialVersionUID = 1L;

    public JasperException(String reason) {
        super(reason);
    }

    /**
     * Creates a JasperException with the embedded exception and the reason for
     * throwing a JasperException.
     * @param reason The exception message
     * @param exception The root cause
     */
    public JasperException(String reason, Throwable exception) {
        super(reason, exception);
    }

    /**
     * Creates a JasperException with the embedded exception.
     * @param exception The root cause
     */
    public JasperException(Throwable exception) {
        super(exception);
    }
}
