## TFSA-2021-094: Heap OOB read in TFLite

### CVE Number
CVE-2021-29606

### Impact
A specially crafted TFLite model could trigger an OOB read on heap in the
TFLite implementation of
[`Split_V`](https://github.com/tensorflow/tensorflow/blob/c59c37e7b2d563967da813fa50fe20b21f4da683/tensorflow/lite/kernels/split_v.cc#L99):

```cc
const int input_size = SizeOfDimension(input, axis_value);
```

If `axis_value` is not a value between 0 and `NumDimensions(input)`, then the
[`SizeOfDimension`
function](https://github.com/tensorflow/tensorflow/blob/102b211d892f3abc14f845a72047809b39cc65ab/tensorflow/lite/kernels/kernel_util.h#L148-L150)
will access data outside the bounds of the tensor shape array:

```cc
inline int SizeOfDimension(const TfLiteTensor* t, int dim) {
  return t->dims->data[dim];
}
```

### Patches
We have patched the issue in GitHub commit
[ae2daeb45abfe2c6dda539cf8d0d6f653d3ef412](https://github.com/tensorflow/tensorflow/commit/ae2daeb45abfe2c6dda539cf8d0d6f653d3ef412).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
