/*
  Teem: Tools to process and visualize scientific data and images             .
  Copyright (C) 2013, 2012, 2011, 2010, 2009  University of Chicago
  Copyright (C) 2008, 2007, 2006, 2005  Gordon Kindlmann
  Copyright (C) 2004, 2003, 2002, 2001, 2000, 1999, 1998  University of Utah

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License
  (LGPL) as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  The terms of redistributing and/or modifying this software also
  include exceptions to the LGPL that facilitate static linking.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <teem/unrrdu.h>

/* learning columns
#include <sys/types.h>
#include <sys/ioctl.h>
*/

#define UNU "unu"

int
main(int argc, const char **argv) {
  int i, ret;
  const char *me;
  char *argv0 = NULL;
  hestParm *hparm;
  airArray *mop;

  me = argv[0];

  /* parse environment variables first, in case they break nrrdDefault*
     or nrrdState* variables in a way that nrrdSanity() should see */
  nrrdDefaultGetenv();
  nrrdStateGetenv();

  /* if user hasn't tried to set nrrdStateKindNoop by an environment
     variable, we set it to false, since its probably what people expect */
  if (!getenv(nrrdEnvVarStateKindNoop)) {
    nrrdStateKindNoop = AIR_FALSE;
  }

  /* if user hasn't tried to set nrrdStateKeyValuePairsPropagate by an envvar,
     we set it to true, since that's probably what unu users expect */
  if (!getenv(nrrdEnvVarStateKeyValuePairsPropagate)) {
    nrrdStateKeyValuePairsPropagate = AIR_TRUE;
  }

  /* no harm done in making sure we're sane */
  nrrdSanityOrDie(me);

  mop = airMopNew();
  hparm = hestParmNew();
  airMopAdd(mop, hparm, (airMopper)hestParmFree, airMopAlways);
  hparm->elideSingleEnumType = AIR_TRUE;
  hparm->elideSingleOtherType = AIR_TRUE;
  hparm->elideSingleOtherDefault = AIR_TRUE;
  hparm->elideSingleNonExistFloatDefault = AIR_TRUE;
  hparm->elideMultipleNonExistFloatDefault = AIR_TRUE;
  hparm->elideSingleEmptyStringDefault = AIR_TRUE;
  hparm->elideMultipleEmptyStringDefault = AIR_TRUE;
  hparm->columns = unrrduDefNumColumns;
  /* learning columns
  if (1) {
    struct winsize ws;
    ioctl(1, TIOCGWINSZ, &ws);
    hparm->columns = ws.ws_col - 1;
  }
  */
  hparm->greedySingleString = AIR_TRUE;

  /* if there are no arguments, then we give general usage information */
  if (1 >= argc) {
    unrrduUsageUnu("unu", hparm);
    airMopError(mop);
    exit(1);
  }
  /* else, we see if its --version */
  if (!strcmp("--version", argv[1])) {
    char vbuff[AIR_STRLEN_LARGE];
    airTeemVersionSprint(vbuff);
    printf("%s\n", vbuff);
    exit(0);
  }
  /* else, we should see if they're asking for a command we know about */
  for (i=0; unrrduCmdList[i]; i++) {
    if (!strcmp(argv[1], unrrduCmdList[i]->name)) {
      break;
    }
    if (!strcmp("--help", argv[1])
        && !strcmp("about", unrrduCmdList[i]->name)) {
      break;
    }
  }
  /* unrrduCmdList[] is NULL-terminated */
  if (unrrduCmdList[i]) {
    /* yes, we have that command */
    /* initialize variables used by the various commands */
    argv0 = AIR_CALLOC(strlen(UNU) + strlen(argv[1]) + 2, char);
    airMopMem(mop, &argv0, airMopAlways);
    sprintf(argv0, "%s %s", UNU, argv[1]);

    /* run the individual unu program, saving its exit status */
    ret = unrrduCmdList[i]->main(argc-2, argv+2, argv0, hparm);
  } else {
    fprintf(stderr, "%s: unrecognized command \"%s\"; type \"%s\" for "
            "complete list\n", me, argv[1], me);
    ret = 1;
  }

  airMopDone(mop, ret);
  return ret;
}
