#include <iostream>
#include <ginac/ginac.h>

#include "SyFi.h"
#include "ginac_tools.h"

using namespace std;
using namespace GiNaC;
using namespace SyFi;


// .................


// pick an expression to test
ex pickExpression(int i)
{
	ex x = get_symbol("x");
	ex y = get_symbol("y");
	ex z = get_symbol("z");

	ex e;
	switch(i)
	{
	case 0: e = 1;      break;
	case 1:	e = x;      break;
	case 2:	e = x+y;    break;
	case 3:	e = x+y+z;  break;
	case 4:	e = x*y;    break;
	case 5:	e = x*y*z;  break;
	case 6:	e = x*x*y*y*z*z;  break;
	case 7:	e = x*x*x*y*y*y*z*z*z;  break;
	case 8:
		e = power(x,3)*power(y,2) + power(x,2) + x*y*y;
		break;
	case 9:
		e = power(x,3)*power(y,2) + power(x,2) + x*y*y;
		e = power(e, e) + e;
		break;
	// add more tests with a new case here, and update the iteration limit in main
	default:
		e = 0;
	}
	return e;
}


int main(int argc, char **argv)
{
  bool verbose = false; // turn this off for the unit tests
  if(argc>1 && argv[1][0] == 'v') verbose = true;

	int from = 0;
	int to   = 10;
	for(int i=from; i<to; i++)
	{
		// pick an expression to test
		ex e = pickExpression(i);
		ex f = e*e;
    
    ExStats es = count_ops(e);
    ExStats fs = count_ops(f);
    
    if(verbose) cout << "Flops in e = " << e << endl;
    else        cout << "Flops in e " << endl;
    cout << "  adds:  " << es.adds << endl;
    cout << "  muls:  " << es.muls << endl;
    cout << "  pows:  " << es.pows << endl;
    cout << "  funs:  " << es.functions << endl;
    cout << "  flops: " << es.flops << endl;
    cout << endl;
    if(verbose) cout << "Flops in f = " << f << endl;
    else        cout << "Flops in f " << endl;
    cout << "  adds:  " << fs.adds << endl;
    cout << "  muls:  " << fs.muls << endl;
    cout << "  pows:  " << fs.pows << endl;
    cout << "  funs:  " << fs.functions << endl;
    cout << "  flops: " << fs.flops << endl;
    cout << endl;
	}
  
	return 0;
}

