" Vim syntax file
" Language:     The SPL Programming Language
" Maintainer:   Clifford Wolf <clifford@clifford.at>
" Filenames:    *.spl,*.webspl
" Last Change:  $Date: 2005-10-07 08:51:08 +0200 (Fri, 07 Oct 2005) $
" URL:          http://svn.clifford.at/spl/trunk/spl-syntax.vim
"
" SPL - The SPL Programming Language
" Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
"
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
"
" This program is distributed in the hope that it will be useful,
" but WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
" GNU General Public License for more details.
"
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"
" spl-syntax.vim: VIM syntax highlighting rules for SPL scripts
"
" --- HOWTO INSTALL ---
"
" 1.
" Copy or symlink this file to ~/.vim/syntax/spl.vim
"
" 2.
" Add the following to your ~/.vimrc:
" au BufRead,BufNewFile *.spl,*.webspl set filetype=spl
"
" ---------------------
"

" SPL Comments
syntax region Comment start="/\*" end="\*/"
syntax region SpecialComment start="/\*\*" end="\*/"
syntax region Comment start="//" end="$"

" The SPL keywords
syntax keyword Statement
\ debug warning panic delete function method import load new this object
\ var static if else do while for foreach asm return exit defined declared
\ undef goto break continue pop shift push unshift next prev eval not and or
\ try catch throw switch default case lengthof elementsof

" Variables, functions and methods
" identifiers which are in no way special aren't highlighted
syntax match NormalIdentifier "[a-zA-Z0-9_.]\+"
syntax match Identifier "\$<[a-zA-Z0-9_.]\+>"
syntax match Identifier "\$[0-9[\]#@$+-]"

" Named parameters, Goto labels, etc..
syntax match Type "\([;{}(\[,]\_s*\)\@<=[a-zA-Z0-9_.]\+:\+"
syntax match Type "[a-zA-Z0-9_.]\+::\+"

" Compiler Pragmas
syntax match PreProc "#!.*$"
syntax match PreProc "#define\s*\S*\(.\|\n\\\)*"
syntax match PreProc "#\(file-as-[a-z]*\|encoding\|undef\)\s*[^ \t;,(){}[\]*\-+~!\'\"@#$%^&=?]*"
syntax region PreProc start="#embedded-file\s*\S*\s*\z(\S*\)" end="\z1"

" Follow { .. } and ( .. )
syntax region Block contains=@SplTopLevel start="{" end="}"
syntax region Block contains=@SplTopLevel start="(" end=")"
highlight link Block None

" Regular expressions
syntax region Constant  extend matchgroup=Special contains=EscSeq,@DollarSubst skip=+\\.+ start="[!=]\~\s*\z([/:,!%@]\)"ms=e end="\z1[A-Za-z]*"
syntax region Constant  extend matchgroup=Special contains=EscSeq,@DollarSubst skip=+\\.+ start="[!=]\~\s*e\z([/:,!%@]\)"ms=e-1 end="\z1[A-Za-z]*"
syntax region Constant  extend matchgroup=Special contains=EscSeq,@DollarSubst skip=+\\.+ start="[!=]\~\s*s\z([/:,!%@]\)"ms=e-1 end="\z1"me=e-1 nextgroup=RegSubst2
syntax region RegSubst2 extend matchgroup=Special contains=EscSeq,@DollarSubst contained skip=+\\.+ start="\z([/:,!%@]\)" end="\z1[A-Za-z]*"
highlight link RegSubst2 Constant

" Strings with single or double quotes
syntax region Constant extend contains=EscSeq,@DollarSubst
\ start=+\z(["']\)+ skip=+\\.+ end=+\z1+

" Here document with <<< and <<
syntax region Constant extend contains=EscSeq,@DollarSubst start="<<<" end="$"
syntax region Constant extend contains=EscSeq,@DollarSubst start="<<\s*\z([A-Za-z0-9]\+\)" end="\z1"

" Here document with >>> and >>
syntax region Constant extend start=">>>" end="$"
syntax region Constant extend start=">>\s*\z([A-Za-z0-9]\+\)" end="\z1"

" Inline templates
syntax region Constant extend contains=@DollarSubst,@SplTags
\ start=+<:\?\z([a-zA-Z]*\)>+ end=+</\z1>+

" Backslash Escape Sequenzes
syntax match EscSeq contained "\\."
highlight link EscSeq Special

" Cluster for all dollar special sequences
syntax cluster DollarSubst contains=DollarEsc,DollarSubst1,DollarSubst2,DollarSubst3

" Escaped Dollar
syntax match DollarEsc contained "\$[$:?]"
highlight link DollarEsc Special

" Simple Variable Substitutions
syntax match DollarSubst1 contained "\$[a-zA-Z0-9_.]*[a-zA-Z0-9_]"
syntax match DollarSubst1 contained "\$[[\]@#]"
highlight link DollarSubst1 Identifier

" Substitutions - ${ .. }, $( .. ) and $< .. >
syntax region DollarSubst2 contained matchgroup=Identifier contains=@SplTopLevel start="\${" end="}"
syntax region DollarSubst2 contained matchgroup=Identifier contains=@SplTopLevel start="\$(" end=")"
syntax region DollarSubst2 contained matchgroup=Identifier contains=@SplTopLevel start="\$<" end=">"
highlight link DollarSubst2 None

" Inline Comments
syntax match DollarSubst3 contained "\$[ \t\n]"
syntax region DollarSubst3 contained start="\$\[" end="\]"
highlight link DollarSubst3 Comment

" SPL Template Tags
syntax cluster SplTags contains=SplTags1,SplTags2,SplCommentTag
syntax match SplTags1 "</spl\(if\|call\|\):[0-9a-z_]*>"
syntax region SplTags1 contained contains=SplTagsAttr start="<spl:" end=">"
syntax region SplTags1 contained contains=SplIfCallTagsAttr,SplIfCallTagsCmdAttr start="<spl\(if\|call\):" end=">"
syntax region SplTagsAttr contained matchgroup=Type contains=@SplTopLevel keepend start=+[a-z]*="+ end=+"+
syntax region SplIfCallTagsAttr contained matchgroup=Type contains=EscSeq,@DollarSubst start=+[a-z]*="+ end=+"+
syntax region SplIfCallTagsAttr contained matchgroup=Type contains=EscSeq,@DollarSubst start=+[a-z]*='+ end=+'+
syntax region SplIfCallTagsCmdAttr contained matchgroup=Type contains=@SplTopLevel start=+[a-z]*=(+ end=+)+
syntax region SplTags2 contained matchgroup=Special contains=@SplTopLevel keepend start="<?spl" end="?>"
syntax region SplTags2 contained matchgroup=Special contains=@SplTopLevel start="<spl:code>" end="</spl:code>"
syntax region SplTags2 contained matchgroup=Special contains=@SplTopLevel start="<spl:inline>" end="</spl:inline>"
syntax region SplCommentTag contained matchgroup=Special start="<spl:comment>" end="</spl:comment>"
highlight link SplTags1 Special
highlight link SplTags2 None
highlight link SplTagsAttr None
highlight link SplIfCallTagsAttr Constant
highlight link SplIfCallTagsCmdAttr None
highlight link SplCommentTag Comment

" Explicit list of Top Level elements (contains=TOP breaks syntax-spltpl.vim)
" egrep 'syntax (keyword|match|region)' syntax-spl.vim | grep -v contained | cut -f3 -d' ' | sort -u
syntax cluster SplTopLevel contains=Block,Comment,Constant,NormalIdentifier,Identifier,PreProc,SpecialComment,SplTags1,Statement,Type

" Burn many CPU cycles for syncing
syntax sync fromstart

