/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_29 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 6085, "epsg", 6085,
        "WGS 84 / EPSG Arctic zone 4-38", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=154 +x_0=38500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-38\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",75.36440330555");
    add_srs_wkt (p, 10,
        "556],PARAMETER[\"central_meridian\",154],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",38500000],PARAMETER[\"false_northing\",4500");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6085\"]]");
    p = add_epsg_def_ex (filter, first, last, 6086, "epsg", 6086,
        "WGS 84 / EPSG Arctic zone 4-40", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=179 +x_0=40500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-40\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",75.36440330555");
    add_srs_wkt (p, 10,
        "556],PARAMETER[\"central_meridian\",179],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",40500000],PARAMETER[\"false_northing\",4500");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6086\"]]");
    p = add_epsg_def_ex (filter, first, last, 6087, "epsg", 6087,
        "WGS 84 / EPSG Arctic zone 5-15", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=54 +x_0=15500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-15\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",73.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",70.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",72.02500919444444],PARAMETER[\"central_meridian\",54],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",15500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"6087\"]]");
    p = add_epsg_def_ex (filter, first, last, 6088, "epsg", 6088,
        "WGS 84 / EPSG Arctic zone 5-17", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=74 +x_0=17500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-17\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",73.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",70.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",72.02500919444444],PARAMETER[\"central_meridian\",74],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",17500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"6088\"]]");
    p = add_epsg_def_ex (filter, first, last, 6089, "epsg", 6089,
        "WGS 84 / EPSG Arctic zone 5-19", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=95 +x_0=19500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-19\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",73.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",70.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",72.02500919444444],PARAMETER[\"central_meridian\",95],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",19500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"6089\"]]");
    p = add_epsg_def_ex (filter, first, last, 6090, "epsg", 6090,
        "WGS 84 / EPSG Arctic zone 5-21", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=116 +x_0=21500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",73.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",70.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",72.02500919444444],PARAMETER[\"central_meridian\",116],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",21500000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"6090\"]]");
    p = add_epsg_def_ex (filter, first, last, 6091, "epsg", 6091,
        "WGS 84 / EPSG Arctic zone 5-23", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=137 +x_0=23500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-23\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",73.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",70.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",72.02500919444444],PARAMETER[\"central_meridian\",137],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",23500000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"6091\"]]");
    p = add_epsg_def_ex (filter, first, last, 6092, "epsg", 6092,
        "WGS 84 / EPSG Arctic zone 5-25", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=158 +x_0=25500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-25\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",73.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",70.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",72.02500919444444],PARAMETER[\"central_meridian\",158],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",25500000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"6092\"]]");
    p = add_epsg_def_ex (filter, first, last, 6093, "epsg", 6093,
        "WGS 84 / EPSG Arctic zone 5-27", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=179 +x_0=27500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-27\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",73.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",70.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",72.02500919444444],PARAMETER[\"central_meridian\",179],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",27500000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"6093\"]]");
    p = add_epsg_def_ex (filter, first, last, 6094, "epsg", 6094,
        "NAD83(NSRS2007) / EPSG Arctic zone 5-29", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-163 +x_0=29500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 5-29\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",73.66666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",70.33333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",72.02500919444444],PARAMETER[\"c");
    add_srs_wkt (p, 12,
        "entral_meridian\",-163],PARAMETER[\"false_easting\",2950");
    add_srs_wkt (p, 13,
        "0000],PARAMETER[\"false_northing\",5500000],UNIT[\"metre");
    add_srs_wkt (p, 14,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 15,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6094\"]]");
    p = add_epsg_def_ex (filter, first, last, 6095, "epsg", 6095,
        "NAD83(NSRS2007) / EPSG Arctic zone 5-31", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-147 +x_0=31500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 5-31\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",73.66666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",70.33333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",72.02500919444444],PARAMETER[\"c");
    add_srs_wkt (p, 12,
        "entral_meridian\",-147],PARAMETER[\"false_easting\",3150");
    add_srs_wkt (p, 13,
        "0000],PARAMETER[\"false_northing\",5500000],UNIT[\"metre");
    add_srs_wkt (p, 14,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 15,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6095\"]]");
    p = add_epsg_def_ex (filter, first, last, 6096, "epsg", 6096,
        "NAD83(NSRS2007) / EPSG Arctic zone 6-14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-165 +x_0=14500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 6-14\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",70.33333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",67],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 11,
        "origin\",68.68747555555557],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-165],PARAMETER[\"false_easting\",14500000],PARAMETER");
    add_srs_wkt (p, 13,
        "[\"false_northing\",6500000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 15,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"6096\"]]");
    p = add_epsg_def_ex (filter, first, last, 6097, "epsg", 6097,
        "NAD83(NSRS2007) / EPSG Arctic zone 6-16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-147 +x_0=16500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 6-16\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",70.33333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",67],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 11,
        "origin\",68.68747555555557],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-147],PARAMETER[\"false_easting\",16500000],PARAMETER");
    add_srs_wkt (p, 13,
        "[\"false_northing\",6500000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 15,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"6097\"]]");
    p = add_epsg_def_ex (filter, first, last, 6098, "epsg", 6098,
        "NAD83(CSRS) / EPSG Arctic zone 1-23", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-90 +x_0=23500000 +y_0=1500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 1-23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",87],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",83.66666666666667],PARAMETER[\"latitude_of_origin\",85.");
    add_srs_wkt (p, 11,
        "43711833333333],PARAMETER[\"central_meridian\",-90],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",23500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"6098\"]]");
    p = add_epsg_def_ex (filter, first, last, 6099, "epsg", 6099,
        "NAD83(CSRS) / EPSG Arctic zone 2-14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-115 +x_0=14500000 +");
    add_proj4text (p, 2,
        "y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 2-14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",83.66666666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",80.33333333333333],PARAMETER[\"latitude_");
    add_srs_wkt (p, 11,
        "of_origin\",82.05842488888888],PARAMETER[\"central_merid");
    add_srs_wkt (p, 12,
        "ian\",-115],PARAMETER[\"false_easting\",14500000],PARAME");
    add_srs_wkt (p, 13,
        "TER[\"false_northing\",2500000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 15,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"6099\"]]");
    p = add_epsg_def_ex (filter, first, last, 6100, "epsg", 6100,
        "NAD83(CSRS) / EPSG Arctic zone 2-16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-75 +x_0=16500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 2-16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",83.66666666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",80.33333333333333],PARAMETER[\"latitude_");
    add_srs_wkt (p, 11,
        "of_origin\",82.05842488888888],PARAMETER[\"central_merid");
    add_srs_wkt (p, 12,
        "ian\",-75],PARAMETER[\"false_easting\",16500000],PARAMET");
    add_srs_wkt (p, 13,
        "ER[\"false_northing\",2500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 15,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"6100\"]]");
    p = add_epsg_def_ex (filter, first, last, 6101, "epsg", 6101,
        "NAD83(CSRS) / EPSG Arctic zone 3-25", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-129 +x_0=25500000 +y_0=3500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",80.33333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",77],PARAMETER[\"latitude_of_origin\",78.");
    add_srs_wkt (p, 11,
        "70733752777778],PARAMETER[\"central_meridian\",-129],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",25500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 13,
        "thing\",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"6101\"]]");
    p = add_epsg_def_ex (filter, first, last, 6102, "epsg", 6102,
        "NAD83(CSRS) / EPSG Arctic zone 3-27", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-99 +x_0=27500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",80.33333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",77],PARAMETER[\"latitude_of_origin\",78.");
    add_srs_wkt (p, 11,
        "70733752777778],PARAMETER[\"central_meridian\",-99],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",27500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"6102\"]]");
    p = add_epsg_def_ex (filter, first, last, 6103, "epsg", 6103,
        "NAD83(CSRS) / EPSG Arctic zone 3-29", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-69 +x_0=29500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",80.33333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",77],PARAMETER[\"latitude_of_origin\",78.");
    add_srs_wkt (p, 11,
        "70733752777778],PARAMETER[\"central_meridian\",-69],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",29500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"6103\"]]");
    p = add_epsg_def_ex (filter, first, last, 6104, "epsg", 6104,
        "NAD83(CSRS) / EPSG Arctic zone 4-14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-129 +x_0=14500000 +y_0=4500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",77],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",73.66666666666667],PARAMETER[\"latitude_of_origin\",75.");
    add_srs_wkt (p, 11,
        "36440330555556],PARAMETER[\"central_meridian\",-129],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",14500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 13,
        "thing\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"6104\"]]");
    p = add_epsg_def_ex (filter, first, last, 6105, "epsg", 6105,
        "NAD83(CSRS) / EPSG Arctic zone 4-16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-104 +x_0=16500000 +y_0=4500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",77],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",73.66666666666667],PARAMETER[\"latitude_of_origin\",75.");
    add_srs_wkt (p, 11,
        "36440330555556],PARAMETER[\"central_meridian\",-104],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",16500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 13,
        "thing\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"6105\"]]");
    p = add_epsg_def_ex (filter, first, last, 6106, "epsg", 6106,
        "NAD83(CSRS) / EPSG Arctic zone 4-18", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-79 +x_0=18500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",77],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",73.66666666666667],PARAMETER[\"latitude_of_origin\",75.");
    add_srs_wkt (p, 11,
        "36440330555556],PARAMETER[\"central_meridian\",-79],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",18500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"6106\"]]");
    p = add_epsg_def_ex (filter, first, last, 6107, "epsg", 6107,
        "NAD83(CSRS) / EPSG Arctic zone 5-33", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-131 +x_0=33500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-33\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",73.66666666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",70.33333333333333],PARAMETER[\"latitude_");
    add_srs_wkt (p, 11,
        "of_origin\",72.02500919444444],PARAMETER[\"central_merid");
    add_srs_wkt (p, 12,
        "ian\",-131],PARAMETER[\"false_easting\",33500000],PARAME");
    add_srs_wkt (p, 13,
        "TER[\"false_northing\",5500000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 15,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"6107\"]]");
    p = add_epsg_def_ex (filter, first, last, 6108, "epsg", 6108,
        "NAD83(CSRS) / EPSG Arctic zone 5-35", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-111 +x_0=35500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-35\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",73.66666666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",70.33333333333333],PARAMETER[\"latitude_");
    add_srs_wkt (p, 11,
        "of_origin\",72.02500919444444],PARAMETER[\"central_merid");
    add_srs_wkt (p, 12,
        "ian\",-111],PARAMETER[\"false_easting\",35500000],PARAME");
    add_srs_wkt (p, 13,
        "TER[\"false_northing\",5500000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 15,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"6108\"]]");
    p = add_epsg_def_ex (filter, first, last, 6109, "epsg", 6109,
        "NAD83(CSRS) / EPSG Arctic zone 5-37", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-91 +x_0=37500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-37\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",73.66666666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",70.33333333333333],PARAMETER[\"latitude_");
    add_srs_wkt (p, 11,
        "of_origin\",72.02500919444444],PARAMETER[\"central_merid");
    add_srs_wkt (p, 12,
        "ian\",-91],PARAMETER[\"false_easting\",37500000],PARAMET");
    add_srs_wkt (p, 13,
        "ER[\"false_northing\",5500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 15,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"6109\"]]");
    p = add_epsg_def_ex (filter, first, last, 6110, "epsg", 6110,
        "NAD83(CSRS) / EPSG Arctic zone 5-39", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-71 +x_0=39500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-39\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",73.66666666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",70.33333333333333],PARAMETER[\"latitude_");
    add_srs_wkt (p, 11,
        "of_origin\",72.02500919444444],PARAMETER[\"central_merid");
    add_srs_wkt (p, 12,
        "ian\",-71],PARAMETER[\"false_easting\",39500000],PARAMET");
    add_srs_wkt (p, 13,
        "ER[\"false_northing\",5500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 15,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"6110\"]]");
    p = add_epsg_def_ex (filter, first, last, 6111, "epsg", 6111,
        "NAD83(CSRS) / EPSG Arctic zone 6-18", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-132 +x_0=18500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",70.33333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",67],PARAMETER[\"latitude_of_origin\",68.");
    add_srs_wkt (p, 11,
        "68747555555557],PARAMETER[\"central_meridian\",-132],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",18500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 13,
        "thing\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"6111\"]]");
    p = add_epsg_def_ex (filter, first, last, 6112, "epsg", 6112,
        "NAD83(CSRS) / EPSG Arctic zone 6-20", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-113 +x_0=20500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",70.33333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",67],PARAMETER[\"latitude_of_origin\",68.");
    add_srs_wkt (p, 11,
        "68747555555557],PARAMETER[\"central_meridian\",-113],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",20500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 13,
        "thing\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"6112\"]]");
    p = add_epsg_def_ex (filter, first, last, 6113, "epsg", 6113,
        "NAD83(CSRS) / EPSG Arctic zone 6-22", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-94 +x_0=22500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",70.33333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",67],PARAMETER[\"latitude_of_origin\",68.");
    add_srs_wkt (p, 11,
        "68747555555557],PARAMETER[\"central_meridian\",-94],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",22500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"6113\"]]");
    p = add_epsg_def_ex (filter, first, last, 6114, "epsg", 6114,
        "NAD83(CSRS) / EPSG Arctic zone 6-24", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-75 +x_0=24500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",70.33333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",67],PARAMETER[\"latitude_of_origin\",68.");
    add_srs_wkt (p, 11,
        "68747555555557],PARAMETER[\"central_meridian\",-75],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",24500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"6114\"]]");
    p = add_epsg_def_ex (filter, first, last, 6115, "epsg", 6115,
        "WGS 84 / EPSG Arctic zone 1-27", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=30 +x_0=27500000 +y_0=1500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-27\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",87],PARAMETER[\"standard_parallel_2\",83.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",85.43711833333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"central_meridian\",30],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",27500000],PARAMETER[\"false_northing\",15000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6115\"]]");
    p = add_epsg_def_ex (filter, first, last, 6116, "epsg", 6116,
        "WGS 84 / EPSG Arctic zone 1-29", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=90 +x_0=29500000 +y_0=1500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-29\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",87],PARAMETER[\"standard_parallel_2\",83.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",85.43711833333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"central_meridian\",90],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",29500000],PARAMETER[\"false_northing\",15000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6116\"]]");
    p = add_epsg_def_ex (filter, first, last, 6117, "epsg", 6117,
        "WGS 84 / EPSG Arctic zone 1-31", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=150 +x_0=31500000 +y_0=1500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-31\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",87],PARAMETER[\"standard_parallel_2\",83.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",85.43711833333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"central_meridian\",150],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",31500000],PARAMETER[\"false_northing\",1500");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6117\"]]");
    p = add_epsg_def_ex (filter, first, last, 6118, "epsg", 6118,
        "WGS 84 / EPSG Arctic zone 1-21", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-150 +x_0=21500000 +y_0=1500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",87],PARAMETER[\"standard_parallel_2\",83.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",85.43711833333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"central_meridian\",-150],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",21500000],PARAMETER[\"false_northing\",150");
    add_srs_wkt (p, 12,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6118\"]]");
    p = add_epsg_def_ex (filter, first, last, 6119, "epsg", 6119,
        "WGS 84 / EPSG Arctic zone 2-28", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=133 +x_0=28500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-28\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",83.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",80.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",82.05842488888888],PARAMETER[\"central_meridian\",133],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",28500000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"6119\"]]");
    p = add_epsg_def_ex (filter, first, last, 6120, "epsg", 6120,
        "WGS 84 / EPSG Arctic zone 2-10", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=166 +x_0=10500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-10\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",83.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",80.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",82.05842488888888],PARAMETER[\"central_meridian\",166],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",10500000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"6120\"]]");
    p = add_epsg_def_ex (filter, first, last, 6121, "epsg", 6121,
        "WGS 84 / EPSG Arctic zone 2-12", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-154 +x_0=12500000 +");
    add_proj4text (p, 2,
        "y_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-12\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",83.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",80.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",82.05842488888888],PARAMETER[\"central_meridian\",-154]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",12500000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"6121\"]]");
    p = add_epsg_def_ex (filter, first, last, 6122, "epsg", 6122,
        "WGS 84 / EPSG Arctic zone 3-21", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=176 +x_0=21500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",80.33333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",77],PARAMETER[\"latitude_of_origin\",78.70733752777");
    add_srs_wkt (p, 10,
        "778],PARAMETER[\"central_meridian\",176],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",21500000],PARAMETER[\"false_northing\",3500");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6122\"]]");
    p = add_epsg_def_ex (filter, first, last, 6123, "epsg", 6123,
        "WGS 84 / EPSG Arctic zone 3-23", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-153 +x_0=23500000 +y_0=3500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-23\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",80.33333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",77],PARAMETER[\"latitude_of_origin\",78.70733752777");
    add_srs_wkt (p, 10,
        "778],PARAMETER[\"central_meridian\",-153],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",23500000],PARAMETER[\"false_northing\",350");
    add_srs_wkt (p, 12,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6123\"]]");
    p = add_epsg_def_ex (filter, first, last, 6124, "epsg", 6124,
        "WGS 84 / EPSG Arctic zone 4-12", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-155 +x_0=12500000 +y_0=4500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-12\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",75.36440330555");
    add_srs_wkt (p, 10,
        "556],PARAMETER[\"central_meridian\",-155],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",12500000],PARAMETER[\"false_northing\",450");
    add_srs_wkt (p, 12,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6124\"]]");
    p = add_epsg_def_ex (filter, first, last, 6125, "epsg", 6125,
        "ETRS89 / EPSG Arctic zone 5-47", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-5 +x_0=47500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-47\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",73.66666666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",70.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",72.02500919444444],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",47500000],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"6125\"]]");
    p = add_epsg_def_ex (filter, first, last, 6128, "epsg", 6128,
        "Grand Cayman National Grid 1959", 0, 0,
        "Clarke 1866", "Greenwich",
        "Grand_Cayman_Geodetic_Datum_1959", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=-179.483,-69.3");
    add_proj4text (p, 1,
        "79,-27.584,-7.862,8.163,6.042,-13.925 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Grand Cayman National Grid 1959\",GEOGCS[\"GCGD");
    add_srs_wkt (p, 1,
        "59\",DATUM[\"Grand_Cayman_Geodetic_Datum_1959\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],TOWGS84[-179.483,-69.379,-27.584,-7.86");
    add_srs_wkt (p, 4,
        "2,8.163,6.042,-13.925],AUTHORITY[\"EPSG\",\"6723\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4723\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",1640419.9475],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"6128\"]]");
    p = add_epsg_def_ex (filter, first, last, 6129, "epsg", 6129,
        "Sister Islands National Grid 1961", 0, 0,
        "Clarke 1866", "Greenwich",
        "Sister_Islands_Geodetic_Datum_1961", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=8.853,-52.644,");
    add_proj4text (p, 1,
        "180.304,-0.393,-2.323,2.96,-24.081 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sister Islands National Grid 1961\",GEOGCS[\"SI");
    add_srs_wkt (p, 1,
        "GD61\",DATUM[\"Sister_Islands_Geodetic_Datum_1961\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7008\"]],TOWGS84[8.853,-52.644,180.304,-0.");
    add_srs_wkt (p, 4,
        "393,-2.323,2.96,-24.081],AUTHORITY[\"EPSG\",\"6726\"]],P");
    add_srs_wkt (p, 5,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 6,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 7,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 8,
        "UTHORITY[\"EPSG\",\"4726\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 9,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-81],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 11,
        "6],PARAMETER[\"false_easting\",1640419.9475],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"6129\"]]");
    p = add_epsg_def_ex (filter, first, last, 6135, "epsg", 6135,
        "CIGD11", 1, 1,
        "GRS 1980", "Greenwich",
        "Cayman_Islands_Geodetic_Datum_2011", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CIGD11\",DATUM[\"Cayman_Islands_Geodetic_Datum_");
    add_srs_wkt (p, 1,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"1100\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6135\"]]");
    p = add_epsg_def_ex (filter, first, last, 6141, "epsg", 6141,
        "Cayman Islands National Grid 2011 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Cayman_Islands_Geodetic_Datum_2011", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19.33333333333333 +lat_2=19.7 +lat_0=19");
    add_proj4text (p, 1,
        ".33333333333333 +lon_0=80.56666666666666 +x_0=899160 +y_");
    add_proj4text (p, 2,
        "0=579120 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cayman Islands National Grid 2011 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"CIGD11\",DATUM[\"Cayman_Islands_Geodetic_Datum");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1100\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6135\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_1\",19.33333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",19.7],PARAMETER[\"latitude_of_origin\",1");
    add_srs_wkt (p, 11,
        "9.33333333333333],PARAMETER[\"central_meridian\",80.5666");
    add_srs_wkt (p, 12,
        "6666666666],PARAMETER[\"false_easting\",2950000],PARAMET");
    add_srs_wkt (p, 13,
        "ER[\"false_northing\",1900000],UNIT[\"foot\",0.3048,AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"6141\"]]");
    p = add_epsg_def_ex (filter, first, last, 6144, "epsg", 6144,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + NN54 height\",GEOGCS[\"ETRS89\",DATU");
    add_srs_wkt (p, 1,
        "M[\"European_Terrestrial_Reference_System_1989\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4258\"]],VERT_CS[\"NN54 heig");
    add_srs_wkt (p, 8,
        "ht\",VERT_DATUM[\"Norway Normal Null 1954\",2005,AUTHORI");
    add_srs_wkt (p, 9,
        "TY[\"EPSG\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 10,
        "\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"");
    add_srs_wkt (p, 11,
        "]],AUTHORITY[\"EPSG\",\"6144\"]]");
    p = add_epsg_def_ex (filter, first, last, 6145, "epsg", 6145,
        "ETRS89 / NTM zone 5", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=5.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 5 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 5\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",5.5],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",100000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"5105\"]],VERT_CS[\"NN54 height\",VERT");
    add_srs_wkt (p, 15,
        "_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 17,
        "\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHO");
    add_srs_wkt (p, 18,
        "RITY[\"EPSG\",\"6145\"]]");
    p = add_epsg_def_ex (filter, first, last, 6146, "epsg", 6146,
        "ETRS89 / NTM zone 6", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 6 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 6\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",6.5],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",100000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"5106\"]],VERT_CS[\"NN54 height\",VERT");
    add_srs_wkt (p, 15,
        "_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 17,
        "\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHO");
    add_srs_wkt (p, 18,
        "RITY[\"EPSG\",\"6146\"]]");
    p = add_epsg_def_ex (filter, first, last, 6147, "epsg", 6147,
        "ETRS89 / NTM zone 7", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=7.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 7 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 7\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",7.5],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",100000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"5107\"]],VERT_CS[\"NN54 height\",VERT");
    add_srs_wkt (p, 15,
        "_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 17,
        "\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHO");
    add_srs_wkt (p, 18,
        "RITY[\"EPSG\",\"6147\"]]");
    p = add_epsg_def_ex (filter, first, last, 6148, "epsg", 6148,
        "ETRS89 / NTM zone 8", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=8.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 8 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 8\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",8.5],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",100000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"5108\"]],VERT_CS[\"NN54 height\",VERT");
    add_srs_wkt (p, 15,
        "_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 17,
        "\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHO");
    add_srs_wkt (p, 18,
        "RITY[\"EPSG\",\"6148\"]]");
    p = add_epsg_def_ex (filter, first, last, 6149, "epsg", 6149,
        "ETRS89 / NTM zone 9", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=9.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 9 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 9\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",9.5],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",100000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"5109\"]],VERT_CS[\"NN54 height\",VERT");
    add_srs_wkt (p, 15,
        "_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 17,
        "\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHO");
    add_srs_wkt (p, 18,
        "RITY[\"EPSG\",\"6149\"]]");
    p = add_epsg_def_ex (filter, first, last, 6150, "epsg", 6150,
        "ETRS89 / NTM zone 10", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 10 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 10\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",10.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5110\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6150\"]]");
    p = add_epsg_def_ex (filter, first, last, 6151, "epsg", 6151,
        "ETRS89 / NTM zone 11", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=11.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 11 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 11\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",11.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5111\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6151\"]]");
    p = add_epsg_def_ex (filter, first, last, 6152, "epsg", 6152,
        "ETRS89 / NTM zone 12", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=12.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 12 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 12\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",12.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5112\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6152\"]]");
    p = add_epsg_def_ex (filter, first, last, 6153, "epsg", 6153,
        "ETRS89 / NTM zone 13", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=13.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 13 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 13\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",13.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5113\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6153\"]]");
    p = add_epsg_def_ex (filter, first, last, 6154, "epsg", 6154,
        "ETRS89 / NTM zone 14", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 14 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 14\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",14.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5114\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6154\"]]");
    p = add_epsg_def_ex (filter, first, last, 6155, "epsg", 6155,
        "ETRS89 / NTM zone 15", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=15.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 15 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 15\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",15.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5115\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6155\"]]");
    p = add_epsg_def_ex (filter, first, last, 6156, "epsg", 6156,
        "ETRS89 / NTM zone 16", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=16.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 16 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 16\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",16.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5116\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6156\"]]");
    p = add_epsg_def_ex (filter, first, last, 6157, "epsg", 6157,
        "ETRS89 / NTM zone 17", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=17.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 17 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 17\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",17.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5117\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6157\"]]");
    p = add_epsg_def_ex (filter, first, last, 6158, "epsg", 6158,
        "ETRS89 / NTM zone 18", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 18 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 18\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",18.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5118\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6158\"]]");
    p = add_epsg_def_ex (filter, first, last, 6159, "epsg", 6159,
        "ETRS89 / NTM zone 19", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=19.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 19 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 19\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",19.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5119\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6159\"]]");
    p = add_epsg_def_ex (filter, first, last, 6160, "epsg", 6160,
        "ETRS89 / NTM zone 20", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=20.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 20 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 20\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",20.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5120\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6160\"]]");
    p = add_epsg_def_ex (filter, first, last, 6161, "epsg", 6161,
        "ETRS89 / NTM zone 21", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=21.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 21 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 21\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",21.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5121\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6161\"]]");
    p = add_epsg_def_ex (filter, first, last, 6162, "epsg", 6162,
        "ETRS89 / NTM zone 22", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=22.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 22 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 22\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",22.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5122\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6162\"]]");
    p = add_epsg_def_ex (filter, first, last, 6163, "epsg", 6163,
        "ETRS89 / NTM zone 23", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=23.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 23 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 23\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",23.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5123\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6163\"]]");
    p = add_epsg_def_ex (filter, first, last, 6164, "epsg", 6164,
        "ETRS89 / NTM zone 24", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=24.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 24 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 24\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",24.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5124\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6164\"]]");
    p = add_epsg_def_ex (filter, first, last, 6165, "epsg", 6165,
        "ETRS89 / NTM zone 25", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=25.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 25 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 25\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",25.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5125\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6165\"]]");
    p = add_epsg_def_ex (filter, first, last, 6166, "epsg", 6166,
        "ETRS89 / NTM zone 26", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=26.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 26 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 26\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",26.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5126\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6166\"]]");
    p = add_epsg_def_ex (filter, first, last, 6167, "epsg", 6167,
        "ETRS89 / NTM zone 27", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=27.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 27 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 27\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",27.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5127\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6167\"]]");
    p = add_epsg_def_ex (filter, first, last, 6168, "epsg", 6168,
        "ETRS89 / NTM zone 28", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=28.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 28 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 28\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",28.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5128\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6168\"]]");
    p = add_epsg_def_ex (filter, first, last, 6169, "epsg", 6169,
        "ETRS89 / NTM zone 29", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=29.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 29 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 29\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",29.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5129\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6169\"]]");
    p = add_epsg_def_ex (filter, first, last, 6170, "epsg", 6170,
        "ETRS89 / NTM zone 30", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=30.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 30 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 30\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 5,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",30.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5130\"]],VERT_CS[\"NN54 height\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 17,
        "1\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"6170\"]]");
    p = add_epsg_def_ex (filter, first, last, 6171, "epsg", 6171,
        "ETRS89 / UTM zone 31N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 31 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / UTM zone 31N\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",3],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"25831\"]],VERT_CS[\"NN54 height\",VERT_D");
    add_srs_wkt (p, 15,
        "ATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 17,
        "]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHORI");
    add_srs_wkt (p, 18,
        "TY[\"EPSG\",\"6171\"]]");
    p = add_epsg_def_ex (filter, first, last, 6172, "epsg", 6172,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 32 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",9],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"25832\"]],VERT_CS[\"NN54 height\",VERT_D");
    add_srs_wkt (p, 15,
        "ATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 17,
        "]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHORI");
    add_srs_wkt (p, 18,
        "TY[\"EPSG\",\"6172\"]]");
    p = add_epsg_def_ex (filter, first, last, 6173, "epsg", 6173,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 33 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",15],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"25833\"]],VERT_CS[\"NN54 height\",VERT_D");
    add_srs_wkt (p, 15,
        "ATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 17,
        "]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHORI");
    add_srs_wkt (p, 18,
        "TY[\"EPSG\",\"6173\"]]");
    p = add_epsg_def_ex (filter, first, last, 6174, "epsg", 6174,
        "ETRS89 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 34 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / UTM zone 34N\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"25834\"]],VERT_CS[\"NN54 height\",VERT_D");
    add_srs_wkt (p, 15,
        "ATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 17,
        "]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHORI");
    add_srs_wkt (p, 18,
        "TY[\"EPSG\",\"6174\"]]");
    p = add_epsg_def_ex (filter, first, last, 6175, "epsg", 6175,
        "ETRS89 / UTM zone 35N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 35 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / UTM zone 35N\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",27],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"25835\"]],VERT_CS[\"NN54 height\",VERT_D");
    add_srs_wkt (p, 15,
        "ATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 17,
        "]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHORI");
    add_srs_wkt (p, 18,
        "TY[\"EPSG\",\"6175\"]]");
    p = add_epsg_def_ex (filter, first, last, 6176, "epsg", 6176,
        "ETRS89 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 36 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / UTM zone 36N\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",33],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"25836\"]],VERT_CS[\"NN54 height\",VERT_D");
    add_srs_wkt (p, 15,
        "ATUM[\"Norway Normal Null 1954\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5174\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 17,
        "]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTHORI");
    add_srs_wkt (p, 18,
        "TY[\"EPSG\",\"6176\"]]");
    p = add_epsg_def_ex (filter, first, last, 6190, "epsg", 6190,
        "Belge 1972 / Belgian Lambert 72", 0, 0,
        "International 1924", "Greenwich",
        "Reseau_National_Belge_1972", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=51.16666723333333 +lat_2=49.8333339 +la");
    add_proj4text (p, 1,
        "t_0=90 +lon_0=4.367486666666666 +x_0=150000.013 +y_0=540");
    add_proj4text (p, 2,
        "0088.438 +ellps=intl +towgs84=-106.8686,52.2978,-103.723");
    add_proj4text (p, 3,
        "9,0.3366,-0.457,1.8422,-1.2747 +units=m +vunits=m +no_de");
    add_proj4text (p, 4,
        "fs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Belge 1972 / Belgian Lambert 72 + Ostend heig");
    add_srs_wkt (p, 1,
        "ht\",PROJCS[\"Belge 1972 / Belgian Lambert 72\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "Belge 1972\",DATUM[\"Reseau_National_Belge_1972\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7022\"]],TOWGS84[-106.8686,52.2978,-103.7239,0.3366,-");
    add_srs_wkt (p, 5,
        "0.457,1.8422,-1.2747],AUTHORITY[\"EPSG\",\"6313\"]],PRIM");
    add_srs_wkt (p, 6,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 7,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 8,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 9,
        "ORITY[\"EPSG\",\"4313\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 10,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",51.16666");
    add_srs_wkt (p, 11,
        "723333333],PARAMETER[\"standard_parallel_2\",49.8333339]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"latitude_of_origin\",90],PARAMETER[\"centra");
    add_srs_wkt (p, 13,
        "l_meridian\",4.367486666666666],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 14,
        "g\",150000.013],PARAMETER[\"false_northing\",5400088.438");
    add_srs_wkt (p, 15,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 16,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"31370\"");
    add_srs_wkt (p, 17,
        "]],VERT_CS[\"Ostend height\",VERT_DATUM[\"Ostend\",2005,");
    add_srs_wkt (p, 18,
        "AUTHORITY[\"EPSG\",\"5110\"]],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 19,
        "[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 20,
        "\"5710\"]],AUTHORITY[\"EPSG\",\"6190\"]]");
    p = add_epsg_def_ex (filter, first, last, 6204, "epsg", 6204,
        "Macedonian State Coordinate System", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Y", "East", "X", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Macedonian State Coordinate System\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",21],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "99],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Y\",EAST],AXIS[\"X\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"6204\"]]");
    p = add_epsg_def_ex (filter, first, last, 6207, "epsg", 6207,
        "Nepal 1981", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Nepal_1981", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.413140239 +towgs");
    add_proj4text (p, 1,
        "84=293.17,726.18,245.36,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nepal 1981\",DATUM[\"Nepal_1981\",SPHEROID[\"Ev");
    add_srs_wkt (p, 1,
        "erest 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7015\"]],TOWGS84[293.17,726.18,245.36,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"1111\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"6207\"]]");
    p = add_epsg_def_ex (filter, first, last, 6210, "epsg", 6210,
        "SIRGAS 2000 / UTM zone 23N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 23N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4674");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-45]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6210");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6211, "epsg", 6211,
        "SIRGAS 2000 / UTM zone 24N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 24N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4674");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-39]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6211");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6316, "epsg", 6316,
        "Macedonia State Coordinate System zone 7", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Y", "East", "X", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Macedonia State Coordinate System zone 7\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"MGI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 2,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"103");
    add_srs_wkt (p, 4,
        "1\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",21],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",7500000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Y\",EAST],AXIS[\"X\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6316\"]]");
    p = add_epsg_def_ex (filter, first, last, 6318, "epsg", 6318,
        "NAD83(2011)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]]");
    p = add_epsg_def_ex (filter, first, last, 6322, "epsg", 6322,
        "NAD83(PA11)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_PA11", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(PA11)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System_PA11\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1117\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"6322\"]]");
    p = add_epsg_def_ex (filter, first, last, 6325, "epsg", 6325,
        "NAD83(MA11)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_MA11", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(MA11)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System_MA11\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 2,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1118\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"6325\"]]");
    p = add_epsg_def_ex (filter, first, last, 6328, "epsg", 6328,
        "NAD83(2011) / UTM zone 59N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 59N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",171],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6328\"]]");
    p = add_epsg_def_ex (filter, first, last, 6329, "epsg", 6329,
        "NAD83(2011) / UTM zone 60N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 60N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",177],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6329\"]]");
    p = add_epsg_def_ex (filter, first, last, 6330, "epsg", 6330,
        "NAD83(2011) / UTM zone 1N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 1N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-177],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6330\"]]");
    p = add_epsg_def_ex (filter, first, last, 6331, "epsg", 6331,
        "NAD83(2011) / UTM zone 2N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 2N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-171],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6331\"]]");
    p = add_epsg_def_ex (filter, first, last, 6332, "epsg", 6332,
        "NAD83(2011) / UTM zone 3N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 3N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-165],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6332\"]]");
    p = add_epsg_def_ex (filter, first, last, 6333, "epsg", 6333,
        "NAD83(2011) / UTM zone 4N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 4N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-159],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6333\"]]");
    p = add_epsg_def_ex (filter, first, last, 6334, "epsg", 6334,
        "NAD83(2011) / UTM zone 5N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 5N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-153],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6334\"]]");
    p = add_epsg_def_ex (filter, first, last, 6335, "epsg", 6335,
        "NAD83(2011) / UTM zone 6N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 6N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-147],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6335\"]]");
    p = add_epsg_def_ex (filter, first, last, 6336, "epsg", 6336,
        "NAD83(2011) / UTM zone 7N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 7N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-141],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6336\"]]");
    p = add_epsg_def_ex (filter, first, last, 6337, "epsg", 6337,
        "NAD83(2011) / UTM zone 8N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 8N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-135],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6337\"]]");
    p = add_epsg_def_ex (filter, first, last, 6338, "epsg", 6338,
        "NAD83(2011) / UTM zone 9N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 9N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-129],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6338\"]]");
    p = add_epsg_def_ex (filter, first, last, 6339, "epsg", 6339,
        "NAD83(2011) / UTM zone 10N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 10N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-123],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6339\"]]");
    p = add_epsg_def_ex (filter, first, last, 6340, "epsg", 6340,
        "NAD83(2011) / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 11N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-117],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6340\"]]");
    p = add_epsg_def_ex (filter, first, last, 6341, "epsg", 6341,
        "NAD83(2011) / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 12N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-111],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6341\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

