9.1 ライブコーディングの基本

# ライブコーディング

実際に楽みながら演奏をする方法を十分に学んできました。この章では、
これまでのすべての章から、どの様に作曲を開始し、ライブパフォーマンスに繋げるかを紹介していきます。
そのために3つの主な要素が必要になります。

* チェック要素：音を作るコードを書く能力
* チェック要素：ファンクション(関数)を作成する能力
* チェック要素：(名前付き) スレッドを使う能力

よーし、始めましょう。最初の音をライブコーディングしましょう。まず演奏したいコード含む関数が必要です。
簡単なところから始めましょう。スレッドでその関数を呼び出すループもほしいところです。

```
define :my_loop do
 play 50
 sleep 1
end

in_thread(name: :looper) do
 loop do
   my_loop
 end
end
```

もしそれが少し複雑に見える場合は、ファンクション（関数）とスレッドのセクションに戻って
復習してください。 既にこれらを頭に焼き付けているならば、それほど複雑ではありません。
ここにあるものは、単に`play 50`を演奏し、ビートのために`sleep 1`を実行するファンクション(関数)です。
そして`my_loop`を呼び出し、繰り返しを実行する`:looper`という名前付きスレッドを定義しています。
このコードを実行すると、音符50を何度も何度も繰り返します。

## チェンジアップ（変化）させる

これから楽しみが始まります。コードを*実行しながら*、50を別の数値55に変更し、もう一度*Run*ボタンを押してみましょう。すごい迫力!変化しましたね!ライブ!

スレッドそれぞれに別の名前を使うことによって、新しいレイヤは追加されせんでした。
そのうえ、そのファンクション（関数）が再定義されることより、音が変化しました。
`:my_loop`に新しい定義を与えると、`:looper`スレッドが新しい定義付けを繰り返します。  

スリープ時間をや音符を変更し、再び試してみてください。どのように`use_synthを追加するには
どうすればよいのでしょうか。たとえば、次のように変更します。

```
define :my_loop do
  use_synth :tb303
  play 50, release: 0.3
  sleep 0.25
end
```

かなり面白くなってきましたが、それをさらに盛り上げることができます。
代わりに、何度も何度も同じ音を再生する、和音を弾いてみましょう：

```
define :my_loop do
  use_synth :tb303
  play chord(:e3, :minor), release: 0.3
  sleep 0.5
end
```

コードからランダムな音階を演奏するにはどうでしょう。

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.3
  sleep 0.25
end
```

またはランダムなカットオフ値を使用してみましょう。

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

最後に、いくつかのドラムを追加しましょう。

```
define :my_loop do
  use_synth :tb303
  sample :drum_bass_hard, rate: rrand(0.5, 2)
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

どんどんおもしろくなってきましたね!

しかしながら、ファンクション（関数）とスレッドを使ったライブコーディングにステップアップする前に、
一息ついて、Sonic Piで永遠にコードを変える方法`live_loop`について次の章を読んでいきましょう。
