/* -------------------------------------------------------------------- */
/* SMS Client, send messages to mobile phones and pagers		*/
/*									*/
/* ia5table.h								*/
/*									*/
/*  Copyright (C) 1997,1998,1999 Angelo Masci				*/
/*									*/
/*  This library is free software; you can redistribute it and/or	*/
/*  modify it under the terms of the GNU Library General Public		*/
/*  License as published by the Free Software Foundation; either	*/
/*  version 2 of the License, or (at your option) any later version.	*/
/*									*/
/*  This library is distributed in the hope that it will be useful,	*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of	*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU	*/
/*  Library General Public License for more details.			*/
/*									*/
/*  You should have received a copy of the GNU Library General Public	*/
/*  License along with this library; if not, write to the Free		*/
/*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	*/
/*									*/
/*  You can contact the author at this e-mail address:			*/
/*									*/
/*  angelo@styx.demon.co.uk						*/
/*									*/
/* -------------------------------------------------------------------- */
/* $Id$
   -------------------------------------------------------------------- */

#include "ia5table.h"
#include <stdio.h>

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */


static int ia5table[] = 
{
	/* [00]   */ 0x20, /* [01]   */ 0x20, /* [02]   */ 0x20, /* [03]   */ 0x20, 
	/* [04]   */ 0x20, /* [05]   */ 0x20, /* [06]   */ 0x20, /* [07]   */ 0x20, 
	/* [08]   */ 0x20, /* [09]   */ 0x20, /* [0A] # */ 0x0A, /* [0B]   */ 0x20, 
	/* [0C]   */ 0x20, /* [0D] # */ 0x0D, /* [0E]   */ 0x20, /* [0F]   */ 0x20, 
	/* [10]   */ 0x20, /* [11]   */ 0x20, /* [12]   */ 0x20, /* [13]   */ 0x20, 
	/* [14]   */ 0x20, /* [15]   */ 0x20, /* [16]   */ 0x20, /* [17]   */ 0x20, 
	/* [18]   */ 0x20, /* [19]   */ 0x20, /* [1A]   */ 0x20, /* [1B] # */ 0x1B, 
	/* [1C]   */ 0x20, /* [1D]   */ 0x20, /* [1E]   */ 0x20, /* [1F]   */ 0x20, 
	/* [20]   */ 0x20, /* [21] ! */ 0x21, /* [22] " */ 0x22, /* [23] # */ 0x23, 
	/* [24] $ */ 0x24, /* [25] % */ 0x25, /* [26] & */ 0x26, /* [27] ' */ 0x27, 
	/* [28] ( */ 0x28, /* [29] ) */ 0x29, /* [2A] * */ 0x2A, /* [2B] + */ 0x2B, 
	/* [2C] , */ 0x2C, /* [2D] - */ 0x2D, /* [2E] . */ 0x2E, /* [2F] / */ 0x2F, 
	/* [30] 0 */ 0x30, /* [31] 1 */ 0x31, /* [32] 2 */ 0x32, /* [33] 3 */ 0x33, 
	/* [34] 4 */ 0x34, /* [35] 5 */ 0x35, /* [36] 6 */ 0x36, /* [37] 7 */ 0x37, 
	/* [38] 8 */ 0x38, /* [39] 9 */ 0x39, /* [3A] : */ 0x3A, /* [3B] ; */ 0x3B, 
	/* [3C] < */ 0x3C, /* [3D] = */ 0x3D, /* [3E] > */ 0x3E, /* [3F] ? */ 0x3F, 
	/* [40] @ */ 0x40, /* [41] A */ 0x41, /* [42] B */ 0x42, /* [43] C */ 0x43, 
	/* [44] D */ 0x44, /* [45] E */ 0x45, /* [46] F */ 0x46, /* [47] G */ 0x47, 
	/* [48] H */ 0x48, /* [49] I */ 0x49, /* [4A] J */ 0x4A, /* [4B] K */ 0x4B, 
	/* [4C] L */ 0x4C, /* [4D] M */ 0x4D, /* [4E] N */ 0x4E, /* [4F] O */ 0x4F, 
	/* [50] P */ 0x50, /* [51] Q */ 0x51, /* [52] R */ 0x52, /* [53] S */ 0x53, 
	/* [54] T */ 0x54, /* [55] U */ 0x55, /* [56] V */ 0x56, /* [57] W */ 0x57, 
	/* [58] X */ 0x58, /* [59] Y */ 0x59, /* [5A] Z */ 0x5A, /* [5B]  */ 0x5B, 
	/* [5C]  */ 0x5C, /* [5D]  */ 0x5D, /* [5E]  */ 0x5E, /* [5F] # */ 0x11, 
	/* [60]   */ 0x20, /* [61] a */ 0x61, /* [62] b */ 0x62, /* [63] c */ 0x63, 
	/* [64] d */ 0x64, /* [65] e */ 0x65, /* [66] f */ 0x66, /* [67] g */ 0x67, 
	/* [68] h */ 0x68, /* [69] i */ 0x69, /* [6A] j */ 0x6A, /* [6B] k */ 0x6B, 
	/* [6C] l */ 0x6C, /* [6D] m */ 0x6D, /* [6E] n */ 0x6E, /* [6F] o */ 0x6F, 
	/* [70] p */ 0x70, /* [71] q */ 0x71, /* [72] r */ 0x72, /* [73] s */ 0x73, 
	/* [74] t */ 0x74, /* [75] u */ 0x75, /* [76] v */ 0x76, /* [77] w */ 0x77, 
	/* [78] x */ 0x78, /* [79] y */ 0x79, /* [7A] z */ 0x7A, /* [7B]  */ 0x7B, 
	/* [7C]  */ 0x7C, /* [7D]  */ 0x7D, /* [7E]  */ 0x7E, /* [7F]   */ 0x20, 
	/* [80] # */ 0x09, /* [81] # */ 0x10, /* [82] # */ 0x05, /* [83]   */ 0x20, 
	/* [84] # */ 0x7B, /* [85] # */ 0x7F, /* [86] # */ 0x0F, /* [87]   */ 0x20, 
	/* [88]   */ 0x20, /* [89]   */ 0x20, /* [8A] # */ 0x04, /* [8B]   */ 0x20, 
	/* [8C]   */ 0x20, /* [8D] # */ 0x07, /* [8E] # */ 0x5B, /* [8F] # */ 0x0E, 
	/* [90] # */ 0x1F, /* [91] # */ 0x1D, /* [92] # */ 0x1C, /* [93]   */ 0x20, 
	/* [94] # */ 0x7C, /* [95] # */ 0x08, /* [96]   */ 0x20, /* [97] # */ 0x06, 
	/* [98]   */ 0x20, /* [99] # */ 0x5C, /* [9A] # */ 0x5E, /* [9B]   */ 0x20, 
	/* [9C] # */ 0x01, /* [9D] # */ 0x03, /* [9E]   */ 0x20, /* [9F]   */ 0x20, 
	/* [A0]   */ 0x20, /* [A1]  */ 0x00, /* [A2]   */ 0x20, /* [A3]  */ 0x01, 
	/* [A4] # */ 0x02, /* [A5]  */ 0x03, /* [A6]   */ 0x20, /* [A7]  */ 0x5E, 
	/* [A8] # */ 0x60, /* [A9]   */ 0x20, /* [AA]   */ 0x20, /* [AB]   */ 0x20, 
	/* [AC]   */ 0x20, /* [AD] # */ 0x40, /* [AE]   */ 0x20, /* [AF]   */ 0x20, 
	/* [B0]   */ 0x20, /* [B1]   */ 0x20, /* [B2]   */ 0x20, /* [B3]   */ 0x20, 
	/* [B4]   */ 0x20, /* [B5]   */ 0x20, /* [B6]   */ 0x20, /* [B7]   */ 0x20, 
	/* [B8]   */ 0x20, /* [B9]   */ 0x20, /* [BA]   */ 0x20, /* [BB]   */ 0x20, 
	/* [BC]   */ 0x20, /* [BD]   */ 0x20, /* [BE]   */ 0x20, /* [BF]  */ 0x60, 
	/* [C0]   */ 0x20, /* [C1]   */ 0x20, /* [C2]   */ 0x20, /* [C3]   */ 0x20, 
	/* [C4]  */ 0x5B, /* [C5]  */ 0x0E, /* [C6]  */ 0x1C, /* [C7]  */ 0x09, 
	/* [C8]   */ 0x20, /* [C9]  */ 0x1F, /* [CA]   */ 0x20, /* [CB]   */ 0x20, 
	/* [CC]   */ 0x20, /* [CD]   */ 0x20, /* [CE]   */ 0x20, /* [CF]   */ 0x20, 
	/* [D0]   */ 0x20, /* [D1]  */ 0x5F, /* [D2]   */ 0x20, /* [D3]   */ 0x20, 
	/* [D4]   */ 0x20, /* [D5]   */ 0x20, /* [D6]  */ 0x5C, /* [D7]   */ 0x20, 
	/* [D8]  */ 0x0B, /* [D9]   */ 0x20, /* [DA]   */ 0x20, /* [DB]   */ 0x20, 
	/* [DC]  */ 0x5D, /* [DD]   */ 0x20, /* [DE]   */ 0x20, /* [DF]  */ 0x7E,  
	/* [E0]  */ 0x7F, /* [E1]   */ 0x20, /* [E2]   */ 0x20, /* [E3]   */ 0x20, 
	/* [E4]  */ 0x7B, /* [E5]  */ 0x0F, /* [E6]  */ 0x1D, /* [E7]   */ 0x20, 
	/* [E8]  */ 0x04, /* [E9]  */ 0x05, /* [EA]   */ 0x20, /* [EB]   */ 0x20, 
	/* [EC]  */ 0x07, /* [ED]   */ 0x20, /* [EE]   */ 0x20, /* [EF]   */ 0x20, 
	/* [F0]   */ 0x20, /* [F1]  */ 0x1E, /* [F2]  */ 0x08, /* [F3]   */ 0x20, 
	/* [F4]   */ 0x20, /* [F5]   */ 0x20, /* [F6]  */ 0x7C, /* [F7]   */ 0x20, 
	/* [F8]  */ 0x0C, /* [F9]  */ 0x06, /* [FA]   */ 0x20, /* [FB]   */ 0x20, 
	/* [FC]  */ 0x7D, /* [FD]   */ 0x20, /* [FE]   */ 0x20, /* [FF]   */ 0x20
};


/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

int toia5(int c)
{
	if (c < 0)
	{
		c += 256;
	}

	if ((c >= 0) && (c <= 255))
	{	
		return (ia5table[c]);
	}

	return 0x20;
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

