
/*
 * slmon
 *
 * Copyright (C) 2000, 2001, 2002 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is partly based on WMMon.app.
 *
 * WMMon.app is copyright (c) 1997, 1998 by Martijn Pieterse and
 * Antoine Nulle.
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 * $Date: 2004/06/20 15:56:48 $
 * $Revision: 1.4 $
 *
 */

#ifndef SLMON_DRAW_H
#define SLMON_DRAW_H

#include "defines.h"
#include "stat.h"

void slmon_clear_screen(int col);
void init_slang(void);
void draw_gauge(int row, int col, int value, char *caption, int align);
void draw_status(void);
void draw_histogram(char *caption);
void draw_histogram_value(int value, int pos);
void clear_histogram(void);
void print_mem(int r, int c);
void print_keys(int mode);
void print_ldavg(int r, int c);
void print_fs(int r, int c);
int print_iface(int r, int c, char *name, unsigned long last_in, unsigned long last_out);

void draw_mode_h(void);
void draw_mode_g(void);
void draw_mode_n(void);
void draw_mode_p(void);
void draw_mode_x(void);
void draw_scrollbar(int r, int c, int h, int prct);
void slmon_status_msg(char *format, ...);

#define HELP_MODE "m main\nn network\np processes\nh histogram\n? help\n"
#define HELP_MAIN "u mem unit\nU fs unit\n-,= gauge len\nup, down scroll fs\n"
#define HELP_HIST "h histogram mode\n-,= horiz size\n_,+ vert size\n"
#define HELP_PROC "up,down,pgup,pgdown scroll list\nk SIGTERM\nK spec signal\na,A,s,S,d,D,f,F change sorting criteria"
#define HELP_NET  "u net unit\nn new interface\nd delete interface"
#define HELP_QUIT "q quit\n"

#endif
