"""Add vcard content to contact table

Revision ID: 8b993243a536
Revises: 5bd48bfdffa2
Create Date: 2024-07-24 07:02:47.770894

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "8b993243a536"
down_revision: Union[str, None] = "5bd48bfdffa2"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("contact", schema=None) as batch_op:
        batch_op.add_column(sa.Column("vcard", sa.String(), nullable=True))
        batch_op.add_column(
            sa.Column(
                "vcard_fetched",
                sa.Boolean(),
                nullable=False,
                server_default=sa.sql.true(),
            )
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("contact", schema=None) as batch_op:
        batch_op.drop_column("vcard_fetched")
        batch_op.drop_column("vcard")

    # ### end Alembic commands ###
