/* Public domain. */

#include "uint32.h"
#include "biguint.h"

/* x^-1 mod m. m must be prime. */

int bu_invmod (uint32 *x, uint32 const *m, unsigned int n)
{
  uint32 one[BIGUINT_MAXLIMBS] ;
  bu_zero(one, n) ;
  one[0] = 1 ;
  return bu_divmod(x, one, x, m, n) ;
}
