/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef IPLISTEDITOR_H
#define IPLISTEDITOR_H

#include <QWidget>
#include <QCheckBox>
#include <QTextEdit>
#include <QPushButton>
#include <QDialog>
#include <QEvent>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class IpListEditor : public QWidget
{
  Q_OBJECT
  private:
    QCheckBox*    m_useIpListChbx;
    QPushButton*  m_showEditorBtn;
    QTextEdit*    m_ipListEdit;
    QPushButton*  m_okBtn;
    QPushButton*  m_cancelBtn;
    QDialog*      m_editorDlg;

  public:
    void retranslate();

  public:
    IpListEditor(QWidget *parent = 0);
    ~IpListEditor();


  protected:
    void changeEvent(QEvent *ev)
    {
      if(ev->type() == QEvent::LanguageChange)
        retranslate();
      else
        QWidget::changeEvent(ev);
    }

  public slots:
    void init();
    void showEditor();
    void applyChanges();
    void discardChanges();
    void setUseIpList(int);
};

#endif
