# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.sitemanager.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.sitemanager.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.sitemanager.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sitemanager.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sitemanager.models.SystemData
    """


class Site(ProxyResource):
    """Site as ARM Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.sitemanager.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.sitemanager.models.SiteProperties
    """

    properties: Optional["_models.SiteProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SiteProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SiteAddressProperties(_Model):
    """Site address properties.

    :ivar street_address1: First line of the street address.
    :vartype street_address1: str
    :ivar street_address2: Second line of the street address.
    :vartype street_address2: str
    :ivar city: City of the address.
    :vartype city: str
    :ivar state_or_province: State or province of the address.
    :vartype state_or_province: str
    :ivar country: Country of the address.
    :vartype country: str
    :ivar postal_code: Postal or ZIP code of the address.
    :vartype postal_code: str
    """

    street_address1: Optional[str] = rest_field(
        name="streetAddress1", visibility=["read", "create", "update", "delete", "query"]
    )
    """First line of the street address."""
    street_address2: Optional[str] = rest_field(
        name="streetAddress2", visibility=["read", "create", "update", "delete", "query"]
    )
    """Second line of the street address."""
    city: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """City of the address."""
    state_or_province: Optional[str] = rest_field(
        name="stateOrProvince", visibility=["read", "create", "update", "delete", "query"]
    )
    """State or province of the address."""
    country: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Country of the address."""
    postal_code: Optional[str] = rest_field(
        name="postalCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Postal or ZIP code of the address."""

    @overload
    def __init__(
        self,
        *,
        street_address1: Optional[str] = None,
        street_address2: Optional[str] = None,
        city: Optional[str] = None,
        state_or_province: Optional[str] = None,
        country: Optional[str] = None,
        postal_code: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SiteProperties(_Model):
    """Site properties.

    :ivar display_name: displayName of Site resource.
    :vartype display_name: str
    :ivar description: Description of Site resource.
    :vartype description: str
    :ivar site_address: Physical address of the site.
    :vartype site_address: ~azure.mgmt.sitemanager.models.SiteAddressProperties
    :ivar labels: Key-value pairs for labeling the site resource.
    :vartype labels: dict[str, str]
    :ivar provisioning_state: Provisioning state of last operation. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.sitemanager.models.ResourceProvisioningState
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """displayName of Site resource."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of Site resource."""
    site_address: Optional["_models.SiteAddressProperties"] = rest_field(
        name="siteAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Physical address of the site."""
    labels: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key-value pairs for labeling the site resource."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of last operation. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        site_address: Optional["_models.SiteAddressProperties"] = None,
        labels: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SiteUpdate(_Model):
    """The type used for update operations of the Site.

    :ivar properties: The updatable properties of the Site.
    :vartype properties: ~azure.mgmt.sitemanager.models.SiteUpdateProperties
    """

    properties: Optional["_models.SiteUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The updatable properties of the Site."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SiteUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SiteUpdateProperties(_Model):
    """The updatable properties of the Site.

    :ivar display_name: displayName of Site resource.
    :vartype display_name: str
    :ivar description: Description of Site resource.
    :vartype description: str
    :ivar site_address: Physical address of the site.
    :vartype site_address: ~azure.mgmt.sitemanager.models.SiteAddressProperties
    :ivar labels: Key-value pairs for labeling the site resource.
    :vartype labels: dict[str, str]
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """displayName of Site resource."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of Site resource."""
    site_address: Optional["_models.SiteAddressProperties"] = rest_field(
        name="siteAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Physical address of the site."""
    labels: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key-value pairs for labeling the site resource."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        site_address: Optional["_models.SiteAddressProperties"] = None,
        labels: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.sitemanager.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.sitemanager.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
