/* Generated by Pyrex 0.9 on Mon Nov 24 18:30:10 2003 */

#include "Python.h"
#include "structmember.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "speex.h"


static PyObject *__Pyx_UnpackItem(PyObject *, int); /*proto*/
static int __Pyx_EndUnpack(PyObject *, int); /*proto*/
static int __Pyx_PrintItem(PyObject *); /*proto*/
static int __Pyx_PrintNewline(void); /*proto*/
static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb); /*proto*/
static void __Pyx_ReRaise(void); /*proto*/
static PyObject *__Pyx_Import(PyObject *name, PyObject *from_list); /*proto*/
static PyObject *__Pyx_GetExcValue(void); /*proto*/
static PyObject *__Pyx_GetName(PyObject *dict, char *name); /*proto*/
static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed, char *name); /*proto*/
static int __Pyx_TypeTest(PyObject *obj, PyTypeObject *type); /*proto*/
static int __Pyx_GetStarArgs(PyObject **args, PyObject **kwds, char *kwd_list[], int nargs, PyObject **args2, PyObject **kwds2); /*proto*/
static void __Pyx_WriteUnraisable(char *name); /*proto*/
static void __Pyx_AddTraceback(char *funcname); /*proto*/
static PyTypeObject *__Pyx_ImportType(char *module_name, char *class_name, long size);  /*proto*/
static int __Pyx_SetVtable(PyObject *dict, void *vtable); /*proto*/
static int __Pyx_GetVtable(PyObject *dict, void **vtabptr); /*proto*/

static PyObject *__pyx_m;
static PyObject *__pyx_b;
static int __pyx_lineno;
static char *__pyx_filename;
staticforward char **__pyx_f;

static char __pyx_mdoc[] = "\nspeex.pyx\n\nPython wrapper for Speex speech codec (www.speex.org)\nDefines a \'speex\' object through which encoding and\ndecoding of audio data can be performed.\n";

/* Declarations from speex */

staticforward PyTypeObject __pyx_type_5speex_new;

struct __pyx_obj_5speex_new {
  PyObject_HEAD
  void (*encState);
  int encQuality;
  int encFramesPerBlock;
  float (*encBuf);
  float (*encPtr);
  int encNumFrames;
  SpeexBits encBits;
  int raw;
  void (*decState);
  int decQuality;
  unsigned char (*decBuf);
  unsigned char (*decPtr);
  unsigned short decBlkSize;
  int decNumBytes;
  int decPhase;
  int decEnhanceOn;
  SpeexBits decBits;
  PyObject *debug;
  PyObject *endianness;
};

static PyTypeObject *__pyx_ptype_5speex_new = 0;
static PyObject *__pyx_k2;
static PyObject *__pyx_k3;
static PyObject *__pyx_k4;
static PyObject *__pyx_k5;

/* Implementation of speex */

static char (__pyx_k1[]) = "0.2";

static char (__pyx_k6[]) = "debug";
static char (__pyx_k7[]) = "Out of memory";
static char (__pyx_k8[]) = "Out of memory";

static int __pyx_f_5speex_3new___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_5speex_3new___init__[] = "\n        Create a new speex speech stream object\n    \n        Arguments:\n         - quality - 0 (lowest) to 10 (highest), default 8\n    \n         - raw - set to 1 for encoding from and decoding to string, default 0\n    \n        Keywords:\n         - debug - set to 1 to issue debug messages, default 0\n    \n        The created speex stream object has two methods:\n         - encode - encode a block of speech audio data\n    \n           Arguments:\n            - block of audio data, as sequence of frames, where\n              each frame is an int\n    \n           Returns:\n            - raw string containing encoded data, or\n              empty string if there is not yet any encoded\n              data available\n    \n         - decode - decodes a block of speech audio data\n    \n           Arguments:\n            - block of encoded data, as raw string,\n    \n           Returns:\n            - block of audio data, as sequence of ints, or\n              an empty sequence if there is no decoded data\n              available yet\n    \n        Notes:\n         - Both of these methods use internal buffering, which means that\n           you can feed in data piecemeal. This helps a lot when sending and\n           receiving data over the net.\n        ";
static int __pyx_f_5speex_3new___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_quality = 0;
  PyObject *__pyx_v_raw = 0;
  PyObject *__pyx_v_kw = 0;
  int __pyx_v_is_raw;
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  static char *__pyx_argnames[] = {"quality","raw",0};
  __pyx_v_quality = __pyx_k2;
  __pyx_v_raw = __pyx_k3;
  if (__Pyx_GetStarArgs(&__pyx_args, &__pyx_kwds, __pyx_argnames, 2, 0, &__pyx_v_kw) < 0) return -1;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "|OO", __pyx_argnames, &__pyx_v_quality, &__pyx_v_raw)) {
    Py_XDECREF(__pyx_args);
    Py_XDECREF(__pyx_kwds);
    Py_XDECREF(__pyx_v_kw);
    return -1;
  }
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_quality);
  Py_INCREF(__pyx_v_raw);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":176 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encState = speex_encoder_init((&speex_nb_mode));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":178 */
  __pyx_1 = PyInt_AsLong(__pyx_v_quality); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 178; goto __pyx_L1;}
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encQuality = __pyx_1;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":179 */
  __pyx_1 = PyInt_AsLong(__pyx_v_raw); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; goto __pyx_L1;}
  __pyx_v_is_raw = __pyx_1;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":180 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->raw = __pyx_v_is_raw;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":181 */
  __pyx_2 = __Pyx_GetName(__pyx_b, "int"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; goto __pyx_L1;}
  __pyx_3 = PyObject_GetAttrString(__pyx_v_kw, "get"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; goto __pyx_L1;}
  __pyx_4 = PyString_FromString(__pyx_k6); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; goto __pyx_L1;}
  __pyx_5 = PyInt_FromLong(0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; goto __pyx_L1;}
  __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_6, 0, __pyx_4);
  PyTuple_SET_ITEM(__pyx_6, 1, __pyx_5);
  __pyx_4 = 0;
  __pyx_5 = 0;
  __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_6); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_6); __pyx_6 = 0;
  __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_5, 0, __pyx_4);
  __pyx_4 = 0;
  __pyx_3 = PyObject_CallObject(__pyx_2, __pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  Py_DECREF(((struct __pyx_obj_5speex_new *)__pyx_v_self)->debug);
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->debug = __pyx_3;
  __pyx_3 = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":183 */
  speex_encoder_ctl(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encState,SPEEX_SET_QUALITY,(&((struct __pyx_obj_5speex_new *)__pyx_v_self)->encQuality));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":187 */
  speex_encoder_ctl(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encState,SPEEX_GET_FRAME_SIZE,(&((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":189 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBuf = ((float (*))malloc((((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock * (sizeof(float )))));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":190 */
  __pyx_1 = (!(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBuf != 0));
  if (__pyx_1) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":191 */
    __pyx_6 = __Pyx_GetName(__pyx_b, "Exception"); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    __pyx_4 = PyString_FromString(__pyx_k7); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_4);
    __pyx_4 = 0;
    __pyx_5 = PyObject_CallObject(__pyx_6, __pyx_2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_5, 0, 0);
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":192 */
  memset(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBuf,0,(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock * (sizeof(float ))));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":193 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encNumFrames = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":194 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encPtr = ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBuf;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":195 */
  speex_bits_init((&((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBits));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":198 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decState = speex_decoder_init((&speex_nb_mode));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":199 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decEnhanceOn = 1;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":200 */
  speex_decoder_ctl(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decState,SPEEX_SET_ENH,(&((struct __pyx_obj_5speex_new *)__pyx_v_self)->decEnhanceOn));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":201 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf = ((unsigned char (*))malloc(2));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":202 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPhase = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":203 */
  __pyx_1 = (!(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf != 0));
  if (__pyx_1) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":204 */
    __pyx_3 = __Pyx_GetName(__pyx_b, "Exception"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 204; goto __pyx_L1;}
    __pyx_4 = PyString_FromString(__pyx_k8); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 204; goto __pyx_L1;}
    __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 204; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_4);
    __pyx_4 = 0;
    __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_6); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 204; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 204; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":205 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPtr = ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":206 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decNumBytes = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":207 */
  speex_bits_init((&((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBits));

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("speex.new.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_XDECREF(__pyx_v_kw);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_quality);
  Py_DECREF(__pyx_v_raw);
  Py_XDECREF(__pyx_args);
  Py_XDECREF(__pyx_kwds);
  return __pyx_r;
}


static void __pyx_f_5speex_3new___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_5speex_3new___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":212 */
  speex_encoder_destroy(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encState);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":213 */
  __pyx_1 = (((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBuf != 0);
  if (__pyx_1) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":214 */
    free(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBuf);
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":217 */
  speex_decoder_destroy(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decState);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":218 */
  __pyx_1 = (((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf != 0);
  if (__pyx_1) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":219 */
    free(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf);
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":222 */
  speex_bits_destroy((&((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBits));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":223 */
  speex_bits_destroy((&((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBits));

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("speex.new.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}

static char (__pyx_k9[]) = "";
static char (__pyx_k10[]) = "";
static char (__pyx_k11[]) = "Out of memory";

static PyObject *__pyx_f_5speex_3new_encode(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_5speex_3new_encode[] = "\n        Encode some audio data\n    \n        Arguments:\n         - data - sequence of audio frames to encode, OR string of 16-bit frames\n    \n         - raw  - true if data being passed in is a string of 16-bit frames\n           defaults to whatever raw arg was passed to constructor\n    \n        Returns:\n         - raw string with encoded data\n        ";
static PyObject *__pyx_f_5speex_3new_encode(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_input = 0;
  PyObject *__pyx_v_raw = 0;
  int __pyx_v_numInputFrames;
  float (*__pyx_v_framesBuf);
  float (*__pyx_v_framesPtr);
  int __pyx_v_i;
  int __pyx_v_totFrames;
  int __pyx_v_cbitsSiz;
  char (__pyx_v_cbits[2048]);
  int __pyx_v_nBlocks;
  int __pyx_v_nBytes;
  char (*__pyx_v_bufOut);
  int __pyx_v_bufOutSiz;
  int __pyx_v_remainder;
  char (*__pyx_v_rawbuf);
  short (*__pyx_v_frameptr);
  PyObject *__pyx_v_inputFramesList;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  char (*__pyx_6);
  float __pyx_7;
  static char *__pyx_argnames[] = {"input","raw",0};
  __pyx_v_raw = __pyx_k4;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|O", __pyx_argnames, &__pyx_v_input, &__pyx_v_raw)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_input);
  Py_INCREF(__pyx_v_raw);
  __pyx_v_inputFramesList = Py_None; Py_INCREF(__pyx_v_inputFramesList);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":260 */
  __pyx_v_cbitsSiz = ((((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock * 5) / 4);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":261 */
  __pyx_v_bufOut = ((char (*))malloc(0));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":262 */
  __pyx_v_bufOutSiz = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":264 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 264; goto __pyx_L1;}
  Py_DECREF(__pyx_v_inputFramesList);
  __pyx_v_inputFramesList = __pyx_1;
  __pyx_1 = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":269 */
  __pyx_2 = __pyx_v_raw == Py_None;
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":270 */
    __pyx_1 = PyInt_FromLong(((struct __pyx_obj_5speex_new *)__pyx_v_self)->raw); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 270; goto __pyx_L1;}
    Py_DECREF(__pyx_v_raw);
    __pyx_v_raw = __pyx_1;
    __pyx_1 = 0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":271 */
  __pyx_1 = __Pyx_GetName(__pyx_b, "type"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; goto __pyx_L1;}
  Py_INCREF(__pyx_v_input);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_input);
  __pyx_4 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_1 = __Pyx_GetName(__pyx_b, "type"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; goto __pyx_L1;}
  __pyx_3 = PyString_FromString(__pyx_k9); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; goto __pyx_L1;}
  __pyx_5 = PyTuple_New(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_5, 0, __pyx_3);
  __pyx_3 = 0;
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 271; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  __pyx_2 = __pyx_4 == __pyx_3;
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":272 */
    __pyx_1 = PyInt_FromLong(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 272; goto __pyx_L1;}
    Py_DECREF(__pyx_v_raw);
    __pyx_v_raw = __pyx_1;
    __pyx_1 = 0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":275 */
  __pyx_2 = PyObject_IsTrue(__pyx_v_raw); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 275; goto __pyx_L1;}
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":276 */
    __pyx_5 = __Pyx_GetName(__pyx_b, "len"); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 276; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 276; goto __pyx_L1;}
    Py_INCREF(__pyx_v_input);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_input);
    __pyx_3 = PyObject_CallObject(__pyx_5, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 276; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_1 = PyInt_FromLong(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 276; goto __pyx_L1;}
    __pyx_5 = PyNumber_Divide(__pyx_3, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 276; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_2 = PyInt_AsLong(__pyx_5); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 276; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __pyx_v_numInputFrames = __pyx_2;
    goto __pyx_L4;
  }
  /*else*/ {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":278 */
    __pyx_4 = __Pyx_GetName(__pyx_b, "len"); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 278; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 278; goto __pyx_L1;}
    Py_INCREF(__pyx_v_input);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_input);
    __pyx_1 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 278; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_2 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 278; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_v_numInputFrames = __pyx_2;
  }
  __pyx_L4:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":284 */
  __pyx_2 = (__pyx_v_numInputFrames == 0);
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":285 */
    __pyx_5 = PyString_FromString(__pyx_k10); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 285; goto __pyx_L1;}
    __pyx_r = __pyx_5;
    __pyx_5 = 0;
    goto __pyx_L0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":290 */
  __pyx_v_totFrames = (__pyx_v_numInputFrames + ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encNumFrames);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":295 */
  __pyx_v_framesBuf = ((float (*))malloc((__pyx_v_totFrames * (sizeof(float )))));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":296 */
  __pyx_v_framesPtr = __pyx_v_framesBuf;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":297 */
  __pyx_2 = (!(__pyx_v_framesBuf != 0));
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":298 */
    __pyx_4 = __Pyx_GetName(__pyx_b, "Exception"); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 298; goto __pyx_L1;}
    __pyx_3 = PyString_FromString(__pyx_k11); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 298; goto __pyx_L1;}
    __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 298; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_3);
    __pyx_3 = 0;
    __pyx_5 = PyObject_CallObject(__pyx_4, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 298; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __Pyx_Raise(__pyx_5, 0, 0);
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 298; goto __pyx_L1;}
    goto __pyx_L6;
  }
  __pyx_L6:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":304 */
  __pyx_2 = ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encNumFrames;
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_2; ++__pyx_v_i) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":305 */
    (__pyx_v_framesPtr[__pyx_v_i]) = (((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBuf[__pyx_v_i]);
    __pyx_L7:;
  }
  __pyx_L8:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":310 */
  __pyx_v_framesPtr = (__pyx_v_framesPtr + __pyx_v_i);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":316 */
  __pyx_2 = PyObject_IsTrue(__pyx_v_raw); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 316; goto __pyx_L1;}
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":317 */
    __pyx_6 = PyString_AsString(__pyx_v_input); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 317; goto __pyx_L1;}
    __pyx_v_rawbuf = __pyx_6;

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":318 */
    __pyx_v_frameptr = ((short (*))__pyx_v_rawbuf);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":319 */
    for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_numInputFrames; ++__pyx_v_i) {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":325 */
      (__pyx_v_framesPtr[__pyx_v_i]) = (__pyx_v_frameptr[__pyx_v_i]);
      __pyx_L10:;
    }
    __pyx_L11:;

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":326 */
    __pyx_v_framesPtr = (__pyx_v_framesPtr + __pyx_v_i);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":327 */
    __pyx_v_frameptr = (__pyx_v_frameptr + __pyx_v_i);
    goto __pyx_L9;
  }
  /*else*/ {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":336 */
    for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_numInputFrames; ++__pyx_v_i) {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":337 */
      __pyx_3 = PyInt_FromLong(__pyx_v_i); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 337; goto __pyx_L1;}
      __pyx_4 = PyObject_GetItem(__pyx_v_input, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 337; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_7 = PyFloat_AsDouble(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 337; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      (__pyx_v_framesPtr[__pyx_v_i]) = __pyx_7;
      __pyx_L12:;
    }
    __pyx_L13:;

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":338 */
    __pyx_v_framesPtr = (__pyx_v_framesPtr + __pyx_v_i);
  }
  __pyx_L9:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":351 */
  __pyx_v_nBlocks = (__pyx_v_totFrames / ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":352 */
  __pyx_v_framesPtr = __pyx_v_framesBuf;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":353 */
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_nBlocks; ++__pyx_v_i) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":355 */
    speex_bits_reset((&((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBits));

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":358 */
    speex_encode(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encState,__pyx_v_framesPtr,(&((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBits));

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":360 */
    __pyx_v_nBytes = speex_bits_write((&((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBits),__pyx_v_cbits,__pyx_v_cbitsSiz);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":362 */
    __pyx_v_bufOut = ((char (*))realloc(__pyx_v_bufOut,((__pyx_v_bufOutSiz + __pyx_v_nBytes) + 2)));

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":365 */
    (__pyx_v_bufOut[__pyx_v_bufOutSiz]) = (__pyx_v_nBytes % 256);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":366 */
    (__pyx_v_bufOut[(__pyx_v_bufOutSiz + 1)]) = (__pyx_v_nBytes / 256);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":367 */
    __pyx_v_bufOutSiz = (__pyx_v_bufOutSiz + 2);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":368 */
    memcpy((__pyx_v_bufOut + __pyx_v_bufOutSiz),__pyx_v_cbits,__pyx_v_nBytes);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":370 */
    __pyx_v_bufOutSiz = (__pyx_v_bufOutSiz + __pyx_v_nBytes);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":373 */
    __pyx_v_framesPtr = (__pyx_v_framesPtr + ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock);
    __pyx_L14:;
  }
  __pyx_L15:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":378 */
  ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encNumFrames = (__pyx_v_totFrames - (__pyx_v_nBlocks * ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":379 */
  __pyx_v_remainder = (((struct __pyx_obj_5speex_new *)__pyx_v_self)->encNumFrames * (sizeof(float )));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":380 */
  memcpy(((struct __pyx_obj_5speex_new *)__pyx_v_self)->encBuf,__pyx_v_framesPtr,__pyx_v_remainder);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":388 */
  free(__pyx_v_framesBuf);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":394 */
  __pyx_1 = PyString_FromStringAndSize(__pyx_v_bufOut,__pyx_v_bufOutSiz); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 394; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("speex.new.encode");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_inputFramesList);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_input);
  Py_DECREF(__pyx_v_raw);
  return __pyx_r;
}

static char (__pyx_k12[]) = "";
static char (__pyx_k13[]) = "self.decBuf=%lx\n";
static char (__pyx_k14[]) = "decPtr=%lx, encPtr=%lx, encBufLen=%d\n";
static char (__pyx_k15[]) = "";

static PyObject *__pyx_f_5speex_3new_decode(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_5speex_3new_decode[] = "\n        Decode an encoded block, return as sequence of frame tuples\n    \n        Arguments:\n          - encoded - raw string, containing encoded data\n          - raw - True if data is to be returned as string of 16-bit frames, defaults to\n            whatever raw value was passed to constructor\n    \n        Returns:\n          - decoded blocks, as sequence of frames, where each frame\n            or a string of these 16-bit frames if raw is True\n            is an int\n        ";
static PyObject *__pyx_f_5speex_3new_decode(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_input = 0;
  PyObject *__pyx_v_raw = 0;
  unsigned char (*__pyx_v_encBuf);
  unsigned char (*__pyx_v_encBufEnd);
  unsigned char (*__pyx_v_encPtr);
  int __pyx_v_encBufLen;
  int __pyx_v_numDecFrames;
  float (*__pyx_v_decFloats);
  float (*__pyx_v_decFloats1);
  short (*__pyx_v_decShorts);
  short (*__pyx_v_decShorts1);
  int __pyx_v_decBlocks;
  int __pyx_v_i;
  int __pyx_v_is_raw;
  int __pyx_v_needed;
  int __pyx_v_newNumFrames;
  char (*__pyx_v_tmp);
  PyObject *__pyx_v_ret;
  PyObject *__pyx_r;
  char (*__pyx_1);
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  static char *__pyx_argnames[] = {"input","raw",0};
  __pyx_v_raw = __pyx_k5;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|O", __pyx_argnames, &__pyx_v_input, &__pyx_v_raw)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_input);
  Py_INCREF(__pyx_v_raw);
  __pyx_v_ret = Py_None; Py_INCREF(__pyx_v_ret);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":434 */
  __pyx_1 = PyString_AsString(__pyx_v_input); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 434; goto __pyx_L1;}
  __pyx_v_tmp = __pyx_1;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":435 */
  __pyx_v_encBuf = ((unsigned char (*))__pyx_v_tmp);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":436 */
  __pyx_v_encBufEnd = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":437 */
  __pyx_v_encPtr = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":438 */
  __pyx_v_encBufLen = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":439 */
  __pyx_v_decFloats = ((float (*))malloc(0));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":440 */
  __pyx_v_decShorts = ((short (*))malloc(0));

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":441 */
  __pyx_v_decBlocks = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":443 */
  __pyx_2 = __pyx_v_raw == Py_None;
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":444 */
    __pyx_3 = PyInt_FromLong(((struct __pyx_obj_5speex_new *)__pyx_v_self)->raw); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 444; goto __pyx_L1;}
    Py_DECREF(__pyx_v_raw);
    __pyx_v_raw = __pyx_3;
    __pyx_3 = 0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":445 */
  __pyx_2 = PyInt_AsLong(__pyx_v_raw); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 445; goto __pyx_L1;}
  __pyx_v_is_raw = __pyx_2;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":450 */
  __pyx_3 = __Pyx_GetName(__pyx_b, "len"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 450; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 450; goto __pyx_L1;}
  Py_INCREF(__pyx_v_input);
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_input);
  __pyx_5 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 450; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  __pyx_2 = PyInt_AsLong(__pyx_5); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 450; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  __pyx_v_encBufLen = __pyx_2;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":451 */
  __pyx_2 = (__pyx_v_encBufLen == 0);
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":452 */
    __pyx_2 = __pyx_v_is_raw;
    if (__pyx_2) {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":453 */
      __pyx_3 = PyString_FromString(__pyx_k12); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 453; goto __pyx_L1;}
      __pyx_r = __pyx_3;
      __pyx_3 = 0;
      goto __pyx_L0;
      goto __pyx_L4;
    }
    /*else*/ {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":455 */
      __pyx_4 = PyList_New(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 455; goto __pyx_L1;}
      __pyx_r = __pyx_4;
      __pyx_4 = 0;
      goto __pyx_L0;
    }
    __pyx_L4:;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":460 */
  __pyx_v_encPtr = __pyx_v_encBuf;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":461 */
  __pyx_v_encBufEnd = (__pyx_v_encBuf + __pyx_v_encBufLen);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":465 */
  while (1) {
    __pyx_L5:;
    __pyx_2 = (__pyx_v_encPtr < __pyx_v_encBufEnd);
    if (!__pyx_2) break;

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":467 */
    __pyx_2 = (((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPhase == 0);
    if (__pyx_2) {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":469 */
      (((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf[0]) = (__pyx_v_encPtr[0]);

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":471 */
      ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPhase = 1;

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":472 */
      __pyx_v_encPtr = (__pyx_v_encPtr + 1);

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":473 */
      __pyx_v_encBufLen = (__pyx_v_encBufLen - 1);

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":474 */
      goto __pyx_L5;
      goto __pyx_L7;
    }
    __pyx_2 = (((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPhase == 1);
    if (__pyx_2) {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":477 */
      (((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf[1]) = (__pyx_v_encPtr[0]);

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":479 */
      ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBlkSize = ((((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf[0]) + (256 * (((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf[1])));

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":483 */
      ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf = ((unsigned char (*))realloc(((void (*))((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf),((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBlkSize));

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":486 */
      ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPtr = ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf;

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":487 */
      ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decNumBytes = 0;

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":488 */
      ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPhase = 2;

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":489 */
      __pyx_v_encPtr = (__pyx_v_encPtr + 1);

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":490 */
      __pyx_v_encBufLen = (__pyx_v_encBufLen - 1);

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":491 */
      goto __pyx_L5;
      goto __pyx_L7;
    }
    /*else*/ {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":495 */
      __pyx_v_needed = (((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBlkSize - ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decNumBytes);

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":500 */
      __pyx_2 = (__pyx_v_encBufLen >= __pyx_v_needed);
      if (__pyx_2) {

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":501 */
        __pyx_v_newNumFrames = ((__pyx_v_decBlocks + 1) * ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock);

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":504 */
        memcpy(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPtr,__pyx_v_encPtr,(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBlkSize - ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decNumBytes));

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":507 */
        __pyx_v_encPtr = (__pyx_v_encPtr + __pyx_v_needed);

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":508 */
        __pyx_v_encBufLen = (__pyx_v_encBufLen - __pyx_v_needed);

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":512 */
        __pyx_v_decShorts = ((short (*))realloc(__pyx_v_decShorts,(__pyx_v_newNumFrames * (sizeof(short )))));

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":513 */
        __pyx_v_decShorts1 = (__pyx_v_decShorts + (__pyx_v_decBlocks * ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock));

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":514 */
        __pyx_v_decFloats = ((float (*))realloc(__pyx_v_decFloats,(__pyx_v_newNumFrames * (sizeof(float )))));

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":515 */
        __pyx_v_decFloats1 = (__pyx_v_decFloats + (__pyx_v_decBlocks * ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock));

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":518 */
        speex_bits_read_from((&((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBits),((char (*))((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPtr),((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBlkSize);

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":521 */
        speex_decode(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decState,(&((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBits),__pyx_v_decFloats1);

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":524 */
        __pyx_2 = ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock;
        for (__pyx_v_i = 0; __pyx_v_i < __pyx_2; ++__pyx_v_i) {

          /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":525 */
          (__pyx_v_decShorts1[__pyx_v_i]) = (__pyx_v_decFloats1[__pyx_v_i]);
          __pyx_L9:;
        }
        __pyx_L10:;

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":527 */
        ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPhase = 0;

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":528 */
        ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decNumBytes = 0;

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":529 */
        __pyx_2 = PyObject_IsTrue(((struct __pyx_obj_5speex_new *)__pyx_v_self)->debug); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 529; goto __pyx_L1;}
        if (__pyx_2) {

          /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":530 */
          printf(__pyx_k13,((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf);
          goto __pyx_L11;
        }
        __pyx_L11:;

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":531 */
        ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf = ((unsigned char (*))realloc(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decBuf,2));

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":532 */
        __pyx_v_decBlocks = (__pyx_v_decBlocks + 1);

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":533 */
        goto __pyx_L5;
        goto __pyx_L8;
      }
      /*else*/ {

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":538 */
        __pyx_2 = PyObject_IsTrue(((struct __pyx_obj_5speex_new *)__pyx_v_self)->debug); if (__pyx_2 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 538; goto __pyx_L1;}
        if (__pyx_2) {

          /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":539 */
          printf(__pyx_k14,((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPtr,__pyx_v_encPtr,__pyx_v_encBufLen);
          goto __pyx_L12;
        }
        __pyx_L12:;

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":541 */
        memcpy(((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPtr,__pyx_v_encPtr,__pyx_v_encBufLen);

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":542 */
        ((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPtr = (((struct __pyx_obj_5speex_new *)__pyx_v_self)->decPtr + __pyx_v_encBufLen);

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":543 */
        __pyx_v_encBufLen = 0;

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":544 */
        goto __pyx_L6;
      }
      __pyx_L8:;
    }
    __pyx_L7:;
  }
  __pyx_L6:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":549 */
  __pyx_2 = (__pyx_v_decBlocks > 0);
  if (__pyx_2) {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":550 */
    __pyx_v_numDecFrames = (__pyx_v_decBlocks * ((struct __pyx_obj_5speex_new *)__pyx_v_self)->encFramesPerBlock);

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":552 */
    __pyx_2 = __pyx_v_is_raw;
    if (__pyx_2) {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":553 */
      __pyx_5 = PyString_FromStringAndSize(((char (*))__pyx_v_decShorts),(__pyx_v_numDecFrames * 2)); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 553; goto __pyx_L1;}
      Py_DECREF(__pyx_v_ret);
      __pyx_v_ret = __pyx_5;
      __pyx_5 = 0;
      goto __pyx_L14;
    }
    /*else*/ {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":556 */
      __pyx_3 = PyList_New(0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 556; goto __pyx_L1;}
      Py_DECREF(__pyx_v_ret);
      __pyx_v_ret = __pyx_3;
      __pyx_3 = 0;

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":557 */
      __pyx_4 = __Pyx_GetName(__pyx_b, "range"); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 557; goto __pyx_L1;}
      __pyx_5 = PyInt_FromLong(__pyx_v_numDecFrames); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 557; goto __pyx_L1;}
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 557; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_5);
      __pyx_5 = 0;
      __pyx_5 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 557; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_4 = PyObject_GetIter(__pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 557; goto __pyx_L1;}
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      for (;;) {
        __pyx_L15:;
        __pyx_3 = PyIter_Next(__pyx_4);
        if (!__pyx_3) {
          if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 557; goto __pyx_L1;}
          break;
        }
        __pyx_2 = PyInt_AsLong(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 557; goto __pyx_L1;}
        Py_DECREF(__pyx_3); __pyx_3 = 0;
        __pyx_v_i = __pyx_2;

        /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":558 */
        __pyx_5 = PyObject_GetAttrString(__pyx_v_ret, "append"); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
        __pyx_3 = PyInt_FromLong((__pyx_v_decShorts[__pyx_v_i])); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
        __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_6, 0, __pyx_3);
        __pyx_3 = 0;
        __pyx_3 = PyObject_CallObject(__pyx_5, __pyx_6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        Py_DECREF(__pyx_6); __pyx_6 = 0;
        Py_DECREF(__pyx_3); __pyx_3 = 0;
      }
      __pyx_L16:;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
    }
    __pyx_L14:;
    goto __pyx_L13;
  }
  /*else*/ {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":560 */
    __pyx_2 = __pyx_v_is_raw;
    if (__pyx_2) {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":561 */
      __pyx_5 = PyString_FromString(__pyx_k15); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}
      Py_DECREF(__pyx_v_ret);
      __pyx_v_ret = __pyx_5;
      __pyx_5 = 0;
      goto __pyx_L17;
    }
    /*else*/ {

      /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":563 */
      __pyx_6 = PyList_New(0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 563; goto __pyx_L1;}
      Py_DECREF(__pyx_v_ret);
      __pyx_v_ret = __pyx_6;
      __pyx_6 = 0;
    }
    __pyx_L17:;
  }
  __pyx_L13:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":567 */
  free(__pyx_v_decShorts);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":568 */
  free(__pyx_v_decFloats);

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":569 */
  Py_INCREF(__pyx_v_ret);
  __pyx_r = __pyx_v_ret;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("speex.new.decode");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_ret);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_input);
  Py_DECREF(__pyx_v_raw);
  return __pyx_r;
}

static PyObject *__pyx_tp_new_5speex_new(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_5speex_new *p = (struct __pyx_obj_5speex_new *)o;
  p->debug = Py_None; Py_INCREF(p->debug);
  p->endianness = Py_None; Py_INCREF(p->endianness);
  return o;
}

static void __pyx_tp_dealloc_5speex_new(PyObject *o) {
  struct __pyx_obj_5speex_new *p = (struct __pyx_obj_5speex_new *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_5speex_3new___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  Py_XDECREF(p->debug);
  Py_XDECREF(p->endianness);
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_5speex_new(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_5speex_new *p = (struct __pyx_obj_5speex_new *)o;
  e = (*v)(p->debug, a); if (e) return e;
  e = (*v)(p->endianness, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_5speex_new(PyObject *o) {
  struct __pyx_obj_5speex_new *p = (struct __pyx_obj_5speex_new *)o;
  Py_XDECREF(p->debug);
  p->debug = Py_None; Py_INCREF(p->debug);
  Py_XDECREF(p->endianness);
  p->endianness = Py_None; Py_INCREF(p->endianness);
  return 0;
}

static struct PyMethodDef __pyx_methods_5speex_new[] = {
  {"encode", (PyCFunction)__pyx_f_5speex_3new_encode, METH_VARARGS|METH_KEYWORDS, __pyx_doc_5speex_3new_encode},
  {"decode", (PyCFunction)__pyx_f_5speex_3new_decode, METH_VARARGS|METH_KEYWORDS, __pyx_doc_5speex_3new_decode},
  {0, 0, 0, 0}
};

static struct PyMemberDef __pyx_members_5speex_new[] = {
  {"debug", T_OBJECT, offsetof(struct __pyx_obj_5speex_new, debug), 0, 0},
  {"endianness", T_OBJECT, offsetof(struct __pyx_obj_5speex_new, endianness), 0, 0},
  {0, 0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_new = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_new = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_new = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_new = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_5speex_new = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "speex.new", /*tp_name*/
  sizeof(struct __pyx_obj_5speex_new), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_5speex_new, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_new, /*tp_as_number*/
  &__pyx_tp_as_sequence_new, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_new, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_new, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_5speex_new, /*tp_traverse*/
  __pyx_tp_clear_5speex_new, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_5speex_new, /*tp_methods*/
  __pyx_members_5speex_new, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_5speex_3new___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_5speex_new, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static struct PyMethodDef __pyx_methods[] = {
  {0, 0, 0, 0}
};

DL_EXPORT(void) initspeex(void); /*proto*/
DL_EXPORT(void) initspeex(void) {
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  __pyx_m = Py_InitModule4("speex", __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  __pyx_b = PyImport_AddModule("__builtin__");
  PyObject_SetAttrString(__pyx_m, "__builtins__", __pyx_b);
  if (PyType_Ready(&__pyx_type_5speex_new) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 104; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "new", (PyObject *)&__pyx_type_5speex_new) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 104; goto __pyx_L1;}
  __pyx_ptype_5speex_new = &__pyx_type_5speex_new;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":12 */
  __pyx_1 = PyString_FromString(__pyx_k1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 12; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "version", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 12; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":14 */
  /*try:*/ {

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":15 */
    __pyx_1 = __Pyx_GetName(__pyx_m, "True"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 15; goto __pyx_L18;}
    if (PyObject_SetAttrString(__pyx_m, "x", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 15; goto __pyx_L18;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }
  goto __pyx_L19;
  __pyx_L18:;
  Py_XDECREF(__pyx_1); __pyx_1 = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":16 */
  /*except:*/ {
    __Pyx_AddTraceback("speex");
    __pyx_1 = __Pyx_GetExcValue(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 16; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":17 */
    __pyx_1 = PyInt_FromLong(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;}
    if (PyObject_SetAttrString(__pyx_m, "True", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;

    /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":18 */
    __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 18; goto __pyx_L1;}
    if (PyObject_SetAttrString(__pyx_m, "False", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 18; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L19;
  }
  __pyx_L19:;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":132 */
  __pyx_1 = PyInt_FromLong(8); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 132; goto __pyx_L1;}
  __pyx_k2 = __pyx_1;
  __pyx_1 = 0;
  __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 132; goto __pyx_L1;}
  __pyx_k3 = __pyx_2;
  __pyx_2 = 0;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":227 */
  Py_INCREF(Py_None);
  __pyx_k4 = Py_None;

  /* "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx":399 */
  Py_INCREF(Py_None);
  __pyx_k5 = Py_None;
  return;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("speex");
}

static char *__pyx_filenames[] = {
  "/main/pywindows/speex/speex-1.0rc3/pySpeex/speex.pyx",
};
statichere char **__pyx_f = __pyx_filenames;

/* Runtime support code */

static int __Pyx_GetStarArgs(
	PyObject **args, 
	PyObject **kwds,
	char *kwd_list[], 
	int nargs,
	PyObject **args2, 
	PyObject **kwds2)
{
	PyObject *x = 0, *args1 = 0, *kwds1 = 0;
	
	if (args2)
		*args2 = 0;
	if (kwds2)
		*kwds2 = 0;
	
	if (args2) {
		args1 = PyTuple_GetSlice(*args, 0, nargs);
		if (!args1)
			goto bad;
		*args2 = PyTuple_GetSlice(*args, nargs, PyTuple_Size(*args));
		if (!*args2)
			goto bad;
	}
	else {
		args1 = *args;
		Py_INCREF(args1);
	}
	
	if (kwds2) {
		if (*kwds) {
			char **p;
			kwds1 = PyDict_New();
			if (!kwds)
				goto bad;
			*kwds2 = PyDict_Copy(*kwds);
			if (!*kwds2)
				goto bad;
			for (p = kwd_list; *p; p++) {
				x = PyDict_GetItemString(*kwds, *p);
				if (x) {
					if (PyDict_SetItemString(kwds1, *p, x) < 0)
						goto bad;
					if (PyDict_DelItemString(*kwds2, *p) < 0)
						goto bad;
				}
			}
		}
		else {
			*kwds2 = PyDict_New();
			if (!*kwds2)
				goto bad;
		}
	}
	else {
		kwds1 = *kwds;
		Py_XINCREF(kwds1);
	}
	
	*args = args1;
	*kwds = kwds1;
	return 0;
bad:
	Py_XDECREF(args1);
	Py_XDECREF(kwds1);
	if (*args2)
		Py_XDECREF(*args2);
	if (*kwds2)
		Py_XDECREF(*kwds2);
	return -1;
}

static PyObject *__Pyx_GetName(PyObject *dict, char *name) {
	PyObject *result;
	result = PyObject_GetAttrString(dict, name);
	if (!result)
		PyErr_SetString(PyExc_NameError, name);
	return result;
}

static PyObject *__Pyx_GetExcValue(void) {
	PyObject *type = 0, *value = 0, *tb = 0;
	PyObject *result = 0;
	PyThreadState *tstate = PyThreadState_Get();
	PyErr_Fetch(&type, &value, &tb);
	PyErr_NormalizeException(&type, &value, &tb);
	if (PyErr_Occurred())
		goto bad;
	if (!value) {
		value = Py_None;
		Py_INCREF(value);
	}
	Py_XDECREF(tstate->exc_type);
	Py_XDECREF(tstate->exc_value);
	Py_XDECREF(tstate->exc_traceback);
	tstate->exc_type = type;
	tstate->exc_value = value;
	tstate->exc_traceback = tb;
	result = value;
	Py_XINCREF(result);
	type = 0;
	value = 0;
	tb = 0;
bad:
	Py_XDECREF(type);
	Py_XDECREF(value);
	Py_XDECREF(tb);
	return result;
}

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb) {
	Py_XINCREF(type);
	Py_XINCREF(value);
	Py_XINCREF(tb);
	/* First, check the traceback argument, replacing None with NULL. */
	if (tb == Py_None) {
		Py_DECREF(tb);
		tb = 0;
	}
	else if (tb != NULL && !PyTraceBack_Check(tb)) {
		PyErr_SetString(PyExc_TypeError,
			"raise: arg 3 must be a traceback or None");
		goto raise_error;
	}
	/* Next, replace a missing value with None */
	if (value == NULL) {
		value = Py_None;
		Py_INCREF(value);
	}
	/* Next, repeatedly, replace a tuple exception with its first item */
	while (PyTuple_Check(type) && PyTuple_Size(type) > 0) {
		PyObject *tmp = type;
		type = PyTuple_GET_ITEM(type, 0);
		Py_INCREF(type);
		Py_DECREF(tmp);
	}
	if (PyString_Check(type))
		;
	else if (PyClass_Check(type))
		; /*PyErr_NormalizeException(&type, &value, &tb);*/
	else if (PyInstance_Check(type)) {
		/* Raising an instance.  The value should be a dummy. */
		if (value != Py_None) {
			PyErr_SetString(PyExc_TypeError,
			  "instance exception may not have a separate value");
			goto raise_error;
		}
		else {
			/* Normalize to raise <class>, <instance> */
			Py_DECREF(value);
			value = type;
			type = (PyObject*) ((PyInstanceObject*)type)->in_class;
			Py_INCREF(type);
		}
	}
	else {
		/* Not something you can raise.  You get an exception
		   anyway, just not what you specified :-) */
		PyErr_Format(PyExc_TypeError,
			     "exceptions must be strings, classes, or "
			     "instances, not %s", type->ob_type->tp_name);
		goto raise_error;
	}
	PyErr_Restore(type, value, tb);
	return;
raise_error:
	Py_XDECREF(value);
	Py_XDECREF(type);
	Py_XDECREF(tb);
	return;
}

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(char *funcname) {
	PyObject *py_srcfile = 0;
	PyObject *py_funcname = 0;
	PyObject *py_globals = 0;
	PyObject *empty_tuple = 0;
	PyObject *empty_string = 0;
	PyCodeObject *py_code = 0;
	PyFrameObject *py_frame = 0;
	
	py_srcfile = PyString_FromString(__pyx_filename);
	if (!py_srcfile) goto bad;
	py_funcname = PyString_FromString(funcname);
	if (!py_funcname) goto bad;
	py_globals = PyModule_GetDict(__pyx_m);
	if (!py_globals) goto bad;
	empty_tuple = PyTuple_New(0);
	if (!empty_tuple) goto bad;
	empty_string = PyString_FromString("");
	if (!empty_string) goto bad;
	py_code = PyCode_New(
		0,            /*int argcount,*/
		0,            /*int nlocals,*/
		0,            /*int stacksize,*/
		0,            /*int flags,*/
		empty_string, /*PyObject *code,*/
		empty_tuple,  /*PyObject *consts,*/
		empty_tuple,  /*PyObject *names,*/
		empty_tuple,  /*PyObject *varnames,*/
		empty_tuple,  /*PyObject *freevars,*/
		empty_tuple,  /*PyObject *cellvars,*/
		py_srcfile,   /*PyObject *filename,*/
		py_funcname,  /*PyObject *name,*/
		__pyx_lineno,   /*int firstlineno,*/
		empty_string  /*PyObject *lnotab*/
	);
	if (!py_code) goto bad;
	py_frame = PyFrame_New(
		PyThreadState_Get(), /*PyThreadState *tstate,*/
		py_code,             /*PyCodeObject *code,*/
		py_globals,          /*PyObject *globals,*/
		0                    /*PyObject *locals*/
	);
	if (!py_frame) goto bad;
	py_frame->f_lineno = __pyx_lineno;
	PyTraceBack_Here(py_frame);
bad:
	Py_XDECREF(py_srcfile);
	Py_XDECREF(py_funcname);
	Py_XDECREF(empty_tuple);
	Py_XDECREF(empty_string);
	Py_XDECREF(py_code);
	Py_XDECREF(py_frame);
}
