from __future__ import absolute_import, unicode_literals

import pytest
from psd_tools.psd.color_mode_data import ColorModeData
from psd_tools.utils import pack

from ..utils import check_read_write

INDEX_COLOR_DATA = (
    b"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
    b"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
    b"\xff\xff\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
    b"\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
    b"\xcc\xcc\xcc\xcc\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99"
    b"\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99\x99"
    b"\x99\x99\x99\x99\x99\x99ffffffffffffffffffffffffffffffffffff333333333"
    b"333333333333333333333333333\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\n\t\xff\xff\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff"
    b"\xff\xff\xff\xcc\xcc\xcc\xcc\xcc\xcc\x99\x99\x99\x99\x99\x99ffffff33"
    b"3333\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xcc\xcc\xcc\xcc"
    b"\xcc\xcc\x99\x99\x99\x99\x99\x99ffffff333333\x00\x00\x00\x00\x00\x00"
    b"\xff\xff\xff\xff\xff\xff\xcc\xcc\xcc\xcc\xcc\xcc\x99\x99\x99\x99\x99"
    b"\x99ffffff333333\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xcc"
    b"\xcc\xcc\xcc\xcc\xcc\x99\x99\x99\x99\x99\x99ffffff333333\x00\x00\x00"
    b"\x00\x00\x00\xff\xff\xff\xff\xff\xff\xcc\xcc\xcc\xcc\xcc\xcc\x99\x99"
    b"\x99\x99\x99\x99ffffff333333\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff"
    b"\xff\xff\xcc\xcc\xcc\xcc\xcc\xcc\x99\x99\x99\x99\x99\x99ffffff333333"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00~\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xcc\x99f3\x00\xff"
    b"\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00"
    b"\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3"
    b"\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc"
    b"\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff"
    b"\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00"
    b"\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3"
    b"\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc"
    b"\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff"
    b"\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00\xff\xcc\x99f3\x00"
    b"\xff\xcc\x99f3\x00Y\xb2\xb2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
)

DUOTONE_DATA = (
    b"\x00\x01\x00\x02\x00\x02\xff\xff\xff\xff\xff\xff\x00\x00\x00\x03  327C"
    b"\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x05Black\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0fPANTONE 327"
    b" CVC\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff"
    b"\xff\xff\x01\x90\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x03\xe8\x00"
    b"\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01^\xff\xff\xff"
    b"\xff\x02\xbc\xff\xff\xff\xff\x03\xe8\x00\x00\x00\x00\xff\xff\xff\xff"
    b"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
    b"\xff\x03\xe8\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
    b"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x03\xe8\x00\x00\x00"
    b"\x14\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00"
    b"\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00"
    b"\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00"
    b"\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00"
    b"\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00"
    b"\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff"
    b"\xff\x00\x00\x00\x00\x00\x00\x00\x00"
)


@pytest.mark.parametrize(
    "fixture",
    [
        b"\x00\x00\x00\x00",
        pack("I", len(INDEX_COLOR_DATA)) + INDEX_COLOR_DATA,
        pack("I", len(DUOTONE_DATA)) + DUOTONE_DATA,
    ],
)
def test_color_mode_data(fixture):
    check_read_write(ColorModeData, fixture)


def test_color_mode_data_exception():
    with pytest.raises(IOError):
        ColorModeData.frombytes(b"")
    with pytest.raises(IOError):
        ColorModeData.frombytes(str(10).encode("ascii"))
