//
// Binder.h
//
// $Id: //poco/1.3/Data/MySQL/include/Poco/Data/MySQL/Binder.h#3 $
//
// Library: Data/MySQL
// Package: MySQL
// Module:  Binder
//
// Definition of the Binder class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Data_MySQL_Binder_INCLUDED
#define Data_MySQL_Binder_INCLUDED


#include "Poco/Data/MySQL/MySQL.h"
#include "Poco/Data/AbstractBinder.h"
#include "Poco/Data/BLOB.h"
#include "Poco/Data/MySQL/MySQLException.h"
#include <mysql.h>


namespace Poco {
namespace Data {
namespace MySQL {


class MySQL_API Binder: public Poco::Data::AbstractBinder
	/// Binds placeholders in the sql query to the provided values. Performs data types mapping.
{
public:
	Binder();
		/// Creates the Binder.
		
	virtual ~Binder();
		/// Destroys the Binder.
	
	virtual void bind(std::size_t pos, const Poco::Int8& val);
		/// Binds an Int8.
		
	virtual void bind(std::size_t pos, const Poco::UInt8& val);
		/// Binds an UInt8.
		
	virtual void bind(std::size_t pos, const Poco::Int16& val);
		/// Binds an Int16.
		
	virtual void bind(std::size_t pos, const Poco::UInt16& val);
		/// Binds an UInt16.
		
	virtual void bind(std::size_t pos, const Poco::Int32& val);
		/// Binds an Int32.
		
	virtual void bind(std::size_t pos, const Poco::UInt32& val);
		/// Binds an UInt32.
		
	virtual void bind(std::size_t pos, const Poco::Int64& val);
		/// Binds an Int64.
		
	virtual void bind(std::size_t pos, const Poco::UInt64& val);
		/// Binds an UInt64.
		
	virtual void bind(std::size_t pos, const bool& val);
		/// Binds a boolean.
		
	virtual void bind(std::size_t pos, const float& val);
		/// Binds a float.
		
	virtual void bind(std::size_t pos, const double& val);
		/// Binds a double.
		
	virtual void bind(std::size_t pos, const char& val);
		/// Binds a single character.

	virtual void bind(std::size_t pos, const std::string& val);
		/// Binds a string.
		
	virtual void bind(std::size_t pos, const Poco::Data::BLOB& val);
		/// Binds a BLOB.

	size_t size() const;
		/// Return count of binded parameters

	MYSQL_BIND* getBindArray() const;
		/// Return array

private:
	virtual void bind(std::size_t, const char* const&)
		/// Binds a const char ptr. 
		/// This is a private no-op in this implementation
		/// due to security risk.
	{
	}

	void realBind(std::size_t pos, enum_field_types type, const void* buffer, int length);
		/// Common bind implementation

private:
	std::vector<MYSQL_BIND> _bindArray;
};


} } } // namespace Poco::Data::MySQL


#endif // Data_MySQL_Binder_INCLUDED
