# PlatformIO Project Examples

- [Development platforms](#development-platforms):
  - [Embedded](#embedded)
  - [Desktop](#desktop)
- [Frameworks](#frameworks)

## Development platforms

### Embedded

* [Aceinna IMU](https://github.com/aceinna/platform-aceinna_imu/tree/master/examples)
* [Atmel AVR](https://github.com/platformio/platform-atmelavr/tree/master/examples)
* [Atmel megaAVR](https://github.com/platformio/platform-atmelmegaavr/tree/master/examples)
* [Atmel SAM](https://github.com/platformio/platform-atmelsam/tree/master/examples)
* [Espressif 32](https://github.com/platformio/platform-espressif32/tree/master/examples)
* [Espressif 8266](https://github.com/platformio/platform-espressif8266/tree/master/examples)
* [Freescale Kinetis](https://github.com/platformio/platform-freescalekinetis/tree/master/examples)
* [GigaDevice GD32V](https://github.com/sipeed/platform-gd32v/tree/master/examples)
* [Infineon XMC](https://github.com/Infineon/platformio-infineonxmc/tree/master/examples)
* [Intel ARC32](https://github.com/platformio/platform-intel_arc32/tree/master/examples)
* [Intel MCS-51 (8051)](https://github.com/platformio/platform-intel_mcs51/tree/master/examples)
* [Kendryte K210](https://github.com/sipeed/platform-kendryte210/tree/master/examples)
* [Lattice iCE40](https://github.com/platformio/platform-lattice_ice40/tree/master/examples)
* [Maxim 32](https://github.com/platformio/platform-maxim32/tree/master/examples)
* [Microchip PIC32](https://github.com/platformio/platform-microchippic32/tree/master/examples)
* [Nordic nRF51](https://github.com/platformio/platform-nordicnrf51/tree/master/examples)
* [Nordic nRF52](https://github.com/platformio/platform-nordicnrf52/tree/master/examples)
* [Nuclei](https://github.com/Nuclei-Software/platform-nuclei/tree/master/examples)
* [NXP i.MX RT](https://github.com/platformio/platform-nxpimxrt/tree/master/examples)
* [NXP LPC](https://github.com/platformio/platform-nxplpc/tree/master/examples)
* [RISC-V GAP](https://github.com/pioplus/platform-riscv_gap/tree/master/examples)
* [Shakti](https://github.com/platformio/platform-shakti/tree/master/examples)
* [SiFive](https://github.com/platformio/platform-sifive/tree/master/examples)
* [Silicon Labs EFM32](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples)
* [ST STM32](https://github.com/platformio/platform-ststm32/tree/master/examples)
* [ST STM8](https://github.com/platformio/platform-ststm8/tree/master/examples)
* [Teensy](https://github.com/platformio/platform-teensy/tree/master/examples)
* [TI MSP430](https://github.com/platformio/platform-timsp430/tree/master/examples)
* [TI TIVA](https://github.com/platformio/platform-titiva/tree/master/examples)
* [WIZNet W7500](https://github.com/platformio/platform-wiznet7500/tree/master/examples)

### Desktop

* [Linux ARM](https://github.com/platformio/platform-linux_arm/tree/master/examples)
* [Linux i686](https://github.com/platformio/platform-linux_i686/tree/master/examples)
* [Linux x86_64](https://github.com/platformio/platform-linux_x86_64/tree/master/examples)
* [Native](https://github.com/platformio/platform-native/tree/master/examples)
* [Windows x86](https://github.com/platformio/platform-windows_x86/tree/master/examples)

## Frameworks

* [Arduino](https://docs.platformio.org/en/latest/frameworks/arduino.html?utm_source=github&utm_medium=examples#examples)
* [CMSIS](https://docs.platformio.org/en/latest/frameworks/cmsis.html?utm_source=github&utm_medium=examples#examples)
* [ESP-IDF](https://docs.platformio.org/en/latest/frameworks/espidf.html?utm_source=github&utm_medium=examples#examples)
* [ESP8266 Non-OS SDK](https://docs.platformio.org/en/latest/frameworks/esp8266-nonos-sdk.html?utm_source=github&utm_medium=examples#examples)
* [ESP8266 RTOS SDK](https://docs.platformio.org/en/latest/frameworks/esp8266-rtos-sdk.html?utm_source=github&utm_medium=examples#examples)
* [Freedom E SDK](https://docs.platformio.org/en/latest/frameworks/freedom-e-sdk.html?utm_source=github&utm_medium=examples#examples)
* [GigaDevice GD32V SDK](https://docs.platformio.org/en/latest/frameworks/gd32vf103-sdk.html?utm_source=github&utm_medium=examples#examples)
* [Kendryte Standalone SDK](https://docs.platformio.org/en/latest/frameworks/kendryte-standalone-sdk.html?utm_source=github&utm_medium=examples#examples)
* [Kendryte FreeRTOS SDK](https://docs.platformio.org/en/latest/frameworks/kendryte-freertos-sdk.html?utm_source=github&utm_medium=examples#examples)
* [libOpenCM3](https://docs.platformio.org/en/latest/frameworks/libopencm3.html?utm_source=github&utm_medium=examples#examples)
* [Mbed](https://docs.platformio.org/en/latest/frameworks/mbed.html?utm_source=github&utm_medium=examples#examples)
* [Nuclei SDK](https://docs.platformio.org/en/latest/frameworks/nuclei-sdk.html?utm_source=github&utm_medium=examples#examples)
* [PULP OS](https://docs.platformio.org/en/latest/frameworks/pulp-os.html?utm_source=github&utm_medium=examples#examples)
* [Pumbaa](https://docs.platformio.org/en/latest/frameworks/pumbaa.html?utm_source=github&utm_medium=examples#examples)
* [Shakti SDK](https://docs.platformio.org/en/latest/frameworks/shakti-sdk.html?utm_source=github&utm_medium=examples#examples)
* [Simba](https://docs.platformio.org/en/latest/frameworks/simba.html?utm_source=github&utm_medium=examples#examples)
* [SPL](https://docs.platformio.org/en/latest/frameworks/spl.html?utm_source=github&utm_medium=examples#examples)
* [STM32Cube](https://docs.platformio.org/en/latest/frameworks/stm32cube.html?utm_source=github&utm_medium=examples#examples)
* [WiringPi](https://docs.platformio.org/en/latest/frameworks/wiringpi.html?utm_source=github&utm_medium=examples#examples)
* [Zephyr](https://docs.platformio.org/en/latest/frameworks/zephyr.html?utm_source=github&utm_medium=examples#examples)
