/* Tic-Tac-Toe plasmoid
 * Copyright (C) 2009 Mauro E. Bender <mbender@dc.uba.ar>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef APPEARANCESETTINGS_H
#define APPEARANCESETTINGS_H

#include "theme.h"

#include <QWidget>
#include <QComboBox>
#include <QString>
#include <Plasma/Svg>

class AppearanceSettings : public QWidget {
	Q_OBJECT
	
	public:
		AppearanceSettings( Plasma::Svg *,  Theme, QWidget * = 0 );
		~AppearanceSettings(){};
		
		void setCurrentTheme( Theme );
		Theme getCurrentTheme();
		
	private:
		QComboBox *_comboBox;
		Theme _currentTheme;
};

#endif