/*	test_Stream_Monitor

PIRL CVS ID: test_Stream_Monitor.java,v 1.8 2012/04/16 06:23:00 castalia Exp

Copyright (C) 2007-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Viewers.Stream_Monitor;
import	PIRL.Conductor.Stream_Logger;
import	PIRL.Utilities.Streams;

import	javax.swing.JFrame;
import	javax.swing.JMenuBar;
import	javax.swing.JPanel;
import	java.awt.Dimension;
import	java.awt.GridBagLayout;
import	java.awt.GridBagConstraints;
import	java.io.InputStream;
import	java.io.OutputStreamWriter;


public class test_Stream_Monitor
{
private static Stream_Monitor
	Monitor = new Stream_Monitor ();


public static void main
	(
	String[]    args
	)
{
if (args.length == 0)
	Usage ();

InputStream
	source = null;
if (args[0].equals ("-"))
	{
	args[0] = "stdin";
	source = System.in;
	}
else
	source = Streams.Get_Stream (args[0]);
if (source == null)
	{
	System.out.println
		("An input stream could not be obtained for " + args[0]);
	Usage ();
	}

Monitor
	.Write (Stream_Monitor.ID + "\n\n", Monitor.NOTICE_STYLE)
	.Auto_Style (true)
	.Auto_Style (args[0], Monitor.stdout_STYLE);

final JFrame
	frame = new JFrame ("Stream_Monitor");
frame.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
JMenuBar
	menu_bar = new JMenuBar ();
menu_bar.add (Monitor.File_Menu ());
menu_bar.add (Monitor.View_Menu ());
frame.setJMenuBar (menu_bar);

JPanel
	content = new JPanel (new GridBagLayout ());
GridBagConstraints
	location = new GridBagConstraints ();
location.fill		= GridBagConstraints.BOTH;
location.weightx	= 1.0;
location.weighty	= 1.0;
location.gridwidth	= GridBagConstraints.REMAINDER;
content.add (Monitor, location);

content.setPreferredSize (new Dimension (640, 480));
frame.setContentPane (content);
frame.pack ();
frame.setVisible (true);

Stream_Logger
	stream_logger = new Stream_Logger
		(args[0], source, Monitor.Writer ());
stream_logger.start ();
}


public static void Usage ()
{
System.out.println
	("Usage: test_Stream_Monitor <source>\n"
	+"  The source may be a filename, URL or '-' for stdin.");
System.exit (1);
}


}
