# Copyright (c) 1997 Sun Microsystems, Inc.
# All rights reserved.
# 
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL SUN MICROSYSTEMS, INC. BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
# OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN
# MICROSYSTEMS, INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# SUN MICROSYSTEMS, INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THE SOFTWARE PROVIDED
# HEREUNDER IS ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS, INC. HAS NO
# OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
# MODIFICATIONS.

package SyncCM::timeops;

use Time::Local;

sub next_ndays
{
    my ($tick, $days) = @_;

    return &adjust_dst($tick, $tick + $days * 24 * 60 * 60);
}


sub adjust_dst
{
    my (@orig) = localtime($_[0]);
    my (@new) = localtime($_[1]);

    # Adjust for daylight savings time.
    #
    return $_[1]
	if ($orig[8] == $new[8]);

    return $_[1] + 60 * 60
	if ($orig[8] == 1);

    return $_[1] - 60 * 60;
}

sub unadjust_dst
{
    my (@orig) = localtime($_[0]);
    my (@new) = localtime($_[1]);

    # Remove DST adjustment
    #
    return $_[1]
	if ($orig[8] == $new[8]);

    return $_[1] - 60 * 60
	if ($orig[8] == 1);

    return $_[1] + 60 * 60;
}

sub diff_ndays
{
    my ($a, $b) = @_;

    $b = &unadjust_dst($a, $b);

    return ($b - $a) / (24 * 60 * 60);
}

sub tickToISO
{
    my (@time) = gmtime($_[0]);
    my ($val);

    $val = sprintf("%04d%02d%02dT%02d%02d%02dZ",
		     $time[5] + 1900,
		     $time[4] + 1,
		     reverse @time[0..3]);
    return ($val);
}

sub ISOToTick
{
    my ($buf) = @_;

    $buf =~ /^(....)(..)(..)T(..)(..)(..)Z/;

    return Time::Local::timelocal($6, $5, $4, $3, $2-1, $1-1900);
}

# Return the number of ticks since the beginning of this day
#
sub dayTicks
{
    my ($tick) = @_;
    my (@time) = localtime($tick);

    @time[0..2] = (0, 0, 0);

    return $tick - Time::Local::timelocal(@time);
}

# Return the first tick of the day containing this tick
#
sub startOfDay
{
    my ($tick) = @_;

    $tick -= &dayTicks($tick);
}

1;

