#!/usr/bin/perl

my $total_failed = 0;

for my $file (<test*.pl>) {
  print "Running $file ... ";
  # This might be 'do' one day, but not until we get output right
  my $output = `perl $file 2> /dev/null`;
  $output =~ s/.*\D(\d+ tests, \d+ succeeded, (\d+) failed).*/$1/s;
  print "$output\n";
  $total_failed += $2;
  print "  Try running the test manually (perl $file) to see failures\n" if $2;
}

if ($total_failed) {
  print "*** $total_failed tests failed\n";
} else {
  print "All tests successful\n";
}
