#############################################################################
#
#
#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 02 $
#
# Updated By:
# Antu Sanadi <santu@secpod.com> on 16/09/2009
#
#
##############################################################################

if(description)
{

  script_id(90012);
  script_version ("$Revision: 02$");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-2010");
  script_name("Buffer overflow in Apple Quicktime Player");
  desc = "The remote host is probable affected by the vulnerabilitys described in
  CVE-2008-0234 CVE-2008-2010

  Impact
    Buffer overflow in Apple Quicktime Player 7.3.1.70
    and other versions before 7.4.1, when RTSP tunneling
    is enabled, allows remote attackers to execute
    arbitrary code via a long Reason-Phrase response
    to an rtsp:// request, as demonstrated using a
    404 error message.

    Unspecified vulnerability in Apple QuickTime Player
    on Windows XP SP2 and Vista SP1 allows remote attackers
    to execute arbitrary code via a crafted QuickTime media
    file. NOTE: as of 20080429, the only disclosure is a
    vague pre-advisory with no actionable information.
    However, because it is from a well-known researcher,
    it is being assigned a CVE identifier for tracking purposes.

  References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0234
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2010
    http://lists.apple.com/archives/security-announce/2008/Feb/msg00001.html
    http://lists.apple.com/archives/Security-announce/2008/Jun/msg00000.html


  Solution:
    All Users should upgrade to the latest version.

  Risk factor : High";

 script_description(desc);
 script_summary("Check the version of Apple Quicktime Player");
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is under GPLv2");
 script_family("Buffer overflow");
 script_dependencies("secpod_apple_quicktime_detection_win_900124.nasl");
 exit(0);
}


include("version_func.inc");

qtVer = get_kb_item("QuickTime/Win/Ver");
if(qtVer)
{
  # QuickTime version < 7.50.51
  if(version_is_less(version:qtVer, test_version:"7.50.51")){
   security_hole(0);
  }
}
