###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_labtam_proftp_detect.nasl 5818 2009-11-19 15:34:29Z nov $
#
# Labtam ProFTP Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900979);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Labtam ProFTP Version Detection");
  desc = "
  Overview: This script detects the installed version of Labtam ProFTP and
  sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Labtam ProFTP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

keys = make_list();

key = "SOFTWARE\Lab-NC\ProFTP";
if(registry_key_exists(key:key)){
  keys = make_list(keys, key);
}

key = "SOFTWARE\Labtam\ProFtp";
if(registry_key_exists(key:key)){
   keys = make_list(keys, key);
}

foreach pfKey (keys)
{
  foreach item(registry_enum_keys(key:pfKey))
  {
    if(item =~ "[0-9]\.[0-9]"){
      set_kb_item(name:"Labtam/ProFTP/Ver", value:item);
      security_note(data:"Labtam ProFTP version " + item +
                                      " was detected on the host");
    }
  }
}
