###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openoffice_word_bof_vuln_win.nasl 4476 2009-09-04 11:30:56 sep $
#
# OpenOffice.org Documents Parsing Buffer Overflow Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800696);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0200", "CVE-2009-0201");
  script_bugtraq_id(36200);
  script_name("OpenOffice.org Word Documents Parsing Buffer Overflow Vulnerability (Win)");
  desc = "
  Overview: The host has OpenOffice installed and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  - An integer underflow error occurs when parsing certain records in a
    Word document table.
  - An heap overflow error occurs when parsing certain records in a Word
    document when opening a malicious Word document.

  Impact:
  Successful remote exploitation could result in arbitrary code execution on
  the affected system which leads to application crash and compromise a
  vulnerable system.

  Impact Level: System/Application

  Affected Software/OS:
  OpenOffice Version prior to 3.1.1 on Windows.

  Fix: Upgrade to OpenOffice Version 3.1.1 or later
  For Updates Refer, http://www.openoffice.org/

  References:
  http://secunia.com/secunia_research/2009-27/
  http://www.vupen.com/english/advisories/2009/2490

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_openoffice_detect_win.nasl");
  script_require_keys("OpenOffice/Win/Ver");
  exit(0);
}


include("version_func.inc");

openVer = get_kb_item("OpenOffice/Win/Ver");
if(!openVer)
{
  exit(0);
}

# Check for OpenOffice version prior to 3.1.1 (3.1.9420)
if(version_is_less(version:openVer, test_version:"3.1.9420")){
  security_hole(0);
}
