##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_flock_detect_lin.nasl 4375 2009-08-31 18:02:24Z aug $
#
# Flock Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800878);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Flock Version Detection (Linux)");
  desc = "
  Overview: This script detects the installed version of Flock Browser and
  sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Flock Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

f_soc = ssh_login_or_reuse_connection();
if(!f_soc){
  exit(0);
}

foreach item (make_list("flock-browser", "flock"))
{
  flock_paths = find_file(file_name:item, file_path:"/", useregex:TRUE,
                          regexpar:"$", sock:f_soc);
  if(!isnull(flock_paths))
  {
    foreach binaryName (flock_paths)
    {
      flockVer = get_bin_version(full_prog_name:chomp(binaryName), sock:f_soc,
                                 version_argv:"--version", ver_pattern:"Flock "+
                                 "Browser ([0-9]\.[0-9.]+((b|rc)[0-9])?)");
      if(!isnull(flockVer[1]))
      {
        set_kb_item(name:"Flock/Linux/Ver", value:flockVer[1]);
        security_note(data:"Flock Browser version " + flockVer[1] + " was detected on the host");
      }
    }
  }
}
ssh_close_connection();
