#
#VID e811aaf1-f015-11d8-876f-00902714cc7c
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52407);
 script_cve_id("CVE-2004-0755");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: ruby";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: ruby

CVE-2004-0755
The FileStore capability in CGI::Session for Ruby before 1.8.1, and
possibly PStore, creates files with insecure permissions, which can
allow local users to steal session information and hijack sessions.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://xforce.iss.net/xforce/xfdb/16996
http://www.debian.org/security/2004/dsa-537
http://marc.theaimsgroup.com/?l=bugtraq&m=109267579822250&w=2
http://www.vuxml.org/freebsd/e811aaf1-f015-11d8-876f-00902714cc7c.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: ruby";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ruby");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.8.2004.07.26")<0) {
    security_note(0, data:"Package ruby version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.7.0")>=0 && revcomp(a:bver, b:"1.8.1.2004.07.23")<0) {
    security_note(0, data:"Package ruby version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
