#
#VID e7bc5600-eaa0-11de-bd9c-00215c6a37bb
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID e7bc5600-eaa0-11de-bd9c-00215c6a37bb
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66611);
 script_cve_id("CVE-2009-4034", "CVE-2009-4136");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("FreeBSD Ports: postgresql-client, postgresql-server");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   postgresql-client
   postgresql-server

CVE-2009-4034
PostgreSQL 7.4.x before 7.4.27, 8.0.x before 8.0.23, 8.1.x before
8.1.19, 8.2.x before 8.2.15, 8.3.x before 8.3.9, and 8.4.x before
8.4.2 does not properly handle a '\0' character in a domain name in
the subject's Common Name (CN) field of an X.509 certificate, which
(1) allows man-in-the-middle attackers to spoof arbitrary SSL-based
PostgreSQL servers via a crafted server certificate issued by a
legitimate Certification Authority, and (2) allows remote attackers to
bypass intended client-hostname restrictions via a crafted client
certificate issued by a legitimate Certification Authority, a related
issue to CVE-2009-2408.

CVE-2009-4136
PostgreSQL 7.4.x before 7.4.27, 8.0.x before 8.0.23, 8.1.x before
8.1.19, 8.2.x before 8.2.15, 8.3.x before 8.3.9, and 8.4.x before
8.4.2 does not properly manage session-local state during execution of
an index function by a database superuser, which allows remote
authenticated users to gain privileges via a table with crafted index
functions, as demonstrated by functions that modify (1) search_path or
(2) a prepared statement, a related issue to CVE-2007-6600 and
CVE-2009-3230.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: postgresql-client, postgresql-server");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"postgresql-client");
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>=0 && revcomp(a:bver, b:"7.4.27")<0) {
    security_note(0, data:"Package postgresql-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.0")>=0 && revcomp(a:bver, b:"8.0.23")<0) {
    security_note(0, data:"Package postgresql-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.1")>=0 && revcomp(a:bver, b:"8.1.19")<0) {
    security_note(0, data:"Package postgresql-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.2")>=0 && revcomp(a:bver, b:"8.2.15")<0) {
    security_note(0, data:"Package postgresql-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.3")>=0 && revcomp(a:bver, b:"8.3.9")<0) {
    security_note(0, data:"Package postgresql-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.4")>=0 && revcomp(a:bver, b:"8.4.2")<0) {
    security_note(0, data:"Package postgresql-client version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"postgresql-server");
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>=0 && revcomp(a:bver, b:"7.4.27")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.0")>=0 && revcomp(a:bver, b:"8.0.23")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.1")>=0 && revcomp(a:bver, b:"8.1.19")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.2")>=0 && revcomp(a:bver, b:"8.2.15")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.3")>=0 && revcomp(a:bver, b:"8.3.9")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.4")>=0 && revcomp(a:bver, b:"8.4.2")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
