\name{computeTestPartialPearson}
\alias{computeTestPartialPearson}
\title{Compute the Partial Pearson Test on 2 data sets.}
\description{
This ROT function, called from a Test C++ object, is given 2 samples,
a vector specifying which variables are to be tested, and optionnaly 
a test level. It then returns the result of a PP test against the 
null hypothesis that the in/out variables are not correlated, and 
the test p-values.
}
\usage{
computeTestPartialPearson(inData, outData, selection, testLevel = 0.95)
}
\arguments{
  \item{inData}{The 'in' sample. (m-by-n matrix)}
  \item{outData}{The 'out' sample (n vector).}
  \item{selection}{The list of partial tests (vector containing the 
                   indexes of the variables to be tested.}
  \item{testLevel}{the test level. (scalar in [0:1])}
}
\value{
 A list is returned, containing :
  \item{testResult}{The result. 1 means H0 is not rejected. (scalar)}
  \item{threshold}{The threshold applied to the p-value when deciding the outcome of the test.}
  \item{pvalues}{The test pvalues. (vector)}
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
outData=runif(4)
inData=matrix(runif(40), 4, 10)
selection=c(1,2,3,6,9)
computeTestPartialPearson(inData,outData,selection)
}
\keyword{multivariate}