/* 
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javafx.scene.control;

/**
Builder class for javafx.scene.control.TreeView
@see javafx.scene.control.TreeView
@deprecated This class is deprecated and will be removed in the next version
* @since JavaFX 2.0
*/
@javax.annotation.Generated("Generated by javafx.builder.processor.BuilderProcessor")
@Deprecated
public class TreeViewBuilder<T, B extends javafx.scene.control.TreeViewBuilder<T, B>> extends javafx.scene.control.ControlBuilder<B> implements javafx.util.Builder<javafx.scene.control.TreeView<T>> {
    protected TreeViewBuilder() {
    }
    
    /** Creates a new instance of TreeViewBuilder. */
    @SuppressWarnings({"deprecation", "rawtypes", "unchecked"})
    public static <T> javafx.scene.control.TreeViewBuilder<T, ?> create() {
        return new javafx.scene.control.TreeViewBuilder();
    }
    
    private int __set;
    private void __set(int i) {
        __set |= 1 << i;
    }
    public void applyTo(javafx.scene.control.TreeView<T> x) {
        super.applyTo(x);
        int set = __set;
        while (set != 0) {
            int i = Integer.numberOfTrailingZeros(set);
            set &= ~(1 << i);
            switch (i) {
                case 0: x.setCellFactory(this.cellFactory); break;
                case 1: x.setEditable(this.editable); break;
                case 2: x.setFocusModel(this.focusModel); break;
                case 3: x.setOnEditCancel(this.onEditCancel); break;
                case 4: x.setOnEditCommit(this.onEditCommit); break;
                case 5: x.setOnEditStart(this.onEditStart); break;
                case 6: x.setRoot(this.root); break;
                case 7: x.setSelectionModel(this.selectionModel); break;
                case 8: x.setShowRoot(this.showRoot); break;
            }
        }
    }
    
    private javafx.util.Callback<javafx.scene.control.TreeView<T>,javafx.scene.control.TreeCell<T>> cellFactory;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#getCellFactory() cellFactory} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B cellFactory(javafx.util.Callback<javafx.scene.control.TreeView<T>,javafx.scene.control.TreeCell<T>> x) {
        this.cellFactory = x;
        __set(0);
        return (B) this;
    }
    
    private boolean editable;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#isEditable() editable} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B editable(boolean x) {
        this.editable = x;
        __set(1);
        return (B) this;
    }
    
    private javafx.scene.control.FocusModel<javafx.scene.control.TreeItem<T>> focusModel;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#getFocusModel() focusModel} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B focusModel(javafx.scene.control.FocusModel<javafx.scene.control.TreeItem<T>> x) {
        this.focusModel = x;
        __set(2);
        return (B) this;
    }
    
    private javafx.event.EventHandler<javafx.scene.control.TreeView.EditEvent<T>> onEditCancel;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#getOnEditCancel() onEditCancel} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B onEditCancel(javafx.event.EventHandler<javafx.scene.control.TreeView.EditEvent<T>> x) {
        this.onEditCancel = x;
        __set(3);
        return (B) this;
    }
    
    private javafx.event.EventHandler<javafx.scene.control.TreeView.EditEvent<T>> onEditCommit;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#getOnEditCommit() onEditCommit} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B onEditCommit(javafx.event.EventHandler<javafx.scene.control.TreeView.EditEvent<T>> x) {
        this.onEditCommit = x;
        __set(4);
        return (B) this;
    }
    
    private javafx.event.EventHandler<javafx.scene.control.TreeView.EditEvent<T>> onEditStart;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#getOnEditStart() onEditStart} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B onEditStart(javafx.event.EventHandler<javafx.scene.control.TreeView.EditEvent<T>> x) {
        this.onEditStart = x;
        __set(5);
        return (B) this;
    }
    
    private javafx.scene.control.TreeItem<T> root;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#getRoot() root} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B root(javafx.scene.control.TreeItem<T> x) {
        this.root = x;
        __set(6);
        return (B) this;
    }
    
    private javafx.scene.control.MultipleSelectionModel<javafx.scene.control.TreeItem<T>> selectionModel;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#getSelectionModel() selectionModel} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B selectionModel(javafx.scene.control.MultipleSelectionModel<javafx.scene.control.TreeItem<T>> x) {
        this.selectionModel = x;
        __set(7);
        return (B) this;
    }
    
    private boolean showRoot;
    /**
    Set the value of the {@link javafx.scene.control.TreeView#isShowRoot() showRoot} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B showRoot(boolean x) {
        this.showRoot = x;
        __set(8);
        return (B) this;
    }
    
    /**
    Make an instance of {@link javafx.scene.control.TreeView} based on the properties set on this builder.
    */
    public javafx.scene.control.TreeView<T> build() {
        javafx.scene.control.TreeView<T> x = new javafx.scene.control.TreeView<T>();
        applyTo(x);
        return x;
    }
}
