/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_KERNELS_COLLECTION_H_
#define _OPENSHIVA_KERNELS_COLLECTION_H_

#include <list>
#include <OpenShiva/Source.h>

namespace GTLCore {
  class String;
}

namespace OpenShiva {
  /**
   * @ingroup OpenShiva
   * 
   * This class allows to access to the list of kernels installed in the system.
   * 
   * The collection will look for .shiva files in:
   * ${PREFIX}/share/OpenGTL/shiva/kernels
   * ${HOME}/.OpenGTL/shiva/kernels
   */
  class OPENSHIVA_EXPORT SourcesCollection {
      GTL_NO_COPY(SourcesCollection);
    public:
      SourcesCollection( );
      ~SourcesCollection();
      /**
       * Add custom directories
       */
      void addDirectory(const GTLCore::String& directory);
      /**
       * Manually register a Kernel in the collection. And takes ownership
       */
      void registerSource( const Source& );
      /**
       * @return the list of kernels in the collection
       */
      std::list< Source > sources() const;
      /**
       * @return the list of sources in the collection that have the type given in argument.
       */
      std::list< Source > sources(Source::SourceType _source) const;
      /**
       * @return a kernel by the name of @p _string or null if no such kernel exists
       */
      Source source(const GTLCore::String& _string) const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif
