/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.turbine.om.ComboKey;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.Persistent;
import org.apache.turbine.om.SimpleKey;
import org.apache.turbine.om.StringKey;

public abstract class BaseObject
implements Persistent,
Serializable {
    public static final int NEW_ID = -1;
    private static String errMsg = "method must be overridden if called";
    private boolean is_new = true;
    private ObjectKey primaryKey = null;
    private boolean modified = false;

    public ObjectKey getPrimaryKey() {
        return this.primaryKey;
    }

    public int getPrimaryKeyAsInt() {
        int pkInt = -1;
        try {
            pkInt = Integer.parseInt(this.getPrimaryKey().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pkInt;
    }

    public long getPrimaryKeyAsLong() {
        long pkLong = -1L;
        try {
            pkLong = Long.parseLong(this.getPrimaryKey().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pkLong;
    }

    public BigDecimal getPrimaryKeyAsBigDecimal() {
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(this.getPrimaryKey().toString());
        }
        catch (Exception e) {
            bd = new BigDecimal(-1.0);
        }
        return bd;
    }

    public String getPrimaryKeyAsString() {
        if (this.getPrimaryKey() == null) {
            return null;
        }
        return this.getPrimaryKey().toString();
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isNew() {
        return this.is_new;
    }

    public void setNew(boolean b) {
        this.is_new = b;
    }

    public void setPrimaryKey(int primaryKey) throws Exception {
        this.primaryKey = new NumberKey(BigDecimal.valueOf(primaryKey));
    }

    public void setPrimaryKey(long primaryKey) throws Exception {
        this.primaryKey = new NumberKey(String.valueOf(primaryKey));
    }

    public void setPrimaryKey(String primaryKey) throws Exception {
        this.primaryKey = new StringKey(primaryKey);
    }

    public void setPrimaryKey(SimpleKey[] primaryKey) throws Exception {
        this.primaryKey = new ComboKey(primaryKey);
    }

    public void setPrimaryKey(ObjectKey primaryKey) throws Exception {
        this.primaryKey = primaryKey;
    }

    public void setModified(boolean m) {
        this.modified = m;
    }

    public void resetModified() {
        this.modified = false;
    }

    public void save() throws Exception {
        throw new Error("BaseObject.save: " + errMsg);
    }

    public Object getByName(String field) {
        throw new Error("BaseObject.getByName: " + errMsg);
    }

    public Object getByPeerName(String name) {
        throw new Error("BaseObject.getByPeerName: " + errMsg);
    }

    public Object getByPosition(int pos) {
        throw new Error("BaseObject.getByPosition: " + errMsg);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BaseObject) {
            return this.equals((BaseObject)obj);
        }
        return false;
    }

    public boolean equals(BaseObject bo) {
        if (bo == null) {
            return false;
        }
        if (this == bo) {
            return true;
        }
        if (this.getPrimaryKey() == null || bo.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(bo.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }
}

