/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_UI_INTERFACE_H__
#define __NB_UI_INTERFACE_H__

#include <glib.h>
#include <gtk/gtk.h>

enum
{
	TARGET_STRING,
	TARGET_URL
};

static GtkTargetEntry drag_drop_target[] =
{
	{ "text/plain",    0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
};


void		nb_ui_create_main_window (void);

/* dialogs */
gboolean	nb_ui_dialog_question (gchar * text, gchar * title);
void		nb_ui_dialog_error (gchar * text);

void		nb_ui_dialog_import ();
void		nb_ui_dialog_export ();

void		nb_ui_about_dialog_create (void);

/* store/load interface settings */
void		nb_ui_store_interface_positions (void);
void		nb_ui_load_interface_positions (void);

/* export dialog callback */
void 		nb_ui_dialog_export_cb_validate (GtkWidget * widget, gpointer user_data);

/* drag and drop callbacks */
void		nb_ui_cb_drag_received (GtkWidget * wgt, GdkDragContext * context, int x, int y, GtkSelectionData * seldata, guint info, guint time, gpointer userdata);

#endif
