import sys
from distutils.core import setup

try:
    from distutils.command.build_py import build_py_2to3
except ImportError:
    pass

fd = open('VERSION','r')
version = fd.read().strip()
fd.close()

from distutils.command.config import config
class CustomConfigCommand(config):
    def run(self):
        fd = open('nordugrid-arc-gangliarc.spec.in', 'r')
        lines = fd.readlines()
        fd.close()
        fd = open('nordugrid-arc-gangliarc.spec', 'w')
        for line in lines:
            line = line.replace("@VERSION@", version)
            fd.write(line)
        fd.close()
        config.run(self)

COMMANDS = {'config' : CustomConfigCommand }
if sys.version_info[0] == 3:
    COMMANDS['build_py'] = build_py_2to3

setup(name='nordugrid-arc-gangliarc',
      version = version,
      description = 'Ganglia monitoring for the ARC server',
      author = 'David Cameron',
      author_email = 'cameron@ndgf.org',
      url = 'http://www.nordugrid.org/',
      license = 'Apache 2.0 license',
      long_description = "gangliarc provides a way to monitor ARC services through an existing ganglia installation. Running gangliarc adds various ARC metrics to ganglia which can then be viewed along with regular ganglia metrics for the ARC host.",
      cmdclass = COMMANDS,
      py_modules = ['gangliarc'],
      data_files = [('/etc/init.d/', ['gangliarc'])]
)

