/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

/*
 * GrantPrivilegesDialog.java
 *
 * Created on 16.12.2008, 20:32:59
 */
package org.netbeans.modules.nativeexecution.support.ui;

import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class GrantPrivilegesDialog extends javax.swing.JPanel {

    private volatile boolean res;

    /** Creates new form GrantPrivilegesDialog */
    public GrantPrivilegesDialog() {
        initComponents();
    }

    public void clearPassword() {
        suPasswordField.setText(null);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        suLoginLabel = new javax.swing.JLabel();
        suPasswordLabel = new javax.swing.JLabel();
        suLoginField = new javax.swing.JTextField();
        suPasswordField = new javax.swing.JPasswordField();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(GrantPrivilegesDialog.class, "GrantPrivilegesDialog.jLabel1.text")); // NOI18N
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        suLoginLabel.setText(org.openide.util.NbBundle.getMessage(GrantPrivilegesDialog.class, "GrantPrivilegesDialog.suLoginLabel.text")); // NOI18N

        suPasswordLabel.setText(org.openide.util.NbBundle.getMessage(GrantPrivilegesDialog.class, "GrantPrivilegesDialog.suPasswordLabel.text")); // NOI18N

        suLoginField.setText(org.openide.util.NbBundle.getMessage(GrantPrivilegesDialog.class, "GrantPrivilegesDialog.suLoginField.text")); // NOI18N

        suPasswordField.setText(org.openide.util.NbBundle.getMessage(GrantPrivilegesDialog.class, "GrantPrivilegesDialog.suPasswordField.text")); // NOI18N
        suPasswordField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                hdlPasswordFieldFocus(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(suLoginLabel)
                            .addComponent(suPasswordLabel))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(suPasswordField, javax.swing.GroupLayout.DEFAULT_SIZE, 302, Short.MAX_VALUE)
                            .addComponent(suLoginField, javax.swing.GroupLayout.DEFAULT_SIZE, 302, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 106, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(suLoginLabel)
                    .addComponent(suLoginField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(suPasswordLabel)
                    .addComponent(suPasswordField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void hdlPasswordFieldFocus(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_hdlPasswordFieldFocus
        suPasswordField.selectAll();
    }//GEN-LAST:event_hdlPasswordFieldFocus

    public boolean askPassword() {
        suPasswordField.setText(null);

        final DialogDescriptor dd = new DialogDescriptor(this,
                loc("GrantPrivilegesDialog.title"), true, // NOI18N
                new Object[]{
                    DialogDescriptor.OK_OPTION,
                    DialogDescriptor.CANCEL_OPTION
                }, DialogDescriptor.OK_OPTION,
                DialogDescriptor.DEFAULT_ALIGN, null, null);
        res = false;
        
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.addWindowFocusListener(new WindowAdapter() {

            @Override
            public void windowGainedFocus(WindowEvent e) {
                suPasswordField.requestFocusInWindow();
            }
        });
        
        try {
            dialog.setVisible(true);
        } catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
            dd.setValue(DialogDescriptor.CANCEL_OPTION);
        } finally {
            dialog.dispose();
        }
        
        res = dd.getValue() == DialogDescriptor.OK_OPTION;
        
        return res;
    }

    public char[] getPassword() {
        return suPasswordField.getPassword();
    }

    public String getUser() {
        return String.valueOf(suLoginField.getText());
    }

    private static String loc(String key, Object... params) {
        return NbBundle.getMessage(GrantPrivilegesDialog.class, key, params);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField suLoginField;
    private javax.swing.JLabel suLoginLabel;
    private javax.swing.JPasswordField suPasswordField;
    private javax.swing.JLabel suPasswordLabel;
    // End of variables declaration//GEN-END:variables
}
