#!/usr/bin/env python

import sys, os.path

if len( sys.argv ) != 3:
    print >> sys.stderr, "Wrong number of arguments. Usage:\n" \
                         "create_version.py local version"
    sys.exit( 1 )

local = sys.argv[ 1 ].upper() == "TRUE"
version = sys.argv[ 2 ]

fName = os.path.sep.join( [ "cppcore", "grid", "webfront", "version.py" ] )
f = open( fName, "w" )
f.write(
"""
#
# Automatically generated by prepare_release
#

VERSION = '""" + version + """'

""" )
f.close()

if not local:
    ret = os.system( "svn add " + fName )
    if ret != 0:
        print >> sys.stderr, "Error adding generated file (" + fName + ") into SVN"
        sys.exit( 1 )

sys.exit( 0 )



