﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Diagnostics;

namespace Internal.Runtime.CompilerHelpers
{
    /// <summary>
    /// <see cref="System.Diagnostics.Debug"/> replacement for the startup path.
    /// It's not safe to use the full-blown Debug class during startup because big chunks
    /// of the managed execution environment are not initialized yet.
    /// </summary>
    internal static class StartupDebug
    {
        [Conditional("DEBUG")]
        public static void Assert(bool condition)
        {
            if (!condition)
                unsafe { *(int*)0 = 0; }
        }
    }
}
