/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <X11/xpm.h>
#include "XPixmap.h"
#include "Drag.h"
#include "MetviewUI.h"
#include <iostream>

XPixmap::XPixmap(const Path& name):
	name_(name),
	pixmap_(0)
{
}

XPixmap::~XPixmap()
{
}

void XPixmap::setLabel(Widget w)
{
	Pixmap pixmap = pixels();
	if(pixmap == XmUNSPECIFIED_PIXMAP)
		return;

	pixmap = CopyBackground(w,pixmap);

	XtVaSetValues(w,
		XmNlabelType, XmPIXMAP,
		XmNlabelPixmap,pixmap,
		0);

	pixmap = MakeDisabledPixmap(w,pixmap);

	XtVaSetValues(w,
		XmNlabelInsensitivePixmap,pixmap,
		0);
}

Pixmap XPixmap::pixels()
{
	if(!pixmap_) pixmap_ = DragGetPixmap(MetviewUI::root(),name_.str().c_str());
	return pixmap_;

}

static Path path(const string& name)
{
	static string dir(getenv("METVIEW_DIR_SHARE"));
	return Path(dir + "/icons/" + name + ".icon");
}

XPixmap::XPixmap(const string& name):
	name_(path(name)),
	pixmap_(0)
{
}

const string& XPixmap::name()
{
	return name_.str();
}
