/*
    interfaces - network interfaces detection
    Copyright (C) 2002-20011  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of samba www.samba.org

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.
*/


#ifndef _ZIFACES_H
#define _ZIFACES_H

#include <libziaint.h>

#ifdef Z_HAVE_WINSOCK2_H
#include <winsock2.h>
#endif

#ifdef Z_HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#define ZIFACE_NAME_SIZE 16
struct ziface_struct {
    char name[16];
    struct in_addr ip;
    struct in_addr netmask;
};

int zifaces_get(struct ziface_struct *ifaces, int max_interfaces);

// 1 if input address is from local network
int ziface_is_local(struct in_addr ia);

#endif
