/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _RGBA_DIALOG_H_
#define _RGBA_DIALOG_H_

#include <QDialog>

class Ui_RgbaDialog;

namespace QtShiva {

  class SpinBoxSliderConnector;
  
  class RgbaDialog : public QDialog {
    Q_OBJECT
    public:
      RgbaDialog( QWidget*, bool showAlpha );
      ~RgbaDialog();
      QColor color();
      void setColor( const QColor& );
    private slots:
      void triangleColorChanged( const QColor& );
      void spinBoxesValuesChanged();
    private:
      Ui_RgbaDialog* m_rgbaDialog;
      SpinBoxSliderConnector* m_connectors[4];
  };

}
#endif
